-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

-- In other words, if you are a modder feel free to reuse this code with above license

--If you reload Lua with CTRL+L use thise in the GE console `

local windowOpen = ui_imgui.BoolPtr(true)

local M = {}
M.dependencies = {"ui_imgui"}
local im = ui_imgui
local ffi = require("ffi")

local internal = not shipping_build or not string.match(beamng_windowtitle, "RELEASE")

local TorqueScriptLua = TorqueScriptLua

--independent GUI
local showUI = nil
local tempFloat = nil
local pos = im.ImVec2(0, 0)
local sizeMin = im.ImVec2(0, 0)
local sizeMax = im.ImVec2(-1, -1)
local imguiUtils = require('ui/imguiUtils')
local lastValue

--scenetree
local objects = nil

local shadowvalue = nil

local tod = nil

--light
local light = nil
local lightmgr
local shadowdisable = 0
local enableShadows = false

--weather
local rainamnt = nil
local fogscaleval = nil
local colorval = nil
local sunval = nil
local ambientval = nil
local fogamnt = nil
local vol = nil

local roughnessVal = nil
local groundVal = nil
local isWet = 0

local decalroad = nil

--lod stuff
local LOD
local LODDEF
local lodBias = im.FloatPtr(0)

--bigmap
local bigmapvalue = 0

--underground parking
local otherLevelPath = "/levels/asagao/info.json"
local playerisintrigger = nil
local zoomSpeed = 0.5
local defaultFov = 48

--level data
local levelfolder = nil
local levelname =  nil
local tool_version = "1.3"
local appTitle = " CK Map Controller - ".. tool_version .." - ".. "no-init" .." - ".. beamng_arch
local promptTitle = "Monorail"
local promptTitle2 = "Monorail2"

local toolWindowName = 'map_controller'

local function onClientStartMission()
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  log('I', 'onClientStartMission', 'Getting current level path' )
  levelname = getCurrentLevelIdentifier()
  --print(levelname)
  log('I', 'onClientStartMission', 'Level is loaded' )
  levelfolder = ("/levels/" .. levelname .. "/")
  appTitle = " CK Map Controller - ".. tool_version .." - ".. levelname .." - ".. beamng_arch
  if TorqueScriptLua then
    log("I", "onClientStartMission", "onCLientStartMission get LOD variable")
    LOD = tonumber(TorqueScriptLua.getVar("$pref::TS::detailAdjust"))
    LODDEF = LOD
    lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
    log('I', 'onClientStartMission', lightmgr )
    shadowdisable = tonumber(TorqueScriptLua.getVar("$pref::Shadows::disable"))
    log('I','onClientStartMission', shadowdisable )
  end
end

--get scene tree all objects
local function getSimObjects(fileName)
  local ret = {}
  local objs = scenetree.getAllObjects()
  --log('E', '', '# objects existing: ' .. tostring(#scenetree.getAllObjects()))
  for _, objName in ipairs(objs) do
    local o = scenetree.findObject(objName)
    if o and o.getFileName then
      if o:getFileName() == fileName then
        table.insert(ret, o)
      end
    end
  end
  return ret
  --log('E', '', '# objects left: ' .. tostring(#scenetree.getAllObjects()))
end

local function getFontList()
  local fonts = {}
  for i = 0, im.IoFontsGetCount() - 1 do
    table.insert(fonts,
    {
      name = ffi.string(im.IoFontsGetName(i))
    })
  end
  return fonts
end

--Hide Elements of map

local function setHiddenRec(object, hidden)
  object.hidden = hidden
  if object:isSubClassOf("SimSet") then
    for i=0, object:size() - 1 do
      setHiddenRec(object:at(i), hidden)
    end
  end
end

local function hideGroup(groupName, hidden)
  if not groupName then
    log('E', "", "Group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Group is missing, please contact level author', icon = "goat"})
  else
  local group = scenetree.findObject(groupName)
  if group then setHiddenRec(group, hidden) end
  end
end

local function onClientPostStartMission()
  if TorqueScriptLua then
    log('I','onClientPostStartMission', 'Hiding forest group' )
    hideGroup("forestoflights", false)
    hideGroup("forestoflights", true)
  end
end

--change material data
local function setMaterialProperty(material, property, layer, value)
  --guihooks.trigger('menuHide')
  --guihooks.trigger('app:waiting', true)
  if type(material) == "string" then
    material = scenetree.findObject(material)
  end

  if material.___type == "class<Material>" then
    material:setField(property, layer, value)
    --we do not want to flush materials
    --material:flush()
    --print("reloading material")
    material:reload()
    --guihooks.trigger('app:waiting', false) -- shows the loading icon
    return true
  else
    log('E', "", "Given object is not a material.")
    return false
  end
end
local lightTable = {}

--Dynamic Lights
local function setAllLightsEnabled(group, value)
  if not group then
    log('E', "setAllLightsEnabled", "Night lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Night lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      if obj and obj.obj:isSubClassOf('LightBase') then
          obj.obj:setLightEnabled( value )
      end
  end
end
end

--DynamicShadows
local function setAllLightsShadowsEnabledDisabled(group, shadowvalue)
  if not group then
    log('E', "setAllLightsShadowsEnabledDisabled", "Night lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Night lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    light = scenetree.findObjectById(id)
    light.castShadows = shadowvalue
  end
  guihooks.trigger('Message', {ttl = 10, msg = 'Shadows Changed', icon = "goat"})
end
end

--Gameengine decal road workaround
local function fixDecalRoad(group)
  if not group then
    log('E', "fixDecalRoad", "Night reflection group is missing, please contact level author")
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    decalroad = scenetree.findObjectById(id)
    decalroad.renderPriority = 9
    decalroad.renderPriority = 10
  end
end
end

--DynamicWeather
local function setWeather(fogscaleval, colorval, sunval, ambientval, fogamnt, group, rainamnt, vol)
    core_environment.setFogScaleGradientFile(fogscaleval)
    core_environment.setColorizeGradientFile(colorval)
    core_environment.setSunScaleGradientFile(sunval)
    core_environment.setAmbientScaleGradientFile(ambientval)
    core_environment.setTimeOfDay(tod)
    core_environment.setFogDensity(fogamnt)
    --core_environment.setPrecipitation(rainamnt)
    for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local precipitation = scenetree.findObjectById(id)
      local sfx = scenetree.findObjectById(id)
      precipitation.numDrops = rainamnt
      sfx.volume = vol
      sfx:postApply()
    end
    guihooks.trigger('Message', {ttl = 10, msg = 'Weather Changed', icon = "goat"})
end

--WET/DRY Section
local function setDryWetMaterials(roughnessVal, groundVal)
  log('I', "setDryWetMaterials", "Switching Materials...")
  if levelname == nil then
    log('E', "setDryWetMaterials", "No init, please restart the game")
    guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
  else
  local materialFiles = FS:findFiles(levelfolder, "dragon2road.materials.json", -1, true, false)
  log('D', 'setDryWetMaterials', dumps(materialFiles))
  for _, fn in ipairs(materialFiles) do
    local dir, basefilename, ext = path.splitWithoutExt(fn)

    if string.find(fn, 'materials.cs$') then
      TorqueScript.exec(fn)
      objects = getSimObjects(fn)
    elseif string.find(fn, 'materials.json$') then
      loadJsonMaterialsFile(fn)
      objects = getSimObjects(fn)
    end

    if not tableIsEmpty(objects) then
      log('I', 'setDryWetMaterials', 'parsing all materials file: ' .. tostring(fn))

      for _, obj in ipairs(objects) do
        log('I', 'setDryWetMaterials', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Roughness: ' .. tostring(obj:getField('roughnessFactor', 0)) )
        log('I', 'setDryWetMaterials', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - GroundType: ' .. tostring(obj:getField('groundType', 0)) )
        setMaterialProperty(obj:getName(), 'roughnessFactor', 0, roughnessVal)
        setMaterialProperty(obj:getName(), 'groundType', 0, groundVal)
      end

    end
  end
  be:reloadCollision()
  log('I', "setDryWetMaterials", "Switching Done!")
end
end

--simple dynamic level cubemap experiment
local cubemapname

local function setCubemap(cubemapname)
  if cubemapname then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      log("I", "setCubemap", "Enabling cubemap " ..cubemapname)
      levelinf:setField('globalEnviromentMap', 0, cubemapname)
      levelinf:postApply()
    else
      log("W", "setCubemap", "Enabling fallback cubemap " ..cubemapname)
      setConsoleVariable("$defaultLevelEnviromentMap", cubemapname)
    end
  end
end


local cubevalue = false

local function onBeamNGTrigger(data)
  -- dump(data)
  if data.triggerName == "Zone_4" and data.event == "enter" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      value = "cubemap_shibuja_parking_reflection"
      setCubemap(value)
      if isWet == 1 then
        setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.005, scenetree.Level_objects, 0, 0)
      end
    end
  end
  if data.triggerName == "Zone_3" and data.event == "enter" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      value = "cubemap_shibuja_tunnel_reflection"
      setCubemap(value)
      if isWet == 1 then
        setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.005, scenetree.Level_objects, 0, 0)
      end
    end
  end
  if data.triggerName == "Zone_4" and data.event == "exit" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      value = cubemapname
      setCubemap(value)
      if isWet == 1 then
        setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.005, scenetree.Level_objects, 2048, 0.6)
      end
    end
  end
  if data.triggerName == "Zone_3" and data.event == "exit" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      value = cubemapname
      setCubemap(value)
      if isWet == 1 then
        setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.005, scenetree.Level_objects, 2048, 0.6)
      end
    end
  end
end


local function onUpdate(dtReal)
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  if freeroam_bigMapMode then
    local dont_showUI = freeroam_bigMapMode.bigMapActive() == true or photoModeOpen
  end
  if not dont_showUI then
   --imgui app
  im.Begin(appTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  tod = scenetree.tod
  if not tod then
  im.Text("There is no TOD")
  im.Text("")
  else

  im.Text("Change TOD")
  if im.Button("Set Midday (Default)") then
    tod.time = 0.03
    core_environment.setTimeOfDay(tod)
  end
  if im.Button("Set Morning") then
    tod.time = 0.919
    core_environment.setTimeOfDay(tod)
  end
  im.SameLine()
  if im.Button("Set Sunset") then
    tod.time = 0.180
    core_environment.setTimeOfDay(tod)
  end
  if im.Button("Set Afternoon") then
    tod.time = 0.089
    core_environment.setTimeOfDay(tod)
  end
  im.SameLine()
  if im.Button("Set Midnight") then
    tod.time = 0.736
    core_environment.setTimeOfDay(tod)
  end
end
if TorqueScriptLua then
  im.Separator()
  if levelname == nil then
    im.Text("No init, please restart the game")
    im.Text("Some features are not available")
    im.Text("")
    if im.Button("Fix level lua without restarting") then
      extensions.mainLevel.onClientStartMission()
    end
    im.Text("")
  else
    im.Text("Change weather")
    --fog, color, sun, ambient, fog density, group, rain, volume of rain
    --Road roughness and ground type
    if im.Button("Set Clear (Default)") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/default/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_ambient.png", 0.001, scenetree.Level_objects, 0, 0)
      if isWet == 1 then
      setDryWetMaterials(1, "ASPHALT")
      hideGroup("ck_rainroad", true)
      fixDecalRoad(scenetree.ck_rainroad)
      isWet = 0
      elseif isWet == 0 then
    end
    end

    im.SameLine()
    if im.Button("Set Rain") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.005, scenetree.Level_objects, 2048, 0.6)
      if isWet == 0 then
      setDryWetMaterials(0.3, "ASPHALT_WET")
      hideGroup("ck_rainroad", false)
      fixDecalRoad(scenetree.ck_rainroad)
      isWet = 1
    elseif isWet == 1 then
    end
    end

    if im.Button("Set Overcast") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.003, scenetree.Level_objects, 0, 0)
      if isWet == 1 then
      setDryWetMaterials(1, "ASPHALT")
      hideGroup("ck_rainroad", true)
      fixDecalRoad(scenetree.ck_rainroad)
      isWet = 0
      elseif isWet == 0 then
    end
    end

    im.SameLine()
    if im.Button("Set Foggy") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/foggy/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_ambient.png", 0.010, scenetree.Level_objects, 0, 0)
      if isWet == 1 then
      setDryWetMaterials(1, "ASPHALT")
      hideGroup("ck_rainroad", true)
      fixDecalRoad(scenetree.ck_rainroad)
      isWet = 0
      elseif isWet == 0 then
    end
    end
    im.Separator()
  end

    --check if there is a reason to generate lights
  if shadowdisable < 1 then
    if lightmgr == "Basic Lighting" then
      else
      im.Text("Toggle Light Shadows")
      local shadowEnabled = im.BoolPtr(enableShadows)
      if im.Checkbox("Enable Shadows", shadowEnabled) then
        enableShadows = shadowEnabled[0]
        setAllLightsShadowsEnabledDisabled(scenetree.spot, enableShadows)
        setAllLightsShadowsEnabledDisabled(scenetree.point, enableShadows)
      end
      im.Separator()
    end
  end
end

im.End()



    --check for TOD
    if not tod then return end
    local value = false
    if tod.time > 0.21 and tod.time < 0.79 then
      if cubevalue == false then
        cubemapname = "cubemap_shibuja_portnight_reflection"
        setCubemap(cubemapname)
        hideGroup("forestoflights", false)
        print("night")
        cubevalue = true
      end
      value = true
    else
      if cubevalue == true then
        cubemapname = "cubemap_shibuja_port_reflection"
        setCubemap(cubemapname)
        hideGroup("forestoflights", true)
        print("day")
        cubevalue = false
      end
    end
  if TorqueScriptLua then
    if lightmgr == "Basic Lighting" then
    else
      if lastValue == value then return end
      lastValue = value

      if scenetree.spot then
        setAllLightsEnabled(scenetree.spot, value)
      end
      end
    end
  end
end

local function onEditorInitialized()
  editor.addWindowMenuItem("Map Controller", onWindowMenuItem, {groupMenuName = 'Car_Killer Addons'})
  editor.registerWindow(toolWindowName, im.ImVec2(500, 200))

end

local function onClientEndMission()
  if TorqueScriptLua then
    log("I", "onClientEndMission", "restored LOD to default previous one")
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
  end
end


M.onClientStartMission = onClientStartMission
M.onClientPostStartMission = onClientPostStartMission
M.onBeamNGTrigger = onBeamNGTrigger
M.onUpdate = onUpdate
M.onEditorInitialized = onEditorInitialized
M.onClientEndMission = onClientEndMission

return M
--Written in Visual Studio Code with Yukino Yukinoshita theme by Car_Killer 2022