-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function setAllLightsEnabled(group, value)
  for i = 0, group:size() - 1 do
    local obj = Sim.upcast(group.obj:at(i))
    if obj then
      if obj.obj:isSubClassOf('LightBase') then
        obj.obj:setLightEnabled(value)
      end
    end
  end
end

local lastValue = nil

local function setCubemap(cubemapname)
  if cubemapname then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      log("I", "setCubemap", "Enabling cubemap " ..cubemapname)
      levelinf:setField('globalEnviromentMap', 0, cubemapname)
      levelinf:postApply()
    else
      log("W", "setCubemap", "Enabling fallback cubemap " ..cubemapname)
      setConsoleVariable("$defaultLevelEnviromentMap", cubemapname)
    end
  end
end

local function setMaterialProperty(material, property, layer, value)
  if type(material) == "string" then
    material = scenetree.findObject(material)
  end

  if material.___type == "class<Material>" then
    if material:getField(property, layer) ~= value then
      material:setField(property, layer, value)
      --we do not want to flush materials
      --material:flush()
      material:reload()
    end
    return true
  else
    log('E', "setMaterialProperty", "Given object is not a material.")
    return false
  end
end

local function onUpdate(dtReal)
  local tod = scenetree.tod
  if not tod then return end

  local value = false
  if tod.time > 0.24 and tod.time < 0.78 then
    value = true
  end

  if lastValue == value then return end
  lastValue = value
  if value == true then
    setMaterialProperty("r_oj_spotlight_b_za_d", 'emissiveFactor', 0, "6.8235302 7.18431377 8.57254982")
    setMaterialProperty("r_sb_default_eh_d", 'emissiveFactor', 0, "4.00392199 4.96470594 5.11372614")
    setMaterialProperty("godray_emitter", 'opacityFactor', 0, "0.0489999987")
    setCubemap("cubemap_st_futoNight_reflection")
  else
    setMaterialProperty("r_oj_spotlight_b_za_d", 'emissiveFactor', 0, "0 0 0")
    setMaterialProperty("r_sb_default_eh_d", 'emissiveFactor', 0, "0 0 0")
    setMaterialProperty("godray_emitter", 'opacityFactor', 0, "0")
    setCubemap("cubemap_st_futo_reflection")
  end

  if scenetree.spot_lights then
    setAllLightsEnabled(scenetree.spot_lights, value ,"")
  end
end

M.onUpdate = onUpdate

return M