
angular.module('beamng.apps')
.directive('hawaiieSpeedo', [function () {
  return {
    template:
        '<object style="width:100%; height:100%; box-sizing:border-box; pointer-events: none" type="image/svg+xml" data="/ui/modules/apps/hawaiieSpeedo/hawaiieSpeedo.svg"></object>',
    replace: true,
    restrict: 'EA',
    link: function (scope, element, attrs) {
        'use strict'
        var streams = ['electrics']
        StreamsManager.add(streams)
        scope.$on('$destroy', function () {
            StreamsManager.remove(streams)
        })

      element.on('load', function () {

        var svg = element[0].contentDocument

        scope.$on('SettingsChanged', function (event, data) {
            svg.getElementById('speedUnit').innerHTML = UiUnits.speed().unit.toUpperCase()
        })

        function alignVal(val, len){
          var tmp = val.toFixed(0);
          if(tmp.length < len)
          return "!".repeat(len-tmp.length) + tmp ;
          else
          return tmp;
        }

        bngApi.engineLua('settings.notifyUI()')

        scope.$on('streamsUpdate', function (event, streams) {
            if (!streams.electrics) { return }

            var speedMs = streams.electrics.wheelspeed
            if (isNaN(speedMs)) speedMs = streams.electrics.airspeed
            var speedConverted = UiUnits.speed(speedMs)
            if(speedConverted === null) return
            var speedUnits = alignVal(speedConverted.val,3)

            if(speedUnits > 999){ speedUnits = 420}

            svg.getElementById('speed').innerHTML = speedUnits
        })
      })


    }
  }
}])
