-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local logTag = "ArenaGen"

local helper = require('scenario/scenariohelper')
local procTrack = require('util/procTrack')




local currentParams = nil


local function makeTapeCircuit(origParams)
   origParams.startingRects =
    {
      {
         width = 150,
        height = 90,
        x = -75,
        y = -90
      },

      {
        width = 80,
        height = 80,
        x = -85,
        y = -170,
        noSplit = true,
        force = { radius = 25, flip = true }
      },
      {
        width = 80,
        height = 80,
        x = 5,
        y = -170,
        noSplit = true,
        force = { radius = 25, flip = true }
      },
      {
        width = 10,
        height = 10,
        x = -5,
        y = -110,
        noSplit = true,
        force = { gate=true },
        start = true

      }



}
   origParams.path.closed = true

   origParams.rollingStart = false
   origParams.moveVehicleIntoPosition = true
   origParams.density = 1
end

local function makeOCircuit(origParams)
  local a = 55
  local b = 40
   origParams.startingRects =
    {
      {
         width = a,
        height = b-1,
        x = -a/2,
        y = -b+1,
        noSplit = true,
        start = true,
        force = {
          gate = true
        }

      },
      {
        width = a,
        height = b-1,
        x = -a/2,
        y = -(b+a+b),
        noSplit = true,
        force = {
          gate = true
        }
      },
      {
         width = b-1,
        height = a,
        x = -(a/2+b),
        y = -(a+b),
        noSplit = true,
        force = {
          gate = true
        }
      },
      {
         width = b-1,
        height = a,
        x = a/2+1,
        y = -(a+b),
        noSplit = true,
        force = {
          gate = true
        }
      },


      {
        width = b,
        height = b,
        x = -(a/2+b),
        y = -b,
        force = {
          radiusPercent = 0
        }
      },
      {
        width = b,
        height = b,
        x = -(a/2+b),
        y = -(b+a+b),
        force = {
          radiusPercent = .4
        }
      },
      {
        width = b,
        height = b,
        x = (a/2),
        y = -b,
        force = {
          radiusPercent = .2
        }
      },
      {
        width = b,
        height = b,
        x = (a/2),
        y = -(b+a+b),
        force = {
          radiusPercent = .0
        }
      }

    }
   origParams.path.closed = true

   origParams.rollingStart = false
   origParams.moveVehicleIntoPosition = true
   origParams.density = 10
 --  origParams.path.gateBaseChance = 0
   origParams.path.gateIncChance =    origParams.path.gateIncChance * .33

   origParams.path.loopBaseChance = .25
   origParams.path.loopIncChance =.25

      origParams.rectModeParams.minXDist = 12
        origParams.rectModeParams.minYDist = 12
end


local function makeRandomizedTrack(origParams)


  origParams.startingRects =
    {

      {
        width = 200,
        height = 130,
        x = -100,
        y = -130
      }

    }
   origParams.path.closed = false

   origParams.rollingStart = false
   if math.random() > .5 then
     origParams.path.closed = true
     origParams.path.lapCount = math.random(1,3)
   else
    origParams.path.lapCount = 1
  end
   origParams.moveVehicleIntoPosition = true
   origParams.start = nil
   origParams.finish = nil
   origParams.rectModeParams.density = math.random() + 0.5


  origParams.path.loopMinDot = math.random()*1 -1 + 0.25 -- minumum dot product for two consecutive nodes to allow to be a loop. higher value means angle has to be sharper. values below 0 means wider than 90° can also be looped.
  origParams.path.loopChance = math.random() -- the chance of a curved node becoming a looparound
  origParams.path.loopBaseChance = math.random() -- base chance for loops
  origParams.path.loopIncChance = math.random() -- everytime a node doesnt loop but could, the chance is increased by this amount.
  origParams.path.gateChance = math.random() -- the chance of a straight node becoming a gate.
  origParams.path.gateBaseChance = math.random() -- the base chance of a straight node becoming a gate.
  origParams.path.gateIncChance = math.random() -- every time a node doesnt become a gate but could, the chance is increased by this amount.
  origParams.rectModeParams.cutValueFunction = function ()
    return  (math.random())
  end

  origParams.rectModeParams.vertSplitFunction = function (width, height)
    return ((math.random()) * (width + height)) < width
  end

end

local function makeSnakeRace(origParams)

  local a = 30
  local b = 4

   origParams.startingRects =
    {

      {
        width = a,
        height = 70,
        x = -75,
        y = -70
      },
      {
        width = a,
        height = 70,
        x = -75,
        y = -150
      },
      {
        width = a,
        height = 75,
        x = 75-a,
        y = -150+37.5
      },

      {
        width = 150-a,
        height = a,
        x = -75 + a,
        y = -(150/(2*b-1)) * 0 - a
      },
      {
        width = 150-2*a,
        height = a,
        x = -75 + a,
        y = -(150/(2*b-1)) * 2 - a
      },{
        width = 150-2*a,
        height = a,
        x = -75 + a,
        y = -(150/(2*b-1)) * 4 - a
      },{
        width = 150-2*a,
        height = a,
        x = -75 + a,
        y = -(150/(2*b-1)) * 6 - a
      }

    }
    origParams.start = { -- the closest node to this point will be the starting node, if there is no rect with the start flag set.
      prefX = 10000,
      prefY = 10000
    }
    origParams.finish = { -- the closest node to this point will be the starting node, if there is no rect with the finish flag set.
     prefX = 10000,
      prefY = -10000
    }
    origParams.path.gateIncChance =.2
    origParams.path.gateBaseChance = .2
    origParams.path.closed = false
    origParams.rectModeParams.fixNodes = math.random(18,23)
    origParams.moveVehicleIntoPosition = true
    origParams.rollingStart = false
end


local function makeStartRects(origParams)
    origParams.startingRects =
    {
      {
        width = 30,
        height = 30,
        x = -15,
        y = 0,
        noSplit = true
      }
      ,
      {
        width = 30,
        height = 10,
        x = -15,
        y = 30,
        noSplit = true,
        start = true
      }
    }
    origParams.moveVehicleIntoPosition = true

    origParams.rollingStart = true
    origParams.vehiclePlacement = {}
    origParams.vehiclePlacement.pos = {x=0,y=70,z=0}
    origParams.vehiclePlacement.dir = {x=0,y=-1,z=0}
end

local function MakeBasicTrack(origParams, size)
  M.makeStartRects(origParams)
  if size == 0 then -- big(orig)
   origParams.startingRects[3] ={
        width = 180,
        height = 120,
        x = -90,
        y = -120
      }
  local offset = math.random() * 150-90
   origParams.startingRects[4] = {
        width = 30,
        height = 30,
        x = offset,
        y = -150,
        noSplit = true
      }

  origParams.startingRects[5] = {
        width = 30,
        height = 10,
        x = offset,
        y = -160,
        noSplit = true,
        finish = true
      }
  elseif size == 1 then -- medium
    origParams.startingRects[3] ={
        width = 120,
        height = 120,
        x = -60,
        y = -120
      }
    local offset = math.random() * 90-60
   origParams.startingRects[4] = {
        width = 30,
        height = 30,
        x = offset,
        y = -150,
        noSplit = true
      }

  origParams.startingRects[5] = {
        width = 30,
        height = 10,
        x = offset,
        y = -160,
        noSplit = true,
        finish = true
      }




  elseif size == 2 then -- small
       origParams.startingRects[3] ={
        width = 90,
        height = 90,
        x = -45,
        y = -90
      }

          local offset = math.random() * 60-45
   origParams.startingRects[4] = {
        width = 30,
        height = 30,
        x = offset,
        y = -120,
        noSplit = true
      }
  origParams.startingRects[5] = {
        width = 30,
        height = 10,
        x = offset,
        y = -130,
        noSplit = true,
        finish = true
      }

  elseif size == 3 then -- sparse
  origParams.startingRects[3] ={
        width = 180,
        height = 120,
        x = -90,
        y = -120
      }
  local offset = math.random() * 150-90
   origParams.startingRects[4] = {
        width = 30,
        height = 30,
        x = offset,
        y = -150,
        noSplit = true
      }

  origParams.startingRects[5] = {
        width = 30,
        height = 10,
        x = offset,
        y = -160,
        noSplit = true,
        finish = true
      }
      origParams.rectModeParams.density = .2
    origParams.path.nodeRadiusFunction = function (closestDist)
         return (1-math.random()*math.random()) *  math.max(0,(closestDist *0.40-2.5))+2
      end
  elseif size == 4 then --long
   origParams.startingRects[3] ={
        width = 60,
        height = 150,
        x = -30,
        y = -150
      }
  local offset = math.random() * 75-150
  local side = math.random() > .5 and 1 or -1

   origParams.startingRects[4] = {
        width = 30,
        height = 30,
        x = side == 1 and 30 or -60,
        y = offset,
        noSplit = true
      }

  origParams.startingRects[5] = {
        width = 10,
        height = 30,
        x = side == 1 and 60 or -70,
        y = offset,
        noSplit = true,
        finish = true
      }

    origParams.rectModeParams.density = 10
    origParams.path.nodeRadiusFunction = function (closestDist)
      if math.random() < .4 then
        return 0
      else
        return math.random() *  math.max(0,(closestDist *0.40-2.5))+2
      end
    end

  elseif size == 5 then --wide
   origParams.startingRects[1] ={
        width = 240,
        height = 50,
        x = -120,
        y = -75
      }
    origParams.startingRects[2] ={
        width = 80,
        height = 25,
        x = 40,
        y = -25
      }
      origParams.startingRects[9] ={
        width = 80,
        height = 25,
        x = -120,
        y = -25,
        noSplit = true,
        force = {radius = 16, flip = false}
      }
       origParams.startingRects[3] ={
        width = 30,
        height = 50,
        x = -90,
        y = -125,
        noSplit = true,
        force = {radius = 5, flip = false}
      }


      origParams.startingRects[4] ={
        width = 30,
        height = 50,
        x = 70,
        y = -125,
        noSplit = true,
      force = {radius = 5, flip = false}
      }
      local offset = math.random() * 3+3
      if math.random()<.5 then offset = -offset end
      origParams.startingRects[5] ={
        width = 20,
        height = 10,
        x = -60,
        y = -110,
        noSplit = true,
        force = {gate = true}
      }
           origParams.startingRects[6] ={
        width = 45,
        height = 20,
        x = -40,
        y = -115 - offset,
        noSplit = true,
        force = {gate = true}
      }
           origParams.startingRects[7] ={
        width = 45,
        height = 20,
        x = 5,
        y = -115 + offset,
        noSplit = true,
        force = {gate = true}
      }
      origParams.startingRects[8] ={
        width = 20,
        height = 10,
        x = 50,
        y = -110,
        noSplit = true,
        force = {gate = true}
      }


      origParams.path.closed = true
      origParams.moveVehicleIntoPosition = true
      origParams.rollingStart = false
      origParams.vehiclePlacement = nil
      origParams.rectModeParams.density = .6
      origParams.path.loopIncChance = .1
      origParams.path.loopBaseChance = .1
      origParams.path.gateBaseChance = .8

      origParams.decoration.gateWidth = 6
      origParams.decoration.gateHeight = 2
  else
   origParams.startingRects[3] ={
        width = 180,
        height = 120,
        x = -90,
        y = -120
      }

  end

end

local function gym(seed,size)

  size = size or math.random(0,9)
  local origParams = procTrack.getDefaultParams()
  origParams.scenarionParam = size
  origParams.populateFunction = function(params,size)
      if size <=5 then
        M.MakeBasicTrack(params,size)
      elseif size == 6 then
        M.makeTapeCircuit(params)
      elseif size == 7 then
        M.makeOCircuit(params)
      elseif size == 8 then
        M.makeRandomizedTrack(params)
      elseif size == 9 then
        M.makeSnakeRace(params)
      end
  end

  origParams.decoration.afterFunction = function(size)
    if size == 6 then
        M.makeBleacher(285,-150,115)
        M.makeBleacher(195,-150,65)

      elseif size == 5 then
        M.makeBleacher(265,-150,90)
        M.makeBleacher(215,-150,90)

        elseif size == 7 then
         M.makeBleacher(255,-90,0)
        M.makeBleacher(225,-90,180)

         M.makeBleacher(240,-75,90)
        M.makeBleacher(240,-105,270)
      elseif size == 4 then
        M.makeBleacher(240,-185,90)
      end
  end

  if seed and type(seed) == "string"  then
    if tonumber(seed) == nil then
      origParams.seed = procTrack.wordsToInt(seed)
    else
      origParams.seed = tonumber(seed)
    end
    log("I",logTag, "Determined seed from string to " .. origParams.seed)
  elseif seed and seed ~= 0 then
    origParams.seed = seed
    log("I",logTag, "Determined seed from number to " .. origParams.seed)
  else
    origParams.seed =  math.floor(os.time())
    math.randomseed(origParams.seed)
    origParams.seed = math.random(500*500*500*500)
    log("I",logTag, "Randomized seed to " .. origParams.seed)
  end

 -- origParams.rectModeParams.density  = density or 1.0

  procTrack.makeGymkhana(origParams)



end


local function makeBleacher(x,y,rot)

      TorqueScript.eval([[GymkhanaArena.add(new TSStatic() {
      shapeName = "levels/driver_training/art/shapes/objects/bleachers.dae";
      playAmbient = "1";
      meshCulling = "0";
      originSort = "0";
      useInstanceRenderData = "0";
      instanceColor = "White";
      collisionType = "Collision Mesh";
      decalType = "Collision Mesh";
      prebuildCollisionData = "0";
      renderNormals = "0";
      forceDetail = "-1";
      position = "]]..x.." "..y..[[ 36.35";
      rotation = "0 0 -1 ]]..rot..[[";
      scale = "1 1 1";
      canSave = "1";
      canSaveDynamicFields = "1";
   });]])
    end



local function onScenarioLoaded(sc)
  gym(sc.track.customData.seed, sc.track.customData.trackType)
end

M.makeBleacher = makeBleacher
M.onScenarioLoaded = onScenarioLoaded


M.makeTapeCircuit = makeTapeCircuit
M.makeOCircuit = makeOCircuit
M.makeStartRects = makeStartRects
M.makeRandomizedTrack = makeRandomizedTrack
M.makeSnakeRace = makeSnakeRace
M.MakeBasicTrack = MakeBasicTrack
return M

