-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

-- In other words, if you are a modder feel free to reuse this code with above license

--If you reload Lua with CTRL+L use thise in the GE console `

local windowOpen = ui_imgui.BoolPtr(true)

local M = {}
M.dependencies = {"ui_imgui"}
local im = ui_imgui
local ffi = require("ffi")

local internal = not shipping_build or not string.match(beamng_windowtitle, "RELEASE")

local TorqueScriptLua = TorqueScriptLua

--independent GUI
local showUI = nil
local tempFloat = nil
local pos = im.ImVec2(0, 0)
local sizeMin = im.ImVec2(0, 0)
local sizeMax = im.ImVec2(-1, -1)
local lastValue

--scenetree
local objects = nil

local shadowvalue = nil

local tod = nil

--light
local light = nil

local waitForFrame = 0
local offsetBias = im.FloatPtr(0)
local offsetval
local frameval
local frameBias = im.FloatPtr(0)

local lightmgr
local shadowdisable = 0
local dynLight = true
local enableShadows = false
local smartShadows = false

local playerPosDebugEnabled = false
local skipCameraEnabled = false
local skipRealTime = false

local lastjobCount

--weather
local rainamnt = nil
local fogscaleval = nil
local colorval = nil
local sunval = nil
local ambientval = nil
local fogamnt = nil
local vol = nil

local roughnessVal = nil
local groundVal = nil
local isWet = 0

local decalroad = nil

--lod stuff
local LOD
local LODDEF
local lodBias = im.FloatPtr(0)

--renderdistance
local renderBias = im.FloatPtr(0)
local defaultDistance

--speed trap
local speed
local speedLimit = nil
local location = ""
local data
local speedData
local unit = tostring( settings.getValue("uiUnitLength") )
local speedtrapFilePath
local showBoard = false
local oldversion = nil
local changed_version = false

--bigmap
local bigmapvalue = 0

--level data
local levelfolder = nil
local levelname =  nil
local tool_version = "2.0"
local appTitle = " CK Map Controller - ".. tool_version .." - ".. "no-init" .." - ".. beamng_arch
local speedTitle = "Speedcamera - Leaderboard ".. "no-init"


local toolWindowName = 'map_controller'

local function onClientStartMission()
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  log('I', '', 'Getting current level path' )
  levelname = getCurrentLevelIdentifier()
  --print(levelname)
  log('I', '', 'Level is loaded' )
  levelfolder = ("/levels/" .. levelname .. "/")
  appTitle = " CK Map Controller - ".. tool_version .." - ".. levelname .." - ".. beamng_arch
  speedTitle = "Speedcamera - Leaderboard ".. levelname
  if TorqueScriptLua then
    log("I", "", "onCLientStartMission get LOD variable")
    LOD = tonumber(TorqueScriptLua.getVar("$pref::TS::detailAdjust"))
    LODDEF = LOD
    defaultDistance = scenetree.theLevelInfo.visibleDistance
    speedtrapFilePath = 'settings/cloud/ck-'..levelname..'-speedtrap.json'
    speedData = jsonReadFile(speedtrapFilePath)
    lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
    log('I', '', lightmgr )
    shadowdisable = tonumber(TorqueScriptLua.getVar("$pref::Shadows::disable"))
    log('I','', shadowdisable )
  end
end

--get scene tree all objects
local function getSimObjects(fileName)
  local ret = {}
  local objs = scenetree.getAllObjects()
  --log('E', '', '# objects existing: ' .. tostring(#scenetree.getAllObjects()))
  for _, objName in ipairs(objs) do
    local o = scenetree.findObject(objName)
    if o and o.getFileName then
      if o:getFileName() == fileName then
        table.insert(ret, o)
      end
    end
  end
  return ret
  --log('E', '', '# objects left: ' .. tostring(#scenetree.getAllObjects()))
end

local function getFontList()
  local fonts = {}
  for i = 0, im.IoFontsGetCount() - 1 do
    table.insert(fonts,
    {
      name = ffi.string(im.IoFontsGetName(i))
    })
  end
  return fonts
end

--Hide Elements of map

local function setHiddenRec(object, hidden)
  object.hidden = hidden
  if object:isSubClassOf("SimSet") then
    for i=0, object:size() - 1 do
      setHiddenRec(object:at(i), hidden)
    end
  end
end

local function hideGroup(groupName, hidden)
  if not groupName then
    log('E', "", "Group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Group is missing, please contact level author', icon = "goat"})
  else
  local group = scenetree.findObject(groupName)
  if group then setHiddenRec(group, hidden) end
  end
end

--change material data
local function setMaterialProperty(material, property, layer, value)
  --guihooks.trigger('menuHide')
  --guihooks.trigger('app:waiting', true)
  if type(material) == "string" then
    material = scenetree.findObject(material)
  end

  if material.___type == "class<Material>" then
    material:setField(property, layer, value)
    --we do not want to flush materials
    --material:flush()
    --print("reloading material")
    material:reload()
    --guihooks.trigger('app:waiting', false) -- shows the loading icon
    return true
  else
    log('E', "", "Given object is not a material.")
    return false
  end
end
local lightTable = {}

--Dynamic Lights
local function setAllLightsEnabled(group, value)
  if not group then
    log('E', "", "Night lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Night lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      if obj and obj.obj:isSubClassOf('LightBase') then
          obj.obj:setLightEnabled( value )
      end
  end
end
end

--DynamicPositionBasedLights
local function setAllLightsPosEnabled(job, group, value, pos1, pos2, shdwpos1, shdwpos2, shadowvalue)
  if not group then
    log('E', "", "Lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Lights group is missing, please contact level author', icon = "goat"})
  else
  --reset table every refresh
  lightTable = {}
  for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      job.sleep(0.00001) -- sleep for one frame, evens impact on performance

      if obj and obj.obj:isSubClassOf('LightBase') then
        local pos = string.split(obj.obj:getField('position', 0))
        local posX = tonumber(pos[1])
        local posY = tonumber(pos[2])
        local posZ = tonumber(pos[3])
        if posX > pos1.x and posY > pos1.y and posZ > pos1.z and posX < pos2.x and posY < pos2.y and posZ < pos2.z then
          obj.obj:setLightEnabled( value )
          --get position of enabled lights
          if playerPosDebugEnabled == true then
            local pos = string.split(obj.obj:getField('position', 0))
            local posX = tonumber(pos[1])
            local posY = tonumber(pos[2])
            local posZ = tonumber(pos[3])
            local lightpos = vec3(posX, posY, posZ)
            table.insert(lightTable, lightpos)
          end
          if smartShadows == true then
            if posX > shdwpos1.x and posY > shdwpos1.y and posZ > shdwpos1.z and posX < shdwpos2.x and posY < shdwpos2.y and posZ < shdwpos2.z then
              obj.castShadows = shadowvalue
            else
              obj.castShadows = false
            end
          end
        else
          obj.obj:setLightEnabled( false )
        end
      end
    end
  end
end

--DynamicShadows
local function setAllLightsShadowsEnabledDisabled(group, shadowvalue)
  if not group then
    log('E', "", "Night lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Night lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    light = scenetree.findObjectById(id)
    light.castShadows = shadowvalue
  end
  guihooks.trigger('Message', {ttl = 10, msg = 'Shadows Changed', icon = "goat"})
end
end

--debug stuph
local OffsetA
local OffsetB
local ShdwOffsetA
local ShdwOffsetB
local playerPos
local playerRot
local freeCam

local function onPlayerPosition(group, value)
  --fallback offset
  local offset = vec3(1000,1000,1000)
  local shdwoffset = vec3(256,256,256)
  --debug offset for now
  --local offset = vec3(data,data,data)
  local veh
  veh = be:getPlayerVehicle(0)
  --would be nice to know if user is using free cam for photos/gameplay
  freeCam = commands.isFreeCamera()
  --update pos every 100 frames
  if waitForFrame <= 0 then
    waitForFrame = 100
    if frameval then
      waitForFrame = frameval
    end
  end
  if veh or freeCam then
    if skipCameraEnabled == true and playerPosDebugEnabled == true and veh then
      playerPos = vec3(veh:getPosition())
      local matrix = veh:getRefNodeMatrix()
      local forVec = vec3(matrix:getColumn(1))
      playerRot = math.atan2(forVec.x, -forVec.y)*180/ math.pi
      playerRot = (playerRot > 0 and playerRot) or (playerRot + 360)
    elseif freeCam then
      playerPos = vec3(getCameraPosition())
      local camera = commands.getCamera()
      local controlId = camera:getID()
      local sobj = scenetree[controlId]
      local matrix = sobj:getTransform()
      local forVec = vec3(matrix:getColumn(1))
      playerRot = math.atan2(forVec.x, -forVec.y)*180/ math.pi
      playerRot = (playerRot > 0 and playerRot) or (playerRot + 360)
    else
      playerPos = vec3(veh:getPosition())
      local matrix = veh:getRefNodeMatrix()
      local forVec = vec3(matrix:getColumn(1))
      playerRot = math.atan2(forVec.x, -forVec.y)*180/ math.pi
      playerRot = (playerRot > 0 and playerRot) or (playerRot + 360)
    end
    if playerPos then
      if offsetval then
        offset = vec3(offsetval,offsetval,offsetval)
      end
      --print(playerRot)
      if playerRot <= 340 and playerRot >= 250 or playerRot <= 150 and playerRot >= 60 then
        shdwoffset = vec3(256,128,24)
      end
      if playerRot <= 250 and playerRot >= 150 or playerRot <= 60 or playerRot >= 340 then
        shdwoffset = vec3(128,256,24)
      end
      OffsetA = playerPos - offset
      OffsetB = playerPos + offset
      ShdwOffsetA = playerPos - shdwoffset
      ShdwOffsetB = playerPos + shdwoffset
      --local relativePosWid = relativePos:width()
      --we set lights through background task to reduce stutter
      extensions.core_jobsystem.create(setAllLightsPosEnabled, 1, group, value, OffsetA, OffsetB, ShdwOffsetA, ShdwOffsetB, true)
    end
  end
end

--player position debug
local function playerPosDebug()
  if freeCam and skipCameraEnabled == false then
  else
    debugDrawer:drawSphere(playerPos, 0.5, ColorF(0, 1, 0, 0.5))
    debugDrawer:drawTextAdvanced((playerPos),
    "Last player position",
    ColorF(1,1,1,1),true, false, ColorI(0,0,0,255))
  end
  --offset
  local debugoffsetA1 = vec3(OffsetA.x,OffsetB.y,OffsetA.z)
  local debugoffsetA2 = vec3(OffsetB.x,OffsetA.y,OffsetA.z)
  local debugoffsetA3 = vec3(OffsetB.x,OffsetB.y,OffsetA.z)

  local debugoffsetB1 = vec3(OffsetB.x,OffsetA.y,OffsetB.z)
  local debugoffsetB2 = vec3(OffsetA.x,OffsetB.y,OffsetB.z)
  local debugoffsetB3 = vec3(OffsetA.x,OffsetA.y,OffsetB.z)

  --debug drawing
  debugDrawer:drawCylinder(OffsetA, debugoffsetA1, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(OffsetA, debugoffsetA2, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetA2, debugoffsetA3, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetA1, debugoffsetA3, 1, ColorF(0,0,1,0.3))

  debugDrawer:drawCylinder(OffsetB, debugoffsetB1, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(OffsetB, debugoffsetB2, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetB2, debugoffsetB3, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetB1, debugoffsetB3, 1, ColorF(0,0,1,0.3))

  debugDrawer:drawCylinder(debugoffsetB2, debugoffsetA1, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(OffsetA, debugoffsetB3, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(OffsetB, debugoffsetA3, 1, ColorF(0,0,1,0.3))
  debugDrawer:drawCylinder(debugoffsetB1, debugoffsetA2, 1, ColorF(0,0,1,0.3))

  if smartShadows == true then
      --offset
  local shdwdebugoffsetA1 = vec3(ShdwOffsetA.x,ShdwOffsetB.y,ShdwOffsetA.z)
  local shdwdebugoffsetA2 = vec3(ShdwOffsetB.x,ShdwOffsetA.y,ShdwOffsetA.z)
  local shdwdebugoffsetA3 = vec3(ShdwOffsetB.x,ShdwOffsetB.y,ShdwOffsetA.z)

  local shdwdebugoffsetB1 = vec3(ShdwOffsetB.x,ShdwOffsetA.y,ShdwOffsetB.z)
  local shdwdebugoffsetB2 = vec3(ShdwOffsetA.x,ShdwOffsetB.y,ShdwOffsetB.z)
  local shdwdebugoffsetB3 = vec3(ShdwOffsetA.x,ShdwOffsetA.y,ShdwOffsetB.z)

  --debug drawing
  debugDrawer:drawCylinder(ShdwOffsetA, shdwdebugoffsetA1, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(ShdwOffsetA, shdwdebugoffsetA2, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetA2, shdwdebugoffsetA3, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetA1, shdwdebugoffsetA3, 1, ColorF(0,1,1,0.3))

  debugDrawer:drawCylinder(ShdwOffsetB, shdwdebugoffsetB1, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(ShdwOffsetB, shdwdebugoffsetB2, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetB2, shdwdebugoffsetB3, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetB1, shdwdebugoffsetB3, 1, ColorF(0,1,1,0.3))

  debugDrawer:drawCylinder(shdwdebugoffsetB2, shdwdebugoffsetA1, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(ShdwOffsetA, shdwdebugoffsetB3, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(ShdwOffsetB, shdwdebugoffsetA3, 1, ColorF(0,1,1,0.3))
  debugDrawer:drawCylinder(shdwdebugoffsetB1, shdwdebugoffsetA2, 1, ColorF(0,1,1,0.3))
  end

  for k,v in pairs(lightTable) do
    debugDrawer:drawSphere(v, 0.5, ColorF(1, 0, 0, 0.5))
  end
end

--Gameengine decal road workaround
local function fixDecalRoad(group)
  if not group then
    log('E', "", "Night reflection group is missing, please contact level author")
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    decalroad = scenetree.findObjectById(id)
    decalroad.renderPriority = 9
    decalroad.renderPriority = 10
  end
end
end

--DynamicWeather
local function setWeather(fogscaleval, colorval, sunval, ambientval, fogamnt, group, rainamnt, vol)
    core_environment.setFogScaleGradientFile(fogscaleval)
    core_environment.setColorizeGradientFile(colorval)
    core_environment.setSunScaleGradientFile(sunval)
    core_environment.setAmbientScaleGradientFile(ambientval)
    core_environment.setTimeOfDay(tod)
    core_environment.setFogDensity(fogamnt)
    --core_environment.setPrecipitation(rainamnt)
    for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local precipitation = scenetree.findObjectById(id)
      local sfx = scenetree.findObjectById(id)
      precipitation.numDrops = rainamnt
      sfx.volume = vol
      sfx:postApply()
    end
    guihooks.trigger('Message', {ttl = 10, msg = 'Weather Changed', icon = "goat"})
end

--DYNAMIC MATERIALS SYSTEM - 2022 Car_Killer
--WET/DRY Section
local function setDryWetMaterials(roughnessVal, groundVal)
  log('I', "", "Switching Materials...")
  if levelname == nil then
    log('E', "", "No init, please restart the game")
    guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
  else
  local materialFiles = FS:findFiles(levelfolder, "road.materials.json", -1, true, false)
  log('D', '', dumps(materialFiles))
  for _, fn in ipairs(materialFiles) do
    local dir, basefilename, ext = path.splitWithoutExt(fn)

    if string.find(fn, 'materials.cs$') then
      TorqueScript.exec(fn)
      objects = getSimObjects(fn)
    elseif string.find(fn, 'materials.json$') then
      loadJsonMaterialsFile(fn)
      objects = getSimObjects(fn)
    end

    if not tableIsEmpty(objects) then
      log('I', '', 'parsing all materials file: ' .. tostring(fn))

      for _, obj in ipairs(objects) do
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Roughness: ' .. tostring(obj:getField('roughnessFactor', 0)) )
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - GroundType: ' .. tostring(obj:getField('groundType', 0)) )
        setMaterialProperty(obj:getName(), 'roughnessFactor', 0, roughnessVal)
        setMaterialProperty(obj:getName(), 'groundType', 0, groundVal)
      end

    end
  end
  be:reloadCollision()
  log('I', "", "Switching Done!")
end
end

--speed trap
local function onSpeedTrap(data, speedLimit, location)
  --we need to ticket players only
  local playerveh = be:getPlayerVehicleID(0)
  local veh
  local user
  --check if steam is working
  if Steam and Steam.isWorking and Steam.accountLoggedIn then
    user = Steam.playerName
  end
  if data.subjectID == playerveh then
    veh = be:getObjectByID(data.subjectID)
    local vehname
    if user == nil then
      user = veh:getDynDataFieldbyName("licenseText", 0)
    end
    local conditions
    --prevent leaking internal vehicles to online leaderboard
    if internal then
      vehname = "INTERNAL BUILD"
    else
      local currentVehicle = core_vehicles.getCurrentVehicleDetails()
      if currentVehicle.model and currentVehicle.model.Name then
        if currentVehicle.model.Brand then
          vehname = currentVehicle.model.Brand .. " " .. currentVehicle.model.Name
        else
          vehname = currentVehicle.model.Name
        end
      end
      --print(vehname)
    end

    --get condition data
    if isWet == 1 then
      conditions = "Rain"
    else
      conditions = "Dry"
    end

    speedLimit = speedLimit /3.6
    local speedVec = vec3(veh:getVelocity(veh:getRefNodeId()) )
    local dir = vec3(veh:getDirectionVector())
    --log("D", "", "speedVec = "..dumps(speedVec))
    --log("D", "", "dir = "..dumps(dir))
    speed = dir:dot(speedVec) -- we use the speed on the axis of the camera only
    if speed > speedLimit * 1.05 then --added a few KMH so the limit is not too strict
      Engine.Audio.playOnce('AudioGui', "/levels/c1/art/sound/trap.ogg")
      local msgRadar = "speeding!!!"
      if ( unit or 'metric') == "metric" then
        msgRadar = string.format("You are speeding %0.1f km/h instead of %0.1f km/h", speed*3.6, speedLimit*3.6)
      else
        msgRadar = string.format("You are speeding %0.1f mph instead of %0.1f mph", speed*2.23694, speedLimit*2.23694)
      end
      guihooks.trigger('Message', {ttl = 5, msg = msgRadar.. " on " ..location.. " with "..vehname, category = "speedtrap", icon = "photo_camera"})

      --generate file if it doesnt exist
      if speedtrapFilePath ~= nil then
        speedData = jsonReadFile(speedtrapFilePath) or {}
        if not speedData.speedtrap then
          speedData.speedtrap = {}
          speedData.version = tool_version
        end
        if not speedData.version then
          speedData.speedtrap = {}
          changed_version = true
          oldversion = "0"
          log('W', "", "unable to detect version, resetting data")
          speedData.version = tool_version
          local res = jsonWriteFile(speedtrapFilePath, speedData, true)
          if not res then
            log('W', "", "unable to save speed")
          end
        end

        if speedData.version ~= tool_version then
          oldversion = speedData.version
          speedData.speedtrap = {}
          changed_version = true
          log('W', "", "version mismatch, resetting data")
          speedData.version = tool_version
          local res = jsonWriteFile(speedtrapFilePath, speedData, true)
          if not res then
            log('W', "", "unable to save speed")
          end
        end
        --if there is no location, add it to the file
        if not speedData.speedtrap[location] then
          speedData.speedtrap[location] = {}
          speedData.speedtrap[location].vehicle = vehname
          speedData.speedtrap[location].conditions = conditions
          speedData.speedtrap[location].speed = speed
          speedData.speedtrap[location].user = user
          speedData.speedtrap[location].speedLimit = speedLimit
          local res = jsonWriteFile(speedtrapFilePath, speedData, true)
          if not res then
            log('W', "", "unable to save speed")
          end

          --get amount of all speed traps
          local locationamnt = scenetree.trap:getCount()

          local count = 0
          for _ in pairs(speedData.speedtrap) do count = count + 1 end
          print(count)
          guihooks.trigger('Message', {ttl = 10, msg = "Speedtraps found: "..count.."/"..locationamnt, category = "newtrap", icon = "plus_one"})
        end
        --dump(speedData.speedtrap)
        --if new personal best, save to file
        if speed > speedData.speedtrap[location].speed then
          local oldspeed = speedData.speedtrap[location].speed
          local diffspeed = speed - oldspeed
          speedData.speedtrap[location].vehicle = vehname
          speedData.speedtrap[location].conditions = conditions
          speedData.speedtrap[location].speed = speed
          speedData.speedtrap[location].user = user
          speedData.speedtrap[location].speedLimit = speedLimit
          local res = jsonWriteFile(speedtrapFilePath, speedData, true)
          if not res then
            log('W', "", "unable to save speed")
          end
          local msgPb = "new pb"
          if ( unit or 'metric') == "metric" then
            msgPb = string.format("New record! %0.1f km/h vs %0.1f km/h, +%0.1f km/h", speed*3.6, oldspeed*3.6, diffspeed*3.6)
          else
            msgPb = string.format("New record! %0.1f mph vs %0.1f mph, +%0.1f mph", speed*2.23694, oldspeed*2.23694, diffspeed*2.23694)
          end
          guihooks.trigger('Message', {ttl = 10, msg = msgPb, category = "newpb", icon = "flag"})
          Engine.Audio.playOnce('AudioGui','event:>UI>Generic>Click_Tonal_Small')
        end
      end
    end
  end
end

--simple dynamic level cubemap experiment
local cubemapname

local function setCubemap(cubemapname)
  if cubemapname then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      log("I", "", "Enabling cubemap " ..cubemapname)
      levelinf:setField('globalEnviromentMap', 0, cubemapname)
      levelinf:postApply()
    else
      log("W", "", "Enabling fallback cubemap " ..cubemapname)
      setConsoleVariable("$defaultLevelEnviromentMap", cubemapname)
    end
  end
end

local function onBeamNGTrigger(data)
  --need a better solution there
  -- dump(data)
  if data.triggerName == "BeamNGTrigger_6" and data.event == "enter" then
    onSpeedTrap(data, 60, "Kosokudaishi Bridge")
  end
  if data.triggerName == "BeamNGTrigger_7" and data.event == "enter" then
    onSpeedTrap(data, 60, "Katsushima")
  end
  if data.triggerName == "BeamNGTrigger_8" and data.event == "enter" then
    onSpeedTrap(data, 60, "Showajima")
  end
  if data.triggerName == "BeamNGTrigger_9" and data.event == "enter" then
    onSpeedTrap(data, 60, "Shinagawa City")
  end
  if data.triggerName == "BeamNGTrigger_10" and data.event == "enter" then
    onSpeedTrap(data, 60, "Koyasu")
  end
  if data.triggerName == "BeamNGTrigger_11" and data.event == "enter" then
    onSpeedTrap(data, 60, "Nishi Ward, Yokohama")
  end
  if data.triggerName == "BeamNGTrigger_12" and data.event == "enter" then
    onSpeedTrap(data, 60, "Yamashitacho IC")
  end
  if data.triggerName == "BeamNGTrigger_13" and data.event == "enter" then
    onSpeedTrap(data, 80, "Yokohama Bay Bridge")
  end
  if data.triggerName == "BeamNGTrigger_14" and data.event == "enter" then
    onSpeedTrap(data, 80, "Ariake")
  end
  if data.triggerName == "BeamNGTrigger_15" and data.event == "enter" then
    onSpeedTrap(data, 60, "Tatsumi Sta.")
  end
  if data.triggerName == "BeamNGTrigger_16" and data.event == "enter" then
    onSpeedTrap(data, 60, "Mitsume-dori")
  end
  if data.triggerName == "BeamNGTrigger_17" and data.event == "enter" then
    onSpeedTrap(data, 60, "Edobashi JCT")
  end
  if data.triggerName == "BeamNGTrigger_18" and data.event == "enter" then
    onSpeedTrap(data, 60, "Rainbow Bridge")
  end
  if data.triggerName == "BeamNGTrigger_19" and data.event == "enter" then
    onSpeedTrap(data, 60, "Kandabashi JCT")
  end
  if data.triggerName == "BeamNGTrigger_20" and data.event == "enter" then
    onSpeedTrap(data, 60, "3 Kitanomarukoen")
  end
  if data.triggerName == "BeamNGTrigger_21" and data.event == "enter" then
    onSpeedTrap(data, 60, "Shibashogyo Koko")
  end
  if data.triggerName == "BeamNGTrigger_22" and data.event == "enter" then
    onSpeedTrap(data, 60, "Kyobashi JCT")
  end
  if data.triggerName == "BeamNGTrigger_23" and data.event == "enter" then
    onSpeedTrap(data, 60, "Chuo City")
  end
  if data.triggerName == "BeamNGTrigger_24" and data.event == "enter" then
    onSpeedTrap(data, 60, "Koto City")
  end
  if data.triggerName == "BeamNGTrigger_25" and data.event == "enter" then
    onSpeedTrap(data, 60, "Shioeda Bridge")
  end
  if data.triggerName == "BeamNGTrigger_26" and data.event == "enter" then
    onSpeedTrap(data, 60, "Tatsumi 1st PA")
  end
  if data.triggerName == "BeamNGTrigger_27" and data.event == "enter" then
    onSpeedTrap(data, 80, "Shinonome")
  end
  if data.triggerName == "BeamNGTrigger_28" and data.event == "enter" then
    onSpeedTrap(data, 60, "Shibaura PA")
  end
  if data.triggerName == "BeamNGTrigger_29" and data.event == "enter" then
    onSpeedTrap(data, 60, "Shibaura JCT")
  end
  if data.triggerName == "BeamNGTrigger_30" and data.event == "enter" then
    onSpeedTrap(data, 60, "Tennozu Ohashi Bridge")
  end
  if data.triggerName == "BeamNGTrigger_31" and data.event == "enter" then
    onSpeedTrap(data, 60, "Samezu Bridge")
  end
  if data.triggerName == "BeamNGTrigger_32" and data.event == "enter" then
    onSpeedTrap(data, 60, "Morigasaki Kaigan")
  end
  if data.triggerName == "BeamNGTrigger_33" and data.event == "enter" then
    onSpeedTrap(data, 60, "Hanedaasahicho")
  end
  if data.triggerName == "BeamNGTrigger_34" and data.event == "enter" then
    onSpeedTrap(data, 60, "Daikokucho")
  end
  if data.triggerName == "BeamNGTrigger_35" and data.event == "enter" then
    onSpeedTrap(data, 60, "Ogurobashi St")
  end
  if data.triggerName == "BeamNGTrigger_36" and data.event == "enter" then
    onSpeedTrap(data, 60, "Shinko Station")
  end
  if data.triggerName == "BeamNGTrigger_37" and data.event == "enter" then
    onSpeedTrap(data, 50, "Ishikawacho JCT")
  end
  if data.triggerName == "BeamNGTrigger_38" and data.event == "enter" then
    onSpeedTrap(data, 60, "Sakuragicho")
  end
  if data.triggerName == "BeamNGTrigger_39" and data.event == "enter" then
    onSpeedTrap(data, 60, "Higashi-Kanagawa")
  end
  if data.triggerName == "BeamNGTrigger_40" and data.event == "enter" then
    onSpeedTrap(data, 60, "Moriyacho")
  end
  if data.triggerName == "BeamNGTrigger_41" and data.event == "enter" then
    onSpeedTrap(data, 60, "Ono Park")
  end
  if data.triggerName == "BeamNGTrigger_42" and data.event == "enter" then
    onSpeedTrap(data, 60, "Kawasaki Ward")
  end
  if data.triggerName == "BeamNGTrigger_43" and data.event == "enter" then
    onSpeedTrap(data, 60, "Yotsuyakamicho")
  end
  if data.triggerName == "BeamNGTrigger_44" and data.event == "enter" then
    onSpeedTrap(data, 60, "Haneda Nishime")
  end
  if data.triggerName == "BeamNGTrigger_45" and data.event == "enter" then
    onSpeedTrap(data, 60, "Hanedakuko")
  end
  if data.triggerName == "BeamNGTrigger_46" and data.event == "enter" then
    onSpeedTrap(data, 60, "Morigasaki")
  end
  if data.triggerName == "BeamNGTrigger_47" and data.event == "enter" then
    onSpeedTrap(data, 60, "Higashishinagawa")
  end
  if data.triggerName == "BeamNGTrigger_48" and data.event == "enter" then
    onSpeedTrap(data, 60, "Tennozu Isle")
  end
  if data.triggerName == "BeamNGTrigger_49" and data.event == "enter" then
    onSpeedTrap(data, 60, "Shioji Bridge")
  end
  if data.triggerName == "BeamNGTrigger_50" and data.event == "enter" then
    onSpeedTrap(data, 80, "Tsurumi Tsubasa Bridge")
  end
end

local function toUnit(speed)
  if ( unit or 'metric') == "metric" then
    --im.Text(tostring(math.ceil(speed*3.6)).." km/h")
    im.Text(string.format("%g",string.format("%.1f",speed*3.6)).." km/h")
  else
    im.Text(string.format("%g",string.format("%.1f",speed*2.23694)).." mph")
  end
end

local cubevalue = false

local function onUpdate(dtReal)
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  if freeroam_bigMapMode then
    local dont_showUI = freeroam_bigMapMode.bigMapActive() == true or photoModeOpen
  end
  if not dont_showUI then
   --imgui app
  im.Begin(appTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  tod = scenetree.tod
  if not tod then
  im.Text("There is no TOD")
  im.Text("")
  else

  im.Text("Change TOD")
  if im.Button("Set Midday (Default)") then
    tod.time = 0.034
    core_environment.setTimeOfDay(tod)
  end
  if im.Button("Set Morning") then
    tod.time = 0.852
    core_environment.setTimeOfDay(tod)
  end
  im.SameLine()
  if im.Button("Set Sunset") then
    tod.time = 0.200
    core_environment.setTimeOfDay(tod)
  end
  if im.Button("Set Afternoon") then
    tod.time = 0.083
    core_environment.setTimeOfDay(tod)
  end
  im.SameLine()
  if im.Button("Set Midnight") then
    tod.time = 0.26
    core_environment.setTimeOfDay(tod)
    setWeather(levelfolder .. "/art/skies/sky_gradients/foggy/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_ambient.png", 0.010, scenetree.Sky, 0, 0)
  end
end
if TorqueScriptLua then
  im.Separator()
  if levelname == nil then
    im.Text("No init, please restart the game")
    im.Text("Some features are not available")
    im.Text("")
    if im.Button("Fix level lua without restarting") then
      extensions.mainLevel.onClientStartMission()
    end
    im.Text("")
  else
    im.Text("Change weather")
    --fog, color, sun, ambient, fog density, group, rain, volume of rain
    --Road roughness and ground type
    if im.Button("Set Clear (Default)") then
      setWeather(0.001, levelfolder .. "/art/skies/sky_gradients/default/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_ambient.png", 0.001, scenetree.Sky, 0, 0)
      if isWet == 1 then
      setDryWetMaterials(1, "ASPHALT")
      hideGroup("ck_rainroad", true)
      fixDecalRoad(scenetree.ck_rainroad)
      isWet = 0
      elseif isWet == 0 then
    end
    end

    im.SameLine()
    if im.Button("Set Rain") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.005, scenetree.Sky, 2048, 0.6)
      if isWet == 0 then
      setDryWetMaterials(0.15, "ASPHALT_WET")
      hideGroup("ck_rainroad", false)
      fixDecalRoad(scenetree.ck_rainroad)
      isWet = 1
    elseif isWet == 1 then
    end
    end

    if im.Button("Set Overcast") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.003, scenetree.Sky, 0, 0)
      if isWet == 1 then
      setDryWetMaterials(1, "ASPHALT")
      hideGroup("ck_rainroad", true)
      fixDecalRoad(scenetree.ck_rainroad)
      isWet = 0
      elseif isWet == 0 then
    end
    end

    im.SameLine()
    if im.Button("Set Foggy") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/foggy/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_ambient.png", 0.010, scenetree.Sky, 0, 0)
      if isWet == 1 then
      setDryWetMaterials(1, "ASPHALT")
      hideGroup("ck_rainroad", true)
      fixDecalRoad(scenetree.ck_rainroad)
      isWet = 0
      elseif isWet == 0 then
    end
    end
    im.Separator()
  end

  im.Text("Lod Bias")
  lodBias[0] = tonumber(TorqueScriptLua.getVar("$pref::TS::detailAdjust") or 1) * 100
  im.PushItemWidth(100)
  if im.SliderFloat("", lodBias, 1, 800, "%.1f") then
    LOD = lodBias[0] / 100
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LOD)
  end
  im.SameLine()
  if im.Button("Reset LOD") then
    if LODDEF == nil then
      TorqueScriptLua.setVar("$pref::TS::detailAdjust", 1)
    else
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
    end
  end

  --far clip settings
  im.Text("View Distance")
  renderBias[0] = scenetree.theLevelInfo.visibleDistance or 3000
  im.PushItemWidth(100)
  if im.SliderFloat("##", renderBias, 1000, 8000, "%.1f") then
    scenetree.theLevelInfo.visibleDistance = renderBias[0]
    scenetree.theLevelInfo:postApply()
    core_environment.setTimeOfDay(tod)
  end
  im.SameLine()
  if im.Button("Reset view distance") then
    if defaultDistance == nil then
      scenetree.theLevelInfo.visibleDistance = 3000
      scenetree.theLevelInfo:postApply()
      core_environment.setTimeOfDay(tod)
    else
      scenetree.theLevelInfo.visibleDistance = defaultDistance
      scenetree.theLevelInfo:postApply()
      core_environment.setTimeOfDay(tod)
    end
  end
  im.Separator()

  if lightmgr == "Basic Lighting" then
  else
    local dynLightEnabled = im.BoolPtr(dynLight)
    if im.Checkbox("Enable Dynamic Lights", dynLightEnabled) then
      dynLight = dynLightEnabled[0]
    end
    if dynLight == true then
      im.Text("Light Distance")
      offsetBias[0] = offsetval or 1000
      im.PushItemWidth(100)
      if im.SliderFloat("##offset_lights", offsetBias, 100, 2000, "%g") then
        offsetval = offsetBias[0]
      end
      im.SameLine()
      if im.Button("Reset Light Distance") then
        offsetval = 1000
      end
      im.Text("Light Refresh Rate")
      frameBias[0] = frameval or 100
      im.PushItemWidth(100)
      if im.SliderFloat("##frame_refresh", frameBias, 200, 10, "%g") then
        frameval = math.ceil(frameBias[0])
      end
      im.SameLine()
      if im.Button("Reset Light Refresh") then
        frameval = 100
      end
      if shadowdisable < 1 then
        local smartShadowsEnabled = im.BoolPtr(smartShadows)
        if im.Checkbox("Smart Shadows (WIP)", smartShadowsEnabled) then
          smartShadows = smartShadowsEnabled[0]
          setAllLightsShadowsEnabledDisabled(scenetree.AIR_light, false)
          setAllLightsShadowsEnabledDisabled(scenetree.AIR_flare, false)
          setAllLightsShadowsEnabledDisabled(scenetree.Z2_light, false)
          setAllLightsShadowsEnabledDisabled(scenetree.Z2_flare, false)
          end
      end
      --debug button
      if freeroam_bigMapMode then
        local dynDbgEnabled = im.BoolPtr(playerPosDebugEnabled)
        if im.Checkbox("Debug Lights", dynDbgEnabled) then
          playerPosDebugEnabled = dynDbgEnabled[0]
        end
        if playerPosDebugEnabled == true then
          local skipCam = im.BoolPtr(skipCameraEnabled)
          if im.Checkbox("Ignore Free Camera", skipCam) then
            skipCameraEnabled = skipCam[0]
          end
          local skipDtReal = im.BoolPtr(skipRealTime)
          if im.Checkbox("Skip Real Time", skipDtReal) then
            skipRealTime = skipDtReal[0]
          end
        end
      end
    end
    im.Separator()
  end
    --check if there is a reason to generate lights
  if shadowdisable < 1 then
    if lightmgr == "Basic Lighting" or smartShadows == true then
      else
      im.Text("Toggle Light Shadows")
      local shadowEnabled = im.BoolPtr(enableShadows)
      if im.Checkbox("Enable Shadows", shadowEnabled) then
        enableShadows = shadowEnabled[0]
        setAllLightsShadowsEnabledDisabled(scenetree.AIR_light, enableShadows)
        setAllLightsShadowsEnabledDisabled(scenetree.AIR_flare, enableShadows)
        setAllLightsShadowsEnabledDisabled(scenetree.Z2_light, enableShadows)
        setAllLightsShadowsEnabledDisabled(scenetree.Z2_flare, enableShadows)
        
      end
      im.Separator()
    end
  end
end
  --show speed leaderboard
  if speedData then
    local boardEnabled = im.BoolPtr(showBoard)
    if im.Checkbox("Show Speedtrap Records", boardEnabled) then
      showBoard = boardEnabled[0]
    end
  end

im.End()

if speedData and showBoard == true then
  --im.Begin(speedTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  --im.Begin(speedTitle, showUI)
  local win = im.GetMainViewport()

  pos.x = win.Pos.x + win.Size.x / 2
  pos.y = win.Pos.y + 40
  im.SetNextWindowPos(pos, im.ImGuiCond_Always, im.ImVec2(0.5, 0))

  im.SetNextWindowBgAlpha(0.7)

  sizeMax.x = win.Size.x - win.Size.x / 1.8
  sizeMax.y = win.Size.y - win.Size.y / 1.3

  sizeMin.x = win.Size.x - win.Size.x / 1.5
  sizeMin.y = win.Size.y - win.Size.y / 1.2

  im.SetNextWindowSizeConstraints(sizeMin, sizeMax)

  im.Begin(speedTitle, showUI, im.WindowFlags_AlwaysAutoResize+im.WindowFlags_NoResize+im.WindowFlags_NoMove+im.WindowFlags_NoCollapse+im.WindowFlags_NoDocking+im.WindowFlags_NoTitleBar)
  local fontavailable = false
  for k,v in pairs(getFontList()) do
    for k,v in pairs(v) do
      if v == "cairo_bold" then
        fontavailable = true
      end
    end
  end
  if fontavailable == true then
    im.PushFont3("cairo_bold")
  end
  if changed_version == true then
    im.TextColored(im.ImVec4(1, 0, 0, 1), "Version changed from "..oldversion..", to "..tool_version.." data has been reset")
  end
  if speedData then
    local locations = {}
    local locationData = speedData.speedtrap
    im.Spacing()
    im.Columns(6)
    im.Text("Location")
    im.NextColumn()
    im.Text("Vehicle")
    im.NextColumn()
    im.Text("Conditions")
    im.NextColumn()
    im.Text("Speed")
    im.NextColumn()
    im.Text("Speed Limit")
    im.NextColumn()
    im.Text("User")
    im.Spacing()
    im.Separator()
    im.Separator()
    im.Spacing()
    im.NextColumn()
    --location
    for k in pairs(speedData.speedtrap) do
      im.Text(tostring(k))
      table.insert(locations, k)
    end
    --data
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "vehicle" then
          im.Text(tostring(v))
        end
      end
    end
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "conditions" then
          im.Text(tostring(v))
        end
      end
    end
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "speed" then
          toUnit(v)
        end
      end
    end
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "speedLimit" then
          toUnit(v)
        end
      end
    end
    im.NextColumn()
    for k,v in pairs(locations) do
      for k,v in pairs(locationData[v]) do
        if k == "user" then
          im.Text(tostring(v))
        end
      end
    end
  else
    im.Text("No Data")
  end
  if fontavailable == true then
    im.PopFont()
  end
  im.End()
end
end

    --check for TOD
    if not tod then return end
    local value = false
    if tod.time > 0.21 and tod.time < 0.79 then
      if cubevalue == false then
        cubemapname = "cubemap_c1night_reflection"
        setCubemap(cubemapname)
        print("night")
        cubevalue = true
      end
      value = true
    else
      if cubevalue == true then
        cubemapname = "cubemap_c1_reflection"
        setCubemap(cubemapname)
        print("day")
        cubevalue = false
      end
    end
  if TorqueScriptLua then
    if lightmgr == "Basic Lighting" then
    else
      if dynLight == true then
        --we don't need to update every frame
        if waitForFrame > 0 then
          if skipRealTime == true and playerPosDebugEnabled == true then
          waitForFrame = waitForFrame - 0.5
          else
          waitForFrame = waitForFrame - dtReal*50
          end
        end
        if waitForFrame <= 0 then
          lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
          shadowdisable = tonumber(TorqueScriptLua.getVar("$pref::Shadows::disable"))
          --onPlayerPosition(scenetree.Tunnel_lights, true)
          --onPlayerPosition(scenetree.Tunnel_sounds, true)
          if value == true then
            onPlayerPosition(scenetree.AIR_light, value)
            onPlayerPosition(scenetree.AIR_flare, value)
            onPlayerPosition(scenetree.Z2_light, value)
            onPlayerPosition(scenetree.Z2_flare, value)
            onPlayerPosition(scenetree.Z2_AMBIENTLIGHTS, value)
            lastValue = true
          end
          if value == false and lastValue == true then
            onPlayerPosition(scenetree.AIR_light, false)
            onPlayerPosition(scenetree.AIR_flare, false)
            onPlayerPosition(scenetree.Z2_light, false)
            onPlayerPosition(scenetree.Z2_flare, false)
            onPlayerPosition(scenetree.Z2_AMBIENTLIGHTS, value)
            lastValue = false
          end
        end
        --enable debug features
        if playerPosDebugEnabled == true then
          playerPosDebug()
        end
      elseif lastValue ~= true then
        if core_jobsystem.getRunningJobCount() ~= 0 then
          -- no jobs?
        local jobCount = core_jobsystem.getRunningJobCount()
        if jobCount ~= lastjobCount then
          lastjobCount = core_jobsystem.getRunningJobCount()
          log("I", "", "Wait for setAllLightsPosEnabled "..tostring(core_jobsystem.getRunningJobCount()))
        end
        else
          log("I", "", "Fallback lights")
          setAllLightsEnabled(scenetree.Tunnel_lights, true)
          setAllLightsEnabled(scenetree.Tunnel_sounds, true)
          lastValue = true
        end
      end
    end
    if freeroam_bigMapMode then
      if freeroam_bigMapMode.bigMapActive() == true then
        if bigmapvalue == 0 or bigmapvalue == 2 then
          TorqueScriptLua.setVar("$pref::TS::detailAdjust", 4)
          hideGroup("water", true)
          hideGroup("bigmap_helper", false)
          bigmapvalue = 1
        end
      elseif bigmapvalue == 1 then
        if LODDEF == nil then
          TorqueScriptLua.setVar("$pref::TS::detailAdjust", 1)
        else
        TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
        end
        hideGroup("water", false)
        hideGroup("bigmap_helper", true)
        bigmapvalue = 2
      end
    end
  end

end

local function onEditorInitialized()
  editor.addWindowMenuItem("Map Controller", onWindowMenuItem, {groupMenuName = 'Car_Killer Addons'})
  editor.registerWindow(toolWindowName, im.ImVec2(500, 200))

end

local function onExit()
  if TorqueScriptLua then
    log("I", "", "onExit restored LOD to default previous one")
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
  end
end


M.onPreRender = onPreRender
M.onClientStartMission = onClientStartMission
M.onClientEndMission = onExit
M.setAllLightsPosEnabled = setAllLightsPosEnabled
M.onUpdate = onUpdate
M.onBeamNGTrigger = onBeamNGTrigger
M.onEditorInitialized = onEditorInitialized
M.onEditorActivated = onEditorActivated
M.onEditorDeactivated = onEditorDeactivated
M.onExit = onExit

return M
--Written in Visual Studio Code with Yukino Yukinoshita theme by Car_Killer 2022