ScriptName PKP:ProgressionHandler Extends Quest

Actor PlayerRef
ActorValue Health

Group System
    GlobalVariable Property _pkp_SYS_ModEnabled Mandatory Const Auto
    GlobalVariable Property _pkp_SYS_AutoProvision Mandatory Const Auto
EndGroup

Group Perks
    Perk[] Property VitalityScalingPerks Mandatory Const Auto
    { Scale Vitality on the presence of each of these }
    Perk Property _pkp_debuffhandlerperk Mandatory Const Auto
    Perk Property _pkp_buffhandlerperk Mandatory Const Auto
    Perk Property _pkp_needsperk Mandatory Const Auto
    Perk Property Trait_AlienDNA Mandatory Const Auto
EndGroup

Group Keywords
    Keyword Property VendorFood Mandatory Const Auto
    Keyword Property VendorDrink Mandatory Const Auto
    Keyword Property ObjectTypeAid Mandatory Const Auto
    Keyword Property ObjectTypeChem Mandatory Const Auto
EndGroup

Group Messages
    Message Property WellRested_Msg Mandatory Const Auto
    { We control visibility here by removing the original script from the record}
    Message[] Property DrunkMessages Mandatory Const Auto
    Message[] Property HungryMessages Mandatory Const Auto
    Message[] Property ThirstMessages Mandatory Const Auto
    Message[] Property TiredMessages Mandatory Const Auto

    Message[] Property ReplenMessages Mandatory Const Auto
    { 0-1: hunger 0-1 2-3: stims w-s 4: thirst}
    Message Property _pkp_Tutorial1 Mandatory Const Auto
    Message Property _pkp_Tutorial2 Mandatory Const Auto

    Message Property _pkp_Tutorial3 Mandatory Const Auto

    Message Property _pkp_notif_paused Mandatory Const Auto
    Message Property _pkp_notif_resumed Mandatory Const Auto
    ;System
    Message Property _pkp_wakeup_1 Mandatory Const Auto
    Message Property _pkp_wakeup_2 Mandatory Const Auto
    ;autoeat
    Message Property _pkp_autoeat_food Mandatory Const Auto
    Message Property _pkp_autoeat_drink Mandatory Const Auto
    Message Property _pkp_tuit_soft Mandatory Const Auto
EndGroup

Group GlobalVariables
    GlobalVariable Property _pkp_stageguard Mandatory Const Auto
    GlobalVariable Property _PKP_NeedsDur Mandatory Const Auto
    { This just controls how long in realtime before the timer spell fires }
    GlobalVariable Property Thirst Mandatory Const Auto
    GlobalVariable Property Hunger Mandatory Const Auto
    GlobalVariable Property Exhaustion Mandatory Const Auto
    GlobalVariable Property Intoxication Mandatory Const Auto
    GlobalVariable Property Hygiene Mandatory Const Auto
    GlobalVariable Property GameDaysPassed Mandatory Const Auto
EndGroup

Group Spells
    ;Intensities
    GlobalVariable Property _pkp_NegativeStrength Mandatory Const Auto
    { Scaling factor for debuffs }
    GlobalVariable Property _pkp_PositiveStrength Mandatory Const Auto
    { Scaling factor for buffs }
    Spell[] Property CooldownSpells Mandatory Const Auto
    { 0: Hunger 1: Thirst 2: Sleep 3: Alc }
    Spell Property _pkp_MonitorSpell Mandatory Const Auto
    Spell Property WellRested Mandatory Const Auto
EndGroup

Group FormLists
    FormList Property _pkp_FilterList_VendorFood Mandatory Const Auto
    { Auto-eat }
    FormList Property _pkp_FilterList_VendorDrink Mandatory Const Auto
    { Auto-drink }
    FormList Property _pkp_stimulantweak Mandatory Const Auto
    { Auto-refresh (coffee/tea only)}
    FormList Property _pkp_alcohol Mandatory Const Auto
    FormList Property _pkp_fillingfoods Mandatory Const Auto
    FormList Property _pkp_tummyachefood Mandatory Const Auto
    FormList Property _pkp_openedfood Mandatory Const Auto
    FormList Property _pkp_strongalcohol Mandatory Const Auto
    Formlist Property _pkp_curehangover Mandatory Const Auto
    Formlist Property _pkp_curestomachache Mandatory Const Auto
    FormList Property _pkp_stimulantstrong Mandatory Const Auto
    FormList Property _pkp_soap Mandatory Const Auto
    FormList Property _pkp_AlienFood Mandatory Const Auto
EndGroup

Group ConditionForms
    ConditionForm Property _PKP_SafeLocation Mandatory Const Auto
    ConditionForm Property _PKP_FocusLocation Mandatory Const Auto
    { dungeons etc where needs are queued instead of fired }
    ConditionForm[] Property CooldownConditions Mandatory Const Auto
    { 0: Hunger 1: Thirst 2: Sleep }
    ConditionForm Property CND_SleepRequirements_WellRested_And_EmotionalSecurity Mandatory Const Auto
    { Piggyback on vanilla Well Rested to trigger FX as needed }
EndGroup

Potion[] GoodFood
Potion[] PoorFood
Potion[] AlcWeak
Potion[] AlcStrong
Potion[] StrongStims
Potion[] WeakStims
Potion[] HangoverCures
Potion[] AlienFood
Potion[] SoapItems

String property fCalendarTimeScaleGroundString="fCalendarTimeScaleGround" auto Const
{ gamesetting for time scale multiplier on real time for game time: game time = real time * fCalendarTimeScaleGround }

float fCalendarTimeScaleGround

float BaseInterval = 8.0 ; corresponds to 4 stages per day - perfect

; Control needs progression times compared to BaseInterval
; 1.0+ : need progresses slower
; 1.0- : need progresses faster
float RateOfThirst = 0.65
float RateOfHunger = 1.0
float RateOfSleep = 1.75

float LastCheck = -1.0
float Bedtime = -1.0

; Accumulated if Focus is on

int StoredSleep = 0
int StoredHunger = 0
int StoredThirst = 0

; Compared as hours on timer firing

float LastStageThirst
float LastStageHunger
float LastStageSleep

; Set in AssignSkillValues

; Vigor is positive and affects durations and buffs 
float Vigor = 1.0
; Vim is negative and effects debuffs and other misc stuff
float Vim = 1.0

; DEBUG - DO NOT TOUCH
bool DEBUGON = true ; Logging or QTVB only
bool DEBUGNOTIFY = false ; Prints logs to toast notifs
bool DEBUGSTART = False

bool Running = false
bool Autoconsume = false
bool NotInitialized = true
bool Easymode = false


;----------------------------------------------------
;---------------- SETTINGS AND STATE ---------------- 
;----------------------------------------------------

Function SettingsHandler()

    If !NotInitialized

        int Mode = _pkp_SYS_ModEnabled.GetValue() as int
        int AutoEat = _pkp_SYS_AutoProvision.GetValue() as int

        bool WasRunning = Running

        if Mode == 1
            Running = True
        ElseIf Mode == 2
            Running = True
        Elseif Mode == 0
            Running = False
        EndIF

        If AutoEat == 1
            Autoconsume = true
        Else    
            Autoconsume = false
        EndIF

        PeakPerf.ApplyPerkToPlayer(_pkp_buffhandlerperk, Running)
        PeakPerf.ApplyPerkToPlayer(_pkp_debuffhandlerperk, Running)
        PeakPerf.ApplyPerkToPlayer(_pkp_needsperk, Running)

        If Running

            If !WasRunning
                _pkp_MonitorSpell.Cast(PlayerRef)
            EndIF

        Else

            KillPeakProcess()

        EndIF

    EndIF

EndFunction

;just shuts everything down instantly
Function KillPeakProcess()
    _pkp_stageguard.SetValue(1)
    PlayerRef.DispelSpell(_pkp_MonitorSpell)
    Utility.Wait(0.4)
    _pkp_stageguard.SetValue(0)
    PeakPerf.ApplyPerkToPlayer(_pkp_buffhandlerperk, false)
    PeakPerf.ApplyPerkToPlayer(_pkp_debuffhandlerperk, false)
    PeakPerf.ApplyPerkToPlayer(_pkp_needsperk, false)
EndFunction

;----------------------------------------------------
;----------------- DEBUG AND SYSTEM ----------------- 
;----------------------------------------------------


;Generic debug function that can be disabled for prod
Function QuickTrace(String asTextToPrint = "Debug Error!")
    If DEBUGON
        Debug.Trace("PEAK: " + asTextToPrint)
        IF DEBUGNOTIFY ; Can log in realtime to avoid alt-tabbing constantly
            Debug.Notification("PKP: " + asTextToPrint)
        EndIF
    EndIF
EndFunction

Function QuickTraceVB(String asTextToPrint = "Debug Error!")
    If DEBUGON
        Debug.Notification("PKP: " + asTextToPrint)
    EndIF
EndFunction

; 0: Hunger 1: Thirst 2: Sleep
bool Function CheckCD(Int aiNeed = -1)
    Return CooldownConditions[aiNeed].IsTrue(PlayerRef)
EndFunction

; 0: Hunger 1: Thirst 2: Sleep
Function TriggerCD(int aiNeed = -1)
    CooldownSpells[aiNeed].Cast(PlayerRef)
EndFunction

;This function lets us quickly check if player meets conjuctive conditions
bool Function CNDK(ConditionForm asConditionForm1, ConditionForm asConditionForm2 = none, ConditionForm asConditionForm3 = none)
    bool ConditionOK = false
    If asConditionForm2
        If asConditionForm3
            ConditionOK = asConditionForm1.IsTrue(PlayerRef) && asConditionForm2.IsTrue(PlayerRef) && asConditionForm3.IsTrue(PlayerRef)
        Else
            ConditionOK = asConditionForm1.IsTrue(PlayerRef) && asConditionForm2.IsTrue(PlayerRef)
        EndIf
    Else
        ConditionOK = asConditionForm1.IsTrue(PlayerRef)
    EndIF
    return ConditionOK
EndFunction

;Returns our current game time scaling.
float Function GGT()
    fCalendarTimeScaleGround = Game.GetGameSettingFloat(fCalendarTimeScaleGroundString)
    QuickTrace( "GGT got " + fCalendarTimeScaleGround )
    Return fCalendarTimeScaleGround
EndFunction

float Function GCT()
    Return GameDaysPassed.GetValue()
EndFunction

;This is just for any banner message
Function HelpMessage(Message asMessageToShow, int Duration = 7, bool abWait = false)
    If abWait
        Utility.Wait(2)
    EndIf
    If asMessageToShow
        asMessageToShow.ShowAsHelpMessage(asEvent = 1, afDuration = Duration, afInterval = 1, aiMaxTimes = 1)
    EndIF
EndFunction


; If run empty simply zeroes values to their base
; Runs on a float[] instead of another set of Globals in this instance
Function LoopTabulator(float[] Mod, GlobalVariable[] Base, float afMult = 1.0)
    int i = 0
    While (i < Mod.length)
        float OriginalValue = Base[i].GetValue()
        float NewValue = OriginalValue * afMult
        Mod[i] = NewValue
        QuickTrace("Tabulator: " + Base[i] + " set to " + Mod[i] + " from " + Base[i].GetValue() )
        i += 1
    EndWhile
EndFunction

; Returns Floor of hours UT since input time
int Function GetHoursSince(float afCompared = 0.0)
    Utility.Wait(0.1)
    float N = GameDaysPassed.GetValue()
    float D = math.abs( afCompared - N )
    int I = Math.Floor( D * 24 )
    QuickTrace("GetHoursSince: " + afCompared + " until " + N + " got " + I)
    Return I ; forgot this first time lol
EndFunction

; Compared = last check
; Interval = hours UT
bool Function IntervalPassed(float afCompared = 0.0, float afInterval = 6.0)
    bool IntervalPassed = false
    float N = GameDaysPassed.GetValue()
    float D = math.abs( N - afCompared ) * 24
    float I = ( afInterval ) ;* 24 )
    If D > I
        IntervalPassed = true
    EndIf
    QuickTrace("IntervalPassed: " + IntervalPassed + " for " + I + " Hours UT")
    ;QuickTrace("IntervalPassed hours: " + " current: " + N * 24 + ", last: " + afCompared * 24 + ", hours: " + I)
    Return IntervalPassed
EndFunction

; Return value: total relevant perks player has
int Function AssignSkillValues()
    int SkillTotal = 1

    float V1 = 1.0
    float V2 = 1.0

    int i = 0
    While i < VitalityScalingPerks.Length
        Perk ThePerk = VitalityScalingPerks[i]
        If PlayerRef.HasPerk(ThePerk)
            SkillTotal += 1
            QuickTrace("CheckSkills Found perk: " + ThePerk )
        EndIf
        i += 1
    EndWhile

    V1 += ( SkillTotal / 12 )
    V2 -= ( SkillTotal / 16 )

    ;Vigor = Math.Clamp(V1, 1.0, 1.8) ; These were failing for some reason...
    ;Vim = Math.Clamp(V2, 0.4, 1.0)

    Vigor = 1 + ( SkillTotal / 12 )
    Vim = 1 - ( SkillTotal / 16 )

    QuickTrace("CheckSkills got Vigor: " + Vigor + " and Vim: " + Vim + " from Skills:" + SkillTotal + " of possible " + VitalityScalingPerks.Length) 

    Return SkillTotal
EndFunction

; Not directly using these anymore
; Function ImportDurations()
;     int i = 0
;     DurationsToUse = New float[Durations.Length]
;     While i < Durations.Length
;         float ThisDuration = Durations[i].GetValue()
;         DurationsToUse[i] = ThisDuration
;         QuickTrace("Set Duration at index " + i + " to " + ThisDuration)
;         i += 1
;     EndWhile
; EndFunction

bool Function Focus()
    bool Focused = _PKP_FocusLocation.IsTrue(PlayerRef)
    QuickTrace("Focus status: " + Focused)
    Return Focused
EndFunction

bool Function Safe()
    bool SafeLoc = _PKP_SafeLocation.IsTrue(PlayerRef)
    QuickTrace("SafeLoc status: " + SafeLoc)
    Return SafeLoc
EndFunction

; runs silent
Function HandleModStartup()

    Running = true
    NotInitialized = False

    LastCheck = GameDaysPassed.GetValue()
    ;ImportDurations() ; irrelevant

    StoredHunger = 0
    StoredThirst = 0
    StoredSleep = 0

    GoodFood = PeakPerf.ImportFormlist(_pkp_fillingfoods) as Potion[]
    PoorFood = PeakPerf.ImportFormlist(_pkp_openedfood) as Potion[]
    AlcWeak = PeakPerf.ImportFormlist(_pkp_alcohol) as Potion[]
    AlcStrong = PeakPerf.ImportFormlist(_pkp_strongalcohol) as Potion[]
    StrongStims = PeakPerf.ImportFormlist(_pkp_stimulantstrong) as Potion[]
    WeakStims = PeakPerf.ImportFormlist(_pkp_stimulantweak) as Potion[]
    AlienFood = PeakPerf.ImportFormlist(_pkp_AlienFood) as Potion[]
    SoapItems = PeakPerf.ImportFormlist(_pkp_soap) as Potion[]

    AssignSkillValues()

    SettingsHandler()

    _pkp_MonitorSpell.Cast(PlayerRef)

EndFunction

Event OnInit()
    StartTimer(3)
EndEvent

Event OnTimer(int aiTimerID)
    PlayerRef = Game.GetPlayer()
    Health = Game.GetHealthAV()
    RegisterForPlayerSleep()
    RegisterForRemoteEvent(PlayerRef, "OnItemEquipped")
    _pkp_tuit_soft.Show()
    Debug.Trace("PKP started with timescale: " + GGT() )
    If DEBUGSTART
        _PKP_NeedsDur.SetValue(120)
        baseinterval = 0.5 ; with new scaling this should reach full values overnight
        playerref.additem(_pkp_soap.GetAt(0))
        HandleModStartup()
    EndIF
EndEvent

bool Function FoodCompatibility(Potion akTheFood)
    bool Compatible = true
    bool PlayerAlien = PlayerRef.HasPerk(Trait_AlienDNA)
    bool CuisineAlien = ( AlienFood.Find(akTheFood) >= 0 ) as bool
    If PlayerAlien != CuisineAlien
        Compatible = False
    EndIf
    QuickTrace("FoodCompat got " + Compatible + " from Player: " + PlayerAlien + " Food: " + CuisineAlien)
    Return Compatible
EndFunction


;----------------------------------------------------------
;------------------------ HANDLERS ------------------------
;----------------------------------------------------------


;if abRefill we will try to continue autofeeding until we are below threshold
Function ConsumableHandler(Form akBaseObject, bool abRefill = false)
    Potion PlayerAte = akBaseObject as Potion
    QuickTrace("ConsumableHandler evaluating: " + PlayerAte)
    int H = 0
    int T = 0
    int S = 0
    int A = 0
    ;Simply trigger 
    If WeakStims.Find(PlayerAte) >= 0
        S -= 128
    ElseIf StrongStims.Find(PlayerAte) >= 0
        S -= 192
    Else
        If PlayerAte.HasKeyword(VendorFood)
            If FoodCompatibility(PlayerAte)
                If PoorFood.Find(PlayerAte) >= 0
                    H -= 64
                ElseIf GoodFood.Find(PlayerAte) >= 0
                    H -= 192
                EndIf
            Else
                H -= 128
                T += 8
            EndIf
        ElseIf PlayerAte.HasKeyword(VendorDrink)
            If AlcStrong.Find(PlayerAte) >= 0
                A += 16
                T += 24
            ElseIf AlcWeak.Find(PlayerAte) >= 0
                A += 4
                T -= 64
            Else
                T -= 192
            EndIf
        EndIf
    EndIF
    QuickTrace("ConsumableHandler Got H:" + H + " T:" + T + " S:" + S)
    Progression(false, H, T, S, 1.0, false)

    If S > 0
        StoredSleep += S
    EndIF

EndFunction

Function AdvanceNeedSingle(GlobalVariable ToMod, int aiAmount, float afIntensity = 1.0, bool abForce = false, bool abNotify = true)
    int CooldownToUse = -1
    float AmountToMod = aiAmount * afIntensity
    If ToMod == Hunger
        CooldownToUse = 0
    ElseIf ToMod == Thirst
        CooldownToUse = 1
    ElseIf ToMod == Exhaustion
        CooldownToUse = 2
    EndIf
    If abForce
        ToMod.Mod(aiAmount * afIntensity)
    Else
        If aiAmount > 0
            ToMod.Mod(AmountToMod)
        ElseIf aiAmount < 0 ; only used for restoration e.g. consuming restore items
            If !CheckCD(CooldownToUse)
                ToMod.Mod(AmountToMod)
                TriggerCD(CooldownToUse)
            EndIf
        EndIf
    EndIF

    If ToMod.GetValue() > 256
        ToMod.SetValue(256)
    ElseIf ToMod.GetValue() < 0
        ToMod.SetValue(0)
    EndIf

EndFunction

; note for later: Vitality will range from 0 - 16 and will be fed into mults where <8 bad >8 good
; it will either control its own independent values or feed directly into V&V, undecided
; probably the former as this is more interesting
; but the latter is more like original and will allow stronger scaling so I think I prefer it
Function StoreVitality()
    int Threshold = 128 ; I may lower this to ~96
    float HDBF = ( Threshold - Hunger.GetValue() ) / 64 ; Positive values if needs are met, negative if not
    float TDBF = ( Threshold - Thirst.GetValue() ) / 64 ; This math scales from 2 to -2 so we have to clamp them
    float SDBF = ( Threshold - Exhaustion.GetValue() ) / 64
    float H2 = Math.Clamp(HDBF, -1.4, 1.4) ; I can just add these to 8 basically
    float T2 = Math.Clamp(TDBF, -1.4, 1.4)
    float S2 = Math.Clamp(SDBF, -1.4, 1.4)
    float Vitality = 8 + ( H2 + T2 + S2 ) ; ops doesnt matter here
EndFunction

Function Progression(bool abProgression = false, int aiHunger = 0, int aiThirst = 0, int aiSleep = 0, float afIntensity = 1.0, bool abNotify = true)
    ;QuickTrace("Progression running " + abProgression + " with H:" + aiHunger + " T:" + aiThirst + " S: " + aiSleep + " Intensity " + afIntensity)
    QuickTrace("Progression START H:" + Hunger.GetValue() + " T:" + Thirst.GetValue() + " S: " + Exhaustion.GetValue() + " Intensity " + afIntensity )
    AdvanceNeedSingle(Hunger, aiHunger, afIntensity, abProgression, abNotify)
    Utility.Wait(0.3)
    AdvanceNeedSingle(Thirst, aiThirst, afIntensity, abProgression, abNotify)
    Utility.Wait(0.3)
    AdvanceNeedSingle(Exhaustion, aiSleep, afIntensity, abProgression, abNotify)
    QuickTrace("Progression END H:" + Hunger.GetValue() + " T:" + Thirst.GetValue() + " S: " + Exhaustion.GetValue() )
EndFunction

Function ProgressIntoxication(int aiAmount)
    If math.abs(aiAmount) > 0
        Intoxication.Mod(aiAmount)
    EndIf
EndFunction

; advances all of our need globals by 64 +- adjustments from time passed or location type
Function HandleAllProgression(float afIntensity = 1.0, bool abNotify = false)

    float Safety = 1.0
    If Safe()
        Safety = 0.6
    EndIF

    ; This is our smart check for sleep or other long events
    ; should be negligible if fired during normal subsequent play
    float TimeMod = Math.Clamp( ( GetHoursSince(LastCheck) / ( BaseInterval ) ), 1.0, 4.0) ; I have no clue what the *6 and +1 were doing
    float Adjustment = afIntensity * TimeMod * Safety
    QuickTrace("HandleProgression Adjustment = " + Adjustment + " from TimeMod " + TimeMod + " and Safety " + Safety)
    int H = 0
    int T = 0
    int S = 0
    int A = ( -24 * Vigor ) as int

    float HungerInt = BaseInterval * RateOfHunger * Vigor
    float ThirstInt = BaseInterval * RateOfThirst * Vigor
    float SleepInt = BaseInterval * RateOfSleep * Vigor

    float Now = GCT()

    QuickTrace("HandleProgression running at " + Now + " vs intervals H:" + HungerInt + " T: " + ThirstInt + " S: " + SleepInt)

    If IntervalPassed(LastStageHunger, HungerInt )
        H += ( 64 + StoredHunger )
        LastStageHunger = Now
    EndIF
    If IntervalPassed(LastStageThirst, ThirstInt )
        T += ( 64 + StoredThirst )
        LastStageThirst = Now
    EndIF
    If IntervalPassed(LastStageSleep, SleepInt ) ; this is the longest one so I will put cleanliness trigger on here
        S += ( 64 + StoredSleep )
        LastStageSleep = Now
        RollCleanliness()
    EndIf

    If !Focus()
        Bool EvalH = true
        bool EvalT = true
        bool EvalS = true
        If Autoconsume
            ;If Hunger.GetValue() > 192
                EvalH = TryToRefill(Hunger)
                Utility.Wait(0.2)
            ;EndIf
            ;If Thirst.GetValue() > 192
                EvalT = TryToRefill(Thirst)
                Utility.Wait(0.2)
            ;EndIf
            ;If Exhaustion.GetValue() > 192
                EvalS = TryToRefill(Exhaustion)
                Utility.Wait(0.2)
            ;EndIf
            If !EvalH
                H = 0
            EndIF
            If !EvalT
                T =0
            EndIF
            If !EvalS
                S =0
            EndIF
            QuickTrace("Progression Autoconsume got H:" + EvalH + ", T:" + EvalT + ", S:" + EvalS)
        EndIF 
        Progression(true, H, T, S, Adjustment, abNotify)
        StoredHunger = 0
        StoredThirst = 0
        StoredSleep = 0
    Else
        StoredHunger += Math.Round( H * Vim )
        StoredThirst += Math.Round( T * Vim )
        StoredSleep += Math.Round( S * Vim )
    EndIf

    LastCheck = GCT()



EndFunction

Function RollCleanliness()
    If Utility.RandomInt(1, 100) < 25 && !Safe()
        QuickTrace("RollCleanliness advancing")
        Hygiene.Mod(24)
    ElseIf Safe() && !DEBUGNOTIFY
        QuickTrace("RollCleanliness regressing in safe location")
        Hygiene.Mod(-18)
    ElseIf DEBUGNOTIFY
        QuickTrace("RollCleanliness advancing with debug")
        Hygiene.Mod(24)
    EndIF
EndFunction

Function HandleDurationEnd()
    HandleAllProgression()
    ;EvaluateAutoConsume()
    _pkp_MonitorSpell.Cast(PlayerRef)
EndFunction

Function BedtimeHandler(float afSleepStartTime, float afDesiredSleepEndTime)
    AssignSkillValues()
    Bedtime = afSleepStartTime
    _pkp_stageguard.SetValue(1) ; I still want to handle this manually on wakeup
EndFunction

Function WakeupHandler(ObjectReference akBed)

    If Running

        float TimeNeeded = 8 * Vim
        bool EnoughSleep = ( GetHoursSince(Bedtime) >= TimeNeeded )
        bool VWellRested = CND_SleepRequirements_WellRested_And_EmotionalSecurity.IsTrue(PlayerRef, akBed)
        int SleepQuality = 0
        QuickTrace("Wakeup got enough:" + EnoughSleep + " from bedtime " + Bedtime + " wakeup " + GCT() + " needed " + TimeNeeded)
        ;HandleAllProgression() ; This will set our value silently so it doesn't matter that we yoink it back

        if EnoughSleep && VWellRested
            Exhaustion.SetValue(0)
            WellRested.Cast(PlayerRef)
            WellRested_Msg.Show()
        else
            Exhaustion.SetValue(65)
            Utility.Wait(3)
            PlayerRef.DispelSpell(WellRested)
            _pkp_wakeup_1.Show()
        endif


        utility.wait(3)
        _pkp_stageguard.SetValue(0)
        _pkp_MonitorSpell.Cast(PlayerRef)

    Else

        KillPeakProcess()

    EndIF

EndFunction


;----------------------------------------------------------
;------------------------ EVENTS --------------------------
;----------------------------------------------------------


Event Actor.OnItemEquipped(Actor akActor, Form akBaseObject, ObjectReference akReference)
    If Running
        If akBaseObject.HasKeyword(VendorFood) || akBaseObject.HasKeyword(VendorDrink) || akBaseObject.HasKeyword(ObjectTypeChem) || akBaseObject.HasKeyword(ObjectTypeAid)
            ConsumableHandler(akBaseObject)
        EndIF
    EndIf
EndEvent

Event OnPlayerSleepStart(float afSleepStartTime, float afDesiredSleepEndTime, ObjectReference akBed)
    If !NotInitialized ; aka initialized
        BedtimeHandler(afSleepStartTime, afDesiredSleepEndTime)
    EndIf
EndEvent

Event OnPlayerSleepStop(bool abInterrupted, ObjectReference akBed)
    If NotInitialized
        HandleModStartup()
        HelpMessage(_pkp_Tutorial3, 6, true)
    Else
        WakeupHandler(akBed)
    EndIf
EndEvent

; Gets the *location* of the planet the Player is on.
Location Function GetPlayerCurrentPlanet()
    Location PlayerIsIn = Game.GetPlayer().GetCurrentLocation()
    Keyword LocTypeMajorOrbital = Game.GetFormFromFile(0x00070A54, "Starfield.esm") as Keyword
    Location[] Planets = PlayerIsIn.GetParentLocations(LocTypeMajorOrbital)
    Location PlayerIsOn = Planets[0]
    Return PlayerIsOn
EndFunction


;----------------------------------------------------------
;------------------  SUBSYSTEM HANDLERS  ------------------
;----------------------------------------------------------

;Returns false if we ate basically
bool Function TryToRefill(GlobalVariable NeedToMod)
    bool Proc = true
    ; ;More accurate but probably slower auto-eat with CPE's GetInventoryItems
    ; If CassiopeiaPapyrusExtender.GetCassiopeiaPapyrusExtenderVersion() > 0
    ;     QuickTrace("TryToRefill firing WITH Cassiopeia")
    ;     Form[] Chow = CassiopeiaPapyrusExtender.GetInventoryItems(PlayerRef, false)
    ;     If NeedToMod == Hunger
    ;         int i = 0
    ;         While (i < Chow.length)
    ;             If Chow[i].HasKeyword(VendorFood)
    ;                 ;Debug.Notification("I ate some food.")
    ;                 PlayerRef.EquipItem(Chow[i], false, true)
    ;                 Proc = false
    ;             EndIf
    ;             i += 1
    ;         EndWhile
    ;     ElseIf NeedToMod == Thirst
    ;         int i = 0
    ;         While (i < Chow.length)
    ;             If Chow[i].HasKeyword(VendorDrink)
    ;                 ;Debug.Notification("I drank something.")
    ;                 PlayerRef.EquipItem(Chow[i], false, true)
    ;                 Proc = false
    ;             EndIf
    ;             i += 1
    ;         EndWhile
    ;     Elseif NeedToMod == Exhaustion
    ;         int i = 0
    ;         While (i < Chow.length)
    ;             If WeakStims.Find(Chow[i] as Potion) >= 0
    ;                 ;Debug.Notification("I had some coffee to stay awake.")
    ;                 PlayerRef.EquipItem(Chow[i], false, true)
    ;                 Proc = false
    ;             EndIf
    ;             i += 1
    ;         EndWhile
    ;     EndIF

    ; Else
    QuickTrace("TryToRefill firing on " + NeedToMod + " at " + NeedToMod.GetValue() )
    If NeedToMod.GetValue() >= 160 && _pkp_stageguard.GetValue() == 0
        If NeedToMod == Hunger
            int RestoreItem = PlayerRef.GetItemCount(VendorFood)
            If RestoreItem > 0
                bool HasChow = false
                Form ToEat

                If PlayerRef.HasPerk(Trait_AlienDNA) ; find alien food if player has alien DNA
                    int i = 0
                    while i < AlienFood.Length
                        If !HasChow && PlayerRef.GetItemCount(AlienFood[i]) > 0
                            ToEat = AlienFood[i]
                            HasChow = true
                        EndIf
                        i += 1
                    EndWhile
                Else ; try to find good food if player has NO alien DNA
                    int i = 0
                    while i < GoodFood.Length
                        If !HasChow && PlayerRef.GetItemCount(GoodFood[i]) > 0
                            ToEat = GoodFood[i]
                            HasChow = true
                        EndIf
                        i += 1
                    EndWhile
                EndIf

                If !HasChow ; try to get poor food if neither of these scenarios apply
                    int i = 0
                    while i < PoorFood.Length
                        If !HasChow && PlayerRef.GetItemCount(PoorFood[i]) > 0
                            ToEat = PoorFood[i]
                            HasChow = true
                        EndIf
                        i += 1
                    EndWhile
                EndIF

                If HasChow && ToEat ; fire the event with our found food whatever it may be
                    QuickTrace("Removing a " + ToEat + " found via array")
                    PlayerRef.RemoveItem(ToEat, 1, false)
                    Utility.Wait(2)
                    ConsumableHandler(ToEat)
                    Proc = false
                Else ; run it by keyword and eat whatever we have
                    QuickTrace("Removing a VendorFood item with count " + RestoreItem)
                    PlayerRef.RemoveItem(VendorFood, 1, false)
                    Utility.Wait(2)
                    AdvanceNeedSingle(Hunger, -128)
                    Proc = false
                    ;Debug.Notification("I ate something.")
                    ;_pkp_autoeat_food.Show()
                EndIf
            EndIF
        ElseIf NeedToMod == Thirst
            int RestoreItem = PlayerRef.GetItemCount(VendorDrink)
            If RestoreItem > 0
                QuickTrace("Removing a VendorDrink item with count " + RestoreItem)
                PlayerRef.RemoveItem(VendorDrink, 1, false)
                Utility.Wait(2)
                AdvanceNeedSingle(Thirst, -128)
                Proc = false
                ;Debug.Notification("I drank something.")
                ;_pkp_autoeat_drink.Show()
            EndIf
        Elseif NeedToMod == Exhaustion
            bool HasCoffee = false
            Form ToEat
            int i = 0
                while i < WeakStims.Length
                    If !HasCoffee && PlayerRef.GetItemCount(WeakStims[i]) > 0
                        ToEat = WeakStims[i]
                        HasCoffee = true  
                    EndIf
                    i += 1
                EndWhile
            If HasCoffee && ToEat
                QuickTrace("Trying to remove a stim " + ToEat)
                PlayerRef.RemoveItem(ToEat, 1, false)
                Utility.Wait(2)
                AdvanceNeedSingle(Exhaustion, -128)
                Proc = false
                ;Debug.Notification("I drank something.")
            EndIf
        EndIf

    Else
        QuickTrace("TryToRefill skipping with stageguard " + _pkp_stageguard.GetValue() + " and need " + NeedToMod + ": " + NeedToMod.GetValue())

    EndIf

    return Proc
EndFunction