ScriptName PKP:SettingsHandler Extends Quest

Group System
    GameplayOption Property _pkp_GPO_MODE Mandatory Const Auto
    GlobalVariable Property _pkp_SYS_ModEnabled Mandatory Const Auto
    GlobalVariable Property _pkp_SYS_CleanlinessEnabled Mandatory Const Auto
    GlobalVariable Property _pkp_SYS_VitalityEnabled Mandatory Const Auto
    GameplayOption Property _PKP_GPO_AUTO Mandatory Const Auto
    GlobalVariable Property _pkp_SYS_AutoProvision Mandatory Const Auto
    FormList Property _pkp_LIST_GPO Mandatory Const Auto
EndGroup

Function CheckSettings()
    int MODE = _pkp_GPO_MODE.GetValue() as int
    int EATS = _PKP_GPO_AUTO.GetValue() as int
    _pkp_SYS_ModEnabled.SetValue(MODE)
    _pkp_SYS_VitalityEnabled.SetValue(MODE) ; since these only run if it is 1 this works too
    _pkp_SYS_CleanlinessEnabled.SetValue(MODE)
    
    _pkp_SYS_AutoProvision.SetValue(EATS)

    PeakPerf.CheckOptions()
EndFunction

Event OnQuestInit()
	StartTimer(4)
    GoToState("Starting")
EndEvent

State Starting
    Event OnTimer(int aiTimerID)
        RegisterForGameplayOptionChangedEvent()
        GotoState("")
    EndEvent
EndState

Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
    If peakperf.wasoptionchanged(aChangedOptions, _pkp_LIST_GPO)
        CheckSettings()
    endif
EndEvent

