-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

-- In other words, if you are a modder feel free to reuse this code with above license

--If you reload Lua with CTRL+L use thise in the GE console `

local windowOpen = ui_imgui.BoolPtr(true)

local M = {}
M.dependencies = {"ui_imgui"}
local im = ui_imgui
local ffi = require("ffi")

local internal = not shipping_build or not string.match(beamng_windowtitle, "RELEASE")

local TorqueScriptLua = TorqueScriptLua

--independent GUI
local showUI = nil
local tempFloat = nil
local pos = im.ImVec2(0, 0)
local sizeMin = im.ImVec2(0, 0)
local sizeMax = im.ImVec2(-1, -1)
local lastValue

--scenetree
local objects = nil

local shadowvalue = nil

local tod = nil

--light
local light = nil

local waitForFrame = 0
local offsetBias = im.FloatPtr(0)
local offsetval
local frameval
local frameBias = im.FloatPtr(0)

local lightmgr
local shadowdisable = 0
local dynLight = true
local enableShadows = false
local smartShadows = false

local playerPosDebugEnabled = false
local skipCameraEnabled = false
local skipRealTime = false

local lastjobCount

--weather
local rainamnt = nil
local fogscaleval = nil
local colorval = nil
local sunval = nil
local ambientval = nil
local fogamnt = nil
local vol = nil

local roughnessVal = nil
local groundVal = nil
local isWet = 0

local decalroad = nil

--lod stuff
local LOD
local LODDEF
local lodBias = im.FloatPtr(0)

--renderdistance
local renderBias = im.FloatPtr(0)
local defaultDistance

--speed trap
local speed
local speedLimit = nil
local location = ""
local data
local speedData
local unit = tostring( settings.getValue("uiUnitLength") )
local speedtrapFilePath
local showBoard = false
local oldversion = nil
local changed_version = false

--bigmap
local bigmapvalue = 0

--level data
local levelfolder = nil
local levelname =  nil
local appTitle = "Map Controller"


local toolWindowName = 'map_controller'

local function onClientStartMission()
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  log('I', '', 'Getting current level path' )
  levelname = getCurrentLevelIdentifier()
  --print(levelname)
  log('I', '', 'Level is loaded' )
  levelfolder = ("/levels/" .. levelname .. "/")
  appTitle = "Map Controller"
  if TorqueScriptLua then
    log("I", "", "onCLientStartMission get LOD variable")
    LOD = tonumber(TorqueScriptLua.getVar("$pref::TS::detailAdjust"))
    LODDEF = LOD
    defaultDistance = scenetree.theLevelInfo.visibleDistance
    speedtrapFilePath = 'settings/cloud/ck-'..levelname..'-speedtrap.json'
    speedData = jsonReadFile(speedtrapFilePath)
    lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
    log('I', '', lightmgr )
    shadowdisable = tonumber(TorqueScriptLua.getVar("$pref::Shadows::disable"))
    log('I','', shadowdisable )
  end
end

--get scene tree all objects
local function getSimObjects(fileName)
  local ret = {}
  local objs = scenetree.getAllObjects()
  --log('E', '', '# objects existing: ' .. tostring(#scenetree.getAllObjects()))
  for _, objName in ipairs(objs) do
    local o = scenetree.findObject(objName)
    if o and o.getFileName then
      if o:getFileName() == fileName then
        table.insert(ret, o)
      end
    end
  end
  return ret
  --log('E', '', '# objects left: ' .. tostring(#scenetree.getAllObjects()))
end

local function getFontList()
  local fonts = {}
  for i = 0, im.IoFontsGetCount() - 1 do
    table.insert(fonts,
    {
      name = ffi.string(im.IoFontsGetName(i))
    })
  end
  return fonts
end

--Hide Elements of map

local function setHiddenRec(object, hidden)
  object.hidden = hidden
  if object:isSubClassOf("SimSet") then
    for i=0, object:size() - 1 do
      setHiddenRec(object:at(i), hidden)
    end
  end
end

local function hideGroup(groupName, hidden)
  if not groupName then
    log('E', "", "Group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Group is missing, please contact level author', icon = "goat"})
  else
  local group = scenetree.findObject(groupName)
  if group then setHiddenRec(group, hidden) end
  end
end

--change material data
local function setMaterialProperty(material, property, layer, value)
  --guihooks.trigger('menuHide')
  --guihooks.trigger('app:waiting', true)
  if type(material) == "string" then
    material = scenetree.findObject(material)
  end

  if material.___type == "class<Material>" then
    material:setField(property, layer, value)
    --we do not want to flush materials
    --material:flush()
    --print("reloading material")
    material:reload()
    --guihooks.trigger('app:waiting', false) -- shows the loading icon
    return true
  else
    log('E', "", "Given object is not a material.")
    return false
  end
end
local lightTable = {}

--Dynamic Lights
local function setAllLightsEnabled(group, value)
  if not group then
  else
  for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      if obj and obj.obj:isSubClassOf('LightBase') then
          obj.obj:setLightEnabled( value )
      end
  end
end
end

--DynamicPositionBasedLights
local function setAllLightsPosEnabled(job, group, value, pos1, pos2, shdwpos1, shdwpos2, shadowvalue)
  if not group then
  else
  --reset table every refresh
  lightTable = {}
  for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      job.sleep(0.00001) -- sleep for one frame, evens impact on performance

      if obj and obj.obj:isSubClassOf('LightBase') then
        local pos = string.split(obj.obj:getField('position', 0))
        local posX = tonumber(pos[1])
        local posY = tonumber(pos[2])
        local posZ = tonumber(pos[3])
        if posX > pos1.x and posY > pos1.y and posZ > pos1.z and posX < pos2.x and posY < pos2.y and posZ < pos2.z then
          obj.obj:setLightEnabled( value )
          --get position of enabled lights
          if playerPosDebugEnabled == true then
            local pos = string.split(obj.obj:getField('position', 0))
            local posX = tonumber(pos[1])
            local posY = tonumber(pos[2])
            local posZ = tonumber(pos[3])
            local lightpos = vec3(posX, posY, posZ)
            table.insert(lightTable, lightpos)
          end
          if smartShadows == true then
            if posX > shdwpos1.x and posY > shdwpos1.y and posZ > shdwpos1.z and posX < shdwpos2.x and posY < shdwpos2.y and posZ < shdwpos2.z then
              obj.castShadows = shadowvalue
            else
              obj.castShadows = false
            end
          end
        else
          obj.obj:setLightEnabled( false )
        end
      end
    end
  end
end



local function onPlayerPosition(group, value)
  --fallback offset
  local offset = vec3(1000,1000,1000)
  local shdwoffset = vec3(256,256,256)
  --debug offset for now
  --local offset = vec3(data,data,data)
  local veh
  veh = be:getPlayerVehicle(0)
  --would be nice to know if user is using free cam for photos/gameplay
  freeCam = commands.isFreeCamera()
  --update pos every 100 frames
  if waitForFrame <= 0 then
    waitForFrame = 100
    if frameval then
      waitForFrame = frameval
    end
  end
  if veh or freeCam then
    if skipCameraEnabled == true and playerPosDebugEnabled == true and veh then
      playerPos = vec3(veh:getPosition())
      local matrix = veh:getRefNodeMatrix()
      local forVec = vec3(matrix:getColumn(1))
      playerRot = math.atan2(forVec.x, -forVec.y)*180/ math.pi
      playerRot = (playerRot > 0 and playerRot) or (playerRot + 360)
    elseif freeCam then
      playerPos = vec3(getCameraPosition())
      local camera = commands.getCamera()
      local controlId = camera:getID()
      local sobj = scenetree[controlId]
      local matrix = sobj:getTransform()
      local forVec = vec3(matrix:getColumn(1))
      playerRot = math.atan2(forVec.x, -forVec.y)*180/ math.pi
      playerRot = (playerRot > 0 and playerRot) or (playerRot + 360)
    else
      playerPos = vec3(veh:getPosition())
      local matrix = veh:getRefNodeMatrix()
      local forVec = vec3(matrix:getColumn(1))
      playerRot = math.atan2(forVec.x, -forVec.y)*180/ math.pi
      playerRot = (playerRot > 0 and playerRot) or (playerRot + 360)
    end
    if playerPos then
      if offsetval then
        offset = vec3(offsetval,offsetval,offsetval)
      end
      --print(playerRot)
      if playerRot <= 340 and playerRot >= 250 or playerRot <= 150 and playerRot >= 60 then
        shdwoffset = vec3(256,128,24)
      end
      if playerRot <= 250 and playerRot >= 150 or playerRot <= 60 or playerRot >= 340 then
        shdwoffset = vec3(128,256,24)
      end
      OffsetA = playerPos - offset
      OffsetB = playerPos + offset
      ShdwOffsetA = playerPos - shdwoffset
      ShdwOffsetB = playerPos + shdwoffset
      --local relativePosWid = relativePos:width()
      --we set lights through background task to reduce stutter
      extensions.core_jobsystem.create(setAllLightsPosEnabled, 1, group, value, OffsetA, OffsetB, ShdwOffsetA, ShdwOffsetB, true)
    end
  end
end


--Gameengine decal road workaround
local function fixDecalRoad(group)
  if not group then
    log('E', "", "Night reflection group is missing, please contact level author")
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    decalroad = scenetree.findObjectById(id)
    decalroad.renderPriority = 9
    decalroad.renderPriority = 10
  end
end
end

--DynamicWeather
local function setWeather(fogscaleval, colorval, sunval, ambientval, fogamnt, group, rainamnt, vol)
    core_environment.setFogScaleGradientFile(fogscaleval)
    core_environment.setColorizeGradientFile(colorval)
    core_environment.setSunScaleGradientFile(sunval)
    core_environment.setAmbientScaleGradientFile(ambientval)
    core_environment.setTimeOfDay(tod)
    core_environment.setFogDensity(fogamnt)
    --core_environment.setPrecipitation(rainamnt)
    for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local precipitation = scenetree.findObjectById(id)
      local sfx = scenetree.findObjectById(id)
      precipitation.numDrops = rainamnt
      sfx.volume = vol
      sfx:postApply()
    end
    guihooks.trigger('Message', {ttl = 10, msg = 'Weather Changed', icon = "goat"})
end

--simple dynamic level cubemap experiment
local cubemapname

local function setCubemap(cubemapname)
  if cubemapname then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      log("I", "", "Enabling cubemap " ..cubemapname)
      levelinf:setField('globalEnviromentMap', 0, cubemapname)
      levelinf:postApply()
    else
      log("W", "", "Enabling fallback cubemap " ..cubemapname)
      setConsoleVariable("$defaultLevelEnviromentMap", cubemapname)
    end
  end
end



local cubevalue = false

local function onUpdate(dtReal)
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  if freeroam_bigMapMode then
    local dont_showUI = freeroam_bigMapMode.bigMapActive() == true or photoModeOpen
  end
  if not dont_showUI then
   --imgui app
  im.Begin(appTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  tod = scenetree.tod
  if not tod then
  im.Text("There is no TOD")
  im.Text("")
  else

  im.Text("Смена погоды")
  im.Separator()
  if im.Button("Чистая погода") then
    core_environment.setTimeOfDay(tod)
	hideGroup("raingermany", true)
	guihooks.trigger('Message', {ttl = 10, msg = 'Вы включили чистую погоду', icon = "cloud_done"})
  end
  if im.Button("Дождь") then
    core_environment.setTimeOfDay(tod)
	hideGroup("raingermany", false)
	guihooks.trigger('Message', {ttl = 10, msg = 'Вы включили дождь', icon = "cloud_done"})
  end
end
im.Separator()
if TorqueScriptLua then
  im.Text("Дистанция прогрузки LOD")
  lodBias[0] = tonumber(TorqueScriptLua.getVar("$pref::TS::detailAdjust") or 1) * 100
  im.PushItemWidth(100)
  if im.SliderFloat("", lodBias, 1, 800, "%.1f") then
    LOD = lodBias[0] / 100
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LOD)
  end
  im.SameLine()
  if im.Button("Сбросить значение прогрузки LOD") then
    guihooks.trigger('Message', {ttl = 10, msg = 'Вы сбросили выставленные настройки', icon = "done"})
    if LODDEF == nil then
      TorqueScriptLua.setVar("$pref::TS::detailAdjust", 1)
    else
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
    end
  end

  im.Text("Дистанция видимости")
  renderBias[0] = scenetree.theLevelInfo.visibleDistance or 3000
  im.PushItemWidth(100)
  if im.SliderFloat("##", renderBias, 1000, 8000, "%.1f") then
    scenetree.theLevelInfo.visibleDistance = renderBias[0]
    scenetree.theLevelInfo:postApply()
    core_environment.setTimeOfDay(tod)
  end
  im.SameLine()
  if im.Button("Сбросить значение дистанцим видимости") then
    guihooks.trigger('Message', {ttl = 10, msg = 'Вы сбросили выставленные настройки', icon = "done"})
    if defaultDistance == nil then
      scenetree.theLevelInfo.visibleDistance = 3000
      scenetree.theLevelInfo:postApply()
      core_environment.setTimeOfDay(tod)
    else
      scenetree.theLevelInfo.visibleDistance = defaultDistance
      scenetree.theLevelInfo:postApply()
      core_environment.setTimeOfDay(tod)
    end
  end
end
  im.Separator()
  im.Text("Автор оригинального меню: Car_Killer")
  im.Text("Автор изменений и оптимизации: Moonwork Workshop")
  im.Text("Сделано специально для MDS MIX")
im.End()

end

    --check for TOD
    if not tod then return end
    local value = false
    if tod.time > 0.21 and tod.time < 0.79 then
      if cubevalue == false then
        cubemapname = "cubemap_c1night_reflection"
        setCubemap(cubemapname)
        print("night")
        cubevalue = true
      end
      value = true
    else
      if cubevalue == true then
        cubemapname = "cubemap_c1_reflection"
        setCubemap(cubemapname)
        print("day")
        cubevalue = false
      end
    end
  if TorqueScriptLua then
    if lightmgr == "Basic Lighting" then
    else
      if dynLight == true then
        --we don't need to update every frame
        if waitForFrame > 0 then
          if skipRealTime == true and playerPosDebugEnabled == true then
          waitForFrame = waitForFrame - 0.5
          else
          waitForFrame = waitForFrame - dtReal*50
          end
        end
        if waitForFrame <= 0 then
          lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
          shadowdisable = tonumber(TorqueScriptLua.getVar("$pref::Shadows::disable"))
          onPlayerPosition(scenetree.Tunnel_lights, true)
          onPlayerPosition(scenetree.Tunnel_sounds, true)
          if value == true then
            onPlayerPosition(scenetree.LightGroup1, value)
            lastValue = true
          end
          if value == false and lastValue == true then
            onPlayerPosition(scenetree.LightGroup1, false)
            lastValue = false
          end
        end
        --enable debug features
        if playerPosDebugEnabled == true then
          playerPosDebug()
        end
      elseif lastValue ~= true then
        if core_jobsystem.getRunningJobCount() ~= 0 then
          -- no jobs?
        local jobCount = core_jobsystem.getRunningJobCount()
        if jobCount ~= lastjobCount then
          lastjobCount = core_jobsystem.getRunningJobCount()
          log("I", "", "Wait for setAllLightsPosEnabled "..tostring(core_jobsystem.getRunningJobCount()))
        end
        else
          log("I", "", "Fallback lights")
          setAllLightsEnabled(scenetree.Tunnel_lights, true)
          setAllLightsEnabled(scenetree.Tunnel_sounds, true)
          lastValue = true
        end
      end
    end
    if freeroam_bigMapMode then
      if freeroam_bigMapMode.bigMapActive() == true then
        if bigmapvalue == 0 or bigmapvalue == 2 then
          TorqueScriptLua.setVar("$pref::TS::detailAdjust", 4)
          hideGroup("water", true)
          hideGroup("bigmap_helper", false)
          bigmapvalue = 1
        end
      elseif bigmapvalue == 1 then
        if LODDEF == nil then
          TorqueScriptLua.setVar("$pref::TS::detailAdjust", 1)
        else
        TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
        end
        hideGroup("water", false)
        hideGroup("bigmap_helper", true)
        bigmapvalue = 2
      end
    end
  end

end

local function onEditorInitialized()
  editor.addWindowMenuItem("Map Controller", onWindowMenuItem, {groupMenuName = 'Car_Killer Addons'})
  editor.registerWindow(toolWindowName, im.ImVec2(500, 200))

end

local function onExit()
  if TorqueScriptLua then
    log("I", "", "onExit restored LOD to default previous one")
    TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
  end
end


M.onPreRender = onPreRender
M.onClientStartMission = onClientStartMission
M.onClientEndMission = onExit
M.setAllLightsPosEnabled = setAllLightsPosEnabled
M.onUpdate = onUpdate
M.onBeamNGTrigger = onBeamNGTrigger
M.onEditorInitialized = onEditorInitialized
M.onEditorActivated = onEditorActivated
M.onEditorDeactivated = onEditorDeactivated
M.onExit = onExit

return M
--Written in Visual Studio Code with Yukino Yukinoshita theme by Car_Killer 2022