angular.module('beamng.apps')
.directive('raceStatsApp', [function () {
  return {
    template: `
      <object class="bngApp" style="width:100%; height:100%; pointer-events: none" type="image/svg+xml" data="/ui/modules/apps/raceStatsApp/race-stats.svg"></object>
    `,
    replace: true,
    restrict: 'EA',
    link: function (scope, element, attrs) {
      StreamsManager.add(['raceResults', 'electrics']);

      scope.$on('$destroy', function () {
        StreamsManager.remove(['raceResults', 'electrics']);
      });

      element.on('load', function () {
        var svg = element[0].contentDocument;
        injectFontStyle(svg);
        updateCurrentDateTime(svg);

        scope.$on('RaceFinished', function (event, results) {
          if(results.lanes[2]) {
            results.lanes[0] = results.lanes[2];
            results.lanes[2] = null;
          }
          console.log('RaceFinished event received:', results); // Logging race results for troubleshooting

          let minTime = Number.POSITIVE_INFINITY;
          let winningLaneId = null;
          let totalTimeByLane = {};

          var currentIndex = 0;
          while(results.lanes[currentIndex]) {
            const lane = results.lanes[currentIndex];
            const lanePrefix = lane.laneId === 1 ? 'Left' : 'Right';
            const totalTime = parseFloat(lane.time);
            totalTimeByLane[lane.laneId] = totalTime;  // Store total time by lane ID

            //updateSvgText(svg, lanePrefix + 'TotalTime', totalTime.toFixed(3) + ' s');

            if (totalTime < minTime) {
              minTime = totalTime;
              winningLaneId = lane.laneId;
            }

            updateLaneData(svg, lane, lanePrefix);
            currentIndex++;
          }

          // If only one lane was used, handle it here
          if (results.lanes.length === 1) {
            const laneIndex = results.lanes[0] ? 0 : 1;
            const usedLaneId = results.lanes[laneIndex].laneId;
            const unusedLaneId = usedLaneId === 1 ? 2 : 1; // Determine the unused lane ID
            const unusedLanePrefix = usedLaneId === 1 ? 'Right' : 'Left';

            // Set text for unused lane to indicate it wasn't used
            updateSvgText(svg, unusedLanePrefix + 'CarNumber', 'Not Used');
            updateSvgText(svg, unusedLanePrefix + 'ReactionTime', '');
            // Add other properties as needed

            // Add any other logic specific to handling a single lane race
          }

          // Determine the winning and losing lanes
          const winningLanePrefix = winningLaneId === 1 ? 'Left' : 'Right';
          const losingLaneId = winningLaneId === 1 ? 2 : 1;  // Assumes two lanes
          const losingLanePrefix = losingLaneId === 1 ? 'Left' : 'Right';

          // Calculate FinishETDifference
          const finishETDifference = Math.abs(totalTimeByLane[winningLaneId] - totalTimeByLane[losingLaneId]).toFixed(3);

          updateSvgText(svg, 'FinishWinningLane', winningLanePrefix);
          updateSvgText(svg, 'FinishETDifference', finishETDifference + ' s');
        });
      });

		function injectFontStyle(svg) {
		  const styleElement = document.createElement('style');
		  styleElement.textContent = `
			@font-face {
			  font-family: 'Straphanger';
			  src: url('/ui/common/straphanger.ttf') format('truetype');
			}
			text {
			  font-family: 'Straphanger', sans-serif;
			}
		  `;

		  // Find the root <svg> element
		  const svgRoot = svg.querySelector('svg');

		  if (svgRoot) {
			svgRoot.appendChild(styleElement);
		  } else {
			console.error('Root SVG element not found');
		  }
		}

		function updateSvgText(svg, id, text) {
		  let element = svg.getElementById(id);
		  if (element && text !== undefined) {
			element.textContent = text;
		  } else {
			console.error(`Missing SVG element or data for ID: ${id}`);
		  }
		}

      function updateLaneData(svg, laneData, lanePrefix) {
        const reactionTime = parseFloat(laneData.reactionTime);
        const adjustedTime = parseFloat(laneData.time);

        updateSvgText(svg, lanePrefix + 'CarNumber', laneData.playerName);
        updateSvgText(svg, lanePrefix + 'ReactionTime', reactionTime.toFixed(3) + ' ');
        updateSvgText(svg, lanePrefix + '60ft', (parseFloat(laneData.sixtyTime)).toFixed(3) + ' ');
        updateSvgText(svg, lanePrefix + '330ft', (parseFloat(laneData.threeThirtyTime)).toFixed(3) + ' ');
        updateSvgText(svg, lanePrefix + 'EighthET', (parseFloat(laneData.eighthTime)).toFixed(3) + ' ');
        updateSvgText(svg, lanePrefix + 'EighthMPH', parseFloat(laneData.eighthSpeed).toFixed(2) + ' ');
        updateSvgText(svg, lanePrefix + '1000ft', (parseFloat(laneData.oneThousandTime)).toFixed(3) + ' ');
        updateSvgText(svg, lanePrefix + 'FinishET', adjustedTime.toFixed(3) + ' ');
        updateSvgText(svg, lanePrefix + 'FinishMPH', parseFloat(laneData.speed).toFixed(2) + ' ');

        // Print 'Red' if inFalseStart is true
        if (laneData.reactionTime < 0) {
          updateSvgText(svg, lanePrefix + 'RedLight', 'RedLight');
        } else {
          updateSvgText(svg, lanePrefix + 'RedLight', '');
        }
      }

      function updateCurrentDateTime(svg) {
        const now = new Date();
        const day = now.toLocaleDateString('en-US', { day: '2-digit', timeZone: 'America/Denver' });
        const month = now.toLocaleDateString('en-US', { month: 'short', timeZone: 'America/Denver' }).toUpperCase();
        const year = now.toLocaleDateString('en-US', { year: 'numeric', timeZone: 'America/Denver' });

        const dateShort = now.toLocaleDateString('en-US', { month: 'long', day: '2-digit', timeZone: 'America/Denver' });
        const dateLong = `${day}/${month}/${year}`;
        const currentTime = now.toLocaleTimeString('en-US', {
          hour: '2-digit',
          minute: '2-digit',
          hour12: true,
          timeZone: 'America/Denver'
        });

        updateSvgText(svg, 'DateShort', dateShort);
        updateSvgText(svg, 'CurrentTime', currentTime);
        updateSvgText(svg, 'DateLong', dateLong);
      }
    }
  };
}]);