--------------------------------------
-- Bandimere DragLights script --
-- Made by 2FastRacing | www.2fast.racing --
--------------------------------------

local M = {}
local Objects = {}
local race_results = {}
local lane_side = { 0, 0 }
local sixty_time = { 0, 0 }
local sixty_speed = { 0, 0 }
local threethirty_time = {0, 0}
local eighth_time = {0, 0}
local eighth_speed = {0, 0}
local onethousand_time = {0, 0}
local in_prestage = { false, false }
local has_finished = { false, false }
local in_stage = { false, false }
local in_stage_time = 0
local in_false_start = false
local crossed = false
local in_race = false
local in_race_time = 0
local isProStyle = true
local printticket = false
local reactionTime = { 0, 0 }
local user = {}
local isEighthMile = false
local ticketBooth = false
local MAX_RACE_TIME = 30


if Steam and Steam.isWorking and Steam.accountLoggedIn then
    user = Steam.playerName
else
    user = "Unknown"  -- Fixed typo and ensured it is a string
end

local function InPreStage() --Check prestage status
local ret = 0
if in_prestage[1] then ret = ret + 1 end
if in_prestage[2] then ret = ret + 1 end
return ret
end

local function allInStage()
local numPrestage = InPreStage()
if numPrestage == 0 then
return false
end

local num = 0 --math
if in_stage[1] then num = num + 1 end
if in_stage[2] then num = num + 1 end
return num == numPrestage
end

  local function hideLaneLights(lane) --Set lights hidden by default
    Objects[lane].lights.prestage:setHidden(true)
    Objects[lane].lights.stage:setHidden(true)
    for _, v in ipairs(Objects[lane].lights.amber) do
      v:setHidden(true)
    end
    --Objects[lane].lights.green:setHidden(true)
    Objects[lane].lights.green:setHidden(true)
    Objects[lane].lights.red:setHidden(true)
  end

local function hideDisplay(display) --Set display hidden by default
	for _, v in ipairs(display.digits) do
		v:setHidden(true)
	end
	display.dot:setHidden(true)
end

local function resetLaneDisplays(lane)
	hideDisplay(Objects[lane].displays.time)
	hideDisplay(Objects[lane].displays.speed)
	hideDisplay(Objects[lane].displays.stagingtimedisp)
	hideDisplay(Objects[lane].displays.stagingspeeddisp)
end

local function setDisplay(display, number, digits) --Set the drag displays ready
	if number == 0 then
		hideDisplay(display)
		return
	end

	local str_left = tostring(math.floor(number) % (10 ^ digits))
	local str_right = tostring(number % 1):sub(3)

	for i = 1, 5, 1 do
		local c = '0'
		if i <= digits then
			local index = i - (digits - #str_left)
			c = str_left:sub(index, index)
		else
			local index = i - digits
			c = str_right:sub(index, index)
		end

		if c ~= '' then
			local path = '/levels/bandimere/art/shapes/quarter_mile_display/display_' .. c .. '.dae'

			display.digits[i]:preApply()
			display.digits[i]:setField('shapeName', 0, path)
			display.digits[i]:setHidden(false)
			display.digits[i]:postApply()
		else
			display.digits[i]:setHidden(true)
		end
	end

	display.dot:setHidden(false)
end

local function resetLane(lane)
	hideLaneLights(lane)
	resetLaneDisplays(lane)
end

local function resetAllLanes() --Reset all lanes
resetLane(1)
resetLane(2)

lane_side = { 0, 0 }

in_prestage = { false, false }
in_stage = { false, false }
has_finished = { false, false }
in_false_start = { false, false }
in_race = false
crossed = { false, false }
end

local function stopWithReason(reason)
    print('== Stopping: ' .. reason)
    resetAllLanes()
    -- Here you might also want to handle any UI notifications or logs
    in_race = false
    in_race_time = 0
    -- Optionally add more logic to inform the user via GUI or other means
end

local function getObjects(side) --Identify map objects
	local ret = {}

	ret.lights = {}
	ret.lights.prestage = scenetree.findObject('lightPrestage' .. side)
	ret.lights.stage = scenetree.findObject('lightStage' .. side)
	ret.lights.amber = {
		scenetree.findObject('lightAmber' .. side .. '1'),
		scenetree.findObject('lightAmber' .. side .. '2'),
		scenetree.findObject('lightAmber' .. side .. '3'),
	}
	ret.lights.green = scenetree.findObject('lightGreen' .. side)
	ret.lights.red = scenetree.findObject('lightRed' .. side)

	ret.displays = {}
	ret.displays.time = {
		digits = {
			scenetree.findObject('timeDisp' .. side .. '1'),
			scenetree.findObject('timeDisp' .. side .. '2'),
			scenetree.findObject('timeDisp' .. side .. '3'),
			scenetree.findObject('timeDisp' .. side .. '4'),
			scenetree.findObject('timeDisp' .. side .. '5'),
		},
		dot = scenetree.findObject('timeDisp' .. side .. 'Dot'),
	}
	ret.displays.speed = {
		digits = {
			scenetree.findObject('speedDisp' .. side .. '1'),
			scenetree.findObject('speedDisp' .. side .. '2'),
			scenetree.findObject('speedDisp' .. side .. '3'),
			scenetree.findObject('speedDisp' .. side .. '4'),
			scenetree.findObject('speedDisp' .. side .. '5'),
		},
		dot = scenetree.findObject('speedDisp' .. side .. 'Dot'),
	}
	ret.displays.stagingtimedisp = {
        digits = {
            scenetree.findObject('stagingTimeDisp' .. side .. '1'),
            scenetree.findObject('stagingTimeDisp' .. side .. '2'),
            scenetree.findObject('stagingTimeDisp' .. side .. '3'),
            scenetree.findObject('stagingTimeDisp' .. side .. '4'),
            scenetree.findObject('stagingTimeDisp' .. side .. '5'),
        },
        dot = scenetree.findObject('stagingTimeDisp' .. side .. 'Dot'),
    }
	ret.displays.stagingspeeddisp = {
        digits = {
            scenetree.findObject('stagingSpeedDisp' .. side .. '1'),
            scenetree.findObject('stagingSpeedDisp' .. side .. '2'),
            scenetree.findObject('stagingSpeedDisp' .. side .. '3'),
            scenetree.findObject('stagingSpeedDisp' .. side .. '4'),
            scenetree.findObject('stagingSpeedDisp' .. side .. '5'),
        },
        dot = scenetree.findObject('stagingSpeedDisp' .. side .. 'Dot'),
    }

    return ret
end

local function loadObjects() --GetObjects
	Objects = {
		getObjects('L'),
		getObjects('R'),
	}
end

local function findVehicleLane(vehicle) --Get Vehicle Lane
if lane_side[1] == vehicle then
return 1
elseif lane_side[2] == vehicle then
return 2
end
return 0
end

local function onClientPostStartMission() --initialize the script
loadObjects()
resetAllLanes()

print([[
    /$$$$$$  /$$$$$$$$ /$$$$$$   /$$$$$$  /$$$$$$$$       /$$$$$$$  /$$$$$$$   /$$$$$$   /$$$$$$   /$$$$$$  /$$     /$$
   /$$__  $$| $$_____//$$__  $$ /$$__  $$|__  $$__/      | $$__  $$| $$__  $$ /$$__  $$ /$$__  $$ /$$__  $$|  $$   /$$/
  |__/  \ $$| $$     | $$  \ $$| $$  \__/   | $$         | $$  \ $$| $$  \ $$| $$  \ $$| $$  \__/| $$  \__/ \  $$ /$$/
    /$$$$$$/| $$$$$  | $$$$$$$$|  $$$$$$    | $$         | $$  | $$| $$$$$$$/| $$$$$$$$| $$ /$$$$| $$ /$$$$  \  $$$$/
   /$$____/ | $$__/  | $$__  $$ \____  $$   | $$         | $$  | $$| $$__  $$| $$__  $$| $$|_  $$| $$|_  $$   \  $$/
  | $$      | $$     | $$  | $$ /$$  \ $$   | $$         | $$  | $$| $$  \ $$| $$  | $$| $$  \ $$| $$  \ $$    | $$
  | $$$$$$$$| $$     | $$  | $$|  $$$$$$/   | $$         | $$$$$$$/| $$  | $$| $$  | $$|  $$$$$$/|  $$$$$$/    | $$
  |________/|__/     |__/  |__/ \______/    |__/         |_______/ |__/  |__/|__/  |__/ \______/  \______/     |__/
]])
print('== 2FastRacing Drag script initialized')
end

local function onExtensionLoaded() --initialize the script on reload
loadObjects()

if Objects[1].lights.prestage ~= nil then --fix lights
resetAllLanes()

print([[
    /$$$$$$  /$$$$$$$$ /$$$$$$   /$$$$$$  /$$$$$$$$       /$$$$$$$  /$$$$$$$   /$$$$$$   /$$$$$$   /$$$$$$  /$$     /$$
   /$$__  $$| $$_____//$$__  $$ /$$__  $$|__  $$__/      | $$__  $$| $$__  $$ /$$__  $$ /$$__  $$ /$$__  $$|  $$   /$$/
  |__/  \ $$| $$     | $$  \ $$| $$  \__/   | $$         | $$  \ $$| $$  \ $$| $$  \ $$| $$  \__/| $$  \__/ \  $$ /$$/
    /$$$$$$/| $$$$$  | $$$$$$$$|  $$$$$$    | $$         | $$  | $$| $$$$$$$/| $$$$$$$$| $$ /$$$$| $$ /$$$$  \  $$$$/
   /$$____/ | $$__/  | $$__  $$ \____  $$   | $$         | $$  | $$| $$__  $$| $$__  $$| $$|_  $$| $$|_  $$   \  $$/
  | $$      | $$     | $$  | $$ /$$  \ $$   | $$         | $$  | $$| $$  \ $$| $$  | $$| $$  \ $$| $$  \ $$    | $$
  | $$$$$$$$| $$     | $$  | $$|  $$$$$$/   | $$         | $$$$$$$/| $$  | $$| $$  | $$|  $$$$$$/|  $$$$$$/    | $$
  |________/|__/     |__/  |__/ \______/    |__/         |_______/ |__/  |__/|__/  |__/ \______/  \______/     |__/
]])
print('== 2FastRacing Drag script initialized from reload')
end
end

local function monitorLaneTriggers(lane, data)
local side = ''
if lane == 1 then
side = 'L'
elseif lane == 2 then
side = 'R'
end

if data.event == 'exit' then
  -- Remove the following block of code:
  -- if in_race and not has_finished[lane] then
  --   if data.triggerName == 'laneTrig' .. side then
  --     crossed = true
  --   end
  -- end
  if in_prestage[lane] and not in_stage[lane] then
    if data.triggerName == 'prestageTrig' .. side then
      in_prestage[lane] = false
      Objects[lane].lights.prestage:setHidden(true)
    end
  elseif in_stage[lane] then
    if data.triggerName == 'stageTrig' .. side then
      stopWithReason(side .. ' backed out of stage.')
    end
  end
end

if data.event == 'enter' then --If not in race ignore triggers.
if not in_race then
  if not in_prestage[lane] then
    if data.triggerName == 'prestageTrig' .. side then
      if in_false_start then
        in_false_start = false
        Objects[lane].lights.red:setHidden(true)
      end

      in_prestage[lane] = true
      Objects[lane].lights.prestage:setHidden(false)
      resetLaneDisplays(lane)

      lane_side[lane] = data.subjectID
    end

  elseif not in_stage[lane] then
    if data.triggerName == 'startTrig' .. side then
      has_finished[lane] = false
      in_stage[lane] = true
      in_stage_time = 0
      Objects[lane].lights.stage:setHidden(false)
    end
  end
end
end
end

local function printAligned(label, value, units)
local maxLabelWidth = 20
local paddedLabel = string.format("%-" .. maxLabelWidth .. "s", label)
local formattedValue = string.format("%9.3f", value)
print(paddedLabel .. " : " .. formattedValue .. " " .. units)
end

local finishtime
local finishspeed

local function onBeamNGTrigger(data)
    monitorLaneTriggers(1, data)
    monitorLaneTriggers(2, data)
    loadObjects()

    if data.event == 'enter' then
        local vehicle = be:getObjectByID(data.subjectID)
        local lane = findVehicleLane(data.subjectID)
        local timeOffset = 2.2 + reactionTime[lane]

          if data.triggerName == 'falseStartTrig' and in_race_time <= 2.2 then
            in_false_start = true
            Objects[lane].lights.red:setHidden(false)


        -- Calculate and print reaction time
      elseif data.triggerName == 'reactionTimeTrig' then
            reactionTime[lane] = in_race_time - 2.4
            setDisplay(Objects[lane].displays.time, reactionTime[lane], 2)

        elseif data.triggerName == 'sixtyTrig' then
            sixty_time[lane] = in_race_time - timeOffset
            setDisplay(Objects[lane].displays.time, sixty_time[lane] - reactionTime[lane], 2)

        elseif data.triggerName == 'threethirtyTrig' then
            threethirty_time[lane] = in_race_time - timeOffset
            setDisplay(Objects[lane].displays.time, threethirty_time[lane] - reactionTime[lane], 2)

        elseif data.triggerName == 'eighthTrig' then
            eighth_time[lane] = in_race_time - timeOffset
            eighth_speed[lane] = vehicle:getVelocity():len() * 2.2369362920544  -- mph conversion factor
            setDisplay(Objects[lane].displays.time, eighth_time[lane] - reactionTime[lane], 2)
            setDisplay(Objects[lane].displays.speed, eighth_speed[lane], 3)

          elseif data.triggerName == 'thousandTrig' then
      if not isEighthMile then
          onethousand_time[lane] = in_race_time - timeOffset
          setDisplay(Objects[lane].displays.time, onethousand_time[lane] - reactionTime[lane], 2)
          hideDisplay(Objects[lane].displays.speed)
      else
          onethousand_time[lane] = 0
      end

  elseif data.triggerName == 'finishTrig' then
      if not isEighthMile then
          finishtime = in_race_time - timeOffset
          finishspeed = vehicle:getVelocity():len() * 2.2369362920544
          setDisplay(Objects[lane].displays.time, finishtime, 2)
          setDisplay(Objects[lane].displays.speed, finishspeed, 3)
		  setDisplay(Objects[lane].displays.stagingtimedisp, finishtime, 2)
		  setDisplay(Objects[lane].displays.stagingspeeddisp, finishspeed, 3)
      else
          finishtime = 0
          finishspeed = 0
      end

            --elseif data.triggerName == 'timeSlip' then
            -- Store race data for the lane along with lane information
            race_results[lane] = {
                time = finishtime,
                speed = finishspeed,
                reactionTime = reactionTime[lane],
                sixtyTime = sixty_time[lane],
                sixtySpeed = sixty_speed[lane],
                eighthTime = eighth_time[lane],
                eighthSpeed = eighth_speed[lane],
                threeThirtyTime = threethirty_time[lane],
                oneThousandTime = onethousand_time[lane],
                laneId = (lane == 1) and 1 or 2,
                inFalseStart = in_false_start,
                playerName = user
            }

            in_prestage[lane] = false
            in_stage[lane] = false
            has_finished[lane] = true
            lane_side[lane] = 0
            hideLaneLights(lane)


            if InPreStage() == 0 then
                -- Both lanes have finished the race, print results and trigger GUI update
                local laneData = {
                    lanes = {
                        race_results[1],
                        race_results[2]
                    }
                }

                print('-- Race ended')
                guihooks.trigger('RaceFinished', laneData)

                print('-- Results --')
                printRaceResults(race_results, "L", 1)
                printRaceResults(race_results, "R", 2)

                in_race = false
            end
        end
    end
end

function printRaceResults(results, laneLabel, laneIndex)
local laneData = results[laneIndex]
if laneData then
    print(string.format('\nLane %s:', laneLabel))
    printAligned("Sixty foot time", laneData.sixtyTime or "N/A", "seconds")
    printAligned("Sixty foot speed", laneData.sixtySpeed or "N/A", "mph")
    printAligned("330 foot time", laneData.threeThirtyTime or "N/A", "seconds")
    printAligned("Eighth mile time", laneData.eighthTime or "N/A", "seconds")
    printAligned("Eighth mile speed", laneData.eighthSpeed or "N/A", "mph")
    printAligned("1000 foot time", laneData.oneThousandTime or "N/A", "seconds")
    printAligned("Finish time", laneData.time or "N/A", "seconds")
    printAligned("Finish speed", laneData.speed or "N/A", "mph")
    printAligned("Reaction time", laneData.reactionTime or "N/A", "seconds")
else
    print(string.format("No data for Lane %s", laneLabel))
end
end

function printAligned(label, value, unit)
print(string.format('%s: %.3f %s', label, value, unit))
end

local function setAllLightsEnabled(group, value)
for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    local obj = scenetree.findObjectById(id)
    if obj and obj.obj:isSubClassOf('LightBase') then
        obj.obj:setLightEnabled( value )
    end
end
end

local function onUpdate(dtReal, dtSim, dtRaw)
    if allInStage() then
        in_stage_time = in_stage_time + dtSim
        in_race_time = in_race_time + dtSim

        -- Calculate when to show lights based on in_stage_time
        if not in_race then
            in_race = true
            in_race_time = 0
        end

        -- Adjust conditions to control when lights come on
        if in_stage_time >= 2 then
            -- Show amber lights
            for lane = 1, 2 do
                if in_stage[lane] then
                    for i, v in ipairs(Objects[lane].lights.amber) do
                        v:setHidden(false)
                    end
                end
            end
        end

        if in_stage_time >= 2.4 then
            -- Show green light
            for lane = 1, 2 do
                if in_stage[lane] then
                    Objects[lane].lights.green:setHidden(false)
                end
            end
        end
    end

    -- Check if race time has exceeded the maximum allowed time
    if in_race and in_race_time > MAX_RACE_TIME then
        stopWithReason("Race timed out after exceeding maximum duration.")
    end


local tod = scenetree.tod
if not tod then return end

local value = false
if tod.time > 0.24 and tod.time < 0.77 then
    value = true
end

if lastValue == value then return end
lastValue = value
print('DynamicLights Loaded!')
if scenetree.NightLights then
    setAllLightsEnabled(scenetree.NightLights, value )
end
if scenetree.LightPosts then
    setAllLightsEnabled(scenetree.LightPosts, value )
end
end

M.onClientPostStartMission = onClientPostStartMission
M.onExtensionLoaded = onExtensionLoaded
M.onBeamNGTrigger = onBeamNGTrigger
M.onUpdate = onUpdate

return M
