
// This is the default save location for any ForestBrush(s) created in
// the Forest Editor.
// This script is executed from ForestEditorPlugin::onWorldEditorStartup().

//--- OBJECT WRITE BEGIN ---
new SimGroup(ForestBrushGroup) {
    canSave = "1";
    canSaveDynamicFields = "1";

    new ForestBrush() {
        internalName = "Trees_Dead";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "tree_oak_dead_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_oak_dead_a";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_oak_dead_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_dead_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "2";
            rotationRange = "360";
            scaleMin = "0.5";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_dead_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "2";
            rotationRange = "360";
            scaleMin = "0.5";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "ExampleForestBrush";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "ExampleElement";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "2";
            scaleExponent = "0.2";
            sinkMin = "0";
            sinkMax = "0.1";
            sinkRadius = "0.25";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "-10000";
            elevationMax = "10000";
                clumpCountExponent = "1";
                clumpCountMax = "1";
                clumpCountMin = "1";
                clumpRadius = "10";
        };
    };
    new ForestBrush() {
        internalName = "Grass_mesh";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "grass_field_filler";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "grass_field_long";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "grass_field_sml";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "10";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.6";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "grass_field_large";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "0";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "0";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "vines";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "vine_side_8m";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_side_4m";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_side_2m";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_side_1m";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_roof_wide";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_roof_small";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_roof_end";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_ground_medium";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_ground_large";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_ground_small";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_wall_wide_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_wall_wide_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_wall_small";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_wall_medium";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_wall_large";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_bush_wide";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_bush_wide_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_bush_small";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "vine_bush_large";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Lush";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "lush_general_01_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "2";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_general_01_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "10";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_general_01_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.6";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_general_01_d";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.6";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_general_01_e";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_ferns_02_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_ferns_02_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_big_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_big_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "NeedFix";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "lush_grass_01_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_grass_01_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_grass_01_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Trees_oak";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "oak_large_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.3";
            rotationRange = "360";
            scaleMin = "0.7";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "oak_large_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.7";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.4";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "oak_large_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.7";
            scaleMax = "1.4";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_oak_forest_canopy_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.6";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "3";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "oak_forest_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.7";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "oak_forest_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "oak_small_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.7";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "oak_sml_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "oak_bush_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.7";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "oak_bush_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.7";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "oak_bush_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.7";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Trees_Aspen";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "tree_aspen_large_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1.5";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_large_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1.5";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_small_low_group";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1.5";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.7";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_small_low";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_small_d";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.5";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_small_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.5";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_small_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.5";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.4";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_small_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.5";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_forest_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_forest_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "2";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_overhang_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Trees_Douglas_Fir";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "tree_douglasfir_large_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_large_a";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_douglasfir_large_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_large_b";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_douglasfir_large_d";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_large_d";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_douglasfir_small_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_small_a";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_douglasfir_small_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_small_b";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_douglasfir_small_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_small_c";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_douglasfir_small_d";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_small_d";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_douglasfir_bush_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_bush_a";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_douglasfir_bush_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_bush_b";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_douglasfir_group";
            canSave = "1";
            canSaveDynamicFields = "1";
            ForestItemData = "tree_douglasfir_group";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Trees_Beech";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "tree_beech_large_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.6";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_large_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.6";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_forest_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_forest_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_small_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "35";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_small_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.4";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "35";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_small_d";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.7";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "35";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_overhang_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Trees_palm";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "tree_palm_f";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_palm_e";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_palm_d";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_palm_overhang_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_palm_overhang_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_palm_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_palm_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_palm_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.4";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Trees_Blocker";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "tree_oak_blocker_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "2";
            rotationRange = "360";
            scaleMin = "0.5";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "1";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_blocker_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.7";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_blocker_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.5";
            rotationRange = "360";
            scaleMin = "0.7";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Ferns";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "lush_ferns_01_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "2";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "lush_ferns_01_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "2";
            rotationRange = "360";
            scaleMin = "0.9";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "30";
            elevationMin = "39.3042";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Bushes_huge";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "tree_beech_bush_d";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.3";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_bush_e";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.32";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.2";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "90";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Bushes_large";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "tree_aspen_bush_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "3";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.3";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_aspen_bush_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1.5";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_bush_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.5";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_bush_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "Bushes_small";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "tree_aspen_bush_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1.5";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.1";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "25";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "tree_beech_bush_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "40";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "rocks_01_a_large";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "rock_01_a_large_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.2";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "rock_01_a_large_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.2";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "rock_01_a_large_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "1.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.2";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "rocks_01_a_small";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "rock_01_a_small_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "2.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.05";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "rock_01_a_small_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "2.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.05";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "rock_01_a_small_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "1";
            scaleMax = "2.5";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0.05";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrushElement() {
        internalName = "utah_greybush_01";
        canSave = "1";
        canSaveDynamicFields = "1";
        probability = "1";
        rotationRange = "360";
        scaleMin = "1";
        scaleMax = "1.5";
        scaleExponent = "1";
        sinkMin = "0";
        sinkMax = "0";
        sinkRadius = "1";
        slopeMin = "0";
        slopeMax = "90";
        elevationMin = "-10000";
        elevationMax = "10000";
    };
    new ForestBrush() {
        internalName = "utah_rocks_big";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "utah_rock_big_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.5";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "utah_rock_big_d";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.5";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "utah_rock_big_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.5";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "utah_rock_big_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.5";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
    new ForestBrush() {
        internalName = "utah_rocks_small";
        canSave = "1";
        canSaveDynamicFields = "1";

        new ForestBrushElement() {
            internalName = "utah_rock_small_a";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "0.3";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "utah_rock_small_b";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "utah_rock_small_c";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "utah_rock_small_d";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
        new ForestBrushElement() {
            internalName = "utah_rock_small_e";
            canSave = "1";
            canSaveDynamicFields = "1";
            probability = "1";
            rotationRange = "360";
            scaleMin = "0.8";
            scaleMax = "1.2";
            scaleExponent = "1";
            sinkMin = "0";
            sinkMax = "0";
            sinkRadius = "1";
            slopeMin = "0";
            slopeMax = "45";
            elevationMin = "-10000";
            elevationMax = "10000";
        };
    };
};
//--- OBJECT WRITE END ---
