-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

-- In other words, if you are a modder feel free to reuse this code with above license

--If you reload Lua with CTRL+L use thise in the GE console `extensions.mainLevel.onClientStartMission()

local windowOpen = ui_imgui.BoolPtr(true)

local M = {}
M.dependencies = {"ui_imgui"}
local im = ui_imgui
local ffi = require("ffi")

--independent GUI
local showUI = nil
local tempFloat = nil

--scenetree
local objects = nil

local shadowvalue = nil

local tod = nil

local light = nil

--weather
local rainamnt = nil
local fogscaleval = nil
local colorval = nil
local sunval = nil
local ambientval = nil
local fogamnt = nil
local vol = nil

local roughnessVal = nil
local groundVal = nil
local isWet = 0

--lod stuff
local LOD
local LODDEF
local lodBias = im.FloatPtr(0)

--level data
local levelfolder = nil
local levelname =  nil
local emission = 0
local tool_version = "1.1"
local appTitle = " CK Map Controller - ".. tool_version .." - ".. "no-init" .." - ".. beamng_arch

local toolWindowName = 'map_controller'

local function onClientStartMission()
  log('I', '', 'Getting current level path' )
  levelname = getCurrentLevelIdentifier()
  --print(levelname)
  log('I', '', 'Level is loaded' )
  levelfolder = ("/levels/" .. levelname .. "/")
  appTitle = " CK Map Controller - ".. tool_version .." - ".. levelname .." - ".. beamng_arch
  log("I", "", "onCLientStartMission Set low LOD variable to get fps hack")
  LOD = tonumber(TorqueScriptLua.getVar("$pref::TS::detailAdjust"))
  LODDEF = LOD
end 

local function uiSliderFloat(label, v, v_min, v_max, format, power, editEnded)
  local res = im.SliderFloat(label, v, v_min, v_max, format, power)
  if editEnded then
    editEnded[0] = im.IsItemDeactivatedAfterEdit()
  end
  return res
end

--get scene tree all objects
local function getSimObjects(fileName)
  local ret = {}
  local objs = scenetree.getAllObjects()
  --log('E', '', '# objects existing: ' .. tostring(#scenetree.getAllObjects()))
  for _, objName in ipairs(objs) do
    local o = scenetree.findObject(objName)
    if o and o.getFileName then
      if o:getFileName() == fileName then
        table.insert(ret, o)
      end
    end
  end
  return ret
  --log('E', '', '# objects left: ' .. tostring(#scenetree.getAllObjects()))
end

--change material data
local function setMaterialProperty(material, property, layer, value)
  --guihooks.trigger('menuHide')
  --guihooks.trigger('app:waiting', true)
  if type(material) == "string" then
    material = scenetree.findObject(material)
  end

  if material.___type == "class<Material>" then
    material:setField(property, layer, value)
    --we do not want to flush materials
    --material:flush()
    --print("reloading material")
    material:reload()
    --guihooks.trigger('app:waiting', false) -- shows the loading icon
    return true
  else
    log('E', "", "Given object is not a material.")
    return false
  end
end

--Dynamic Lights
local function setAllLightsEnabled(group, value)
  if not group then
    log('E', "", "Night lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Night lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      if obj and obj.obj:isSubClassOf('LightBase') then
          obj.obj:setLightEnabled( value )
      end
  end
end
end

--DynamicShadows
local function setAllLightsShadowsEnabledDisabled(group, shadowvalue)
  if not group then
    log('E', "", "Night lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Night lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    light = scenetree.findObjectById(id)
    light.castShadows = shadowvalue 
  end
  guihooks.trigger('Message', {ttl = 10, msg = 'Shadows Changed', icon = "goat"})
end
end

--DynamicWeather
local function setWeather(fogscaleval, colorval, sunval, ambientval, fogamnt, group, rainamnt, vol)
    core_environment.setFogScaleGradientFile(fogscaleval)
    core_environment.setColorizeGradientFile(colorval)
    core_environment.setSunScaleGradientFile(sunval)
    core_environment.setAmbientScaleGradientFile(ambientval)
    core_environment.setTimeOfDay(tod)
    core_environment.setFogDensity(fogamnt)
    --core_environment.setPrecipitation(rainamnt)
    for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local precipitation = scenetree.findObjectById(id)
      local sfx = scenetree.findObjectById(id)
      precipitation.numDrops = rainamnt 
      sfx.volume = vol 
    end
    guihooks.trigger('Message', {ttl = 10, msg = 'Weather Changed', icon = "goat"})
end

--DYNAMIC MATERIALS SYSTEM - 2022 Car_Killer
--DAY/NIGHT Section
local function enabledisableEmissionGlow(isEmissive)
    log('I', "", "Switching Materials...")
    if levelname == nil then
      log('E', "", "No init, please restart the game")
      guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
    else
  local materialFiles = FS:findFiles(levelfolder, "emissive.materials.json", -1, true, false)
  log('D', '', dumps(materialFiles))
  for _, fn in ipairs(materialFiles) do
    local dir, basefilename, ext = path.splitWithoutExt(fn)
    
    if string.find(fn, 'materials.cs$') then
      TorqueScript.exec(fn)
      objects = getSimObjects(fn)
    elseif string.find(fn, 'materials.json$') then
      loadJsonMaterialsFile(fn)
      objects = getSimObjects(fn)
    end

    if not tableIsEmpty(objects) then
      log('I', '', 'parsing all materials file: ' .. tostring(fn))

      for _, obj in ipairs(objects) do
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Emission: ' .. tostring(obj:getField('emissive', 0)) )
        --log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Glow: ' .. tostring(obj:getField('glow', 0)) )
        setMaterialProperty(obj:getName(), 'emissive', 0, isEmissive)
        --setMaterialProperty(obj:getName(), 'glow', 0, isEmissive)
      end 

    end

  end
  log('I', "", "Switching Done!")
end
end

--WET/DRY Section
local function setDryWetMaterials(roughnessVal, groundVal)
  log('I', "", "Switching Materials...")
  if levelname == nil then
    log('E', "", "No init, please restart the game")
    guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
  else
  local materialFiles = FS:findFiles(levelfolder, "pbrshit.materials.json", -1, true, false)
  log('D', '', dumps(materialFiles))
  for _, fn in ipairs(materialFiles) do
    local dir, basefilename, ext = path.splitWithoutExt(fn)
    
    if string.find(fn, 'materials.cs$') then
      TorqueScript.exec(fn)
      objects = getSimObjects(fn)
    elseif string.find(fn, 'materials.json$') then
      loadJsonMaterialsFile(fn)
      objects = getSimObjects(fn)
    end

    if not tableIsEmpty(objects) then
      log('I', '', 'parsing all materials file: ' .. tostring(fn))

      for _, obj in ipairs(objects) do
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Roughness: ' .. tostring(obj:getField('roughnessFactor', 0)) )
        log('I', '', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - GroundType: ' .. tostring(obj:getField('groundType', 0)) )
        setMaterialProperty(obj:getName(), 'roughnessFactor', 0, roughnessVal)
        setMaterialProperty(obj:getName(), 'groundType', 0, groundVal)
      end 

    end
  end
  be:reloadCollision()
  log('I', "", "Switching Done!")
end
end


local lastValue = nil
local lastValue_burners = nil

local function onUpdate()

   --imgui app
  im.Begin(appTitle, showUI)
  tod = scenetree.tod
  if not tod then
  im.Text("There is no TOD")
  im.Text("")
  else

  im.Text("Change TOD")
  if im.Button("Set Midday (Default)") then
    tod.time = 0.034
    core_environment.setTimeOfDay(tod)
  end
  if im.Button("Set Morning") then
    tod.time = 0.852
    core_environment.setTimeOfDay(tod)
  end
  im.SameLine()
  if im.Button("Set Sunset") then
    tod.time = 0.205
    core_environment.setTimeOfDay(tod)
  end
  if im.Button("Set Afternoon") then
    tod.time = 0.083
    core_environment.setTimeOfDay(tod)
  end
  im.SameLine()
  if im.Button("Set Midnight") then
    tod.time = 0.26
    core_environment.setTimeOfDay(tod)
  end
end

  if levelname == nil then
    im.Text("No init, please restart the game")
    im.Text("Some features are not available")
    im.Text("")
    if im.Button("Fix level lua without restarting") then
      extensions.mainLevel.onClientStartMission()
    end
    im.Text("")
  else
    im.Text("Change weather")
    --fog, color, sun, ambient, fog density, group, rain, volume of rain
    --Road roughness and ground type
    if im.Button("Set Clear (Default)") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/default/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_ambient.png", 0.001, scenetree.level_objects, 0, 0)
      if isWet == 1 then
      setDryWetMaterials(1, "ASPHALT")
      isWet = 0
      elseif isWet == 0 then
    end
    end 

    im.SameLine()
    if im.Button("Set Rain") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.005, scenetree.level_objects, 2048, 0.4)
      if isWet == 0 then
      setDryWetMaterials(0.35, "ASPHALT_WET")
      isWet = 1
    elseif isWet == 1 then
    end
    end 

    if im.Button("Set Overcast") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.003, scenetree.level_objects, 0, 0)
      if isWet == 1 then
      setDryWetMaterials(1, "ASPHALT")
      isWet = 0
      elseif isWet == 0 then
    end
    end 

    im.SameLine()
    if im.Button("Set Foggy") then
      setWeather(levelfolder .. "/art/skies/sky_gradients/foggy/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_ambient.png", 0.010, scenetree.level_objects, 0, 0)
      if isWet == 1 then
      setDryWetMaterials(1, "ASPHALT")
      isWet = 0
      elseif isWet == 0 then
    end
    end
  end

    im.Text("Toggle Night Light Shadows")
    if im.Button("Disabled (Default)") then
      setAllLightsShadowsEnabledDisabled(scenetree.nightlights, false)
    end 

    im.SameLine()
    if im.Button("Enabled") then
      setAllLightsShadowsEnabledDisabled(scenetree.nightlights, true)
    end 

    im.Text("Lod Bias")
    lodBias[0] = tonumber(TorqueScriptLua.getVar("$pref::TS::detailAdjust") or 1) * 100
    im.PushItemWidth(100)
    if uiSliderFloat("", lodBias, 1, 800, "%.1f") then
      LOD = lodBias[0] / 100
      TorqueScriptLua.setVar("$pref::TS::detailAdjust", LOD)
    end
    im.SameLine()
    if im.Button("Reset to original") then
      if LODDEF == nil then
        TorqueScriptLua.setVar("$pref::TS::detailAdjust", 1)
      else
      TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
      end
    end 
    im.Text("Real LOD Value: " ..tostring((TorqueScriptLua.getVar("$pref::TS::detailAdjust") or 1)))

  im.End()

  --check for TOD
  tod = scenetree.tod
  if not tod then return end

  local value = false
  if tod.time > 0.21 and tod.time < 0.79 then
    if emission == 0 then
    enabledisableEmissionGlow(1)
    emission = 1
    elseif emission == 1 then
    end
    value = true
  else
    if emission == 1 then
    enabledisableEmissionGlow(0)
    emission = 0
    elseif emission == 0 then
    end
  end

  if lastValue == value then return end
  lastValue = value

  if scenetree.nightlights then
    setAllLightsEnabled(scenetree.nightlights, value ,"")
  end

end

local function onEditorInitialized()
  editor.addWindowMenuItem("Map Controller", onWindowMenuItem, {groupMenuName = 'Car_Killer Addons'})
  editor.registerWindow(toolWindowName, im.ImVec2(500, 200))

end

local function onExit()
  log("I", "", "onExit restored LOD to default previous one")
  TorqueScriptLua.setVar("$pref::TS::detailAdjust", LODDEF)
end


M.onClientStartMission = onClientStartMission
M.onClientEndMission = onExit
M.onUpdate = onUpdate
M.work = work
M.onEditorInitialized = onEditorInitialized
M.onEditorActivated = onEditorActivated
M.onEditorDeactivated = onEditorDeactivated
M.onExit = onExit

return M
--Written in Visual Studio Code with Nino Nakano theme by Car_Killer 2022