import bpy
import os
import glob
from collections import defaultdict

filesPth = '/home/carkiller/.local/share/BeamNG.drive/0.33/mods/unpacked/c1_vramfix/levels/c1/art/models/'

jsonOut = ''
#we need to cleanup scene before importing new model

bpy.ops.object.select_all(action='SELECT')
bpy.ops.object.delete(use_global=False)

bpy.ops.outliner.orphans_purge()
bpy.ops.outliner.orphans_purge()
bpy.ops.outliner.orphans_purge()

for subdir, dirs, files in os.walk(filesPth):
  for file in files:
    if file.endswith('.dae'):
      removed = False
      bpy.ops.object.select_all(action='DESELECT')
      importfile = subdir + "/" + file
      bpy.ops.wm.collada_import(filepath = importfile,
                            auto_connect = True,
                            find_chains = True,
                            fix_orientation = True)
      bpy.ops.object.select_all(action='DESELECT')

      for o in bpy.context.scene.objects:
                if o.type == 'MESH':
                    bpy.context.view_layer.objects.active = o
                    o.select_set(True)
                    bpy.ops.object.origin_set(type='ORIGIN_GEOMETRY', center='BOUNDS')
                    location = o.location
                    folder = subdir.replace('/home/carkiller/.local/share/BeamNG.drive/0.33/mods/unpacked/c1_vramfix/levels/c1/art/models/','')
                    jsonOut = jsonOut + '{"class":"TSStatic","__parent":"newPrefab","position":['+ str(location[0]) + ',' + str(location[1]+1.83630355) + ',' + str(location[2]+849.184998) + '],"collisionType":"Visible Mesh Final","decalType":"Visible Mesh Final","isRenderEnabled":false,"playAmbient":false,"shapeName":"/levels/c1/art/models/' + str(folder) + '/' + str(file) + '","useInstanceRenderData":true}\n'
                    o.location = (0, 0, 0)

      exportmodel = subdir + "/" + file
      bpy.ops.wm.collada_export(filepath = exportmodel,
                      apply_modifiers = True,
                      use_texture_copies=False)

    #we need to cleanup scene before importing new model

    bpy.ops.object.select_all(action='SELECT')
    bpy.ops.object.delete(use_global=False)

    bpy.ops.outliner.orphans_purge()
    bpy.ops.outliner.orphans_purge()
    bpy.ops.outliner.orphans_purge()
    print("Cleaining scene")

if not jsonOut == "":
  with open (filesPth + 'items.level.json', 'w') as f:
    f.write(jsonOut)
print("DONE")