-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

-- In other words, if you are a modder feel free to reuse this code with above license

--If you reload Lua with CTRL+L use thise in the GE console `

local M = {}
M.dependencies = {"ui_imgui"}
local im = ui_imgui
local ffi = require("ffi")

local internal = not shipping_build or not string.match(beamng_windowtitle, "RELEASE")

local TorqueScriptLua = TorqueScriptLua

-- TWEAKS
local partitionGridSpaceSize = 384.0
local shadowpartitionGridSpaceSize = 8.0
local lightGroupNames = {"Tunnel_lights", "Tunnel_sounds", "sign_lights", "LightGroup1", "LightGroup2", "LightGroup3",
                        "LightGroup4", "LightGroup5", "LightGroup6", "LightGroup7", "LightGroup8", "LightGroup9", "garage_japan_unpacked"}

--independent GUI
local showUI = nil
local pos = im.ImVec2(0, 0)
local skipImgui = false

--scenetree
local objects = nil

local tod = nil

-- DATA, DON'T TOUCH
local partitionGridMin
local partitionGridMax
local partitionGridSpacesX
local partitionGridSpacesY
local totalPartitionGridSpaces
local partitionGrid = {}
local luaLoaded = false

-- DATA, DON'T TOUCH 2
local partitionGrid2Min
local partitionGrid2Max
local partitionGrid2SpacesX
local partitionGrid2SpacesY
local totalPartitionGrid2Spaces
local partitionGrid2 = {}

local lastValue = nil
local lastValueAdd = nil
local lastCameraCell = -1
local lastCameraCell2 = -1
local allLights = {}

local lightmgr
local shadowdisable = 0

local debugEnabled = false

local speedtrpgroup = im.ArrayChar(256)
local speedzonegroup = im.ArrayChar(256)
local cubemapgroup = im.ArrayChar(256)


local instanceData = {}

--weather
local isWet = 0

local isThunder = false
local decalroad = nil

--progress data
local progressData
local progressFilePath

--renderdistance
local renderBias = im.FloatPtr(0)
local defaultDistance

--bigmap
local bigmapvalue = 0

--teleporter
local playerisintrigger = nil

--level data
local levelfolder = nil
local levelname =  nil
local tool_version = "2.2"
local appTitle = " CK Map Controller - ".. tool_version .." - ".. "no-init" .." - ".. beamng_arch
local debugTitle = "Debug Controller - ".. tool_version .." - ".. "no-init" .." - ".. beamng_arch

local toolWindowName = 'map_controller'

-- Keep track of the last set of lights we enabled so we don't have to loop over every light and disable it each time we change cells
local lastEnabledLightCount = 0
local lastEnabledLightIndices = {}

local lastEnabledShadowCount = 0
local lastEnabledShadowIndices = {}

local function enableLights(xCell, zCell, value, table)
  -- disable previously enabled lights
  for i=1,lastEnabledLightCount,1 do
    local light = allLights[lastEnabledLightIndices[i]]
    light.texSize = 32
    light:setLightEnabled(false)
  end

  lastEnabledLightCount = 0
  for x=math.max(0, xCell - 1), math.min(partitionGridSpacesX - 1, xCell + 1),1 do
    for z=math.max(0, zCell - 1), math.min(partitionGridSpacesY - 1, zCell + 1),1 do
      for _,lightIndex in ipairs(partitionGrid[1 + (z * partitionGridSpacesX) + x]) do
        -- mark enabled
        lastEnabledLightCount = lastEnabledLightCount + 1
        lastEnabledLightIndices[lastEnabledLightCount] = lightIndex

        -- enable light
        local light = allLights[lightIndex]
        if table then
          if tableContains(table, scenetree.findObjectById(light:getField('parentGroup',0)):getName()) then
            light:setLightEnabled(value)
          end
        else
          light.texSize = 256
          light:setLightEnabled(value)
        end
      end
    end
  end
end

local function enableShadows(xCell, zCell)
  -- disable previously enabled lights
  for i=1,lastEnabledShadowCount,1 do
    local shadow = allLights[lastEnabledShadowIndices[i]]
    shadow.castShadows = false
  end

  lastEnabledShadowCount = 0
  for x=math.max(0, xCell - 1), math.min(partitionGrid2SpacesX - 1, xCell + 1),1 do
    for z=math.max(0, zCell - 1), math.min(partitionGrid2SpacesY - 1, zCell + 1),1 do
      for _,shadowIndex in ipairs(partitionGrid2[1 + (z * partitionGrid2SpacesX) + x]) do
        -- mark enabled
        lastEnabledShadowCount = lastEnabledShadowCount + 1
        lastEnabledShadowIndices[lastEnabledShadowCount] = shadowIndex

        -- enable light
        local shadow = allLights[shadowIndex]
        shadow.castShadows = true
      end
    end
  end
end

local function getCellForPosition(p)
  local xCell = math.floor((p.x - partitionGridMin.x) / partitionGridSpaceSize)
  local yCell = math.floor((p.y - partitionGridMin.y) / partitionGridSpaceSize)
  return xCell, yCell
end

local function getCellIndexForPosition(p)
  local xCell, yCell = getCellForPosition(p)
  return (yCell * partitionGridSpacesX) + xCell
end

local function positionInRange(p)
  return p.x >= partitionGridMin.x and p.x <= partitionGridMax.x and p.y >= partitionGridMin.y and p.y <= partitionGridMax.y
end

--grid2
local function getCellForPosition2(p)
  local xCell = math.floor((p.x - partitionGrid2Min.x) / shadowpartitionGridSpaceSize)
  local yCell = math.floor((p.y - partitionGrid2Min.y) / shadowpartitionGridSpaceSize)
  return xCell, yCell
end

local function getCellIndexForPosition2(p)
  local xCell, yCell = getCellForPosition2(p)
  return (yCell * partitionGrid2SpacesX) + xCell
end

local function positionInRange2(p)
  return p.x >= partitionGrid2Min.x and p.x <= partitionGrid2Max.x and p.y >= partitionGrid2Min.y and p.y <= partitionGrid2Max.y
end

local function getInstanceData()
  local instanceData = {}
  local materials = {}
  local allObjects = scenetree:getAllObjects()
  if allObjects then
    for k,name in pairs(allObjects) do
      local object = scenetree.findObject(name)
      if object and object.___type == "class<Material>" then
        if object:getField('instanceEmissive', 0) == "1" then
          materials[name] = true
        end
      end
    end
    for k,name in pairs(allObjects) do
      local object = scenetree.findObject(name)
      if object and object:isSubClassOf("TSStatic") then
        if object:getDynDataFieldbyName('is_tunnel', 0) == "1" then
          -- do nothing
        else
          local matNames = object:getMaterialNames()
          for k,v in pairs(matNames) do
            if materials[v] == true then
              local objId = object:getId()
              local instColor = object:getField('instanceColor', 0)
              instanceData[objId] = instColor
            end
          end
        end
      end
    end
    for k,v in pairs(instanceData) do
      local instance = scenetree.findObjectById(k)
      if instance then
        instance:setField('instanceColor', 0, "Black")
        instance:updateInstanceRenderData()
      end
    end
  end
  return instanceData
end

local function onClientStartMission()
  print("DM light cull onClientStartMission")
  luaLoaded = true
  -- collect lights
  for _, lightGroupName in pairs(lightGroupNames) do
    local lightGroup = scenetree[lightGroupName]
    if lightGroup then
      for i = 0, lightGroup.obj:getCount(), 1 do
        local id = lightGroup.obj:idAt(i)
        local obj = scenetree.findObjectById(id)
        if obj and obj.obj:isSubClassOf('LightBase') then
          table.insert(allLights, obj.obj)
        end
      end
    else
      print("ERROR: lightGroup " .. lightGroupName .. " not found!")
    end
  end

  -- compute grid
  local minX = 99999.0
  local minY = 99999.0
  local maxX = -99999.0
  local maxY = -99999.0

  for i,v in ipairs(allLights) do
    local pos = v:getPosition()
    minX = math.min(pos.x, minX)
    minY = math.min(pos.y, minY)

    maxX = math.max(pos.x, maxX)
    maxY = math.max(pos.y, maxY)
  end

  partitionGridMin = vec3(minX, minY, 0)
  partitionGridMax = vec3(maxX, maxY, 0)
  partitionGridSpacesX = math.ceil((partitionGridMax.x - partitionGridMin.x) / partitionGridSpaceSize)
  partitionGridSpacesY = math.ceil((partitionGridMax.y - partitionGridMin.y) / partitionGridSpaceSize)
  totalPartitionGridSpaces = (partitionGridSpacesX * partitionGridSpacesY)

  partitionGrid2Min = vec3(minX, minY, 0)
  partitionGrid2Max = vec3(maxX, maxY, 0)
  partitionGrid2SpacesX = math.ceil((partitionGrid2Max.x - partitionGrid2Min.x) / shadowpartitionGridSpaceSize)
  partitionGrid2SpacesY = math.ceil((partitionGrid2Max.y - partitionGrid2Min.y) / shadowpartitionGridSpaceSize)
  totalPartitionGrid2Spaces = (partitionGrid2SpacesX * partitionGrid2SpacesY)

  -- allocate tables
  for i=1,totalPartitionGridSpaces,1 do
    table.insert(partitionGrid, {})
  end

  for i=1,totalPartitionGrid2Spaces,1 do
    table.insert(partitionGrid2, {})
  end

  for i=1,512,1 do
    table.insert(lastEnabledLightIndices, 0)
  end

  for i=1,512,1 do
    table.insert(lastEnabledShadowIndices, 0)
  end

  -- place lights in cells
  for i,v in ipairs(allLights) do
    local pos = v:getPosition()
    table.insert(partitionGrid[getCellIndexForPosition(pos) + 1], i)
  end

  for i,v in ipairs(allLights) do
    local pos = v:getPosition()
    table.insert(partitionGrid2[getCellIndexForPosition2(pos) + 1], i)
  end

  -- turn off all lights
  for i,v in ipairs(allLights) do
    v:setLightEnabled(false)
    v.castShadows = false
  end

  -- debug
  local largestCell = -1
  local largestCellIndex = 0
  local totalLightsInCells = 0

  for i,c in ipairs(partitionGrid) do
    if #c > largestCell then
      largestCellIndex = i
      largestCell = #c
    end
    totalLightsInCells = totalLightsInCells + #c
  end

  print("Tot spaces: " .. tostring(totalPartitionGridSpaces))
  print("X spaces: " .. tostring(partitionGridSpacesX))
  print("Y spaces: " .. tostring(partitionGridSpacesY))
  print("Min extents: " .. tostring(partitionGridMin))
  print("Max extents: " .. tostring(partitionGridMax))
  print("Worst bucket was " .. tostring(largestCellIndex) .. " containing " .. tostring(largestCell) .. ". Total " .. tostring(totalLightsInCells))

  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  log('I', 'onClientStartMission', 'Getting current level path' )
  levelname = getCurrentLevelIdentifier()
  --print(levelname)
  log('I', 'onClientStartMission', 'Level is loaded' )
  levelfolder = ("/levels/" .. levelname .. "/")
  appTitle = " CK Map Controller - ".. tool_version .." - ".. levelname .." - ".. beamng_arch
  debugTitle = "Debug Controller - ".. tool_version .." - ".. levelname .." - ".. beamng_arch
  if TorqueScriptLua then
    log("I", "onClientStartMission", "onCLientStartMission get LOD variable")
    defaultDistance = scenetree.theLevelInfo.visibleDistance
    progressFilePath = 'settings/cloud/ck-'..levelname..'-progress.json'
    if FS:fileExists('settings/cloud/ck-'..levelname..'-speedtrap.json') then FS:removeFile('settings/cloud/ck-'..levelname..'-speedtrap.json') end
    progressData = jsonReadFile(progressFilePath)
    lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
    log('I', 'onClientStartMission', lightmgr )
    shadowdisable = tonumber(TorqueScriptLua.getVar("$pref::Shadows::disable"))
    log('I','onClientStartMission', shadowdisable )
    instanceData = getInstanceData()
  end
end

--get scene tree all objects
local function getSimObjects(fileName)
  local ret = {}
  local objs = scenetree.getAllObjects()
  --log('E', '', '# objects existing: ' .. tostring(#scenetree.getAllObjects()))
  for _, objName in ipairs(objs) do
    local o = scenetree.findObject(objName)
    if o and o.getFileName then
      if o:getFileName() == fileName then
        table.insert(ret, o)
      end
    end
  end
  return ret
  --log('E', '', '# objects left: ' .. tostring(#scenetree.getAllObjects()))
end

local function getFontList()
  local fonts = {}
  for i = 0, im.IoFontsGetCount() - 1 do
    table.insert(fonts,
    {
      name = ffi.string(im.IoFontsGetName(i))
    })
  end
  return fonts
end

local function onUiChangedState(newUIState, prevUIState)
  if newUIState:sub(1, 4) == 'menu' then
    skipImgui = false
  else
    skipImgui = true
  end
end

--Hide Elements of map

local function setHiddenRec(object, hidden)
  object.hidden = hidden
  if object:isSubClassOf("SimSet") then
    for i=0, object:size() - 1 do
      setHiddenRec(object:at(i), hidden)
    end
  end
end

local function hideGroup(groupName, hidden)
  if not groupName then
    log('E', "", "Group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Group is missing, please contact level author', icon = "goat"})
  else
    local group = scenetree.findObject(groupName)
    if group then setHiddenRec(group, hidden) end
  end
end

local function onClientPostStartMission()
  if TorqueScriptLua then
    log('I','onClientPostStartMission', 'Hiding forest group' )
    hideGroup("hide_forest", false)
    hideGroup("hide_forest", true)
  end
end

--change material data
local function setMaterialProperty(material, property, layer, value)
  --guihooks.trigger('menuHide')
  --guihooks.trigger('app:waiting', true)
  if type(material) == "string" then
    material = scenetree.findObject(material)
  end

  if material.___type == "class<Material>" then
    material:setField(property, layer, value)
    --we do not want to flush materials
    --material:flush()
    --print("reloading material")
    material:reload()
    --guihooks.trigger('app:waiting', false) -- shows the loading icon
    return true
  else
    log('E', "", "Given object is not a material.")
    return false
  end
end

local function getFadeScreenData(preview, sub, desc)
  local level_name = "Garage"
  local preview = preview or nil
  if level_name == nil then
    if levelname == nil then level_name = "no_init" else level_name = levelname end
  end
  return {image = preview, title = level_name, subtitle = sub, text = desc}
end

--Gameengine decal road workaround
local function fixDecalRoad(group)
  if not group then
    log('E', "fixDecalRoad", "Night reflection group is missing, please contact level author")
  else
    for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      decalroad = scenetree.findObjectById(id)
      decalroad.renderPriority = 9
      decalroad.renderPriority = 10
    end
  end
end

local rainAmount = 0
local isUsingSkybox = false
--DynamicWeather
local function setWeather(fogscaleval, colorval, sunval, ambientval, fogamnt, fogHeight, group, rainamnt, vol, useSkybox, skyMat)
    local tod = scenetree.tod
    core_environment.setFogScaleGradientFile(fogscaleval)
    core_environment.setColorizeGradientFile(colorval)
    core_environment.setSunScaleGradientFile(sunval)
    core_environment.setAmbientScaleGradientFile(ambientval)
    core_environment.setFogDensity(fogamnt)
    core_environment.setFogAtmosphereHeight(fogHeight)
    core_environment.setNightFogGradientFile(fogscaleval)
    --core_environment.setPrecipitation(rainamnt)
    for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local precipitation = scenetree.findObjectById(id)
      local sfx
      if isThunder == true then
        sfx = scenetree.findObject("thndr_rain")
      else
        sfx = scenetree.findObjectById(id)
      end
      local skyBox = scenetree.findObject("SkyBox_1")
      if useSkybox == true then
        skyBox.Material = skyMat
        isUsingSkybox = true
        skyBox:postApply()
        skyBox.hidden = false
      else
        skyBox.hidden = true
        isUsingSkybox = false
      end
      precipitation.numDrops = rainamnt
      rainAmount = rainamnt
      sfx.volume = vol
      sfx:postApply()
    end
    core_environment.setTimeOfDay(tod)
    guihooks.trigger('Message', {ttl = 10, msg = 'Weather Changed', icon = "goat"})
end

--DYNAMIC MATERIALS SYSTEM - 2022 Car_Killer
--DAY/NIGHT Section
local function enabledisableEmissionGlow(isEmissive)
  if isEmissive == 1 then
    for k,v in pairs(instanceData) do
      local instance = scenetree.findObjectById(k)
      if instance then
        instance:setField('instanceColor', 0, v)
        instance:updateInstanceRenderData()
      end
    end
  else
    for k,v in pairs(instanceData) do
      local instance = scenetree.findObjectById(k)
      if instance then
        instance:setField('instanceColor', 0, "Black")
        instance:updateInstanceRenderData()
      end
    end
  end
end

--WET/DRY Section
local function setDryWetMaterials(roughnessVal, groundVal)
  log('I', "setDryWetMaterials", "Switching Materials...")
  if levelname == nil then
    log('E', "setDryWetMaterials", "No init, please restart the game")
    guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
  else
    local materialFiles = FS:findFiles(levelfolder, "road.materials.json", -1, true, false)
    log('D', 'setDryWetMaterials', dumps(materialFiles))
    for _, fn in ipairs(materialFiles) do
      local dir, basefilename, ext = path.splitWithoutExt(fn)

      if string.find(fn, 'materials.cs$') then
        TorqueScript.exec(fn)
        objects = getSimObjects(fn)
      elseif string.find(fn, 'materials.json$') then
        loadJsonMaterialsFile(fn)
        objects = getSimObjects(fn)
      end

      if not tableIsEmpty(objects) then
        log('I', 'setDryWetMaterials', 'parsing all materials file: ' .. tostring(fn))

        for _, obj in ipairs(objects) do
          log('I', 'setDryWetMaterials', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Roughness: ' .. tostring(obj:getField('roughnessFactor', 0)) )
          log('I', 'setDryWetMaterials', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - GroundType: ' .. tostring(obj:getField('groundType', 0)) )
          setMaterialProperty(obj:getName(), 'roughnessFactor', 0, roughnessVal)
          setMaterialProperty(obj:getName(), 'groundType', 0, groundVal)
        end

      end
    end
    be:reloadCollision()
    log('I', "setDryWetMaterials", "Switching Done!")
  end
end

local function teleportPlayerto(job, locationID)
  ui_fadeScreen.start(1, getFadeScreenData('/levels/c1/garage_tp.jpg', "You are driving safely to your destination", ''))
  local pos
  local rot
  job.sleep(2)
  -- garage
  if locationID == 0 then
    pos = vec3(0, 0, 0)
    rot = quatFromEuler(0, -0.5, 0)
  end
  -- outbound
  if locationID == 1 then
    pos = vec3(-148.343, -1457.152, 855.556)
    rot = quatFromEuler(0, 0, -25.55)
  end
  -- inbound
  if locationID == 2 then
    pos = vec3(-280.805, -1319.192, 855.890)
    rot = quatFromEuler(0, 0, 2.5)
  end

  if pos and rot then
    spawn.safeTeleport(be:getPlayerVehicle(0), pos, quat(0,0,1,0) * rot, nil, nil, nil, nil, false)
    core_camera.resetCamera(0)
  end
  job.sleep(2)
  ui_fadeScreen.stop(1)
end

local waifuTable = {}
local lookCounter = 0
local function waifuHunter(dtReal)
  if progressData and progressData.version == tool_version then
  --if progressData then
    if not progressData.waifuHunter then progressData.waifuHunter = {} end
    if tableIsEmpty(waifuTable) then
      local waifuGroup = scenetree['waifu_hunter']
      if waifuGroup then
        for i = 0, waifuGroup.obj:getCount(), 1 do
          local id = waifuGroup.obj:idAt(i)
          local obj = scenetree.findObjectById(id)
          if obj and obj.obj:isSubClassOf('TSStatic') then
            table.insert(waifuTable, obj.obj)
          end
        end
      else
        print("ERROR: group waifu_hunter not found!")
      end
    else
      if progressData.waifuHunter then
        local min = math.huge
        local distances = {}
        local cameraPosition = core_camera.getPosition()
        for k,v in pairs(waifuTable) do
          if not Engine.sceneGetCameraFrustum():isBoxOutside(v:getWorldBox()) and Engine.sceneGetCameraFrustum():isBoxContained(v:getWorldBox()) then
            local objectPosition = v:getPosition()
            local distance = (vec3(cameraPosition.x, cameraPosition.y, 0) - vec3(objectPosition.x, objectPosition.y, 0)):length()
            table.insert(distances, distance)
          end
        end
        for k,v in pairs(distances) do
          min = math.min(min, v)
        end
        for k,v in pairs(waifuTable) do
          if not Engine.sceneGetCameraFrustum():isBoxOutside(v:getWorldBox()) and Engine.sceneGetCameraFrustum():isBoxContained(v:getWorldBox()) then
            local objectPosition = v:getPosition()
            local distance = (vec3(cameraPosition.x, cameraPosition.y, 0) - vec3(objectPosition.x, objectPosition.y, 0)):length()
            if min == distance and distance <= 15 then
              lookCounter = lookCounter + dtReal
              if lookCounter > 2 then
                local filePath = v:getModelFile()
                local dir, filename, ext = path.splitWithoutExt(filePath, true)
                if not progressData.waifuHunter[filename] then
                  print(v.waifuName..', '..min..', '..lookCounter)
                  progressData.waifuHunter[filename] = true
                  local res = jsonWriteFile(progressFilePath, progressData, true)
                  if not res then
                    log('W', "waifuHunter", "unable to save progress")
                  end
                  local count = 0
                  for _ in pairs(progressData.waifuHunter) do count = count + 1 end
                  local msgW = "waifu Found"
                  msgW = string.format("Found " ..count.."/10: \n"..v.waifuName)
                  guihooks.trigger('Message', {ttl = 10, msg = msgW, category = "waifuHunter", icon = "check"})
                  Engine.Audio.playOnce('AudioGui','event:>UI>Missions>Prop_Knock')
                end
              end
            elseif min == distance and distance > 15 then
              lookCounter = 0
            end
          end
        end
      end
    end
  else
    progressData = {}
    progressData.version = tool_version
  end
end

local thndrcnt = 0
local delay = 0
local isPlayedA = false
local isPlayedB = false
local isPlayedC = false
local isPlayedD = false
local realTime = 0
local rndcont = 0

local randomoffset1 = math.random(-3000, 3000)
local randomoffset2 = math.random(-3000, 3000)
local randomoffset3 = math.random(150, 300)

local function onWeatherThunder(dtSim, dtReal)
  local paused = dtSim < 0.00001
  if not paused then
    local playerWPos
    realTime = realTime + dtReal
    thndrcnt = thndrcnt + dtSim
    if realTime >= 5 then
      rndcont = math.random(5, 60)
      if math.random(1, 8) == 4 then
        randomoffset1 = math.random(-500, 500)
        randomoffset2 = math.random(-500, 500)
        randomoffset3 = math.random(1, 200)
      else
        randomoffset1 = math.random(-3000, 3000)
        randomoffset2 = math.random(-3000, 3000)
        randomoffset3 = math.random(1, 200)
      end
      realTime = 0
    end
    if thndrcnt >= rndcont then
      --FIX FUCKIN MATH THERE, THERE IS A BETTER WAY TO DO THIS
      -- done :)
      local veh = be:getPlayerVehicle(0)
      local sounddelay = 0
      local dir = levelfolder.."/art/sound/"
      local sndTable = {dir.."Thunder_a.mp3",dir.."thunder_b.mp3",dir.."thunder_c.mp3",dir.."thunder_d.mp3"}
      if veh then
        playerWPos = vec3(veh:getPosition())
      else
        playerWPos = vec3(core_camera.getPosition())
      end
      local oldplayerPos = playerWPos
      playerWPos = playerWPos + vec3(randomoffset1, randomoffset2, randomoffset3)
      sounddelay = (oldplayerPos - playerWPos):length()
      sounddelay = sounddelay / 331 --sound speed in m/s
      if sounddelay < 0 then sounddelay = -sounddelay end
      local thunderbolt = scenetree.findObject("thunder_obj")
      local vfx = scenetree.findObject("thndr")
      thunderbolt:setPosition(playerWPos)
      vfx.radius = scenetree.theLevelInfo.visibleDistance / 2
      vfx:setPosition(playerWPos)
      if isPlayedA ~= true and randomoffset2 then
        hideGroup("thunder", false)
        isPlayedA = true
        delay = 0
      end
      if delay >= math.random(0.05, 0.3) and isPlayedA == true and isPlayedB ~= true then
        hideGroup("thunder", true)
        delay = 0
        isPlayedB = true
      end
      if delay >= math.random(0.05, 0.1) and isPlayedB == true and isPlayedC ~= true then
        hideGroup("thunder", false)
        delay = 0
        isPlayedC = true
      end
      if delay >= math.random(0.05, 0.3) and isPlayedC == true and isPlayedD ~= true then
        hideGroup("thunder", true)
        delay = 0
        isPlayedD = true
      end
      if delay >= sounddelay and isPlayedC == true then
        Engine.Audio.playOnce('AudioEnvironment', sndTable[math.random(1, 4)])
        thndrcnt = 0
        delay = 0
        isPlayedA = false
        isPlayedB = false
        isPlayedC = false
        isPlayedD = false
      end
    end
  end
end

--simple dynamic level cubemap experiment
local cubemapname

local function setCubemap(cubemapname)
  if cubemapname then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      local tod = scenetree.tod
      log("I", "setCubemap", "Enabling cubemap " ..cubemapname)
      levelinf:setField('globalEnviromentMap', 0, cubemapname)
      levelinf:postApply()
      if tod then
        core_environment.setTimeOfDay(tod)
      end
    else
      log("W", "setCubemap", "Enabling fallback cubemap " ..cubemapname)
      setConsoleVariable("$defaultLevelEnviromentMap", cubemapname)
    end
  end
end

local function renderImguiDebug()
  im.Begin(debugTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  im.Text("Needs World Editor to run")
  if editor and editor.isEditorActive and editor.isEditorActive() then
    im.PushItemWidth(im.GetContentRegionAvailWidth())
    im.Text("Speedtraps scenetree group")
    if im.InputText("##speedtrpgroup", speedtrpgroup) then
    end
    im.Text("Speedzones scenetree group")
    if im.InputText("##speedzonegroup", speedzonegroup) then
    end
    im.Text("Cubemaps scenetree group")
    if im.InputText("##cubemapgroup", cubemapgroup) then
    end
    im.PopItemWidth()
    if im.Button("Generate waypoints data") then
      local speedtrpgroup = ffi.string(speedtrpgroup)
      local trapgroup = scenetree[speedtrpgroup]

      local speedzonegroup = ffi.string(speedzonegroup)
      local zonegroup = scenetree[speedzonegroup]

      local cubemapgroup = ffi.string(cubemapgroup)
      local cubegroup = scenetree[cubemapgroup]

      local trapwaypoints = {}
      local zonewaypoints = {}
      local cubemapwaypoints = {}

      if trapgroup and speedtrpgroup then
        for i = 0, trapgroup.obj:getCount(), 1 do
          local id = trapgroup.obj:idAt(i)
          local wpobj = scenetree.findObjectById(id)
          local wp = wpobj:getName()
          if wpobj:isSubClassOf("BeamNGTrigger") then
            table.insert(trapwaypoints, wp)
          end
        end
      end

      if zonegroup and speedzonegroup then
        for i = 0, zonegroup.obj:getCount(), 1 do
          local id = zonegroup.obj:idAt(i)
          local wpobj = scenetree.findObjectById(id)
          local wp = wpobj:getName()
          if wpobj:isSubClassOf("BeamNGTrigger") then
            table.insert(zonewaypoints, wp)
          end
        end
      end

      if cubegroup and cubemapgroup then
        for i = 0, cubegroup.obj:getCount(), 1 do
          local id = cubegroup.obj:idAt(i)
          local wpobj = scenetree.findObjectById(id)
          local wp = wpobj:getName()
          if wpobj:isSubClassOf("BeamNGTrigger") then
            table.insert(cubemapwaypoints, wp)
          end
        end
      end

        local jsonData = {}
        jsonData.levelname = levelname
        jsonData.directory = levelfolder
        jsonData.speedtraps = {}
        jsonData.speedzones = {}
        jsonData.cubemaps = {}
        jsonData.version = tool_version
        for k,v in pairs(trapwaypoints) do
          jsonData.speedtraps[v] = {}
          jsonData.speedtraps[v].triggerName = v
          jsonData.speedtraps[v].name = "Replace with name"
          jsonData.speedtraps[v].speedLimit = 60
        end
        for k,v in pairs(zonewaypoints) do
          jsonData.speedzones[v] = {}
          jsonData.speedzones[v].triggerName = v
          jsonData.speedzones[v].name = "Replace with name"
          jsonData.speedzones[v].speedLimit = 60
        end
        for k,v in pairs(cubemapwaypoints) do
          jsonData.cubemaps[v] = {}
          jsonData.cubemaps[v].triggerName = v
          jsonData.cubemaps[v].cubemapname = "cubemap_"..levelname.."_reflection"
        end
        dump(jsonData)
        extensions.editor_fileDialog.saveFile(
          function(data)
            local dir, filename, ext = path.splitWithoutExt(data.filepath, true)
            local saveData = jsonData
            saveData.name = filename
            jsonWriteFile(data.filepath, saveData, true)
            log("I","saveData","Saved Waypoint Data to " .. data.filepath)
          end,
          {{"Waypoint Data",".waypoint_data.json"}}, false, 'levels/'..levelname)
        end
      else
        if im.Button("Enable all features") then
          editor.toggleActive()
        end
      end
      if im.Button("Enable Emissive") then
        enabledisableEmissionGlow(1)
      end
      if im.Button("Add tunnel triggers") then
        local count = 0
        local tunnelZone = scenetree.Zones
        local missionGroup = scenetree.MissionGroup
        if tunnelZone then
          for i = 0, tunnelZone.obj:getCount(), 1 do
            local id = tunnelZone.obj:idAt(i)
            local obj = scenetree.findObjectById(id)
            if obj and obj:getClassName() == "Zone" then
              count = count + 1
              local position = obj:getPosition()
              local rotation = obj:getRotation()
              local scale = obj:getScale()
              local createTrigger
              createTrigger = createObject('BeamNGTrigger')
              createTrigger:setPosRot(position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w)
              createTrigger:setScale(scale)
              createTrigger:registerObject("TunnelTrigger_"..count)
              missionGroup:addObject(createTrigger)
            end
          end
        end
      end
      if im.Button("Light generator") then
        local count = 0
        local AllObjects = scenetree.getAllObjects()
        local missionGroup = scenetree.MissionGroup
        --[[if AllObjects and missionGroup then
          for k,name in pairs(AllObjects) do
            local object = scenetree.findObject(name)
            if object:isSubClassOf("TSStatic") then
              if string.endswith(object:getModelFile(), '8A_66_60_BA.dae') or string.endswith(object:getModelFile(), '71_5E_5C_AF.dae') or string.endswith(object:getModelFile(), 'DD_91_E0_0C.dae') then
                local position = object:getWorldBoxCenter()
                local createLight
                print(position)
                count = count + 1
                createLight = createObject('PointLight')
                createLight:setPosition(position)
                createLight:registerObject("StreetLightH_"..count)
                missionGroup:addObject(createLight)
              end
            end
          end
        end]]--
      end
      if im.Button("Light optimizer") then
        local lights = {}
        local count = 0
        local AllObjects = scenetree.getAllObjects()
        if AllObjects then
          for k,name in pairs(AllObjects) do
            local object = scenetree.findObject(name)
            if object:isSubClassOf("LightBase") then
              local position = object:getPosition()
              if position then
                local posX = tonumber(string.format("%.1f", position.x))
                local posY =  tonumber(string.format("%.1f", position.y))
                local newPos = tostring(vec3(posX, posY, 0))
                if lights[newPos] == true then
                  print(object:getName())
                  object:deleteObject()
                end
                lights[newPos] = true
              end
            end
          end
        end
      end
      if im.Button("Get lights amount") then
        local count = 0
        local AllObjects = scenetree.getAllObjects()
        if AllObjects then
          for k,name in pairs(AllObjects) do
            local object = scenetree.findObject(name)
            if object:isSubClassOf("LightBase") then
              count = count +1
            end
          end
          print('There is '..count..' lights in the level')
        end
      end
      if im.Button("Slap Delay Generator") then
        local positions = {}
        local count = 0
        local AllObjects = scenetree.getAllObjects()
        local missionGroup = scenetree.MissionGroup
        if AllObjects and missionGroup then
          for k,name in pairs(AllObjects) do
            local object = scenetree.findObject(name)
            if object:isSubClassOf("SpotLight") then
              local position = object:getPosition()
              if not tableIsEmpty(positions) then
                for k,v in pairs(positions) do if (v - position):length() < 64  then goto skipObject end end
              end
              local createDelay
              count = count + 1
              createDelay = createObject('SFXEmitter')
              createDelay:setPosition(position)
              createDelay:setField('track',0, 'event:>Special>Slap Delays>Delay_10')
              createDelay:registerObject("SlapDelay10_"..count)
              missionGroup:addObject(createDelay)
              table.insert(positions, position)
            end
            ::skipObject::
          end
        end
        print("Done. Generated: "..count.." objects")
      end
      if im.Button("Fix pos skill issue :(") then
        local newPrefab = scenetree.newPrefab
        if newPrefab then
          for i = 0, newPrefab.obj:getCount(), 1 do
            local id = newPrefab.obj:idAt(i)
            local obj = scenetree.findObjectById(id)
            if obj and obj:getClassName() == "TSStatic" then
              local position = obj:getPosition() - vec3(0,1.83630355,0)
              obj:setPosition(position)
            end
          end
        end
      end
    im.End()
end

local function renderTeleportUI(triggername)
  local win = im.GetMainViewport()
  pos.x = win.Pos.x + win.Size.x / 2
  pos.y = win.Pos.y + win.Size.y / 2
  im.SetNextWindowPos(pos, im.ImGuiCond_Always, im.ImVec2(0.5, 0.5))
  im.SetNextWindowBgAlpha(0.7)

  im.Begin("Destination Selector", nil, im.WindowFlags_AlwaysAutoResize+im.WindowFlags_NoResize+im.WindowFlags_NoMove+im.WindowFlags_NoCollapse+im.WindowFlags_NoDocking+im.WindowFlags_NoTitleBar)
  im.PushFont3("cairo_bold")
  im.SetWindowFontScale(2.0)
  im.Text("Where do you want to go?")
  im.Separator()
  if string.startswith(triggername, "garage_entrance") then
    if im.Button("Garage", im.ImVec2(400, 0)) then
      extensions.core_jobsystem.create(teleportPlayerto, 1, 0)
      playerisintrigger = nil
    end
  end
  if triggername == "garage_exit" then
    if im.Button("Heiwajima PA (Inbound)", im.ImVec2(400, 0)) then
      extensions.core_jobsystem.create(teleportPlayerto, 3, 2)
      playerisintrigger = nil
    end
    if im.Button("Heiwajima PA (Outbound)", im.ImVec2(400, 0)) then
      extensions.core_jobsystem.create(teleportPlayerto, 3, 1)
      playerisintrigger = nil
    end
  end
  if im.Button("Nowhere", im.ImVec2(400, 0)) then
    playerisintrigger = nil
  end
  im.PopFont()
  im.SetWindowFontScale(1.0)
  im.End()
end

local function renderImguiMain()
  im.Begin(appTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  if TorqueScriptLua then
    if levelname == nil then
      im.Text("No init, please restart the game")
      im.Text("Some features are not available")
      im.Text("")
      if im.Button("Fix level lua without restarting") then
        extensions.mainLevel.onClientStartMission()
      end
      im.Text("")
    else
      im.Text("Change weather")
      --fog, color, sun, ambient, fog density, group, rain, volume of rain
      --Road roughness and ground type
      if im.Button("Set Clear (Default)") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/default/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_ambient.png", 0.001, 1200, scenetree.Sky, 0, 0, false, nil)
        if isWet == 1 then
          setDryWetMaterials(1, "ASPHALT")
          hideGroup("ck_rainroad", true)
          fixDecalRoad(scenetree.ck_rainroad)
          isWet = 0
          elseif isWet == 0 then
        end
        hideGroup("thunder", true)
      end

      im.SameLine()
      if im.Button("Set Wet (Clear)") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/default/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_ambient.png", 0.001, 1200, scenetree.Sky, 0, 0, false, nil)
        if isWet == 0 then
          setDryWetMaterials(0.4, "ASPHALT_WET")
          hideGroup("ck_rainroad", false)
          fixDecalRoad(scenetree.ck_rainroad)
          isWet = 1
          elseif isWet == 1 then
        end
        hideGroup("thunder", true)
      end

      if im.Button("Set Overcast") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.003, 1200, scenetree.Sky, 0, 0, false, nil)
        if isWet == 1 then
          setDryWetMaterials(1, "ASPHALT")
          hideGroup("ck_rainroad", true)
          fixDecalRoad(scenetree.ck_rainroad)
          isWet = 0
          elseif isWet == 0 then
        end
        hideGroup("thunder", true)
      end

      im.SameLine()
      if im.Button("Set Foggy") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/foggy/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_ambient.png", 0.010, 0, scenetree.Sky, 0, 0, false, nil)
        if isWet == 1 then
          setDryWetMaterials(1, "ASPHALT")
          hideGroup("ck_rainroad", true)
          fixDecalRoad(scenetree.ck_rainroad)
          isWet = 0
          elseif isWet == 0 then
        end
        hideGroup("thunder", true)
      end
      if im.Button("Set Rain") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.005, 0, scenetree.Sky, 2048, 0.6, false, nil)
        if isWet == 0 then
          setDryWetMaterials(0.4, "ASPHALT_WET")
          hideGroup("ck_rainroad", false)
          fixDecalRoad(scenetree.ck_rainroad)
          isWet = 1
          elseif isWet == 1 then
        end
        hideGroup("thunder", true)
      end
      im.SameLine()
      if im.Button("Set Thunder") then
        isThunder = true
        setWeather(levelfolder .. "/art/skies/sky_gradients/thunder/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/thunder/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/thunder/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/thunder/gradient_ambient.png", 0.015, 0, scenetree.Sky, 2048*1.5, 1, true, "cloudy-original")
        if isWet == 0 then
          setDryWetMaterials(0.4, "ASPHALT_WET")
          hideGroup("ck_rainroad", false)
          fixDecalRoad(scenetree.ck_rainroad)
          isWet = 1
          elseif isWet == 1 then
        end
      end
      im.Separator()
    end
    --far clip settings
    im.Text("View Distance")
    renderBias[0] = scenetree.theLevelInfo.visibleDistance or 4000
    im.PushItemWidth(100)
    if im.SliderFloat("##", renderBias, 1000, 10000, "%.1f") then
      scenetree.theLevelInfo.visibleDistance = renderBias[0]
      scenetree.theLevelInfo:postApply()
      core_environment.setTimeOfDay(tod)
    end
    im.SameLine()
    if im.Button("Reset view distance") then
      if defaultDistance == nil then
        scenetree.theLevelInfo.visibleDistance = 3000
        scenetree.theLevelInfo:postApply()
        core_environment.setTimeOfDay(tod)
      else
        scenetree.theLevelInfo.visibleDistance = defaultDistance
        scenetree.theLevelInfo:postApply()
        core_environment.setTimeOfDay(tod)
      end
    end
    im.Separator()
    if im.TreeNode1("Advanced settings") then
      im.Separator()
      local dbgEnabled = im.BoolPtr(debugEnabled)
      if im.Checkbox("Enable Debug", dbgEnabled) then
        debugEnabled = dbgEnabled[0]
      end
      im.TreePop()
    end
  end
  im.End()
end

local function onBeamNGTrigger(data)
  if data and data.triggerName then
    local triggerName = data.triggerName
    local trigger = scenetree.findObject(triggerName)
    local group = nil
    if trigger then group = trigger:getGroup() end
    local groupName = nil
    if group then groupName = group:getName() end
    local vehid = be:getPlayerVehicleID(0)
    if data.event == "enter" and data.subjectID == vehid then
      if groupName and groupName == 'tunnel_triggers' then
        if rainAmount and rainAmount > 0 then
          local precipitation = scenetree.findObject("Precipitation_1")
          precipitation.hidden = true
        end
        setCubemap('cubemap_c1tunnel_reflection')
      end
      if groupName and groupName == 'garage_triggers' then
        playerisintrigger = triggerName
      end
    end
    if data.event == "exit" and data.subjectID == vehid then
      local tod = scenetree.tod
      if groupName and groupName == 'tunnel_triggers' and tod.time > 0.21 and tod.time < 0.79 then
        if rainAmount and rainAmount > 0 then
          local precipitation = scenetree.findObject("Precipitation_1")
          precipitation.hidden = false
        end
        setCubemap('cubemap_c1night_reflection')
      elseif groupName and groupName == 'tunnel_triggers' then
        if rainAmount and rainAmount > 0 then
          local precipitation = scenetree.findObject("Precipitation_1")
          precipitation.hidden = false
        end
        setCubemap('cubemap_c1_reflection')
      end
      if groupName and groupName == 'garage_triggers' then
        playerisintrigger = nil
      end
    end
  end
end

local cubevalue = false

local function onUpdate(dtReal, dtSim)
  if luaLoaded == false then
    extensions.mainLevel.onClientStartMission()
  end

  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end

  tod = scenetree.tod

  local dont_showUI
  if freeroam_bigMapMode then
    dont_showUI = freeroam_bigMapMode.bigMapActive() == true or photoModeOpen
  end

  if not dont_showUI and skipImgui == false then
    --imgui app
    renderImguiMain()
    if debugEnabled == true then
      renderImguiDebug()
    end
  end

  if playerisintrigger ~= nil then
    renderTeleportUI(playerisintrigger)
  end

  delay = delay + dtSim

  waifuHunter(dtReal)

  --check for TOD
  if not tod then return end

  local value = (tod.time > 0.21 and tod.time < 0.79)
  local cameraCell = getCellIndexForPosition(core_camera.getPosition())
  local cameraCell2 = getCellIndexForPosition2(core_camera.getPosition())

  if (cameraCell ~= lastCameraCell or lastValue ~= value) and positionInRange(core_camera.getPosition()) then
    local xCell, zCell = getCellForPosition(core_camera.getPosition())
    enableLights(xCell, zCell, value)
  end

  local valueAdd = false
  if value == false then valueAdd = true end
  if valueAdd == true then
    if (cameraCell ~= lastCameraCell or lastValueAdd ~= valueAdd) and positionInRange(core_camera.getPosition()) then
      local xCell, zCell = getCellForPosition(core_camera.getPosition())
      enableLights(xCell, zCell, valueAdd, {"Tunnel_lights", "Tunnel_sounds", "garage_japan_unpacked"})
    end
  end

  lastCameraCell = cameraCell
  lastValue = value
  lastValueAdd = valueAdd
  local positionc2 = core_camera.getPosition()
  if be:getPlayerVehicle(0) then
    positionc2 = be:getPlayerVehicle(0):getPosition()
  end
  if (cameraCell2 ~= lastCameraCell2) and positionInRange2(positionc2) then
    local xCell, zCell = getCellForPosition2(positionc2)
    enableShadows(xCell, zCell)
  end

  lastCameraCell2 = cameraCell2

  local skyBox = scenetree.findObject("SkyBox_1")
  if tod.time > 0.21 and tod.time < 0.79 then
    if cubevalue == false then
      enabledisableEmissionGlow(1)
      cubemapname = "cubemap_c1night_reflection"
      setCubemap(cubemapname)
      print("night")
      cubevalue = true
      hideGroup("hide_forest", false)
      if isUsingSkybox == true then
        skyBox.hidden = true
      end
    end
    value = true
  else
    if cubevalue == true then
      enabledisableEmissionGlow(0)
      cubemapname = "cubemap_c1_reflection"
      setCubemap(cubemapname)
      print("day")
      cubevalue = false
      if isUsingSkybox then
        skyBox.hidden = false
      end
      hideGroup("hide_forest", true)
    end
  end
  if isThunder == true then onWeatherThunder(dtSim, dtReal) end
  if TorqueScriptLua then
    if freeroam_bigMapMode then
      if freeroam_bigMapMode.bigMapActive() == true then
        if bigmapvalue == 0 or bigmapvalue == 2 then
          hideGroup("water", true)
          hideGroup("bigmap_helper", false)
          bigmapvalue = 1
        end
      elseif bigmapvalue == 1 then
        hideGroup("water", false)
        hideGroup("bigmap_helper", true)
        bigmapvalue = 2
      end
    end
  end
end

local function onEditorInitialized()
  editor.addWindowMenuItem("Map Controller", onWindowMenuItem, {groupMenuName = 'Car_Killer Addons'})
  editor.registerWindow(toolWindowName, im.ImVec2(500, 200))
end


M.onClientStartMission = onClientStartMission
M.onClientPostStartMission = onClientPostStartMission
M.onUiChangedState = onUiChangedState
M.onUpdate = onUpdate
M.onBeamNGTrigger = onBeamNGTrigger
M.onEditorInitialized = onEditorInitialized

return M