
// This is the default save location for any TSForestItemData(s) created in the
// Forest Editor Editor (this script is executed from onServerCreated())

datablock TSForestItemData(tree_cypress)
{
   internalName = "tree_cypress";
   shapeFile = "levels/ogc_map/art/shapes/trees/trees_cypress/cypress_tree.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(grassclump_large)
{
   internalName = "grassclump_large";
   shapeFile = "levels/ogc_map/art/shapes/trees/grassclump_large.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(grassclump_small)
{
   internalName = "grassclump_large";
   shapeFile = "levels/ogc_map/art/groundcover/grassclump_small.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(spanishbayonet1)
{
   internalName = "spanishbayonet1";
   shapeFile = "levels/ogc_map/art/shapes/trees/spanishbayonet1.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(spanishbayonet2)
{
   internalName = "spanishbayonet2";
   shapeFile = "levels/ogc_map/art/shapes/trees/spanishbayonet2.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};


datablock TSForestItemData(eucalyptus_tall)
{
   internalName = "eucalyptus_tall";
   shapeFile = "levels/ogc_map/art/shapes/trees/trees_eucalyptus/eucalyptus_tall.dae";
   windScale = "1";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(eucalyptus_double)
{
   internalName = "eucalyptus_double";
   shapeFile = "levels/ogc_map/art/shapes/trees/trees_eucalyptus/eucalyptus_double.dae";
   windScale = "1";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(eucalyptus_group)
{
   internalName = "eucalyptus_group";
   shapeFile = "levels/ogc_map/art/shapes/trees/trees_eucalyptus/eucalyptus_group.dae";
   windScale = "1";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};



datablock TSForestItemData(pine_radiata_forest)
{
    internalName = "pine_radiata_forest";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/pine_radiata_forest.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(pine_radiata_large)
{
    internalName = "pine_radiata_large";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/pine_radiata_large.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};
datablock TSForestItemData(pine_radiata_small)
{
    internalName = "pine_radiata_small";
    shapeFile = "/levels/ogc_map/art/shapes/trees/trees_conifer/pine_radiata_small.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
   hidden = "1";
};

datablock TSForestItemData(pine_radiata_weathered)
{
    internalName = "pine_radiata_weathered";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/pine_radiata_weathered.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(oak_dry_a)
{
    internalName = "oak_dry_a";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_oak/oak_a.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(oak_dry_b)
{
    internalName = "oak_dry_b";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_oak/oak_b.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(oak_dry_c)
{
    internalName = "oak_dry_c";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_oak/oak_c.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(oak_dry_d)
{
    internalName = "oak_dry_d";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_oak/oak_d.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};
datablock TSForestItemData(redwood_split)
{
    internalName = "redwood_split";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/redwood_split.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(redwood_tall)
{
    internalName = "redwood_tall";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/redwood_tall.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(redwood_broad)
{
    internalName = "redwood_broad";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/redwood_broad.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};


datablock TSForestItemData(fanpalm_full)
{
    internalName = "fanpalm_full";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_palm/fanpalm_full.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(fanpalm_short)
{
    internalName = "fanpalm_short";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_palm/fanpalm_short.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(fanpalm_skirt)
{
    internalName = "fanpalm_skirt";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_palm/fanpalm_skirt.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(fanpalm_slim)
{
    internalName = "fanpalm_slim";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_palm/fanpalm_slim.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(fanpalm_tall)
{
    internalName = "fanpalm_tall";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_palm/fanpalm_tall.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(BBZ_redwood1)
{
    internalName = "BBZ_redwood1";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/BBZ_redwood1.dae";
    
};

datablock TSForestItemData(BBZ_redwood2)
{
    internalName = "BBZ_redwood2";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/BBZ_redwood2.dae";
    
};

datablock TSForestItemData(BBZ_redwood3)
{
    internalName = "BBZ_redwood3";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/BBZ_redwood3.dae";
    
};

datablock TSForestItemData(BBZ_redwood4)
{
    internalName = "BBZ_redwood4";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/BBZ_redwood4.dae";
    
};

datablock TSForestItemData(BBZ_redwood5)
{
    internalName = "BBZ_redwood5";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_conifer/BBZ_redwood5.dae";
    
};

datablock TSForestItemData(shrub_a)
{
    internalName = "shrub_a";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_shrub/shrub_a.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_b)
{
    internalName = "shrub_b";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_shrub/shrub_b.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_c)
{
    internalName = "shrub_c";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_shrub/shrub_c.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_d)
{
    internalName = "shrub_d";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_shrub/shrub_d.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_e)
{
    internalName = "shrub_e";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_shrub/shrub_e.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_f)
{
    internalName = "shrub_f";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_shrub/shrub_f.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_g)
{
    internalName = "shrub_g";
    shapeFile = "levels/ogc_map/art/shapes/trees/trees_shrub/shrub_g.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(flag_usa1)
{
   internalName = "flag_usa1";
   shapeFile = "levels/ogc_map/art/shapes/objects/flag_usa1.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(featherflag_gavril)
{
   internalName = "featherflag_gavril";
   shapeFile = "levels/ogc_map/art/shapes/objects/featherflag_gavril.dae";
   windScale = "0";
   trunkBendScale = "0.300000012";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
   order_simset = "0";
   mass = "1";
};

datablock TSForestItemData(featherflag_beamng)
{
   internalName = "featherflag_beamng";
   shapeFile = "levels/ogc_map/art/shapes/objects/featherflag_beamng.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(featherflag_repair)
{
   internalName = "featherflag_repair";
   shapeFile = "levels/ogc_map/art/shapes/objects/featherflag_repair.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(featherflag_ibishu)
{
   internalName = "featherflag_ibishu";
   shapeFile = "levels/ogc_map/art/shapes/objects/featherflag_ibishu.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(featherflag_bruckell)
{
   internalName = "featherflag_bruckell";
   shapeFile = "levels/ogc_map/art/shapes/objects/featherflag_bruckell.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};
//--------------------------------------------------HOUSES

datablock TSForestItemData(house1)
{
    internalName = "house1";
    shapeFile = "levels/ogc_map/art/shapes/buildings/house1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(house2)
{
    internalName = "house2";
    shapeFile = "levels/ogc_map/art/shapes/buildings/house2.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(house3)
{
    internalName = "house3";
    shapeFile = "levels/ogc_map/art/shapes/buildings/house3.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(house4)
{
    internalName = "house4";
    shapeFile = "levels/ogc_map/art/shapes/buildings/house4.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(tent1)
{
    internalName = "tent1";
    shapeFile = "levels/ogc_map/art/shapes/buildings/tent1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(marshaltower)
{
    internalName = "marshaltower";
    shapeFile = "levels/ogc_map/art/shapes/buildings/marshaltower.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(seating1)
{
    internalName = "seating1";
    shapeFile = "levels/ogc_map/art/shapes/buildings/seating1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};


//--------------------------------------------------WAREHOUSES

datablock TSForestItemData(warehouse1)
{
    internalName = "warehouse1";
    shapeFile = "levels/ogc_map/art/shapes/buildings/warehouse1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------------------ROCKS
datablock TSForestItemData(wca_rock1)
{
    internalName = "wca_rock1";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock1.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock2)
{
    internalName = "wca_rock2";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock2.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock3)
{
    internalName = "wca_rock3";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock3.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock4)
{
    internalName = "wca_rock4";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock4.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock5)
{
    internalName = "wca_rock5";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock5.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock6)
{
    internalName = "wca_rock6";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock6.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock7)
{
    internalName = "wca_rock7";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock7.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock8)
{
    internalName = "wca_rock8";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock8.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock9)
{
    internalName = "wca_rock9";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock9.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock10)
{
    internalName = "wca_rock10";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock10.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock11)
{
    internalName = "wca_rock11";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_rock11.dae";
    radius = "0";
};

datablock TSForestItemData(wca_cliff1)
{
    internalName = "wca_cliff1";
    shapeFile = "levels/ogc_map/art/shapes/rocks/wca_cliff1.dae";
    radius = "0";
};


//-------------------------------------------------TRACK OBJECTS
datablock TSForestItemData(barrierfence_folk)
{
    internalName = "barrierfence_folk";
    shapeFile = "levels/ogc_map/art/shapes/objects/barrierfence_folk.dae";
    radius = "0";
    annotation = "GUARD_RAIL";
    mode = "Override";
};

datablock TSForestItemData(barrierfence_plain)
{
    internalName = "barrierfence_plain";
    shapeFile = "levels/ogc_map/art/shapes/objects/barrierfence_plain.dae";
    radius = "0";
    annotation = "GUARD_RAIL";
    mode = "Override";
};

//--------------------------------------------SOLAR PANEL

datablock TSForestItemData(solarpanel)
{
    internalName = "solarpanel";
    shapeFile = "levels/ogc_map/art/shapes/objects/solarpanel.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------PYLON

datablock TSForestItemData(pylon)
{
    internalName = "pylon";
    shapeFile = "levels/ogc_map/art/shapes/objects/pylon.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(train_support1)
{
    internalName = "train_support1";
    shapeFile = "levels/ogc_map/art/shapes/objects/train_support1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(road_support1)
{
    internalName = "road_support1";
    shapeFile = "levels/ogc_map/art/shapes/objects/road_support1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------WALLS

datablock TSForestItemData(wall_brick1)
{
    internalName = "wall_brick1";
    shapeFile = "levels/ogc_map/art/shapes/objects/wall_brick1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(wall_metal1)
{
    internalName = "wall_metal1";
    shapeFile = "levels/ogc_map/art/shapes/objects/wall_metal1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(wall_wire1)
{
    internalName = "wall_wire1";
    shapeFile = "levels/ogc_map/art/shapes/objects/wall_wire1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(wall_wood1)
{
    internalName = "wall_wood1";
    shapeFile = "levels/ogc_map/art/shapes/objects/wall_wood1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};
//-------------------------------------------POWER POLES

datablock TSForestItemData(powerpole1)
{
    internalName = "powerpole1";
    shapeFile = "levels/ogc_map/art/shapes/objects/powerpole1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(powerpole2)
{
    internalName = "powerpole2";
    shapeFile = "levels/ogc_map/art/shapes/objects/powerpole2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(powerpole3)
{
    internalName = "powerpole3";
    shapeFile = "levels/ogc_map/art/shapes/objects/powerpole3.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(powerpole4)
{
    internalName = "powerpole4";
    shapeFile = "levels/ogc_map/art/shapes/objects/powerpole4.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

//-------------------------------------------FENCES

datablock TSForestItemData(fence_metal1)
{
    internalName = "fence_metal1";
    shapeFile = "levels/ogc_map/art/shapes/objects/fence_metal1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(screenfence1)
{
    internalName = "screenfence1";
    shapeFile = "levels/ogc_map/art/shapes/objects/screenfence1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------RAILINGS

datablock TSForestItemData(railing_support1)
{
    internalName = "railing_support1";
    shapeFile = "levels/ogc_map/art/shapes/objects/railing_support1.dae";
    radius = "0";
    annotation = "GUARD_RAIL";
    mode = "Override";
};

datablock TSForestItemData(railing_support2)
{
    internalName = "railing_support2";
    shapeFile = "levels/ogc_map/art/shapes/objects/railing_support2.dae";
    radius = "0";
    annotation = "GUARD_RAIL";
    mode = "Override";
};

datablock TSForestItemData(guardrail_support1)
{
    internalName = "guardrail_support1";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrail_support1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrailpost)
{
    internalName = "guardrailpost";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrailpost.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail1)
{
    internalName = "guardrail1";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrail1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail2)
{
    internalName = "guardrail2";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrail2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail1_white)
{
    internalName = "guardrail1_white";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrail1_white.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail2_white)
{
    internalName = "guardrail2_white";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrail2_white.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail1_blue)
{
    internalName = "guardrail1_blue";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrail1_blue.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail2_blue)
{
    internalName = "guardrail2_blue";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrail2_blue.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail1_red)
{
    internalName = "guardrail1_red";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrail1_red.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail2_red)
{
    internalName = "guardrail2_red";
    shapeFile = "levels/ogc_map/art/shapes/objects/guardrail2_red.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(tirestack1)
{
    internalName = "tirestack1";
    shapeFile = "levels/ogc_map/art/shapes/objects/tirestack1.dae";
    radius = "0";
};

datablock TSForestItemData(hr_tirestack_blue)
{
    internalName = "hr_tirestack_blue";
    shapeFile = "levels/ogc_map/art/shapes/objects/hr_tirestack_blue.dae";
    radius = "0";
};

datablock TSForestItemData(hr_tirestack_white)
{
    internalName = "hr_tirestack_white";
    shapeFile = "levels/ogc_map/art/shapes/objects/hr_tirestack_white.dae";
    radius = "0";
};

//-------------------------------------------SUBSTATION

datablock TSForestItemData(substation_circuitbreaker)
{
    internalName = "substation_circuitbreaker";
    shapeFile = "levels/ogc_map/art/shapes/objects/substation_circuitbreaker.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(substation_lightning)
{
    internalName = "substation_lightning";
    shapeFile = "levels/ogc_map/art/shapes/objects/substation_lightning.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(substation_support)
{
    internalName = "substation_support";
    shapeFile = "levels/ogc_map/art/shapes/objects/substation_support.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
    
};

datablock TSForestItemData(substation_transformer)
{
    internalName = "substation_transformer";
    shapeFile = "levels/ogc_map/art/shapes/objects/substation_transformer.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(substation_truss)
{
    internalName = "substation_truss";
    shapeFile = "levels/ogc_map/art/shapes/objects/substation_truss.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------INDUSTRIAL OBJECTS

datablock TSForestItemData(industrial_watertower)
{
    internalName = "industrial_watertower";
    shapeFile = "levels/ogc_map/art/shapes/objects/industrial_watertower.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(workshop1)
{
    internalName = "workshop1";
    shapeFile = "levels/ogc_map/art/shapes/buildings/workshop1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(leanto_small)
{
    internalName = "leanto_small";
    shapeFile = "levels/ogc_map/art/shapes/buildings/leanto_small.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(leanto_large)
{
    internalName = "leanto_large";
    shapeFile = "levels/ogc_map/art/shapes/buildings/leanto_large.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(storagerack)
{
    internalName = "storagerack";
    shapeFile = "levels/ogc_map/art/shapes/buildings/storagerack.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(industrial_pumpjack)
{
    internalName = "industrial_pumpjack";
    shapeFile = "levels/ogc_map/art/shapes/objects/industrial_pumpjack.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------------PIPELINE

datablock TSForestItemData(pipeline_support1)
{
    internalName = "pipeline_support1";
    shapeFile = "levels/ogc_map/art/shapes/objects/pipeline_support1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(pipeline_support2)
{
    internalName = "pipeline_support2";
    shapeFile = "levels/ogc_map/art/shapes/objects/pipeline_support2.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------------TOLL OBJECTS

datablock TSForestItemData(toll)
{
    internalName = "toll";
    shapeFile = "levels/ogc_map/art/shapes/objects/toll.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(toll_edge)
{
    internalName = "toll_edge";
    shapeFile = "levels/ogc_map/art/shapes/objects/toll_edge.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(toll_side)
{
    internalName = "toll_side";
    shapeFile = "levels/ogc_map/art/shapes/objects/toll_side.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};


//-------------------------------------------POLES

datablock TSForestItemData(pole_fence1)
{
    internalName = "pole_fence1";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_fence1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_fence2)
{
    internalName = "pole_fence2";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_fence2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_light_bridge)
{
    internalName = "pole_light_bridge";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_light_bridge.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_light_single)
{
    internalName = "pole_light_single";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_light_single.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_light_double)
{
    internalName = "pole_light_double";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_light_double.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_light_signal1)
{
    internalName = "pole_light_signal1";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_light_signal1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_traffic1)
{
    internalName = "pole_traffic1";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_traffic1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_thick)
{
    internalName = "pole_thick";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_thick.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_boom_med)
{
    internalName = "pole_boom_med";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_boom_med.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(boom_trafficlight_small)
{
    internalName = "boom_trafficlight_small";
    shapeFile = "levels/ogc_map/art/shapes/objects/boom_trafficlight_small.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_city1)
{
    internalName = "pole_city1";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_city1.dae";
    radius = "0";
   annotation = "POLE";
   mode = "Override";
};

datablock TSForestItemData(pole_lighting1)
{
    internalName = "pole_lighting1";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_lighting1.dae";
    radius = "0";
   annotation = "POLE";
   mode = "Override";
};

datablock TSForestItemData(pole_lighting2)
{
    internalName = "pole_lighting2";
    shapeFile = "levels/ogc_map/art/shapes/objects/pole_lighting2.dae";
    radius = "0";
   annotation = "POLE";
   mode = "Override";
};

datablock TSForestItemData(cable_boom)
{
    internalName = "cable_boom";
    shapeFile = "levels/ogc_map/art/shapes/objects/cable_boom.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(light_city)
{
    internalName = "light_city";
    shapeFile = "levels/ogc_map/art/shapes/objects/light_city.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(lamp1)
{
    internalName = "lamp1";
    shapeFile = "levels/ogc_map/art/shapes/objects/lamp1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};
//-------------------------------------------BILLBOARDS

datablock TSForestItemData(billboard_structure1)
{
    internalName = "billboard_structure1";
    shapeFile = "levels/ogc_map/art/shapes/objects/billboard_structure1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(billboard_structure2)
{
    internalName = "billboard_structure2";
    shapeFile = "levels/ogc_map/art/shapes/objects/billboard_structure2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(sign_rounded)
{
    internalName = "sign_rounded";
    shapeFile = "levels/ogc_map/art/shapes/objects/sign_rounded.dae";
    radius = "0";
};

datablock TSForestItemData(sign_turboburger)
{
    internalName = "sign_turboburger";
    shapeFile = "levels/ogc_map/art/shapes/objects/sign_turboburger.dae";
    radius = "0";
};

//-------------------------------------------TRAFFIC LIGHTS

datablock TSForestItemData(trafficlight_city1)
{
    internalName = "trafficlight_city1";
    shapeFile = "levels/ogc_map/art/shapes/objects/trafficlight_city1.dae";
    radius = "0";
    annotation = "TRAFFIC_SIGNALS";
    mode = "Override";
};

datablock TSForestItemData(trafficlight_city2)
{
    internalName = "trafficlight_city2";
    shapeFile = "levels/ogc_map/art/shapes/objects/trafficlight_city2.dae";
    radius = "0";
    annotation = "TRAFFIC_SIGNALS";
    mode = "Override";
};

datablock TSForestItemData(trafficlight_overhead1)
{
    internalName = "trafficlight_overhead1";
    shapeFile = "levels/ogc_map/art/shapes/objects/trafficlight_overhead1.dae";
    radius = "0";
    annotation = "TRAFFIC_SIGNALS";
    mode = "Override";
};

datablock TSForestItemData(trafficlight_overhead2)
{
    internalName = "trafficlight_overhead2";
    shapeFile = "levels/ogc_map/art/shapes/objects/trafficlight_overhead2.dae";
    radius = "0";
    annotation = "TRAFFIC_SIGNALS";
    mode = "Override";
};

datablock TSForestItemData(crosswalklight)
{
    internalName = "crosswalklight";
    shapeFile = "levels/ogc_map/art/shapes/objects/crosswalklight.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

//-------------------------------------------SIDEWALK OBJECTS

datablock TSForestItemData(hydrant1)
{
    internalName = "hydrant1";
    shapeFile = "levels/ogc_map/art/shapes/objects/hydrant1.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(bollard_yellow)
{
    internalName = "bollard_yellow";
    shapeFile = "levels/ogc_map/art/shapes/objects/bollard_yellow.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(bollard_hoop_red)
{
    internalName = "bollard_hoop_red";
    shapeFile = "levels/ogc_map/art/shapes/objects/bollard_hoop_red.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(bollard_hoop_grey)
{
    internalName = "bollard_hoop_grey";
    shapeFile = "levels/ogc_map/art/shapes/objects/bollard_hoop_grey.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(planterbox)
{
    internalName = "planterbox";
    shapeFile = "levels/ogc_map/art/shapes/objects/planterbox.dae";
    radius = "0";
   annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(trafficlightbox_green)
{
    internalName = "trafficlightbox_green";
    shapeFile = "levels/ogc_map/art/shapes/objects/trafficlightbox_green.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(postbox_blue)
{
    internalName = "postbox_blue";
    shapeFile = "levels/ogc_map/art/shapes/objects/postbox_blue.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(gaspump)
{
    internalName = "gaspump";
    shapeFile = "levels/ogc_map/art/shapes/objects/gaspump.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------CONSTRUCTION OBJECTS

datablock TSForestItemData(dumpster)
{
    internalName = "dumpster";
    shapeFile = "levels/ogc_map/art/shapes/objects/dumpster.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(sandbarrel)
{
    internalName = "sandbarrel";
    shapeFile = "levels/ogc_map/art/shapes/objects/sandbarrel.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(constructionbarrier)
{
    internalName = "constructionbarrier";
    shapeFile = "levels/ogc_map/art/shapes/objects/constructionbarrier.dae";
    radius = "0";
    annotation = "ROADBLOCK";
    mode = "Override";
};

datablock TSForestItemData(jerseybarrier_3m)
{
    internalName = "jerseybarrier_3m";
    shapeFile = "levels/ogc_map/art/shapes/objects/jerseybarrier_3m.dae";
    radius = "0";
    annotation = "ROADBLOCK";
    mode = "Override";
};

datablock TSForestItemData(jerseybarrier_end)
{
    internalName = "jerseybarrier_end";
    shapeFile = "levels/ogc_map/art/shapes/objects/jerseybarrier_end.dae";
    radius = "0";
    annotation = "ROADBLOCK";
    mode = "Override";
};

datablock TSForestItemData(spool)
{
    internalName = "spool";
    shapeFile = "levels/ogc_map/art/shapes/objects/spool.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(pallet)
{
    internalName = "pallet";
    shapeFile = "levels/ogc_map/art/shapes/objects/pallet.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------ROAD SIGNS

datablock TSForestItemData(sign_truss1)
{
    internalName = "sign_truss1";
    shapeFile = "levels/ogc_map/art/shapes/objects/sign_truss1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(sign_truss2)
{
    internalName = "sign_truss2";
    shapeFile = "levels/ogc_map/art/shapes/objects/sign_truss2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(sign_truss3)
{
    internalName = "sign_truss3";
    shapeFile = "levels/ogc_map/art/shapes/objects/sign_truss3.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(sign_truss4)
{
    internalName = "sign_truss4";
    shapeFile = "levels/ogc_map/art/shapes/objects/sign_truss4.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};


datablock TSForestItemData(tree_oak_bush_a)
{
    internalName = "tree_oak_bush_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_bush_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.100000001";
    detailAmp = "0.150000006";
    detailFreq = "4";
   mass = "2";
   rigidity = "15";
};

datablock TSForestItemData(tree_oak_bush_c)
{
    internalName = "tree_oak_bush_c";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_bush_c.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0500000007";
    branchAmp = "0.300000012";
    detailAmp = "0.400000006";
    detailFreq = "4";
   mass = "2";
   rigidity = "30";
};


datablock TSForestItemData(tree_oak_large_a)
{
    internalName = "tree_oak_large_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_large_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0399999991";
    branchAmp = "0.150000006";
    detailAmp = "0.200000003";
    detailFreq = "4";
    rigidity = "80";
   mass = "100";
   dampingCoefficient = "0.300000012";
};



datablock TSForestItemData(tree_oak_large_c)
{
    internalName = "tree_oak_large_c";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_large_c.dae";
    mass = "100";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0399999991";
    branchAmp = "0.200000003";
    detailAmp = "0.200000003";
    detailFreq = "4";
   rigidity = "60";
   dampingCoefficient = "0.300000012";
};

datablock TSForestItemData(tree_oak_bush_b)
{
    internalName = "tree_oak_bush_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_bush_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    trunkBendScale = "0.05";
    branchAmp = "0.200000003";
    detailAmp = "0.400000006";
    detailFreq = "5";
   mass = "2";
   rigidity = "25";
};


datablock TSForestItemData(tree_oak_sml_a)
{
    internalName = "tree_oak_sml_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_sml_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.300000012";
    detailAmp = "0.300000012";
    detailFreq = "5";
   mass = "15";
   rigidity = "35";
};


datablock TSForestItemData(tree_oak_large_b)
{
    internalName = "tree_oak_large_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_large_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0199999996";
    branchAmp = "0.150000006";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "200";
   rigidity = "100";
   dampingCoefficient = "0.200000003";
};

datablock TSForestItemData(tree_oak_large_b)
{
    internalName = "tree_oak_large_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_large_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0199999996";
    branchAmp = "0.400000006";
    detailAmp = "0.400000006";
    detailFreq = "5";
   mass = "200";
   rigidity = "100";
   dampingCoefficient = "0.200000003";
};

datablock TSForestItemData(tree_oak_forest_group)
{
    internalName = "tree_oak_forest_group";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_forest_group.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.200000003";
    detailAmp = "0.200000003";
    detailFreq = "5";
   mass = "60";
   rigidity = "35";
   radius = "1.29999995";
};

datablock TSForestItemData(grass_field_large)
{
    internalName = "grass_field_large";
    shapeFile = "levels/derby/art/shapes/groundcover/grass_field_large.dae";
    radius = "0.4";
    rigidity = "5";
    tightnessCoefficient = "4";
    windScale = "0.6";
    trunkBendScale = "0.1";
    detailAmp = "0.4";
    detailFreq = "0.4";
    collidable = "0";
};

datablock TSForestItemData(tree_aspen_overhang_a)
{
    internalName = "tree_aspen_overhang_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_overhang_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.6";
    trunkBendScale = "0.0500000007";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "3";
   mass = "10";
};

datablock TSForestItemData(tree_aspen_large_b)
{
    internalName = "tree_aspen_large_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_large_b.dae";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "4";
    tightnessCoefficient = "4";
    windScale = "0.6";
   dampingCoefficient = "0.200000003";
   trunkBendScale = "0.0500000007";
   mass = "60";
   rigidity = "45";
};

datablock TSForestItemData(tree_aspen_forest_b)
{
    internalName = "tree_aspen_forest_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_forest_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "4";
    trunkBendScale = "0.0500000007";
   mass = "45";
   rigidity = "22";
};

datablock TSForestItemData(tree_aspen_forest_a)
{
    internalName = "tree_aspen_forest_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_forest_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.0500000007";
    detailAmp = "0.1";
    detailFreq = "4";
    trunkBendScale = "0.0700000003";
   mass = "40";
   rigidity = "20";
};

datablock TSForestItemData(tree_aspen_forest_group)
{
    internalName = "tree_aspen_forest_group";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_forest_group.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "5";
    trunkBendScale = "0";
};

datablock TSForestItemData(tree_aspen_small_a)
{
    internalName = "tree_aspen_small_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_small_a.dae";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "5";
    tightnessCoefficient = "4";
    windScale = "0.4";
    radius = "0.5";
   mass = "30";
   rigidity = "20";
};

datablock TSForestItemData(tree_aspen_small_b)
{
    internalName = "tree_aspen_small_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_small_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0199999996";
    detailAmp = "0.150000006";
    detailFreq = "7";
   mass = "12";
   radius = "0.5";
};

datablock TSForestItemData(tree_aspen_small_c)
{
    internalName = "tree_aspen_small_c";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_small_c.dae";
    trunkBendScale = "0.200000003";
    branchAmp = "0.0299999993";
    detailAmp = "0.200000003";
    detailFreq = "7";
    tightnessCoefficient = "4";
    windScale = "0.4";
   mass = "19";
   rigidity = "16";
};

datablock TSForestItemData(tree_aspen_small_d)
{
    internalName = "tree_aspen_small_d";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_small_d.dae";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0299999993";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "20";
   rigidity = "17";
};

datablock TSForestItemData(tree_aspen_bush_c)
{
    internalName = "tree_aspen_bush_c";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_bush_c.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.150000006";
    branchAmp = "0";
    detailAmp = "0.150000006";
    detailFreq = "6";
};

datablock TSForestItemData(tree_aspen_bush_a)
{
    internalName = "tree_aspen_bush_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_bush_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.200000003";
    branchAmp = "0";
    detailAmp = "0.100000001";
    detailFreq = "7";
    radius = "0.300000012";
   mass = "1";
   rigidity = "3";
   dampingCoefficient = "0.5";
};

datablock TSForestItemData(tree_aspen_bush_b)
{
    internalName = "tree_aspen_bush_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_bush_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0";
    detailAmp = "0.150000006";
    detailFreq = "6";
    radius = "0.5";
   mass = "3";
   rigidity = "6";
};

datablock TSForestItemData(tree_aspen_large_a)
{
    internalName = "tree_aspen_large_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_large_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0299999993";
    detailAmp = "0.150000006";
    detailFreq = "3";
    mass = "50";
    radius = "0.5";
   rigidity = "30";
};



datablock TSForestItemData(vine_ground_medium)
{
    internalName = "vine_ground_medium";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_ground_medium.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    detailAmp = "0.1";
    detailFreq = "0.5";
    radius = "0.5";
};

datablock TSForestItemData(vine_bush_wide)
{
    internalName = "vine_bush_wide";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_bush_wide.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.01";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.8";
};

datablock TSForestItemData(vine_bush_large)
{
    internalName = "vine_bush_large";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_bush_large.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_ground_large)
{
    internalName = "vine_ground_large";
    shapeFile = "levels/derby/art/shapes/trees/vine/vine_ground_large.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_ground_large)
{
    internalName = "vine_ground_large";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_ground_large.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.5";
    trunkBendScale = "0.1";
};

datablock TSForestItemData(vine_wall_wide_b)
{
    internalName = "vine_wall_wide_b";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_wall_wide_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_wall_small)
{
    internalName = "vine_wall_small";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_wall_small.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.4";
};

datablock TSForestItemData(vine_wall_medium)
{
    internalName = "vine_wall_medium";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_wall_medium.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_wall_large)
{
    internalName = "vine_wall_large";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_wall_large.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.2";
    trunkBendScale = "0.1";
};

datablock TSForestItemData(vine_ground_small)
{
    internalName = "vine_ground_small";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_ground_small.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.5";
};

datablock TSForestItemData(vine_bush_small)
{
    internalName = "vine_bush_small";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_bush_small.dae";
    radius = "0.5";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_bush_wide_b)
{
    internalName = "vine_bush_wide_b";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_bush_wide_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_roof_wide)
{
    internalName = "vine_roof_wide";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_roof_wide.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    trunkBendScale = "0";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_roof_small)
{
    internalName = "vine_roof_small";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_roof_small.dae";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0.6";
    tightnessCoefficient = "4";
};

datablock TSForestItemData(vine_roof_end)
{
    internalName = "vine_roof_end";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_roof_end.dae";
    windScale = "0.4";
    trunkBendScale = "0.02";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_2m)
{
    internalName = "vine_side_2m";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_side_2m.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_4m)
{
    internalName = "vine_side_4m";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_side_4m.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_8m)
{
    internalName = "vine_side_8m";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_side_8m.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(tree_oak_sml_b)
{
    internalName = "tree_oak_sml_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_sml_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.300000012";
    detailAmp = "0.300000012";
    detailFreq = "5";
   mass = "20";
   rigidity = "30";
   trunkBendScale = "0.0700000003";
};

datablock TSForestItemData(tree_oak_sml_b)
{
    internalName = "tree_oak_sml_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_sml_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.300000012";
    detailAmp = "0.400000006";
    detailFreq = "5";
   mass = "20";
   rigidity = "30";
};

datablock TSForestItemData(vine_wall_wide_a)
{
    internalName = "vine_wall_wide_a";
    shapeFile = "levels/derby/art/shapes/trees/vines/vine_wall_wide_a.dae";
    radius = "0.5";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};


datablock TSForestItemData(tree_beech_large_c)
{
    internalName = "tree_beech_large_c";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_large_c.dae";
    radius = "0.5";
    dampingCoefficient = "0.04";
    windScale = "0.400000006";
    trunkBendScale = "0.2";
    branchAmp = "0.0700000003";
    detailAmp = "0.100000001";
    detailFreq = "4";
   mass = "40";
   rigidity = "25";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_overhang_a)
{
    internalName = "tree_beech_overhang_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_overhang_a.dae";
    radius = "0.5";
    dampingCoefficient = "0.300000012";
    windScale = "0.400000006";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "30";
   rigidity = "20";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_small_d)
{
    internalName = "tree_beech_small_d";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_small_d.dae";
    dampingCoefficient = "0.300000012";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.200000003";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "20";
   rigidity = "15";
   tightnessCoefficient = "2";
};

datablock TSForestItemData(tree_beech_small_c)
{
    internalName = "tree_beech_small_c";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_small_c.dae";
    dampingCoefficient = "0.400000006";
    windScale = "0.4";
    trunkBendScale = "0.0599999987";
    branchAmp = "0.0700000003";
    detailAmp = "0.300000012";
    detailFreq = "4";
   mass = "7";
   rigidity = "7";
   tightnessCoefficient = "2";
};

datablock TSForestItemData(tree_beech_small_b)
{
    internalName = "tree_beech_small_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_small_b.dae";
    dampingCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "10";
   rigidity = "15";
   tightnessCoefficient = "2";
};

datablock TSForestItemData(tree_beech_forest_a)
{
    internalName = "tree_beech_forest_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_forest_a.dae";
    dampingCoefficient = "0.400000006";
    windScale = "0.4";
    trunkBendScale = "0.05";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "20";
   rigidity = "30";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_forest_b)
{
    internalName = "tree_beech_forest_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_forest_b.dae";
    dampingCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0399999991";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "40";
   rigidity = "18";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_forest_group)
{
    internalName = "tree_beech_forest_group";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_forest_group.dae";
    dampingCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "4";
};

datablock TSForestItemData(tree_beech_large_b)
{
    internalName = "tree_beech_large_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_large_b.dae";
    dampingCoefficient = "0.100000001";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "80";
   rigidity = "70";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_bush_c)
{
    internalName = "tree_beech_bush_c";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_bush_c.dae";
    dampingCoefficient = "0.5";
    windScale = "0.4";
    trunkBendScale = "0.05";
    branchAmp = "0.0700000003";
    detailAmp = "0.200000003";
    detailFreq = "4";
    radius = "0.5";
   mass = "3";
   rigidity = "12";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_bush_a)
{
    internalName = "tree_beech_bush_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_bush_a.dae";
    radius = "0.5";
    dampingCoefficient = "0.400000006";
    windScale = "0.4";
    trunkBendScale = "0.05";
    branchAmp = "0.0199999996";
    detailAmp = "0.3";
    detailFreq = "4";
   mass = "1";
   rigidity = "11";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_bush_b)
{
    internalName = "tree_beech_bush_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_bush_b.dae";
    radius = "0.5";
    dampingCoefficient = "0.400000006";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0799999982";
    detailAmp = "0.3";
    detailFreq = "4";
   mass = "2";
   rigidity = "6";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_oak_forest_b)
{
    internalName = "tree_oak_forest_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_forest_b.dae";
    windScale = "0.4";
    trunkBendScale = "0.0399999991";
    branchAmp = "0.200000003";
    detailAmp = "0.300000012";
    detailFreq = "5";
   mass = "75";
   rigidity = "55";
};

datablock TSForestItemData(tree_oak_dead_a)
{
    internalName = "tree_oak_dead_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_dead_a.dae";
    radius = "2";
    windScale = "0.4";
   mass = "100";
   rigidity = "80";
   trunkBendScale = "0.0399999991";
   branchAmp = "0.200000003";
   detailAmp = "0.200000003";
   detailFreq = "4";
};

datablock TSForestItemData(tree_oak_blocker_a)
{
    internalName = "tree_oak_blocker_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_blocker_a.dae";
    windScale = "0.400000006";
   radius = "0.600000024";
   mass = "10";
   rigidity = "40";
   dampingCoefficient = "4";
   trunkBendScale = "0.0199999996";
   branchAmp = "0.100000001";
   detailAmp = "0.200000003";
   detailFreq = "4";
};

datablock TSForestItemData(tree_aspen_blocker_a)
{
    internalName = "tree_aspen_blocker_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_blocker_a.dae";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "4";
   mass = "2";
   rigidity = "5";
};

datablock TSForestItemData(tree_beech_blocker_a)
{
    internalName = "tree_beech_blocker_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_blocker_a.dae";
    radius = "0.8";
    dampingCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.0500000007";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "4";
   tightnessCoefficient = "2";
};

datablock TSForestItemData(tree_beech_dead_a)
{
    internalName = "tree_beech_dead_a";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_dead_a.dae";
    radius = "0.5";
};

datablock TSForestItemData(tree_beech_dead_b)
{
    internalName = "tree_beech_dead_b";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_dead_b.dae";
    radius = "0.5";
};

datablock TSForestItemData(tree_aspen_small_low)
{
    internalName = "tree_aspen_small_low";
    shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_small_low.dae";
    windScale = "0.4";
    trunkBendScale = "0.200000003";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "4";
    radius = "0.3";
   mass = "11";
   rigidity = "11";
};

datablock TSForestItemData(tree_beech_bush_d)
{
    internalName = "tree_beech_bush_d";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_bush_d.dae";
    radius = "0.699999988";
    windScale = "0.4";
    trunkBendScale = "0.0500000007";
    branchAmp = "0.0700000003";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "2";
   rigidity = "8";
   tightnessCoefficient = "3";
   dampingCoefficient = "0.400000006";
};

datablock TSForestItemData(tree_beech_bush_e)
{
    internalName = "tree_beech_bush_e";
    shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_bush_e.dae";
    radius = "1";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.0700000003";
    detailAmp = "0.300000012";
    detailFreq = "4";
   mass = "2";
   rigidity = "7";
   tightnessCoefficient = "3";
   dampingCoefficient = "0.300000012";
};


datablock TSForestItemData(ind_rubbish_01_a)
{
    internalName = "ind_rubbish_01_a";
    shapeFile = "levels/derby/art/shapes/buildings/ind_rubbish_01_a.dae";
    radius = "0.1";
};



datablock TSForestItemData(tree_oak_dead_b)
{
   internalName = "tree_oak_dead_b";
   shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_dead_b.dae";
   mass = "15";
   rigidity = "35";
   tightnessCoefficient = "4";
   windScale = "0.400000006";
   trunkBendScale = "0.0299999993";
   branchAmp = "0.200000003";
   detailAmp = "0.200000003";
   detailFreq = "4";
};



datablock TSForestItemData(tree_oak_forest_a)
{
   internalName = "tree_oak_forest_a";
   shapeFile = "levels/derby/art/shapes/trees/trees_oak/tree_oak_forest_a.dae";
   mass = "100";
   rigidity = "55";
   windScale = "0.400000006";
   trunkBendScale = "0.0399999991";
   branchAmp = "0.400000006";
   detailAmp = "0.400000006";
   detailFreq = "4";
   radius = "1";
};

datablock TSForestItemData(tree_aspen_wall)
{
   internalName = "tree_aspen_wall";
   shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_wall.dae";
   rigidity = "20";
   windScale = "0.400000006";
   trunkBendScale = "0.00999999978";
   branchAmp = "0.0500000007";
   detailAmp = "0.100000001";
   detailFreq = "5";
   mass = "20";
};

datablock TSForestItemData(oak_beech_wallblocker_long)
{
   internalName = "oak_beech_wallblocker_long";
   shapeFile = "levels/derby/art/shapes/trees/oak_beech_wallblocker_long.dae";
   mass = "3";
   rigidity = "7";
   tightnessCoefficient = "4";
   dampingCoefficient = "0.400000006";
   windScale = "0.400000006";
   detailAmp = "0.200000003";
   detailFreq = "4";
};

datablock TSForestItemData(tree_aspen_small_low_group)
{
   internalName = "tree_aspen_small_low_group";
   shapeFile = "levels/derby/art/shapes/trees/trees_aspen/tree_aspen_small_low_group.dae";
};

datablock TSForestItemData(tree_beech_small_forest_group)
{
   internalName = "tree_beech_small_forest_group";
   shapeFile = "levels/derby/art/shapes/trees/trees_beech/tree_beech_small_forest_group.dae";
};


datablock TSForestItemData(cork_oak_bush_medium)
{
   internalName = "cork_oak_bush_medium";
   shapeFile = "levels/derby/art/shapes/trees/ECA_coast_bush/cork_oak_bush_medium.dae";
   radius = "0.5";
};

datablock TSForestItemData(generibush)
{
   internalName = "generibush";
   shapeFile = "levels/derby/art/shapes/trees/ECA_coast_bush/generibush.dae";
};

datablock TSForestItemData(generibush_small)
{
   internalName = "generibush_small";
   shapeFile = "levels/derby/art/shapes/trees/ECA_coast_bush/generibush_small.dae";
   radius = "0.5";
};

datablock TSForestItemData(maritime_pine_bush)
{
   internalName = "maritime_pine_bush";
   shapeFile = "levels/derby/art/shapes/trees/ECA_coast_bush/maritime_pine_bush.dae";
};

datablock TSForestItemData(cork_oak_bush_large)
{
   internalName = "cork_oak_bush_large";
   shapeFile = "levels/derby/art/shapes/trees/ECA_coast_bush/cork_oak_bush_large.dae";
};
datablock TSForestItemData(eca_rock_small)
{
   internalName = "eca_rock_small";
   shapeFile = "levels/industrial/art/shapes/rocks/eca_rock_small.dae";
   radius = "0.300000012";
};

datablock TSForestItemData(eca_rock_small_2)
{
   internalName = "eca_rock_small_2";
   shapeFile = "levels/industrial/art/shapes/rocks/eca_rock_small_2.dae";
   radius = "0.200000003";
};

datablock TSForestItemData(eca_rock_small_3)
{
   internalName = "eca_rock_small_3";
   shapeFile = "levels/industrial/art/shapes/rocks/eca_rock_small_3.dae";
   radius = "0.200000003";
};

datablock TSForestItemData(eca_rock_small_4)
{
   internalName = "eca_rock_small_4";
   shapeFile = "levels/industrial/art/shapes/rocks/eca_rock_small_4.dae";
   radius = "0.200000003";
};

datablock TSForestItemData(eca_rock_small_5)
{
   internalName = "eca_rock_small_5";
   shapeFile = "levels/industrial/art/shapes/rocks/eca_rock_small_5.dae";
   radius = "0.200000003";
};

datablock TSForestItemData(tree_oak_bush_a)
{
    internalName = "tree_oak_bush_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_bush_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.100000001";
    detailAmp = "0.150000006";
    detailFreq = "4";
   mass = "2";
   rigidity = "15";
   radius = "0.200000003";
};

datablock TSForestItemData(tree_oak_bush_c)
{
    internalName = "tree_oak_bush_c";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_bush_c.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0500000007";
    branchAmp = "0.300000012";
    detailAmp = "0.400000006";
    detailFreq = "4";
   mass = "2";
   rigidity = "30";
   radius = "0.400000006";
};


datablock TSForestItemData(tree_oak_large_a)
{
    internalName = "tree_oak_large_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_large_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0399999991";
    branchAmp = "0.150000006";
    detailAmp = "0.200000003";
    detailFreq = "4";
    rigidity = "80";
   mass = "100";
   dampingCoefficient = "0.300000012";
};



datablock TSForestItemData(tree_oak_large_c)
{
    internalName = "tree_oak_large_c";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_large_c.dae";
    mass = "100";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0399999991";
    branchAmp = "0.200000003";
    detailAmp = "0.200000003";
    detailFreq = "4";
   rigidity = "60";
   dampingCoefficient = "0.300000012";
};

datablock TSForestItemData(tree_oak_bush_b)
{
    internalName = "tree_oak_bush_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_bush_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    trunkBendScale = "0.05";
    branchAmp = "0.200000003";
    detailAmp = "0.400000006";
    detailFreq = "5";
   mass = "2";
   rigidity = "25";
   radius = "0.300000012";
};


datablock TSForestItemData(tree_oak_sml_a)
{
    internalName = "tree_oak_sml_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_sml_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.300000012";
    detailAmp = "0.300000012";
    detailFreq = "5";
   mass = "15";
   rigidity = "35";
};


datablock TSForestItemData(tree_oak_large_b)
{
    internalName = "tree_oak_large_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_large_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0199999996";
    branchAmp = "0.150000006";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "200";
   rigidity = "100";
   dampingCoefficient = "0.200000003";
};

datablock TSForestItemData(tree_oak_large_b)
{
    internalName = "tree_oak_large_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_large_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0199999996";
    branchAmp = "0.400000006";
    detailAmp = "0.400000006";
    detailFreq = "5";
   mass = "200";
   rigidity = "100";
   dampingCoefficient = "0.200000003";
};

datablock TSForestItemData(tree_oak_forest_group)
{
    internalName = "tree_oak_forest_group";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_forest_group.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.200000003";
    detailAmp = "0.200000003";
    detailFreq = "5";
   mass = "60";
   rigidity = "35";
   radius = "1.29999995";
};

datablock TSForestItemData(tree_oak_dead_a)
{
    internalName = "tree_oak_dead_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_dead_a.dae";
    radius = "2";
    windScale = "0.4";
   mass = "100";
   rigidity = "80";
   trunkBendScale = "0.0399999991";
   branchAmp = "0.200000003";
   detailAmp = "0.200000003";
   detailFreq = "4";
};


datablock TSForestItemData(tree_oak_forest_b)
{
    internalName = "tree_oak_forest_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_forest_b.dae";
    windScale = "0.4";
    trunkBendScale = "0.0399999991";
    branchAmp = "0.200000003";
    detailAmp = "0.300000012";
    detailFreq = "5";
   mass = "75";
   rigidity = "55";
};


datablock TSForestItemData(tree_oak_blocker_a)
{
    internalName = "tree_oak_blocker_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_blocker_a.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.15";
    detailAmp = "0.3";
    detailFreq = "1.5";
    rigidity = "32";
   dampingCoefficient = "3";
   radius = "0.5";
   mass = "4";
};

datablock TSForestItemData(tree_oak_forest_canopy_a)
{
    internalName = "tree_oak_forest_canopy_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_forest_canopy_a.dae";
    windScale = "0.4";
    trunkBendScale = "0.01";
    branchAmp = "0.5";
    detailAmp = "0.5";
    detailFreq = "0.5";
};









datablock TSForestItemData(grass_field_large)
{
    internalName = "grass_field_large";
    shapeFile = "levels/industrial/art/shapes/groundcover/grass_field_large.dae";
    radius = "0.4";
    rigidity = "5";
    tightnessCoefficient = "4";
    windScale = "0.6";
    trunkBendScale = "0.1";
    detailAmp = "0.4";
    detailFreq = "0.4";
    collidable = "0";
};

datablock TSForestItemData(grass_field_sml)
{
    internalName = "grass_field_sml";
    shapeFile = "levels/industrial/art/shapes/groundcover/grass_field_sml.dae";
    radius = "0.2";
    tightnessCoefficient = "4";
    windScale = "0.5";
    trunkBendScale = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    collidable = "0";
};

datablock TSForestItemData(grass_field_long)
{
    internalName = "grass_field_long";
    shapeFile = "levels/industrial/art/shapes/groundcover/grass_field_long.dae";
    tightnessCoefficient = "4";
    windScale = "0.6";
    trunkBendScale = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
};

datablock TSForestItemData(grass_field_filler)
{
    internalName = "grass_field_filler";
    shapeFile = "levels/industrial/art/shapes/groundcover/grass_field_filler.dae";
    tightnessCoefficient = "4";
    windScale = "0.6";
    trunkBendScale = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
};







datablock TSForestItemData(tree_aspen_overhang_a)
{
    internalName = "tree_aspen_overhang_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_overhang_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.6";
    trunkBendScale = "0.0500000007";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "3";
   mass = "10";
};

datablock TSForestItemData(tree_aspen_large_b)
{
    internalName = "tree_aspen_large_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_large_b.dae";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "4";
    tightnessCoefficient = "4";
    windScale = "0.6";
   dampingCoefficient = "0.200000003";
   trunkBendScale = "0.0500000007";
   mass = "60";
   rigidity = "45";
};

datablock TSForestItemData(tree_aspen_forest_b)
{
    internalName = "tree_aspen_forest_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_forest_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "4";
    trunkBendScale = "0.0500000007";
   mass = "45";
   rigidity = "22";
};

datablock TSForestItemData(tree_aspen_forest_a)
{
    internalName = "tree_aspen_forest_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_forest_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.0500000007";
    detailAmp = "0.1";
    detailFreq = "4";
    trunkBendScale = "0.0700000003";
   mass = "40";
   rigidity = "20";
};

datablock TSForestItemData(tree_aspen_forest_group)
{
    internalName = "tree_aspen_forest_group";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_forest_group.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "5";
    trunkBendScale = "0";
};

datablock TSForestItemData(tree_aspen_small_a)
{
    internalName = "tree_aspen_small_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_small_a.dae";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "5";
    tightnessCoefficient = "4";
    windScale = "0.4";
    radius = "0.5";
   mass = "14";
   rigidity = "17";
};

datablock TSForestItemData(tree_aspen_small_b)
{
    internalName = "tree_aspen_small_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_small_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0199999996";
    detailAmp = "0.150000006";
    detailFreq = "7";
   mass = "15";
   radius = "0.5";
   rigidity = "18";
};

datablock TSForestItemData(tree_aspen_small_c)
{
    internalName = "tree_aspen_small_c";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_small_c.dae";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0299999993";
    detailAmp = "0.200000003";
    detailFreq = "7";
    tightnessCoefficient = "4";
    windScale = "0.4";
   mass = "19";
   rigidity = "20";
};

datablock TSForestItemData(tree_aspen_small_d)
{
    internalName = "tree_aspen_small_d";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_small_d.dae";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0299999993";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "20";
   rigidity = "17";
};

datablock TSForestItemData(tree_aspen_bush_c)
{
    internalName = "tree_aspen_bush_c";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_bush_c.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.150000006";
    branchAmp = "0";
    detailAmp = "0.150000006";
    detailFreq = "6";
   mass = "5";
};

datablock TSForestItemData(tree_aspen_bush_a)
{
    internalName = "tree_aspen_bush_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_bush_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.200000003";
    branchAmp = "0";
    detailAmp = "0.100000001";
    detailFreq = "7";
    radius = "0.300000012";
   mass = "1";
   rigidity = "3";
   dampingCoefficient = "0.5";
};

datablock TSForestItemData(tree_aspen_bush_b)
{
    internalName = "tree_aspen_bush_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_bush_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0";
    detailAmp = "0.150000006";
    detailFreq = "6";
    radius = "0.5";
   mass = "3";
   rigidity = "6";
};

datablock TSForestItemData(tree_aspen_large_a)
{
    internalName = "tree_aspen_large_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_large_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0299999993";
    detailAmp = "0.150000006";
    detailFreq = "3";
    mass = "50";
    radius = "0.5";
   rigidity = "30";
};

datablock TSForestItemData(tree_aspen_small_low)
{
    internalName = "tree_aspen_small_low";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_small_low.dae";
    windScale = "0.4";
    trunkBendScale = "0.200000003";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "4";
    radius = "0.3";
   mass = "11";
   rigidity = "11";
};

datablock TSForestItemData(tree_aspen_blocker_a)
{
    internalName = "tree_aspen_blocker_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_blocker_a.dae";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0500000007";
    detailAmp = "0.150000006";
    detailFreq = "4";
   mass = "2";
   rigidity = "5";
};

datablock TSForestItemData(tree_aspen_small_low_group)
{
   internalName = "tree_aspen_small_low_group";
   shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_small_low_group.dae";
};









datablock TSForestItemData(vine_ground_medium)
{
    internalName = "vine_ground_medium";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_ground_medium.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    detailAmp = "0.1";
    detailFreq = "0.5";
    radius = "0.300000012";
};

datablock TSForestItemData(vine_bush_wide)
{
    internalName = "vine_bush_wide";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_bush_wide.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.01";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.5";
   mass = "2";
};

datablock TSForestItemData(vine_bush_large)
{
    internalName = "vine_bush_large";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_bush_large.dae";
    tightnessCoefficient = "4";
    windScale = "0.100000001";
    trunkBendScale = "0.0500000007";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
   radius = "0.300000012";
   rigidity = "10";
   mass = "1";
};

datablock TSForestItemData(vine_ground_large)
{
    internalName = "vine_ground_large";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_ground_large.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
   radius = "0.5";
   mass = "2";
   dampingCoefficient = "0.600000024";
};

datablock TSForestItemData(vine_ground_large)
{
    internalName = "vine_ground_large";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_ground_large.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.5";
    trunkBendScale = "0.1";
};

datablock TSForestItemData(vine_wall_wide_b)
{
    internalName = "vine_wall_wide_b";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_wall_wide_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_wall_small)
{
    internalName = "vine_wall_small";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_wall_small.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.4";
};

datablock TSForestItemData(vine_wall_medium)
{
    internalName = "vine_wall_medium";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_wall_medium.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
   radius = "0.300000012";
};

datablock TSForestItemData(vine_wall_large)
{
    internalName = "vine_wall_large";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_wall_large.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.2";
    trunkBendScale = "0";
};

datablock TSForestItemData(vine_ground_small)
{
    internalName = "vine_ground_small";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_ground_small.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
    radius = "0.200000003";
};

datablock TSForestItemData(vine_bush_small)
{
    internalName = "vine_bush_small";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_bush_small.dae";
    radius = "0.5";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_bush_wide_b)
{
    internalName = "vine_bush_wide_b";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_bush_wide_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.00999999978";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
   radius = "0.5";
   mass = "1";
};

datablock TSForestItemData(vine_roof_wide)
{
    internalName = "vine_roof_wide";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_roof_wide.dae";
    tightnessCoefficient = "4";
    windScale = "0.3";
    trunkBendScale = "0";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_roof_small)
{
    internalName = "vine_roof_small";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_roof_small.dae";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0.6";
    tightnessCoefficient = "4";
};

datablock TSForestItemData(vine_roof_end)
{
    internalName = "vine_roof_end";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_roof_end.dae";
    windScale = "0.4";
    trunkBendScale = "0.02";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_2m)
{
    internalName = "vine_side_2m";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_side_2m.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_4m)
{
    internalName = "vine_side_4m";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_side_4m.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_8m)
{
    internalName = "vine_side_8m";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_side_8m.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};









datablock TSForestItemData(tree_oak_sml_b)
{
    internalName = "tree_oak_sml_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_sml_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.300000012";
    detailAmp = "0.300000012";
    detailFreq = "5";
   mass = "20";
   rigidity = "30";
   trunkBendScale = "0.0700000003";
};

datablock TSForestItemData(tree_oak_sml_b)
{
    internalName = "tree_oak_sml_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_sml_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.300000012";
    detailAmp = "0.400000006";
    detailFreq = "5";
   mass = "20";
   rigidity = "30";
};

datablock TSForestItemData(vine_wall_wide_a)
{
    internalName = "vine_wall_wide_a";
    shapeFile = "levels/industrial/art/shapes/trees/vines/vine_wall_wide_a.dae";
    radius = "0.5";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(lush_ferns_01)
{
    internalName = "lush_ferns_01";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_ferns_01_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.1";
    detailAmp = "0.04";
    detailFreq = "1";
    radius = "0.3";
};

datablock TSForestItemData(lush_ferns_02_a)
{
    internalName = "lush_ferns_02_a";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_ferns_02_b.dae";
    radius = "0.2";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.1";
    detailAmp = "0.4";
    detailFreq = "0.5";
};

datablock TSForestItemData(lush_big_a)
{
    internalName = "lush_big_a";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_big_a.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.1";
    detailAmp = "0.1";
    detailFreq = "0.5";
    radius = "0.2";
};

datablock TSForestItemData(lush_big_b)
{
    internalName = "lush_big_b";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_big_b.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.1";
    detailFreq = "0.5";
    radius = "0.2";
};

datablock TSForestItemData(lush_general_01_b)
{
    internalName = "lush_general_01_b";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_general_01_b.dae";
    radius = "0.2";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.05";
    detailAmp = "0.1";
    detailFreq = "0.2";
};

datablock TSForestItemData(lush_general_01_c)
{
    internalName = "lush_general_01_c";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_general_01_c.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.05";
    detailAmp = "0.2";
    detailFreq = "0.2";
    radius = "0.2";
};

datablock TSForestItemData(lush_general_01_d)
{
    internalName = "lush_general_01_d";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_general_01_d.dae";
    radius = "0.2";
    tightnessCoefficient = "4";
    windScale = "0.4";
    branchAmp = "0.05";
    detailAmp = "0.2";
    detailFreq = "0.2";
};

datablock TSForestItemData(lush_general_01_e)
{
    internalName = "lush_general_01_e";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_general_01_e.dae";
    tightnessCoefficient = "4";
    windScale = "0.4";
    detailAmp = "0.5";
    detailFreq = "0.5";
    radius = "0.2";
};

datablock TSForestItemData(lush_general_01_a)
{
    internalName = "lush_general_01_a";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_general_01_a.dae";
    windScale = "0.4";
    branchAmp = "0.02";
    detailAmp = "0.1";
    detailFreq = "0.2";
    radius = "0.2";
    tightnessCoefficient = "4";
};

datablock TSForestItemData(lush_ferns_01_a)
{
    internalName = "lush_ferns_01_a";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_ferns_01_a.dae";
    radius = "0.4";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.05";
    detailAmp = "0.3";
    detailFreq = "0.3";
};

datablock TSForestItemData(lush_ferns_01_b)
{
    internalName = "lush_ferns_01_b";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_ferns_01_b.dae";
    radius = "0.2";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.05";
    detailAmp = "0.3";
    detailFreq = "0.3";
};

datablock TSForestItemData(lush_ferns_02_b)
{
    internalName = "lush_ferns_02_b";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_ferns_02_b.dae";
    radius = "0.4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.05";
    detailAmp = "0.3";
    detailFreq = "0.3";
};

datablock TSForestItemData(lush_grass_01_a)
{
    internalName = "lush_grass_01_a";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_grass_01_a.dae";
    radius = "0.2";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.05";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(lush_grass_01_c)
{
    internalName = "lush_grass_01_c";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_grass_01_c.dae";
    radius = "0.2";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.05";
    detailAmp = "0.1";
    detailFreq = "0.6";
};

datablock TSForestItemData(lush_grass_01_b)
{
    internalName = "lush_grass_01_b";
    shapeFile = "levels/industrial/art/shapes/groundcover/lush_grass_01_b.dae";
    radius = "0.15";
    tightnessCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.1";
    branchAmp = "0.05";
    detailAmp = "0.1";
    detailFreq = "0.6";
};






datablock TSForestItemData(tree_beech_small_forest_group)
{
   internalName = "tree_beech_small_forest_group";
   shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_small_forest_group.dae";
   radius = "0.5";
   dampingCoefficient = "0.200000003";
    windScale = "0.400000006";
    trunkBendScale = "0.04";
    branchAmp = "0";
    detailAmp = "0.100000001";
    detailFreq = "4";
   mass = "40";
   rigidity = "25";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_large_c)
{
    internalName = "tree_beech_large_c";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_large_c.dae";
    radius = "0.5";
    dampingCoefficient = "0.200000003";
    windScale = "0.400000006";
    trunkBendScale = "0.04";
    branchAmp = "0.0700000003";
    detailAmp = "0.100000001";
    detailFreq = "4";
   mass = "40";
   rigidity = "25";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_overhang_a)
{
    internalName = "tree_beech_overhang_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_overhang_a.dae";
    radius = "0.5";
    dampingCoefficient = "0.300000012";
    windScale = "0.400000006";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "30";
   rigidity = "20";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_small_d)
{
    internalName = "tree_beech_small_d";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_small_d.dae";
    dampingCoefficient = "0.300000012";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.200000003";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "20";
   rigidity = "15";
   tightnessCoefficient = "2";
};

datablock TSForestItemData(tree_beech_small_c)
{
    internalName = "tree_beech_small_c";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_small_c.dae";
    dampingCoefficient = "0.400000006";
    windScale = "0.4";
    trunkBendScale = "0.0599999987";
    branchAmp = "0.0700000003";
    detailAmp = "0.300000012";
    detailFreq = "4";
   mass = "7";
   rigidity = "7";
   tightnessCoefficient = "2";
};

datablock TSForestItemData(tree_beech_small_b)
{
    internalName = "tree_beech_small_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_small_b.dae";
    dampingCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "10";
   rigidity = "15";
   tightnessCoefficient = "2";
};

datablock TSForestItemData(tree_beech_forest_a)
{
    internalName = "tree_beech_forest_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_forest_a.dae";
    dampingCoefficient = "0.400000006";
    windScale = "0.4";
    trunkBendScale = "0.05";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "20";
   rigidity = "30";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_forest_b)
{
    internalName = "tree_beech_forest_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_forest_b.dae";
    dampingCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0399999991";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "40";
   rigidity = "18";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_forest_group)
{
    internalName = "tree_beech_forest_group";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_forest_group.dae";
    dampingCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "4";
};

datablock TSForestItemData(tree_beech_large_b)
{
    internalName = "tree_beech_large_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_large_b.dae";
    dampingCoefficient = "0.100000001";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.100000001";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "80";
   rigidity = "70";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_bush_c)
{
    internalName = "tree_beech_bush_c";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_bush_c.dae";
    dampingCoefficient = "0.5";
    windScale = "0.4";
    trunkBendScale = "0.05";
    branchAmp = "0.0700000003";
    detailAmp = "0.200000003";
    detailFreq = "4";
    radius = "0.5";
   mass = "3";
   rigidity = "12";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_bush_a)
{
    internalName = "tree_beech_bush_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_bush_a.dae";
    radius = "0.5";
    dampingCoefficient = "0.400000006";
    windScale = "0.4";
    trunkBendScale = "0.05";
    branchAmp = "0.0199999996";
    detailAmp = "0.3";
    detailFreq = "4";
   mass = "1";
   rigidity = "11";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_bush_b)
{
    internalName = "tree_beech_bush_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_bush_b.dae";
    radius = "0.5";
    dampingCoefficient = "0.400000006";
    windScale = "0.4";
    trunkBendScale = "0.100000001";
    branchAmp = "0.0799999982";
    detailAmp = "0.3";
    detailFreq = "4";
   mass = "2";
   rigidity = "6";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tree_beech_blocker_a)
{
    internalName = "tree_beech_blocker_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_blocker_a.dae";
    radius = "0.8";
    dampingCoefficient = "4";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.0500000007";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "4";
   tightnessCoefficient = "2";
};

datablock TSForestItemData(tree_beech_dead_a)
{
    internalName = "tree_beech_dead_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_dead_a.dae";
    radius = "0.5";
};

datablock TSForestItemData(tree_beech_dead_b)
{
    internalName = "tree_beech_dead_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_dead_b.dae";
    radius = "0.5";
};

datablock TSForestItemData(tree_beech_bush_d)
{
    internalName = "tree_beech_bush_d";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_bush_d.dae";
    radius = "0.699999988";
    windScale = "0.4";
    trunkBendScale = "0.0500000007";
    branchAmp = "0.0700000003";
    detailAmp = "0.200000003";
    detailFreq = "4";
   mass = "2";
   rigidity = "8";
   tightnessCoefficient = "3";
   dampingCoefficient = "0.400000006";
};

datablock TSForestItemData(tree_beech_bush_e)
{
    internalName = "tree_beech_bush_e";
    shapeFile = "levels/industrial/art/shapes/trees/trees_beech/tree_beech_bush_e.dae";
    radius = "1";
    windScale = "0.4";
    trunkBendScale = "0.0700000003";
    branchAmp = "0.0700000003";
    detailAmp = "0.300000012";
    detailFreq = "4";
   mass = "2";
   rigidity = "7";
   tightnessCoefficient = "3";
   dampingCoefficient = "0.300000012";
};








datablock TSForestItemData(rock_01_a_large_b)
{
    internalName = "rock_01_a_large_b";
    shapeFile = "levels/industrial/art/shapes/rocks/rock_01_a_large_b.dae";
    radius = "0.3";
};

datablock TSForestItemData(rock_01_a_large_c)
{
    internalName = "rock_01_a_large_c";
    shapeFile = "levels/industrial/art/shapes/rocks/rock_01_a_large_c.dae";
    radius = "0.3";
};

datablock TSForestItemData(rock_01_a_small_a)
{
    internalName = "rock_01_a_small_a";
    shapeFile = "levels/industrial/art/shapes/rocks/rock_01_a_small_a.dae";
    radius = "0.15";
};

datablock TSForestItemData(rock_01_a_small_b)
{
    internalName = "rock_01_a_small_b";
    shapeFile = "levels/industrial/art/shapes/rocks/rock_01_a_small_b.dae";
    radius = "0.15";
};

datablock TSForestItemData(rock_01_a_small_c)
{
    internalName = "rock_01_a_small_c";
    shapeFile = "levels/industrial/art/shapes/rocks/rock_01_a_small_c.dae";
    radius = "0.15";
};

datablock TSForestItemData(rock_01_a_large_a)
{
    internalName = "rock_01_a_large_a";
    shapeFile = "levels/industrial/art/shapes/rocks/rock_01_a_large_a.dae";
    radius = "0.3";
};








datablock TSForestItemData(tree_palm_a)
{
    internalName = "tree_palm_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_palm/tree_palm_a.dae";
    radius = "0.5";
    windScale = "0.5";
    branchAmp = "0.1";
    detailAmp = "1.5";
    detailFreq = "0.2";
    trunkBendScale = "0.05";
    rigidity = "10";
};

datablock TSForestItemData(tree_palm_b)
{
    internalName = "tree_palm_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_palm/tree_palm_b.dae";
    radius = "0.5";
    windScale = "0.5";
    branchAmp = "0.1";
    detailAmp = "1.5";
    detailFreq = "0.2";
    trunkBendScale = "0.05";
};

datablock TSForestItemData(tree_palm_c)
{
    internalName = "tree_palm_c";
    shapeFile = "levels/industrial/art/shapes/trees/trees_palm/tree_palm_c.dae";
    radius = "0.5";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "1.5";
    detailFreq = "0.2";
};

datablock TSForestItemData(tree_palm_overhang_b)
{
    internalName = "tree_palm_overhang_b";
    shapeFile = "levels/industrial/art/shapes/trees/trees_palm/tree_palm_overhang_b.dae";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "1.5";
    detailFreq = "0.2";
};

datablock TSForestItemData(tree_palm_overhang_a)
{
    internalName = "tree_palm_overhang_a";
    shapeFile = "levels/industrial/art/shapes/trees/trees_palm/tree_palm_overhang_a.dae";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "1.5";
    detailFreq = "0.2";
};

datablock TSForestItemData(tree_palm_g)
{
    internalName = "tree_palm_g";
    shapeFile = "levels/industrial/art/shapes/trees/trees_palm/tree_palm_g.dae";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "1.5";
    detailFreq = "0.2";
    radius = "0.3";
};

datablock TSForestItemData(tree_palm_e)
{
    internalName = "tree_palm_e";
    shapeFile = "levels/industrial/art/shapes/trees/trees_palm/tree_palm_e.dae";
    radius = "0.5";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "1.5";
    detailFreq = "0.2";
};

datablock TSForestItemData(tree_palm_f)
{
    internalName = "tree_palm_f";
    shapeFile = "levels/industrial/art/shapes/trees/trees_palm/tree_palm_f.dae";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "1.5";
    detailFreq = "0.2";
    radius = "0.3";
};

datablock TSForestItemData(tree_palm_d)
{
    internalName = "tree_palm_d";
    shapeFile = "levels/industrial/art/shapes/trees/trees_palm/tree_palm_d.dae";
    radius = "0.5";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "1.5";
    detailFreq = "0.2";
};

datablock TSForestItemData(ind_rubbish_01_a)
{
    internalName = "ind_rubbish_01_a";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_rubbish_01_a.dae";
    radius = "0.1";
};

datablock TSForestItemData(coastrock_dark_b)
{
    internalName = "coastrock_dark_b";
    shapeFile = "levels/industrial/art/shapes/rocks/coastrock_dark_b.dae";
};

datablock TSForestItemData(coastrock_dark_c)
{
    internalName = "coastrock_dark_c";
    shapeFile = "levels/industrial/art/shapes/rocks/coastrock_dark_c.dae";
};

datablock TSForestItemData(coastrock_dark_d)
{
    internalName = "coastrock_dark_d";
    shapeFile = "levels/industrial/art/shapes/rocks/coastrock_dark_d.dae";
};

datablock TSForestItemData(coastrock_dark_a)
{
    internalName = "coastrock_dark_a";
    shapeFile = "levels/industrial/art/shapes/rocks/coastrock_dark_a.dae";
};

datablock TSForestItemData(DRI_rock_b)
{
    internalName = "DRI_rock_b";
    shapeFile = "levels/industrial/art/shapes/rocks/DRI_rock_b.dae";
};

datablock TSForestItemData(DRI_rock_a)
{
    internalName = "DRI_rock_a";
    shapeFile = "levels/industrial/art/shapes/rocks/DRI_rock_a.dae";
};

datablock TSForestItemData(DRI_rock_c)
{
    internalName = "DRI_rock_c";
    shapeFile = "levels/industrial/art/shapes/rocks/DRI_rock_c.dae";
};

datablock TSForestItemData(DRI_rock_d)
{
    internalName = "DRI_rock_d";
    shapeFile = "levels/industrial/art/shapes/rocks/DRI_rock_d.dae";
};

datablock TSForestItemData(DRI_rock_e)
{
    internalName = "DRI_rock_e";
    shapeFile = "levels/industrial/art/shapes/rocks/DRI_rock_e.dae";
};

datablock TSForestItemData(DRI_rock_g)
{
    internalName = "DRI_rock_g";
    shapeFile = "levels/industrial/art/shapes/rocks/DRI_rock_g.dae";
    radius = "0.5";
};

datablock TSForestItemData(DRI_rock_f)
{
    internalName = "DRI_rock_f";
    shapeFile = "levels/industrial/art/shapes/rocks/DRI_rock_f.dae";
    radius = "0.5";
};











datablock TSForestItemData(tree_oak_dead_b)
{
   internalName = "tree_oak_dead_b";
   shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_dead_b.dae";
   mass = "15";
   rigidity = "35";
   tightnessCoefficient = "4";
   windScale = "0.400000006";
   trunkBendScale = "0.0299999993";
   branchAmp = "0.200000003";
   detailAmp = "0.200000003";
   detailFreq = "4";
};



datablock TSForestItemData(tree_oak_forest_a)
{
   internalName = "tree_oak_forest_a";
   shapeFile = "levels/industrial/art/shapes/trees/trees_oak/tree_oak_forest_a.dae";
   mass = "100";
   rigidity = "55";
   windScale = "0.400000006";
   trunkBendScale = "0.0399999991";
   branchAmp = "0.400000006";
   detailAmp = "0.400000006";
   detailFreq = "4";
   radius = "1";
};

datablock TSForestItemData(tree_aspen_wall)
{
   internalName = "tree_aspen_wall";
   shapeFile = "levels/industrial/art/shapes/trees/trees_aspen/tree_aspen_wall.dae";
   rigidity = "20";
   windScale = "0.400000006";
   trunkBendScale = "0.00999999978";
   branchAmp = "0.0500000007";
   detailAmp = "0.100000001";
   detailFreq = "5";
   mass = "20";
};

datablock TSForestItemData(oak_beech_wallblocker_long)
{
   internalName = "oak_beech_wallblocker_long";
   shapeFile = "levels/industrial/art/shapes/trees/oak_beech_wallblocker_long.dae";
   mass = "3";
   rigidity = "7";
   tightnessCoefficient = "4";
   dampingCoefficient = "0.400000006";
   windScale = "0.400000006";
   detailAmp = "0.200000003";
   detailFreq = "4";
};

datablock TSForestItemData(container_01_a)
{
    internalName = "container_01_a";
    shapeFile = "levels/industrial/art/shapes/misc/container_01_a.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(container_01_b)
{
    internalName = "container_01_b";
    shapeFile = "levels/industrial/art/shapes/misc/container_01_b.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_01_a)
{
    internalName = "ind_obj_01_a";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_01_a.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_01_b)
{
    internalName = "ind_obj_01_b";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_01_b.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_01_c)
{
    internalName = "ind_obj_01_c";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_01_c.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_02_a)
{
    internalName = "ind_obj_02_a";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_02_a.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_02_b)
{
    internalName = "ind_obj_02_b";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_02_b.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_02_c)
{
    internalName = "ind_obj_02_c";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_02_c.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_03_a)
{
    internalName = "ind_obj_03_a";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_03_a.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_03_b)
{
    internalName = "ind_obj_03_b";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_03_b.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_04_a)
{
    internalName = "ind_obj_04_a";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_04_a.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_obj_04_b)
{
    internalName = "ind_obj_04_b";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_obj_04_b.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_rubbish_01_a)
{
    internalName = "ind_rubbish_01_a";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_rubbish_01_a.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_rubbish_01_b)
{
    internalName = "ind_rubbish_01_b";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_rubbish_01_b.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_rubbish_01_c)
{
    internalName = "ind_rubbish_01_c";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_rubbish_01_c.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_rubbish_01_d)
{
    internalName = "ind_rubbish_01_d";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_rubbish_01_d.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};

datablock TSForestItemData(ind_rubbish_01_e)
{
    internalName = "ind_rubbish_01_e";
    shapeFile = "levels/industrial/art/shapes/buildings/ind_rubbish_01_e.dae";
    radius = ".8";
    dampingCoefficient = "0";
    windScale = "0";
    trunkBendScale = "0";
    branchAmp = "0";
    detailAmp = "0";
    detailFreq = "0";
};




datablock TSForestItemData(tall_plant)
{
   internalName = "tall_plant";
   shapeFile = "levels/industrial/art/shapes/trees/trees_italy/tall_plant.dae";
    dampingCoefficient = "0.1";
    windScale = "0.4";
    trunkBendScale = "0.3";
    branchAmp = "0.02";
    detailAmp = "0.1";
    detailFreq = "4";
    radius = "0.5";
   mass = "1";
   rigidity = "2";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(tall_plant_bush)
{
    internalName = "tall_plant_bush";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/tall_plant_bush.dae";
    dampingCoefficient = "0.1";
    windScale = "0.4";
    trunkBendScale = "0.05";
    branchAmp = "0.02";
    detailAmp = "0.1";
    detailFreq = "4";
    radius = "0.5";
   mass = "8";
   rigidity = "20";
   tightnessCoefficient = "4";
};















datablock TSForestItemData(scots_pine_filler)
{
    internalName = "scots_pine_filler";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/scots_pine_filler.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
   radius = "0.7";
};

datablock TSForestItemData(scraggly_tree_filler_1)
{
    internalName = "scraggly_tree_filler_1";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/scraggly_tree_filler_1.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
   radius = "0.7";
};

datablock TSForestItemData(holm_oak_city_small)
{
    internalName = "holm_oak_city_small";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/holm_oak_city_small.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
   radius = "0.7";
};

datablock TSForestItemData(holm_oak_filler_1)
{
    internalName = "holm_oak_filler_1";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/holm_oak_filler_1.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
   radius = "0.7";
};

datablock TSForestItemData(holm_oak_filler_2)
{
    internalName = "holm_oak_filler_2";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/holm_oak_filler_2.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
   radius = "0.7";
};

datablock TSForestItemData(holm_oak_filler_center)
{
    internalName = "holm_oak_filler_center";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/holm_oak_filler_center.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
   radius = "2.5";
};

datablock TSForestItemData(cypress_tree)
{
    internalName = "cypress_tree";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/cypress_tree.dae";
    tightnessCoefficient = "1";
    windScale = "0.3";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.08";
    detailFreq = "1.5";
    rigidity = "10.2";
   mass = "10";
   radius = "0.8";
};

datablock TSForestItemData(cypress_hedge_3m)
{
    internalName = "cypress_hedge_3m";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/cypress_hedge_3m.dae";
    tightnessCoefficient = "1";
    windScale = "0.200000003";
    trunkBendScale = "0.05";
    branchAmp = "0.0199999996";
    detailAmp = "0.0700000003";
    detailFreq = "1.5";
    rigidity = "10.2";
   mass = "10";
   radius = "0.8";
   dampingCoefficient = "1";
};

datablock TSForestItemData(holm_oak_test)
{
    internalName = "holm_oak_test";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/holm_oak.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.00999999978";
    branchAmp = "0.150000006";
    detailAmp = "0.2";
    detailFreq = "4";
    rigidity = "70";
   mass = "90";
   dampingCoefficient = "0.150000006";
};

datablock TSForestItemData(holm_oak_bush)
{
    internalName = "holm_oak_bush";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/holm_oak_bush.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.3";
    detailFreq = "1.5";
    rigidity = "38";
   dampingCoefficient = "3";
   radius = "0.5";
   mass = "3.5";
};

datablock TSForestItemData(holm_oak_bush_huge)
{
    internalName = "holm_oak_bush_huge";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/holm_oak_bush_huge.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.3";
    detailFreq = "1.5";
    rigidity = "44";
   dampingCoefficient = "3";
   radius = "0.5";
   mass = "4";
};

datablock TSForestItemData(cork_oak_large_1)
{
    internalName = "cork_oak_large_1";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/cork_oak_large_1.dae";
    tightnessCoefficient = "4";
    windScale = "0.400000006";
    trunkBendScale = "0.0149999997";
    branchAmp = "0.150000006";
    detailAmp = "0.2";
    detailFreq = "4";
    rigidity = "80";
   mass = "100";
   dampingCoefficient = "0.150000006";
};

datablock TSForestItemData(cork_oak_medium)
{
    internalName = "cork_oak_medium";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/cork_oak_medium.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
};

datablock TSForestItemData(cork_oak_filler_large)
{
    internalName = "cork_oak_filler_large";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/cork_oak_filler_large.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
};

datablock TSForestItemData(cork_oak_filler_small)
{
    internalName = "cork_oak_filler_small";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/cork_oak_filler_small.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
};

datablock TSForestItemData(cork_oak_filler_center)
{
    internalName = "cork_oak_filler_center";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/cork_oak_filler_center.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.2";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
   radius = "2.5";
};

datablock TSForestItemData(cork_oak_bush_large)
{
    internalName = "cork_oak_bush_large";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/cork_oak_bush_large.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "20";
   dampingCoefficient = "3";
   radius = "0.5";
   mass = "4";
};

datablock TSForestItemData(cork_oak_bush_medium)
{
    internalName = "cork_oak_bush_medium";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/cork_oak_bush_medium.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "20";
   dampingCoefficient = "3";
   radius = "0.5";
   mass = "3";
};

datablock TSForestItemData(maritime_pine_tree)
{
    internalName = "maritime_pine_tree";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/maritime_pine.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.07";
    branchAmp = "0.1";
    detailAmp = "0.12";
    detailFreq = "1.5";
    rigidity = "10";
   mass = "10";
   dampingCoefficient = "3";
};

datablock TSForestItemData(maritime_pine_2)
{
    internalName = "maritime_pine_2";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/maritime_pine_2.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.07";
    branchAmp = "0.1";
    detailAmp = "0.12";
    detailFreq = "1.5";
    rigidity = "10";
   mass = "10";
   dampingCoefficient = "3";
};

datablock TSForestItemData(maritime_pine_bush)
{
    internalName = "maritime_pine_bush";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/maritime_pine_bush.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.07";
    branchAmp = "0.1";
    detailAmp = "0.12";
    detailFreq = "1.5";
    rigidity = "10";
   mass = "10";
   dampingCoefficient = "3";
};

datablock TSForestItemData(scots_pine_tree)
{
    internalName = "scots_pine_tree";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/scots_pine.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.07";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "10";
   mass = "10";
   dampingCoefficient = "3";
   radius = "2";
};

datablock TSForestItemData(scraggly_tree)
{
    internalName = "scraggly_tree";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/scraggly.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.1";
    rigidity = "10";
   dampingCoefficient = "3";
};

datablock TSForestItemData(scraggly_tree_2)
{
    internalName = "scraggly_tree_2";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/scraggly_2.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.1";
    rigidity = "10";
   dampingCoefficient = "3";
};

datablock TSForestItemData(scraggly_bush)
{
    internalName = "scraggly_bush";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/scraggly_bush.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "50";
    detailFreq = "0.03";
    rigidity = "10";
   dampingCoefficient = "3";
};

datablock TSForestItemData(olive_tree)
{
    internalName = "olive_tree";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/olive.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.1";
    rigidity = "10";
   dampingCoefficient = "3";
};

datablock TSForestItemData(grape_vine)
{
    internalName = "grape_vine";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/grape_vine.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.07";
    rigidity = "10";
   dampingCoefficient = "3";
};

datablock TSForestItemData(grape_vine_group)
{
    internalName = "grape_vine_group";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/grape_vine_group.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.07";
    rigidity = "10";
   dampingCoefficient = "3";
};

datablock TSForestItemData(fluffy_bush)
{
    internalName = "fluffy_bush";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/fluffy_bush.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.";
    rigidity = "15";
   dampingCoefficient = "3";
   radius = "0.5";
   mass = "1";
};







datablock TSForestItemData(generibush)
{
    internalName = "generibush";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/generibush.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.07";
    rigidity = "10";
   dampingCoefficient = "3";
   radius = "1";
   translucentBlendOp = "LerpAlpha";
   planarReflection = "0";
   dynamicCubemap = "0";
};

datablock TSForestItemData(generibush_small)
{
    internalName = "generibush_small";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/generibush_small.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.07";
    rigidity = "10";
   dampingCoefficient = "3";
   radius = "1";
   translucentBlendOp = "LerpAlpha";
   planarReflection = "0";
   dynamicCubemap = "0";
};

datablock TSForestItemData(generibush_tiny)
{
    internalName = "generibush_tiny";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/generibush_tiny.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.05";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.07";
    rigidity = "10";
   dampingCoefficient = "3";
   radius = "1";
   translucentBlendOp = "LerpAlpha";
   planarReflection = "0";
   dynamicCubemap = "0";
};

datablock TSForestItemData(generibush_cracks)
{
   internalName = "generibush_cracks";
   shapeFile = "levels/industrial/art/shapes/trees/trees_italy/generibush_cracks.dae";
};










datablock TSForestItemData(italy_palm_1)
{
    internalName = "italy_palm_1";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/italy_palm_1.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.03";
    branchAmp = "0.1";
    detailAmp = "0.3";
    detailFreq = "0.5";
    rigidity = "20";
   dampingCoefficient = "3";
   radius = "1";
   translucentBlendOp = "LerpAlpha";
   planarReflection = "0";
   dynamicCubemap = "0";
};

datablock TSForestItemData(italy_palm_1_short)
{
    internalName = "italy_palm_1_short";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/italy_palm_1_short.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.03";
    branchAmp = "0.1";
    detailAmp = "0.3";
    detailFreq = "0.5";
    rigidity = "20";
   dampingCoefficient = "3";
   radius = "1";
   translucentBlendOp = "LerpAlpha";
   planarReflection = "0";
   dynamicCubemap = "0";
};

datablock TSForestItemData(forest_mix)
{
    internalName = "forest_mix";
    shapeFile = "levels/industrial/art/shapes/trees/trees_italy/forest_mix.dae";
    tightnessCoefficient = "1";
    windScale = "0.3";
    trunkBendScale = "0.08";
    branchAmp = "0.1";
    detailAmp = "5";
    detailFreq = "0.04";
    rigidity = "10";
   dampingCoefficient = "3";
   radius = "4";
   translucentBlendOp = "LerpAlpha";
   planarReflection = "0";
   dynamicCubemap = "0";
};

datablock TSForestItemData(vine_fall_large)
{
   internalName = "vine_fall_large";
   shapeFile = "levels/industrial/art/shapes/trees/vines/vine_fall_large.dae";
   tightnessCoefficient = "4";
   windScale = "0.300000012";
   trunkBendScale = "0.0500000007";
   branchAmp = "0";
   detailAmp = "0.100000001";
   detailFreq = "3";
   radius = "0.400000006";
   rigidity = "2";
   dampingCoefficient = "0";
};

datablock TSForestItemData(vine_fall_medium)
{
   internalName = "vine_fall_medium";
   shapeFile = "levels/industrial/art/shapes/trees/vines/vine_fall_medium.dae";
   radius = "0.300000012";
   mass = "3";
   rigidity = "1";
   tightnessCoefficient = "4";
   dampingCoefficient = "0";
   windScale = "0.300000012";
   trunkBendScale = "0.0500000007";
   detailAmp = "0.100000001";
   detailFreq = "3";
};

datablock TSForestItemData(debris_a_a)
{
   internalName = "debris_a_a";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_a.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(debris_a_b)
{
   internalName = "debris_a_b";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_b.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(debris_a_brick_a)
{
   internalName = "debris_a_brick_a";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_brick_a.DAE";
   radius = "0.00999999978";
};

datablock TSForestItemData(debris_a_brick_b)
{
   internalName = "debris_a_brick_b";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_brick_b.DAE";
   radius = "0.00999999978";
};

datablock TSForestItemData(debris_a_brick_c)
{
   internalName = "debris_a_brick_c";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_brick_c.DAE";
   radius = "0.00999999978";
};

datablock TSForestItemData(debris_a_brick_d)
{
   internalName = "debris_a_brick_d";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_brick_d.DAE";
   radius = "0.00999999978";
};

datablock TSForestItemData(debris_a_brickwall)
{
   internalName = "debris_a_brickwall";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_brickwall.DAE";
   radius = "0.200000003";
};

datablock TSForestItemData(debris_a_c)
{
   internalName = "debris_a_c";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_c.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(debris_a_d)
{
   internalName = "debris_a_d";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_d.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(debris_a_e)
{
   internalName = "debris_a_e";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_e.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(debris_a_f)
{
   internalName = "debris_a_f";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_f.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(debris_a_s1)
{
   internalName = "debris_a_s1";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_s1.DAE";
   radius = "0.0500000007";
};

datablock TSForestItemData(debris_a_s2)
{
   internalName = "debris_a_s2";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_s2.DAE";
   radius = "0.0500000007";
};

datablock TSForestItemData(debris_a_s3)
{
   internalName = "debris_a_s3";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_s3.DAE";
   radius = "0.0500000007";
};

datablock TSForestItemData(debris_a_s4)
{
   internalName = "debris_a_s4";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_s4.DAE";
   radius = "0.0500000007";
};

datablock TSForestItemData(debris_a_s5)
{
   internalName = "debris_a_s5";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_s5.DAE";
   radius = "0.0500000007";
};

datablock TSForestItemData(debris_a_s6)
{
   internalName = "debris_a_s6";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_a_s6.DAE";
   radius = "0.0500000007";
};

datablock TSForestItemData(debris_b_a)
{
   internalName = "debris_b_a";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_b_a.DAE";
   radius = "0.5";
};

datablock TSForestItemData(debris_b_b)
{
   internalName = "debris_b_b";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_b_b.DAE";
   radius = "0.5";
};

datablock TSForestItemData(debris_b_bigbrick_a)
{
   internalName = "debris_b_bigbrick_a";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_b_bigbrick_a.DAE";
   radius = "0.0500000007";
};

datablock TSForestItemData(debris_b_bigbrick_b)
{
   internalName = "debris_b_bigbrick_b";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_b_bigbrick_b.DAE";
   radius = "0.0500000007";
};

datablock TSForestItemData(debris_b_col_big)
{
   internalName = "debris_b_col_big";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_b_col_big.DAE";
   radius = "0.5";
};

datablock TSForestItemData(debris_b_col_small)
{
   internalName = "debris_b_col_small";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_b_col_small.DAE";
   radius = "0.5";
};

datablock TSForestItemData(debris_m_barbent_a)
{
   internalName = "debris_m_barbent_a";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_m_barbent_a.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(debris_m_barbent_b)
{
   internalName = "debris_m_barbent_b";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_m_barbent_b.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(debris_m_barlong)
{
   internalName = "debris_m_barlong";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_m_barlong.DAE";
   radius = "0.5";
};

datablock TSForestItemData(debris_m_barrel_a)
{
   internalName = "debris_m_barrel_a";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_m_barrel_a.DAE";
   radius = "0.5";
};

datablock TSForestItemData(debris_m_barrel_b)
{
   internalName = "debris_m_barrel_b";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_m_barrel_b.DAE";
   radius = "0.5";
};

datablock TSForestItemData(debris_m_barshort)
{
   internalName = "debris_m_barshort";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_m_barshort.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(debris_m_can_a)
{
   internalName = "debris_m_can_a";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_m_can_a.DAE";
   radius = "0.200000003";
};

datablock TSForestItemData(debris_m_can_b)
{
   internalName = "debris_m_can_b";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_m_can_b.DAE";
   radius = "0.200000003";
};

datablock TSForestItemData(debris_m_pipe)
{
   internalName = "debris_m_pipe";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_m_pipe.DAE";
   radius = "0.400000006";
};

datablock TSForestItemData(debris_b_angle)
{
   internalName = "debris_b_angle";
   shapeFile = "levels/industrial/art/shapes/buildings/debris/debris_b_angle.DAE";
   radius = "0.300000012";
};

datablock TSForestItemData(concrete_bollard)
{
   internalName = "concrete_bollard";
   shapeFile = "levels/industrial/art/shapes/misc/concrete_bollard.dae";
   radius = "0.200000003";
};

datablock TSForestItemData(electric_pole_02)
{
   internalName = "electric_pole_02";
   shapeFile = "levels/industrial/art/shapes/buildings/power_lines/electric_pole_02.dae";
};

datablock TSForestItemData(electrical_support_01)
{
   internalName = "electrical_support_01";
   shapeFile = "levels/industrial/art/shapes/buildings/power_lines/electrical_support_01.dae";
};

datablock TSForestItemData(electrical_support_02)
{
   internalName = "electrical_support_02";
   shapeFile = "levels/industrial/art/shapes/buildings/power_lines/electrical_support_02.dae";
};

datablock TSForestItemData(metal_pole)
{
   internalName = "metal_pole";
   shapeFile = "levels/industrial/art/shapes/buildings/power_lines/metal_pole.dae";
};

datablock TSForestItemData(transformer_x2)
{
   internalName = "transformer_x2";
   shapeFile = "levels/industrial/art/shapes/buildings/power_lines/transformer_x2.dae";
};

datablock TSForestItemData(transformer_x4)
{
   internalName = "transformer_x4";
   shapeFile = "levels/industrial/art/shapes/buildings/power_lines/transformer_x4.dae";
};

datablock TSForestItemData(electric_pole_01)
{
   internalName = "electric_pole_01";
   shapeFile = "levels/industrial/art/shapes/buildings/power_lines/electric_pole_01.dae";
};

datablock TSForestItemData(excavator)
{
   internalName = "excavator";
   shapeFile = "levels/ogc_map/art/shapes/objects/excavator.dae";
};

datablock TSForestItemData(desert_rocks_large_02)
{
   internalName = "desert_rocks_large_02";
   shapeFile = "levels/johnson_valley/art/shapes/rocks/s_rocks_desert_large_02.dae";
};

datablock TSForestItemData(desert_rocks_large_03)
{
   internalName = "desert_rocks_large_03";
   shapeFile = "levels/johnson_valley/art/shapes/rocks/s_rocks_desert_large_03.dae";
};
  
datablock TSForestItemData(desert_rocks_large_04)
{
   internalName = "desert_rocks_large_04";
   shapeFile = "levels/johnson_valley/art/shapes/rocks/s_rocks_desert_large_04.dae";
};

datablock TSForestItemData(desert_rocks_large_05)
{
   internalName = "desert_rocks_large_05";
   shapeFile = "levels/johnson_valley/art/shapes/rocks/s_rocks_desert_large_05.dae";
};
  
datablock TSForestItemData(desert_rocks_large_06)
{
   internalName = "desert_rocks_large_06";
   shapeFile = "levels/johnson_valley/art/shapes/rocks/s_rocks_desert_large_06.dae";
};
  
datablock TSForestItemData(desert_rocks_large_07)
{
   internalName = "desert_rocks_large_07";
   shapeFile = "levels/johnson_valley/art/shapes/rocks/s_rocks_desert_large_07.dae";
};

datablock TSForestItemData(deserttree_dead)
{
   internalName = "deserttree_dead";
   shapeFile = "levels/johnson_valley/art/shapes/trees/deserttrees/deserttree_dead.dae";
   windScale = "0.5";
   branchAmp = "0.005";
   detailAmp = "0.02";
   detailFreq = "0.7";
};

datablock TSForestItemData(deserttree_bush_medium)
{
   internalName = "deserttree_bush_medium";
   shapeFile = "levels/johnson_valley/art/shapes/trees/deserttrees/deserttree_bush_medium.dae";
   windScale = "0.5";
   branchAmp = "0.005";
   detailAmp = "0.02";
   detailFreq = "0.7";
};
  
datablock TSForestItemData(deserttree_bush_tiny)
{
   internalName = "deserttree_bush_tiny";
   shapeFile = "levels/johnson_valley/art/shapes/trees/deserttrees/deserttree_bush_tiny.dae";
   windScale = "0.5";
   branchAmp = "0.005";
   detailAmp = "0.02";
   detailFreq = "0.7";
};

datablock TSForestItemData(deserttree_bush_medium_dead)
{
   internalName = "deserttree_bush_medium_dead";
   shapeFile = "levels/johnson_valley/art/shapes/trees/deserttrees/deserttree_bush_medium_dead.dae";
   windScale = "0.5";
   branchAmp = "0.005";
   detailAmp = "0.02";
   detailFreq = "0.7";
};  

datablock TSForestItemData(tree_douglasfir_bush_a)
{
   internalName = "tree_douglasfir_bush_a";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_bush_a.dae";
   windScale = "0.5";
   trunkBendScale = "0.1";
   branchAmp = "0.01";
   detailAmp = "0.2";
   detailFreq = "1.5";
   radius = "0.2";
   mass = "1";
   rigidity = "5";   
};  

datablock TSForestItemData(tree_douglasfir_bush_b)
{
   internalName = "tree_douglasfir_bush_b";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_bush_b.dae";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.01";
   detailAmp = "0.1";
   detailFreq = "3";
   radius = "0.2";
   mass = "1";
   rigidity = "5";   
}; 

datablock TSForestItemData(tree_douglasfir_chopped)
{
   internalName = "tree_douglasfir_chopped";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_chopped.dae";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   radius = "0.3";
   rigidity = "5";   
}; 

datablock TSForestItemData(tree_douglasfir_dead)
{
   internalName = "tree_douglasfir_dead";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_dead.dae";
   windScale = "0.3";
   branchAmp = "0.1";
   detailAmp = "0.3";
   detailFreq = "0.3";
   rigidity = "5";   
}; 

datablock TSForestItemData(tree_douglasfir_dead_02)
{
   internalName = "tree_douglasfir_dead_02";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_dead_02.dae";
   windScale = "0.4";
   branchAmp = "0.01";
   detailAmp = "0.2";
   detailFreq = "3";
   trunkBendScale = "0.04";
}; 

datablock TSForestItemData(tree_douglasfir_group)
{
   internalName = "tree_douglasfir_group";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_group.dae";
   windScale = "0.5";
   branchAmp = "0.02";
   detailAmp = "0.2";
   detailFreq = "5";
   rigidity = "5"; 
   trunkBendScale = "0.005";
}; 

datablock TSForestItemData(tree_douglasfir_group_low)
{
   internalName = "tree_douglasfir_group_low";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_group_low.dae";
   windScale = "0.4";
   branchAmp = "0.001";
   detailAmp = "0.02";
   detailFreq = "2";
   radius = "2";
}; 

datablock TSForestItemData(tree_douglasfir_large_a)
{
   internalName = "tree_douglasfir_large_a";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_large_a.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.02";
   detailAmp = "0.2";
   detailFreq = "5";
   mass = "70";
   rigidity = "150"; 
}; 

datablock TSForestItemData(tree_douglasfir_large_b)
{
   internalName = "tree_douglasfir_large_b";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_large_b.dae";
   windScale = "0.4";
   trunkBendScale = "0.04";
   branchAmp = "0.02";
   detailAmp = "0.2";
   detailFreq = "5";
   radius = "0.5";
   mass = "40";
   rigidity = "100"; 
}; 

datablock TSForestItemData(tree_douglasfir_large_c)
{
   internalName = "tree_douglasfir_large_c";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_large_c.dae";
   windScale = "0.4";
   trunkBendScale = "0.04";
   branchAmp = "0.06";
   detailAmp = "0.2";
   detailFreq = "5";
   radius = "0.5";
   mass = "55";
   rigidity = "130"; 
}; 

datablock TSForestItemData(tree_douglasfir_large_d)
{
   internalName = "tree_douglasfir_large_d";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_large_d.dae";
   windScale = "0.4";
   trunkBendScale = "0.04";
   branchAmp = "0.07";
   detailAmp = "0.2";
   detailFreq = "5";
   mass = "60";
   rigidity = "130"; 
}; 

datablock TSForestItemData(tree_douglasfir_small_a)
{
   internalName = "tree_douglasfir_small_a";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_small_a.dae";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.03";
   detailAmp = "0.2";
   detailFreq = "5";
   rigidity = "20"; 
}; 

datablock TSForestItemData(tree_douglasfir_small_b)
{
   internalName = "tree_douglasfir_small_b";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_small_b.dae";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.03";
   detailAmp = "0.2";
   detailFreq = "4";
   mass = "10";
   rigidity = "22"; 
}; 

datablock TSForestItemData(tree_douglasfir_small_c)
{
   internalName = "tree_douglasfir_small_c";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_small_c.dae";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.02";
   detailAmp = "0.15";
   detailFreq = "4";
   mass = "7";
   rigidity = "17"; 
}; 

datablock TSForestItemData(tree_douglasfir_small_d)
{
   internalName = "tree_douglasfir_small_d";
   shapeFile = "levels/driver_training/art/shapes/trees/trees_douglasfir/tree_douglasfir_small_d.dae";
   windScale = "0.4";
   trunkBendScale = "0.06";
   branchAmp = "0.02";
   detailAmp = "0.15";
   detailFreq = "4";
   mass = "1";
   rigidity = "6"; 
}; 