-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local running = true

local helper = require('scenario/scenariohelper')

local function reset()
    running = false
end

local function fail(reason)
    scenario_scenarios.finish({failed = reason})
    reset()
end

local function onRaceStart()
    reset()

    helper.setAiMode('aiCar1', 'manual')
    --helper.setAiAggression('aiCar1', 1.2)
    helper.setAiTarget('aiCar1', 'road1_1')
    helper.trackVehicle('aiCar1', 'aiCar')
    helper.trackVehicle('scenario_player0', 'playerCar')

    running = true
end

local function onRaceTick(raceTickTime)
    if not running then
        return
    end

    local aiCarData = map.objects[map.objectNames['aiCar']]
    local playerCarData = map.objects[map.objectNames['playerCar']]

    if not aiCarData or not playerCarData then
        return
    end

    if aiCarData.damage > 0 and speed == 0 then
        speed = playerCarData.vel:length()
    end

    if playerCarData.damage >= 5000 then
        fail("scenarios.gridmap.gm_corridor.fail.msg")
    end

end

M.onRaceStart = onRaceStart
M.onRaceTick = onRaceTick

return M