-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local running = true
local speed = 0

local helper = require('scenario/scenariohelper')

local function reset()
    running = false
end

local function fail(reason)
    scenario_scenarios.finish({failed = reason})
    reset()
end

local function success(speed)
    local result = {msg = {txt = "scenarios.gridmap.gm_intersection_1.win.msg", context = {speed = string.format("%0.2f", speed * 3.6)}}}
    scenario_scenarios.finish(result)
    reset()
end

local function onRaceStart()
    reset()

    helper.setAiMode('aiCar1', 'manual')
    helper.setAiTarget('aiCar1', 'road2_2')
    helper.trackVehicle('aiCar1', 'aiCar')
    helper.trackVehicle('scenario_player0', 'playerCar')

    running = true
end

local function onRaceTick(raceTickTime)
  local scenario = scenario_scenarios.getScenario()

  if not scenario or not running then
      return
  end

  local aiCarData = map.objects[map.objectNames['aiCar']]
  local playerCarData = map.objects[map.objectNames['playerCar']]

  if not aiCarData or not playerCarData then
      return
  end

  if aiCarData.damage > 0 and speed == 0 then
      speed = playerCarData.vel:length()
  end

  if aiCarData.damage >= 5000 and scenario.timer > 20 then
      success(speed)
  end

  if scenario.timer > 22 then
      fail("scenarios.gridmap.gm_intersection_1.fail.msg")
  end
end

M.onRaceStart = onRaceStart
M.onRaceTick = onRaceTick

return M