-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

-- cache frequently used functions/modules in upvalues for efficiency
local helper = require('scenario/scenariohelper')
local finish = scenario_scenarios.finish
local getScenario = scenario_scenarios.getScenario
local trackVehicleMovementAfterDamage = scenario_scenarios.trackVehicleMovementAfterDamage

local running = true
local speed = 0
local hitTime = nil

local function reset()
  running = false
end

local function fail(reason)
  finish({failed = reason})
  reset()
end

local function success(speed)
  finish({msg = {txt = 'scenarios.gridmap.gm_intersection_2.win.msg', context = {speed = string.format('%0.2f', speed*3.6)}}})
  reset()
end

local function onRaceStart()
  reset()

  local arg = {vehicleName = 'aiCar1', waypoints = {'road2_2'}, aggression = 1.8}
  helper.setAiPath(arg)

  helper.trackVehicle('aiCar1', 'aiCar')
  helper.trackVehicle('scenario_player0', 'playerCar')

  trackVehicleMovementAfterDamage('scenario_player0')

  running = true
end

local function onRaceTick(raceTickTime)
  local scenario = getScenario()

  if not scenario or not running then
    return
  end

  local aiCarData = map.objects[map.objectNames['aiCar']]
  local playerCarData = map.objects[map.objectNames['playerCar']]

  if not aiCarData or not playerCarData then
    return
  end

  if aiCarData.damage > 0 and speed == 0 then
    speed = playerCarData.vel:length()
  end

  if scenario.timer > 16 then
    if hitTime then
      success(speed)
    else
      fail('scenarios.gridmap.gm_intersection_2.fail.msg')
    end
  end
end

local function onObjectCollision(objA, objB)
  if not hitTime then
    hitTime = getScenario().timer
  end
end

M.onRaceStart = onRaceStart
M.onRaceTick = onRaceTick
M.onObjectCollision = onObjectCollision

return M
