local M = {}

local playerInstance = 'scenario_player0'
local playerParked = false

local function onRaceStart()

  playerParked = false
  scenario_scenarios.trackVehicleMovementAfterDamage(playerInstance)

end

local function onBeamNGTrigger(data)
  --dump(data)

  if data.subjectName == playerInstance then

    if data.triggerName == 'parkingzone' then -- registers when the player is in the parking spot

      if data.event == 'enter' then
        playerParked = true
      else -- if he exits the parking spot
        playerParked = false
      end

    elseif data.triggerName == 'failzone_curb' then -- ends the scenario if the player overshoots the parking spot

      scenario_scenarios.finish({failed = 'scenarios.gridmap.hard_parking.fail.distance.msg'})

    end
  end
end

local function onVehicleStoppedMoving(vehicleID) --ends the scenario when the player has stopped moving
  local playerVehicle = scenetree.findObject(playerInstance)

  if vehicleID == playerVehicle:getID() then

    if playerParked then
      scenario_scenarios.finish({msg = 'scenarios.gridmap.hard_parking.win.msg'})
    else
      scenario_scenarios.finish({failed = 'scenarios.gridmap.hard_parking.fail.distance.msg'})
    end
  end
end

M.onRaceStart = onRaceStart
M.onBeamNGTrigger = onBeamNGTrigger
M.onVehicleStoppedMoving = onVehicleStoppedMoving

return M