-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local luaLoaded = false

M.dependencies = {"ui_imgui"}
local im = ui_imgui
local imguiUtils = require('ui/imguiUtils')


local pos = im.ImVec2(0, 0)

--teleport
local otherLevelPath = "/levels/infra_c8_m6_business/info.json"
local otherLevelPath2 = "/levels/c8_m2_industrial/info.json"
local playerisintrigger = nil
local promptTitle = "Teleport"
local teleportTempFile = "/temp/infra_teleport.json"

-- TWEAKS
local partitionGridSpaceSize = 32.0

local partitionGrid2SpaceSize = 16.0

-- DATA, DON'T TOUCH
local partitionGridMin
local partitionGridMax
local partitionGridSpacesX
local partitionGridSpacesY
local totalPartitionGridSpaces
local partitionGrid = {}

-- DATA, DON'T TOUCH 2
local partitionGrid2Min
local partitionGrid2Max
local partitionGrid2SpacesX
local partitionGrid2SpacesY
local totalPartitionGrid2Spaces
local partitionGrid2 = {}

local lastValue = nil
local lastCameraCell = -1
local lastCameraCell2 = -1
local allLights = {}
local allProps = {}

local lightmgr

-- Keep track of the last set of lights we enabled so we don't have to loop over every light and disable it each time we change cells
local lastEnabledLightCount = 0
local lastEnabledLightIndices = {}

local lastEnabledPropCount = 0
local lastEnabledPropIndices = {}

local currentCube = nil
local cubemapProbes = {}

local function setCubemap(value)
  if value then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      --log("I", "setCubemap", "Enabling cubemap " ..value)
      levelinf:setField('globalEnviromentMap', 0, value)
      levelinf:postApply()
    else
      --log("W", "setCubemap", "Enabling fallback cubemap " ..value)
      setConsoleVariable("$defaultLevelEnviromentMap", value)
    end
  end
end

local function enableLights(xCell, zCell)
  -- disable previously enabled lights
  for i=1,lastEnabledLightCount,1 do
    local light = allLights[lastEnabledLightIndices[i]]
    light:setLightEnabled(false)
  end

  lastEnabledLightCount = 0
  for x=math.max(0, xCell - 1), math.min(partitionGridSpacesX - 1, xCell + 1),1 do
    for z=math.max(0, zCell - 1), math.min(partitionGridSpacesY - 1, zCell + 1),1 do
      for _,lightIndex in ipairs(partitionGrid[1 + (z * partitionGridSpacesX) + x]) do
        -- mark enabled
        lastEnabledLightCount = lastEnabledLightCount + 1
        lastEnabledLightIndices[lastEnabledLightCount] = lightIndex

        -- enable light
        local light = allLights[lightIndex]
        light:setLightEnabled(true)
      end
    end
  end
end

local function enableProps(xCell, zCell)
  for i=1,lastEnabledPropCount,1 do
    local prop = allProps[lastEnabledPropIndices[i]]
    be:getObjectByID(prop):setActive(0)
  end
  --print("Disabled "..tostring(lastEnabledPropCount).." physical props")

  lastEnabledPropCount = 0
  for x=math.max(0, xCell - 1), math.min(partitionGrid2SpacesX - 1, xCell + 1),1 do
    for z=math.max(0, zCell - 1), math.min(partitionGrid2SpacesY - 1, zCell + 1),1 do
      for _,propIndex in ipairs(partitionGrid2[1 + (z * partitionGrid2SpacesX) + x]) do
        -- mark enabled
        lastEnabledPropCount = lastEnabledPropCount + 1
        lastEnabledPropIndices[lastEnabledPropCount] = propIndex

        local prop = allProps[propIndex]
        be:getObjectByID(prop):setActive(1)
      end
    end
  end
  --print("Enabled "..tostring(lastEnabledPropCount).." physical props")
end

--get player vehicle
local function getCurrentVehicle()
  local result = nil
  if gameplay_walk and gameplay_walk.isWalking() then
    return result
  end

  -- get the current vehicle to load it in the garage
  local vehicle = be:getPlayerVehicle(0)
  local playerVehicleData = core_vehicle_manager.getPlayerVehicleData()
  if vehicle and playerVehicleData then
    local config = serialize(playerVehicleData.config) -- when using "vehicle.partConfig" here, the color of the vehicle will be wrong if you use a custom default config
    local model = vehicle.JBeam
    result = { model, {config=config} }
  end
  return result
end


local function getCellForPosition(p)
  local xCell = math.floor((p.x - partitionGridMin.x) / partitionGridSpaceSize)
  local yCell = math.floor((p.y - partitionGridMin.y) / partitionGridSpaceSize)
  return xCell, yCell
end

local function getCellIndexForPosition(p)
  local xCell, yCell = getCellForPosition(p)
  return (yCell * partitionGridSpacesX) + xCell
end

local function positionInRange(p)
  return p.x >= partitionGridMin.x and p.x <= partitionGridMax.x and p.y >= partitionGridMin.y and p.y <= partitionGridMax.y
end

--grid2
local function getCellForPosition2(p)
  local xCell = math.floor((p.x - partitionGrid2Min.x) / partitionGrid2SpaceSize)
  local yCell = math.floor((p.y - partitionGrid2Min.y) / partitionGrid2SpaceSize)
  return xCell, yCell
end

local function getCellIndexForPosition2(p)
  local xCell, yCell = getCellForPosition2(p)
  return (yCell * partitionGrid2SpacesX) + xCell
end

local function positionInRange2(p)
  return p.x >= partitionGrid2Min.x and p.x <= partitionGrid2Max.x and p.y >= partitionGrid2Min.y and p.y <= partitionGrid2Max.y
end

local function updatePropsData()
  partitionGrid2 = {}
    -- allocate table
  for i=1,512,1 do
    table.insert(lastEnabledPropIndices, 0)
  end

  -- compute grid2
  local minX = 99999.0
  local minY = 99999.0
  local maxX = -99999.0
  local maxY = -99999.0

  for i,v in ipairs(allProps) do
    local pos = be:getObjectByID(v):getPosition()
    minX = math.min(pos.x, minX)
    minY = math.min(pos.y, minY)

    maxX = math.max(pos.x, maxX)
    maxY = math.max(pos.y, maxY)
  end

  partitionGrid2Min = vec3(minX, minY, 0)
  partitionGrid2Max = vec3(maxX, maxY, 0)
  partitionGrid2SpacesX = math.ceil((partitionGrid2Max.x - partitionGrid2Min.x) / partitionGrid2SpaceSize)
  partitionGrid2SpacesY = math.ceil((partitionGrid2Max.y - partitionGrid2Min.y) / partitionGrid2SpaceSize)
  totalPartitionGrid2Spaces = (partitionGrid2SpacesX * partitionGrid2SpacesY)

  -- allocate tables
  for i=1,totalPartitionGrid2Spaces,1 do
    table.insert(partitionGrid2, {})
  end

  for i,v in ipairs(allProps) do
    local pos = be:getObjectByID(v):getPosition()
    table.insert(partitionGrid2[getCellIndexForPosition2(pos) + 1], i)
  end
end

local mirrorTarget

local function onClientStartMission()
  luaLoaded = true

  if FS:fileExists(teleportTempFile) then
    local teleportTempData = jsonReadFile(teleportTempFile)
    if teleportTempData then
      spawn.safeTeleport(be:getPlayerVehicle(0), teleportTempData.targetPos, quat(0,0,1,0) * teleportTempData.targetRot, nil, nil, nil, nil, false)
      core_camera.resetCamera(0)
    end
    FS:removeFile(teleportTempFile)
  end

  local probes = scenetree.cubemaps_data
  if probes then
    for i = 0, probes.obj:getCount(), 1 do
      local id = probes.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      if obj and obj:isSubClassOf("SceneObject") then
        cubemapProbes[obj:getName()] = obj:getPosition()
      end
    end
  end

  lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
  local allObjects = scenetree:getAllObjects()
  if allObjects then
    for k,v in pairs(allObjects) do
      local obj = scenetree.findObject(v)
      if obj and obj.obj:isSubClassOf('LightBase') then
        if obj:getField('castShadows', 0) == "1" then
          table.insert(allLights, obj.obj)
        end
      end
    end
  end

  if lightmgr ~= "Advanced Lighting 1.5" then
    setCubemap("cubemap_infra_c8_m4_isle2_reflection")
  end

  -- compute grid
  local minX = 99999.0
  local minY = 99999.0
  local maxX = -99999.0
  local maxY = -99999.0

  for i,v in ipairs(allLights) do
    local pos = v:getPosition()
    minX = math.min(pos.x, minX)
    minY = math.min(pos.y, minY)

    maxX = math.max(pos.x, maxX)
    maxY = math.max(pos.y, maxY)
  end

  partitionGridMin = vec3(minX, minY, 0)
  partitionGridMax = vec3(maxX, maxY, 0)
  partitionGridSpacesX = math.ceil((partitionGridMax.x - partitionGridMin.x) / partitionGridSpaceSize)
  partitionGridSpacesY = math.ceil((partitionGridMax.y - partitionGridMin.y) / partitionGridSpaceSize)
  totalPartitionGridSpaces = (partitionGridSpacesX * partitionGridSpacesY)

  -- allocate tables
  for i=1,totalPartitionGridSpaces,1 do
    table.insert(partitionGrid, {})
  end

  for i=1,512,1 do
    table.insert(lastEnabledLightIndices, 0)
  end

  -- place lights in cells
  for i,v in ipairs(allLights) do
    local pos = v:getPosition()
    table.insert(partitionGrid[getCellIndexForPosition(pos) + 1], i)
  end

  -- turn off all lights
  for i,v in ipairs(allLights) do
    v:setLightEnabled(false)
  end

  --turn on filtered out lights
  if allObjects then
    for k,v in pairs(allObjects) do
      local obj = scenetree.findObject(v)
      if obj and obj.obj:isSubClassOf('LightBase') then
        if obj:getField('castShadows', 0) == "0" then
          obj:setLightEnabled(true)
        end
      end
    end
  end

  -- debug
  local largestCell = -1
  local largestCellIndex = 0
  local totalLightsInCells = 0

  for i,c in ipairs(partitionGrid) do
    if #c > largestCell then
      largestCellIndex = i
      largestCell = #c
    end
    totalLightsInCells = totalLightsInCells + #c
  end

  --print("Tot spaces: " .. tostring(totalPartitionGridSpaces))
  --print("X spaces: " .. tostring(partitionGridSpacesX))
  --print("Y spaces: " .. tostring(partitionGridSpacesY))
  --print("Min extents: " .. tostring(partitionGridMin))
  --print("Max extents: " .. tostring(partitionGridMax))
  --print("Worst bucket was " .. tostring(largestCellIndex) .. " containing " .. tostring(largestCell) .. ". Total " .. tostring(totalLightsInCells))
  local props_spawned = false
  if allObjects then
    for k,v in pairs(allObjects) do
      local obj = scenetree.findObject(v)
      if obj and obj.obj:isSubClassOf('BeamNGVehicle') then
        if string.find(obj:getName(), "physics_prop_") then
          if obj.partConfig == '/vehicles/infra_c8_m4_isle2_prop/traffic_mirror.pc' then
            mirrorTarget = obj
          end
          props_spawned = true
        end
      end
    end
  end
  local prop_physics = scenetree.prop_physics
  if prop_physics and props_spawned == false then
    for i = 0, prop_physics.obj:getCount(), 1 do
      local id = prop_physics.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      if obj and obj:isSubClassOf("TSStatic") then
        local name = obj:getModelFile()
        local pos = obj:getWorldBoxCenter()
        local rot = obj:getRotation()
        name = string.gsub(name, "/levels/infra_c8_m4_isle2/art/infra_c8_m4_isle2/props/", "")
        name = string.gsub(name, ".dae", "")
        local options = {}
        options.autoEnterVehicle = false
        options.vehicleName = "physics_prop_"..i
        obj.hidden = true
        local veh = spawn.spawnVehicle('infra_c8_m4_isle2_prop', '/vehicles/infra_c8_m4_isle2_prop/'..name..'.pc', pos, rot, options)
        print("Settings up fields for "..veh:getName())
        veh.uiState = 0
        veh:setDynDataFieldbyName('isParked', 0, "true")
        veh:setDynDataFieldbyName('ignoreTraffic', 0, "true")
        veh.playerUsable = false
        veh.renderDistance = 15
        veh:postApply()
        if veh.partConfig == '/vehicles/infra_c8_m4_isle2_prop/turnstile_001_wheel.pc' then
          veh:setPosition(vec3(10.399, -46.801, 19.229))
        end
        if name == 'traffic_mirror' then
          mirrorTarget = veh
        end
        gameplay_walk.addVehicleToBlacklist(veh:getId())
      end
    end
  end
  local allObjects = scenetree:getAllObjects()
  if allObjects then
    for k,v in pairs(allObjects) do
      local obj = scenetree.findObject(v)
      if obj and obj.obj:isSubClassOf('BeamNGVehicle') then
        if string.find(obj:getName(), "physics_prop_") then
          table.insert(allProps, obj:getId())
        end
      end
    end
  end

  updatePropsData()

  for i,v in ipairs(allProps) do
    be:getObjectByID(v):setActive(0)
  end
end

local renderedOnce = false
local function renderMirror(mirrorTarget)
  if mirrorTarget and not Engine.sceneGetCameraFrustum():isBoxOutside(mirrorTarget:getWorldBox()) then
    local camPos = core_camera.getPosition()
    local mirrorPos = vec3(mirrorTarget:getPosition())
    local cameraDistanceToMirror = (camPos - mirrorPos):length()
    if (cameraDistanceToMirror < 20 and lightmgr == "Advanced Lighting 1.5") or renderedOnce == false then
      mirrorTarget:renderCameraToMaterial('@streetMirror1',
      vec3(-43.94011768,-26.54145467,14.50371746),
      QuatF(0.4266290854,0.8979294496,-0.09269459287,0.05583940812),
      Point2I(256, 256),
      140,
      Point2F(0.5, 50)
      )
      renderedOnce = true
    end
  end
end

local function bakeCubemaps(job)
  local probes = scenetree.cubemaps_data
  if probes then
    for i = 0, probes.obj:getCount(), 1 do
      local id = probes.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      if obj and obj:isSubClassOf("SceneObject") then
        local name = obj:getName()
        local pos = obj:getPosition()
        core_camera.setPosition(0, pos)
        job.sleep(1)
        captureCameraCubemap('/levels/infra_c8_m4_isle2/art/probes/probe_'..name..'_reflection/probe')
        local f = io.open('/levels/infra_c8_m4_isle2/art/probes/probe_'..name..'_reflection/main.materials.json', "a")
        f:write('{', '\n')
        f:write('  "probe_'..name..'_reflection" : {', '\n')
        f:write('    "name" : "probe_'..name..'_reflection",', '\n')
        f:write('    "class" : "CubemapData",', '\n')
        f:write('    "cubeFace" : [', '\n')
        f:write('      "/levels/infra_c8_m4_isle2/art/probes/probe_'..name..'_reflection/probe0.hdr.dds",', '\n')
        f:write('      "/levels/infra_c8_m4_isle2/art/probes/probe_'..name..'_reflection/probe1.hdr.dds",', '\n')
        f:write('      "/levels/infra_c8_m4_isle2/art/probes/probe_'..name..'_reflection/probe2.hdr.dds",', '\n')
        f:write('      "/levels/infra_c8_m4_isle2/art/probes/probe_'..name..'_reflection/probe3.hdr.dds",', '\n')
        f:write('      "/levels/infra_c8_m4_isle2/art/probes/probe_'..name..'_reflection/probe4.hdr.dds",', '\n')
        f:write('      "/levels/infra_c8_m4_isle2/art/probes/probe_'..name..'_reflection/probe5.hdr.dds"', '\n')
        f:write('    ]', '\n')
        f:write('  },', '\n')
        f:write('  "'..name..'_reflection" : {', '\n')
        f:write('    "name" : "'..name..'_reflection",', '\n')
        f:write('    "mapTo" : "unmapped_mat",', '\n')
        f:write('    "class" : "Material",', '\n')
        f:write('    "Stages" : [ {}, {}, {}, {} ],', '\n')
        f:write('    "cubemap" : "probe_'..name..'_reflection",', '\n')
        f:write('    "materialTag0" : "probe",', '\n')
        f:write('    "materialTag1" : "Natural",', '\n')
        f:write('    "materialTag2" : "BNG_sky"', '\n')
        f:write('  }', '\n')
        f:write('}')
        f:close()
        job.sleep(1)
      end
    end
  end
end

local function updateCubemapProbes()
  core_jobsystem.create(bakeCubemaps)
end

local function switchProbe()
  local camPos = core_camera.getPosition()
  local distanceToProbe = {}
  for k,v in pairs(cubemapProbes) do
    distanceToProbe[k] = (camPos - v):length()
  end
  local min = math.huge
  for k,v in pairs(distanceToProbe) do
    min = math.min(min, v)
  end
  for k,v in pairs(distanceToProbe) do
    if v == min and currentCube ~= "probe_"..k.."_reflection" then
      currentCube = "probe_"..k.."_reflection"
      setCubemap(currentCube)
      --print("Ping")
    end
  end
end

local function onBeamNGTrigger(data)
  -- dump(data)
  if data.triggerName == "BeamNG_teleport1" and data.event == "enter" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 1
    end
  end
  if data.triggerName == "BeamNG_teleport1" and data.event == "exit" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 0
    end
  end
  if data.triggerName == "BeamNG_teleport2" and data.event == "enter" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 2
    end
  end
  if data.triggerName == "BeamNG_teleport2" and data.event == "exit" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 0
    end
  end
end

local function onUpdate()
  if luaLoaded == false then
    extensions.mainLevel.onClientStartMission()
  end
  if playerisintrigger == 1 or playerisintrigger == 2 then
    local addonmap = nil
    if playerisintrigger == 1 then
      addonmap = FS:fileExists(otherLevelPath)
    elseif playerisintrigger == 2 then
      addonmap = FS:fileExists(otherLevelPath2)
    end
    local win = im.GetMainViewport()

    local image2 = imguiUtils.texObj('/levels/infra_c8_m4_isle2/map_switch.png')
    local image2size = im.ImVec2(640, 480)
    -- set position
    pos.x = win.Pos.x + win.Size.x / 2
    pos.y = win.Pos.y + win.Size.y / 2
    im.SetNextWindowPos(pos, im.ImGuiCond_Always, im.ImVec2(0.5, 0.5))
    im.SetNextWindowBgAlpha(0.7)

    im.Begin(promptTitle, nil, im.WindowFlags_AlwaysAutoResize+im.WindowFlags_NoResize+im.WindowFlags_NoMove+im.WindowFlags_NoCollapse+im.WindowFlags_NoDocking+im.WindowFlags_NoTitleBar)
    im.PushFont3("cairo_bold")
    if addonmap == true then
      im.SetWindowFontScale(2.0)
      im.Text("\n       Do you want to switch to another map?        \n ")
      if playerisintrigger == 1 then
        if im.Button("Point Elias", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
          local teleportTable = {targetPos = vec3(-94.476, 157.823, 4.302), targetRot = quatFromEuler(0, -0.5, 0)}
          jsonWriteFile(teleportTempFile, teleportTable, true)
          freeroam_freeroam.startFreeroam(otherLevelPath, nil, nil, getCurrentVehicle())
        end
      elseif playerisintrigger == 2 then
        if im.Button("Industrial District", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
          local teleportTable = {targetPos = vec3(161.747, 42.730, -60.1), targetRot = quatFromEuler(0, 0, math.rad(135))}
          jsonWriteFile(teleportTempFile, teleportTable, true)
          freeroam_freeroam.startFreeroam(otherLevelPath2, nil, nil, getCurrentVehicle())
        end
      end
      if im.Button("Stay Here", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
        playerisintrigger = 0
      end
    else
      im.SetWindowFontScale(1.65)
      if playerisintrigger == 1 then
        im.Text("This feature requires the Point Elias, Stalburg mod. This can be downloaded from the repository link below, come back once it has been installed")
      elseif playerisintrigger == 2 then
        im.Text("This feature requires the Industrial District, Stalburg mod. This can be downloaded from the repository link below, come back once it has been installed")
      end
      im.Text("")
      im.Image(image2.texId, image2size, im.ImVec2(0, 0), im.ImVec2(1, 1), col)
      im.Text("")
      im.SetWindowFontScale(1.2)
      if im.Button("Download (beamng.com)", im.ImVec2(120, 0)) then
        playerisintrigger = 0
        openWebBrowser("https://www.beamng.com/resources/authors/agentmooshroom5.272928/")
      end
      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text("Open BeamNG Repository in your web browser")
        im.EndTooltip()
      end
    end
    im.PopFont()
    im.SetWindowFontScale(1.0)
    im.End()
  end
  local cameraCell = getCellIndexForPosition(core_camera.getPosition())
  if (cameraCell ~= lastCameraCell) and positionInRange(core_camera.getPosition())  then
    local xCell, zCell = getCellForPosition(core_camera.getPosition())
    enableLights(xCell, zCell)
  end
  local cameraCell2 = getCellIndexForPosition2(core_camera.getPosition())
  if (cameraCell2 ~= lastCameraCell2) and positionInRange2(core_camera.getPosition())  then
    updatePropsData()
    local xCell, zCell = getCellForPosition2(core_camera.getPosition())
    enableProps(xCell, zCell)
  end

  lastCameraCell = cameraCell
  lastCameraCell2 = cameraCell2
  renderMirror(mirrorTarget)
  if lightmgr == "Advanced Lighting 1.5" then
    switchProbe()
  end
end

M.onClientStartMission = onClientStartMission
M.updateCubemapProbes = updateCubemapProbes
M.onUpdate = onUpdate
M.onBeamNGTrigger = onBeamNGTrigger

return M