-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local luaLoaded = false

M.dependencies = {"ui_imgui"}
local im = ui_imgui
local imguiUtils = require('ui/imguiUtils')


local pos = im.ImVec2(0, 0)

--teleport
local otherLevelPath = "/levels/infra_c8_m6_business/info.json"
local otherLevelPath2 = "/levels/c9_m1b_shipyard/info.json"
local playerisintrigger = nil
local promptTitle = "Teleport"
local teleportTempFile = "/temp/infra_teleport.json"

-- TWEAKS
local partitionGridSpaceSize = 32.0

-- DATA, DON'T TOUCH
local partitionGridMin
local partitionGridMax
local partitionGridSpacesX
local partitionGridSpacesY
local totalPartitionGridSpaces
local partitionGrid = {}

local lastValue = nil
local lastCameraCell = -1
local lastCameraCell2 = -1
local allLights = {}
local allProps = {}

local lightmgr

local sparkParticles = {}


-- Keep track of the last set of lights we enabled so we don't have to loop over every light and disable it each time we change cells
local lastEnabledLightCount = 0
local lastEnabledLightIndices = {}

local cubemapProbes = {}

local instanceData = {}

local function setCubemap(value)
  if value then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      --log("I", "setCubemap", "Enabling cubemap " ..value)
      levelinf:setField('globalEnviromentMap', 0, value)
      levelinf:postApply()
    else
      --log("W", "setCubemap", "Enabling fallback cubemap " ..value)
      setConsoleVariable("$defaultLevelEnviromentMap", value)
    end
  end
end

local function getInstanceData()
  local instanceData = {}
  local materials = {}
  local allObjects = scenetree:getAllObjects()
  if allObjects then
    for k,name in pairs(allObjects) do
      local object = scenetree.findObject(name)
      if object and object.___type == "class<Material>" then
        if object:getField('instanceEmissive', 0) == "1" then
          materials[name] = true
        end
      end
    end
    for k,name in pairs(allObjects) do
      local object = scenetree.findObject(name)
      if object and object:isSubClassOf("TSStatic") then
        if object:getDynDataFieldbyName('is_tunnel', 0) == "1" then
          --do nothing
        else
          local matNames = object:getMaterialNames()
          for k,v in pairs(matNames) do
            if materials[v] == true then
              local objId = object:getId()
              local instColor = object:getField('instanceColor', 0)
              instanceData[objId] = instColor
            end
          end
        end
      end
    end
    for k,v in pairs(instanceData) do
      local instance = scenetree.findObjectById(k)
      if instance then
        instance:setField('instanceColor', 0, "Black")
        instance:updateInstanceRenderData()
      end
    end
  end
  return instanceData
end

local function enabledisableEmissionGlow(isEmissive)
  if isEmissive == 1 then
    for k,v in pairs(instanceData) do
      local instance = scenetree.findObjectById(k)
      if instance then
        instance:setField('instanceColor', 0, v)
        instance:updateInstanceRenderData()
      end
    end
  else
    for k,v in pairs(instanceData) do
      local instance = scenetree.findObjectById(k)
      if instance then
        instance:setField('instanceColor', 0, "Black")
        instance:updateInstanceRenderData()
      end
    end
  end
end

--get player vehicle
local function getCurrentVehicle()
  local result = nil
  if gameplay_walk and gameplay_walk.isWalking() then
    return result
  end

  -- get the current vehicle to load it in the garage
  local vehicle = be:getPlayerVehicle(0)
  local playerVehicleData = core_vehicle_manager.getPlayerVehicleData()
  if vehicle and playerVehicleData then
    local config = serialize(playerVehicleData.config) -- when using "vehicle.partConfig" here, the color of the vehicle will be wrong if you use a custom default config
    local model = vehicle.JBeam
    result = { model, {config=config} }
  end
  return result
end

local function enableLights(xCell, zCell, value)
  -- disable previously enabled lights
  for i=1,lastEnabledLightCount,1 do
    local light = allLights[lastEnabledLightIndices[i]]
    light:setLightEnabled(false)
  end

  lastEnabledLightCount = 0
  for x=math.max(0, xCell - 1), math.min(partitionGridSpacesX - 1, xCell + 1),1 do
    for z=math.max(0, zCell - 1), math.min(partitionGridSpacesY - 1, zCell + 1),1 do
      for _,lightIndex in ipairs(partitionGrid[1 + (z * partitionGridSpacesX) + x]) do
        -- mark enabled
        lastEnabledLightCount = lastEnabledLightCount + 1
        lastEnabledLightIndices[lastEnabledLightCount] = lightIndex

        -- enable light
        local light = allLights[lightIndex]
        light:setLightEnabled(value)
      end
    end
  end
end

local function getCellForPosition(p)
  local xCell = math.floor((p.x - partitionGridMin.x) / partitionGridSpaceSize)
  local yCell = math.floor((p.y - partitionGridMin.y) / partitionGridSpaceSize)
  return xCell, yCell
end

local function getCellIndexForPosition(p)
  local xCell, yCell = getCellForPosition(p)
  return (yCell * partitionGridSpacesX) + xCell
end

local function positionInRange(p)
  return p.x >= partitionGridMin.x and p.x <= partitionGridMax.x and p.y >= partitionGridMin.y and p.y <= partitionGridMax.y
end

local function onClientStartMission()
  luaLoaded = true

  instanceData = getInstanceData()

  if FS:fileExists(teleportTempFile) then
    local teleportTempData = jsonReadFile(teleportTempFile)
    if teleportTempData then
      spawn.safeTeleport(be:getPlayerVehicle(0), teleportTempData.targetPos, quat(0,0,1,0) * teleportTempData.targetRot, nil, nil, nil, nil, false)
      core_camera.resetCamera(0)
    end
    FS:removeFile(teleportTempFile)
  end

  local allObjects = scenetree:getAllObjects()
  if allObjects then
    for k,v in pairs(allObjects) do
      local obj = scenetree.findObject(v)
      if obj and obj.obj:isSubClassOf('LightBase') then
        if obj:getField('castShadows', 0) == "1" then
          table.insert(allLights, obj.obj)
        end
      end
      if obj and obj.obj:isSubClassOf('ParticleEmitterNode') and string.find(obj:getName(), "env_spark_") then
        sparkParticles[obj:getName()] = obj:getPosition()
      end
    end
  end

  -- compute grid
  local minX = 99999.0
  local minY = 99999.0
  local maxX = -99999.0
  local maxY = -99999.0

  for i,v in ipairs(allLights) do
    local pos = v:getPosition()
    minX = math.min(pos.x, minX)
    minY = math.min(pos.y, minY)

    maxX = math.max(pos.x, maxX)
    maxY = math.max(pos.y, maxY)
  end

  partitionGridMin = vec3(minX, minY, 0)
  partitionGridMax = vec3(maxX, maxY, 0)
  partitionGridSpacesX = math.ceil((partitionGridMax.x - partitionGridMin.x) / partitionGridSpaceSize)
  partitionGridSpacesY = math.ceil((partitionGridMax.y - partitionGridMin.y) / partitionGridSpaceSize)
  totalPartitionGridSpaces = (partitionGridSpacesX * partitionGridSpacesY)

  -- allocate tables
  for i=1,totalPartitionGridSpaces,1 do
    table.insert(partitionGrid, {})
  end

  for i=1,512,1 do
    table.insert(lastEnabledLightIndices, 0)
  end

  -- place lights in cells
  for i,v in ipairs(allLights) do
    local pos = v:getPosition()
    table.insert(partitionGrid[getCellIndexForPosition(pos) + 1], i)
  end

  -- turn off all lights
  for i,v in ipairs(allLights) do
    v:setLightEnabled(false)
  end

  --turn on filtered out lights
  if allObjects then
    for k,v in pairs(allObjects) do
      local obj = scenetree.findObject(v)
      if obj and obj.obj:isSubClassOf('LightBase') then
        if obj:getField('castShadows', 0) == "0" then
          obj:setLightEnabled(true)
        end
      end
    end
  end

  -- debug
  local largestCell = -1
  local largestCellIndex = 0
  local totalLightsInCells = 0

  for i,c in ipairs(partitionGrid) do
    if #c > largestCell then
      largestCellIndex = i
      largestCell = #c
    end
    totalLightsInCells = totalLightsInCells + #c
  end

  enabledisableEmissionGlow(0)

  --print("Tot spaces: " .. tostring(totalPartitionGridSpaces))
  --print("X spaces: " .. tostring(partitionGridSpacesX))
  --print("Y spaces: " .. tostring(partitionGridSpacesY))
  --print("Min extents: " .. tostring(partitionGridMin))
  --print("Max extents: " .. tostring(partitionGridMax))
  --print("Worst bucket was " .. tostring(largestCellIndex) .. " containing " .. tostring(largestCell) .. ". Total " .. tostring(totalLightsInCells))
end

local function onBeamNGTrigger(data)
  -- dump(data)
  if data.triggerName == "BeamNG_teleport1" and data.event == "enter" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 1
    end
  end
  if data.triggerName == "BeamNG_teleport1" and data.event == "exit" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 0
    end
  end
  if (data.triggerName == "BeamNG_teleport2" or data.triggerName == "BeamNG_teleport3" or data.triggerName == "BeamNG_teleport4") and data.event == "enter" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 2
    end
  end
  if (data.triggerName == "BeamNG_teleport2" or data.triggerName == "BeamNG_teleport3" or data.triggerName == "BeamNG_teleport4") and data.event == "exit" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 0
    end
  end
end

local function onUpdate(dtReal)
  if luaLoaded == false then
    extensions.mainLevel.onClientStartMission()
  end

  if playerisintrigger == 1 or playerisintrigger == 2 then
    local addonmap = nil
    if playerisintrigger == 1 then
      addonmap = FS:fileExists(otherLevelPath)
    elseif playerisintrigger == 2 then
      addonmap = FS:fileExists(otherLevelPath2)
    end
    local win = im.GetMainViewport()

    local image2 = imguiUtils.texObj('/levels/c9_m1_alley/map_switch.png')
    local image2size = im.ImVec2(640, 480)
    -- set position
    pos.x = win.Pos.x + win.Size.x / 2
    pos.y = win.Pos.y + win.Size.y / 2
    im.SetNextWindowPos(pos, im.ImGuiCond_Always, im.ImVec2(0.5, 0.5))
    im.SetNextWindowBgAlpha(0.7)

    im.Begin(promptTitle, nil, im.WindowFlags_AlwaysAutoResize+im.WindowFlags_NoResize+im.WindowFlags_NoMove+im.WindowFlags_NoCollapse+im.WindowFlags_NoDocking+im.WindowFlags_NoTitleBar)
    im.PushFont3("cairo_bold")
    if addonmap == true then
      im.SetWindowFontScale(2.0)
      im.Text("\n       Do you want to switch to another map?        \n ")
      if playerisintrigger == 1 then
        if im.Button("Point Elias", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
          local teleportTable = {targetPos = vec3(-159.961, -10.428, 3.507), targetRot = quatFromEuler(0, 0, math.rad(-90))}
          jsonWriteFile(teleportTempFile, teleportTable, true)
          freeroam_freeroam.startFreeroam(otherLevelPath, nil, nil, getCurrentVehicle())
        end
      elseif playerisintrigger == 2 then
        if im.Button("Shipyard", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
          local teleportTable = {targetPos = vec3(287.632, -305.634, 0.404), targetRot = quatFromEuler(0, 0, math.rad(180))}
          jsonWriteFile(teleportTempFile, teleportTable, true)
          freeroam_freeroam.startFreeroam(otherLevelPath2, nil, nil, getCurrentVehicle())
        end
      end
      if im.Button("Stay Here", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
        playerisintrigger = 0
      end
    else
      im.SetWindowFontScale(1.65)
      if playerisintrigger == 1 then
        im.Text("This feature requires the Point Elias, Stalburg mod. This can be downloaded from the repository link below, come back once it has been installed")
      elseif playerisintrigger == 2 then
        im.Text("This feature requires the Shipyard, Stalburg mod. This can be downloaded from the repository link below, come back once it has been installed")
      end
      im.Text("")
      im.Image(image2.texId, image2size, im.ImVec2(0, 0), im.ImVec2(1, 1), col)
      im.Text("")
      im.SetWindowFontScale(1.2)
      if im.Button("Download (beamng.com)", im.ImVec2(120, 0)) then
        playerisintrigger = 0
        openWebBrowser("https://www.beamng.com/resources/authors/agentmooshroom5.272928/")
      end
      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text("Open BeamNG Repository in your web browser")
        im.EndTooltip()
      end
    end
    im.PopFont()
    im.SetWindowFontScale(1.0)
    im.End()
  end

  local tod = scenetree.tod
  if not tod then return end

  local value = (tod.time > 0.21 and tod.time < 0.79)
  local cameraCell = getCellIndexForPosition(core_camera.getPosition())

  if (cameraCell ~= lastCameraCell or lastValue ~= value) and positionInRange(core_camera.getPosition())  then
    local xCell, zCell = getCellForPosition(core_camera.getPosition())
    enableLights(xCell, zCell, value)
  end
  if lastValue ~= value then
    if value == true then
      enabledisableEmissionGlow(1)
    else
      enabledisableEmissionGlow(0)
    end
  end
  lastCameraCell = cameraCell
  lastValue = value
end

M.onClientStartMission = onClientStartMission
M.onUpdate = onUpdate
M.onBeamNGTrigger = onBeamNGTrigger

return M