-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function setAllLightsEnabled(group, value)
  for i = 0, group:size() - 1 do
    local obj = Sim.upcast(group.obj:at(i))
    if obj then
      if obj.obj:isSubClassOf('LightBase') then
        obj.obj:setLightEnabled(value)
      end
    end
  end
end

local lastValue = nil

local function setCubemap(cubemapname)
  if cubemapname then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      log("I", "setCubemap", "Enabling cubemap " ..cubemapname)
      levelinf:setField('globalEnviromentMap', 0, cubemapname)
      levelinf:postApply()
    else
      log("W", "setCubemap", "Enabling fallback cubemap " ..cubemapname)
      setConsoleVariable("$defaultLevelEnviromentMap", cubemapname)
    end
  end
end

local function onUpdate(dtReal)
  local tod = scenetree.tod
  if not tod then return end

  local value = false
  if tod.time > 0.24 and tod.time < 0.78 then
    value = true
  end

  if lastValue == value then return end
  lastValue = value
  if value == true then
    setCubemap("cubemap_st_daidojiNight_reflection")
  else
    setCubemap("cubemap_st_daidoji_reflection")
  end

  if scenetree.lights then
    setAllLightsEnabled(scenetree.lights, value ,"")
  end
end

M.onUpdate = onUpdate

return M