local M = {}

local yVec = vec3(0,1,0)

local camDistanceLimit = 100
local defaultRedLightTriggerSpeed = 5

local function onSpeedTrapTriggeredPHI(speedTrapData, playerSpeed, overSpeed)
  if not speedTrapData.speedLimit then return end
  local veh = getPlayerVehicle(0)
  ui_message({txt="ui.freeroam.speedTrap.speedingMessage", context={licensePlate = core_vehicles.getVehicleLicenseText(veh), recordedSpeed = playerSpeed, speedLimit = speedTrapData.speedLimit}}, 10, 'speedTrap')
end

local function speedCamLightJob(job, lightObj)
  job.sleep(0.1 / math.max(simTimeAuthority.getReal(), 0.001))
  lightObj.isEnabled = false
  job.sleep(0.1 / math.max(simTimeAuthority.getReal(), 0.001))
  lightObj.isEnabled = true
  job.sleep(0.1 / math.max(simTimeAuthority.getReal(), 0.008))
  lightObj.isEnabled = false
end

local function redLightLightJob(job, lightObj, delay)
  job.sleep(0.1 / math.max(simTimeAuthority.getReal(), 0.001))
  lightObj.isEnabled = false
  job.sleep(delay / math.max(simTimeAuthority.getReal(), 0.001))
  lightObj.isEnabled = true
  job.sleep(0.1 / math.max(simTimeAuthority.getReal(), 0.001))
  lightObj.isEnabled = false
end


--map for average speed db
--[triggerid][subjectid] = unixtime
M.averageSpeedDB =  {
}

local function averageSpeedDeleteJob(job, triggerName, subjectID, delay)
  print ("Average Speed Delete Job: " .. triggerName .. " " .. subjectID)
  job.sleep(delay / math.max(simTimeAuthority.getReal(), 0.001))
  M.averageSpeedDB[triggerName][subjectID] = nil
  print("Average Speed Delete Job Done")
end

local vehVelocity = vec3()
local triggerDir = vec3()
local vehPos = vec3()
local camPos = vec3()
local speedCamMessage = 
[[Speed Limit Exeeded: 
- %s
- Activation Speed: {{%f | unit: "speed":0}} 
- Speed Limit: {{%f | unit: "speed":0}}
- %s]]
local basicMessage = 
[[Vehicle Detected:
- %s
- %s]]
local averageSpeedMessage = 
[[Average Speed Limit Exeeded:
- %s
- Activation Average Speed: {{%f | unit: "speed":0}} 
- Speed Limit: {{%f | unit: "speed":0}}
- %s]]
--[[
  example data
  {
    event = "enter",
    speedLimit = "11.176",
    speedTrapLightName = "speedTrapLight1",
    speedTrapType = "speed",
    subjectID = 46855,
    subjectName = "clone0",
    triggerEvent = 0,
    triggerID = 16584,
    triggerName = "speedTrapTrigger1"
  }
]]


function TriggerServerEvent(name, data)
	MPGameNetwork.send('E:'..name..':'..data)
end

local function reportToServer(subjectID, vehicledesc, vehSpeed, speedLimit, triggerName, triggerType)
  if (MPCoreNetwork == nil) then return end
  if (not MPCoreNetwork.isMPSession()) then return end
  local ID = MPVehicleGE.getServerVehicleID(subjectID)
  local data = jsonEncode({ID = ID, vehicledesc = vehicledesc, vehSpeed = vehSpeed, speedLimit = speedLimit, triggerName = triggerName, triggerType = triggerType})
  TriggerServerEvent('speedTrapTrigger', data)
end

local function onBeamNGTrigger(data)
  if not data or not data.speedTrapTypePHI then return end

  if data.event == 'enter' then

    for key, Data in pairs(core_trailerRespawn.getTrailerData()) do
      if Data.trailerId == data.subjectID then
        return
      end
    end


    vehVelocity:set(be:getObjectVelocityXYZ(data.subjectID))
    local vehSpeed = vehVelocity:length()

    if (data.speedTrapTypePHI == "avgspeedstart") then
      if data.endTriggerName then
        if not M.averageSpeedDB[data.endTriggerName] then
          M.averageSpeedDB[data.endTriggerName] = {}
        end
        print("Average Speed Start: " .. data.endTriggerName .. " " .. data.subjectID)
        M.averageSpeedDB[data.endTriggerName][data.subjectID] = os.time()
        core_jobsystem.create(averageSpeedDeleteJob, 1, data.endTriggerName, data.subjectID, data.expireTime * 1000)
      end
      return
    end
     if data.speedTrapTypePHI == "avgspeedend" then
      print("Average Speed End: " .. data.triggerName .. " " .. data.subjectID)
      dump(M.averageSpeedDB)
        if M.averageSpeedDB[data.triggerName] and M.averageSpeedDB[data.triggerName][data.subjectID] then
          local startTime = M.averageSpeedDB[data.triggerName][data.subjectID]
          local endTime = os.time()
          local timeDiff = (endTime - startTime)
          print ("Time Diff: " .. timeDiff)

          local distance = data.distance
          if (distance == nil) then
            distance = data.Distance
          end
          print("Distance: " .. distance)
          vehSpeed = distance / timeDiff 
          print("Average Speed: " .. vehSpeed)
          M.averageSpeedDB[data.triggerName][data.subjectID] = nil
        else 
          return
        end
    end

    local isRedLightCamera = data.speedTrapType == "redLight"

    local speedLimit = data.speedLimit or 0

    local convertedSpeedLimit = speedLimit * 0.44704

    local speedLimitTolerance = 0
    if data.speedLimitTolerance then
      speedLimitTolerance = data.speedLimitTolerance * 0.44704
    else
      speedLimitTolerance = convertedSpeedLimit * 0.1
    end
    local triggerSpeed = isRedLightCamera and (tonumber(data.triggerSpeed) or defaultRedLightTriggerSpeed) or (convertedSpeedLimit + speedLimitTolerance)
    local overSpeed = vehSpeed - speedLimit

    -- check if over speedlimit
    if vehSpeed > triggerSpeed then
      local trafficSignalColor
      if isRedLightCamera then
        local trafficSignal = core_trafficSignals.getSignalByName(data.trafficSignalId)
        trafficSignalColor = trafficSignal:getState()
        if trafficSignalColor == "redTrafficLight" then
          extensions.hook('onRedLightCamTriggered', data, vehSpeed)
        end
      else
        if not data.speedLimit then return end
            
          local details = core_vehicles.getVehicleDetails(data.subjectID)

          local vehicledesc = ""

          if details.model.Brand then
            vehicledesc = details.model.Brand
          end

          if details.model.Name then
            if vehicledesc == "" then
              vehicledesc = details.model.Name
            else
              vehicledesc = vehicledesc .. " " .. details.model.Name
            end
          end

          if (vehicledesc == "") then
            vehicledesc = "Unknown Vehicle"
          end

          local plate = core_vehicles.getVehicleLicenseText(be:getObjectByID(data.subjectID))
          if plate then
            vehicledesc = vehicledesc .. ", \"" .. plate .. "\""
          else 
            vehicledesc = vehicledesc .. ", No License Plate"
          end

          if (data.customMessage) then 
            if data.customMessage == "detected" then
              ui_message(string.format(basicMessage, vehicledesc, data.triggerName), 10, 'speedTrap'.. data.triggerName .. data.subjectName, "photo_camera")
              return
            elseif data.customMessage == "avgspeed" then
              ui_message(string.format(averageSpeedMessage, vehicledesc, vehSpeed, convertedSpeedLimit, data.triggerName), 10, 'speedTrap'.. data.triggerName .. data.subjectName, "photo_camera")
              return
            end
            
          else
			      ui_message(string.format(speedCamMessage, vehicledesc, vehSpeed, convertedSpeedLimit, data.triggerName), 10, 'speedTrap'.. data.triggerName .. data.subjectName, "photo_camera")
          end
        end

        if data.speedTrapLightName then
          -- TODO maybe build a cache with ids if findObject is too slow
          local lightObj = scenetree.findObject(data.speedTrapLightName)
          if isRedLightCamera then
            if lightObj and trafficSignalColor == "redTrafficLight" then
              lightObj.isEnabled = true
              core_jobsystem.create(redLightLightJob, 1, lightObj, 10 / math.max(vehSpeed, 0.01))
            end
          else
            if lightObj then
              lightObj.isEnabled = true
              core_jobsystem.create(speedCamLightJob, 1, lightObj)
            end
          end
        end
    end
  end
end

local function getSpeedTrapsInCurrentLevel(speedTrapType)
  local objs = getObjectsByClass("BeamNGTrigger")
  if not objs then return {} end
  local res = {}
  for _, obj in pairs(objs) do
    if obj.speedTrapType == speedTrapType then
      table.insert(res, obj)
    end
  end
  return res
end

M.onBeamNGTrigger = onBeamNGTrigger

M.getSpeedTrapsInCurrentLevel = getSpeedTrapsInCurrentLevel

local oldLightsValue = nil

local function setAllLightsEnabled(group, lightsValue)
    for i = 0, group.obj:getCount(), 1 do
        local id = group.obj:idAt(i)
        local obj = scenetree.findObjectById(id)
        if obj and obj.obj:isSubClassOf('LightBase') then
            obj.obj:setLightEnabled(lightsValue)
        end
    end
end

local function printTest()
    print('test')
end

local function onUpdate()
    local tod = scenetree.tod
    if not tod then return end

    local lightsValue = false
    if tod.time > 0.21 and tod.time < 0.77 then
        lightsValue = true
    end

    if oldLightsValue == lightsValue then return end
    oldLightsValue = lightsValue

    if scenetree.dynamic_lights then
      setAllLightsEnabled(scenetree.dynamic_lights, lightsValue)
    end
end

M.onUpdate = onUpdate

return M