import ter_io
import math

PATH = 'C:/Users/Atlas/AppData/Local/BeamNG.drive/0.32/levels/river_highway/keep/new_terrain.ter'

heightMapSize = 8192**2
heightMapItemSize = 2
layerMapSize = 8192**2
layerMapItemSize = 1

# it'd be better if you pass in the path to the json file 
print('read')
terrain = ter_io.read_terrain(PATH, heightMapSize, heightMapItemSize, layerMapSize, layerMapItemSize)

#terrain['heightMap'] = list(terrain['heightMap'])

def map_range(val, input_range=(0,1), output_range=(0,1), clamp=False):
    fac = ((val-input_range[0])/(input_range[1]-input_range[0]))
    if clamp: fac = max(0, min(fac, 1))
    return (fac*(output_range[1]-output_range[0]) + output_range[0])



def remap(map):
    new_map = []

    for elem in map:
        elem = map_range(elem/65535, (450/1024, 962/1024), (0, 1), False)
        new_map.append(int(math.floor(max(0, min(65535*elem, 65535)))))

    return new_map

terrain['heightMap'] = remap(terrain['heightMap'])

print('write')
ter_io.write_terrain('C:/Users/Atlas/AppData/Local/BeamNG.drive/0.32/levels/river_highway/new_terrain.ter', terrain)

print('DONE')
