# Custom terrain reader

import struct
import json
import io


def save_preview(name, data):
    with open(f'preview/{name}.json', 'w') as f:
        f.write(json.dumps(data)) 


def read_terrain(path='terrain.ter', heightMapSize = 16777216, heightMapItemSize = 2, layerMapSize = 16777216, layerMapItemSize = 1) -> dict:

    # version(char), size(unsigned int), heightMap(heightMapSize * heightMapItemSize), layerMap(layerMapSize * layerMapItemSize), layerTextureMap(layerMapSize * layerMapItemSize), materialNames

    def read_materialNames(file: io.BufferedReader):
        material_count = struct.unpack('<I', file.read(4))[0]
        materialNames = []
        for _ in range(material_count):
            name_length = struct.unpack('<B', file.read(1))[0]
            name = file.read(name_length).decode('utf-8')
            #print(name)
            materialNames.append(name)
        return materialNames

    terrain = {}
    with open(path, 'rb') as file:
        terrain['version'] = struct.unpack('<B', file.read(1))[0]
        terrain['size'] = struct.unpack('<I', file.read(4))[0]
        terrain['heightMap'] = struct.unpack('<' + 'H' * heightMapSize, file.read(heightMapSize * heightMapItemSize))
        terrain['layerMap'] = struct.unpack('<' + 'B' * layerMapSize, file.read(layerMapSize * layerMapItemSize))
        terrain['materialNames'] = read_materialNames(file)

    return terrain



def write_terrain(path, terrain):
    with open(path, 'wb') as file:
        file.write(struct.pack('<B', terrain['version']))
        file.write(struct.pack('<I', terrain['size']))
        file.write(struct.pack('<' + 'H' * len(terrain['heightMap']), *terrain['heightMap']))
        file.write(struct.pack('<' + 'B' * len(terrain['layerMap']), *terrain['layerMap']))

        file.write(struct.pack('<I', len(terrain['materialNames'])))
        for name in terrain['materialNames']:
            file.write(struct.pack('<B', len(name)))
            file.write(name.encode('utf-8'))

