-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local settarget = 0

local function onReset()
    electrics.values['turna'] = 0
	electrics.values['turnb'] = 1
end

local function updateGFX(dt)

    local open = electrics.values['open_input'] or 0
    local close = electrics.values['close_input'] or 0
	if open == 1 then settarget = -1 end
	if close == 1 then settarget = 1 end
    local target = math.max(0, math.min(1, electrics.values['turna'] + (settarget * dt)))
    electrics.values['turna'] = target
	electrics.values['turnb'] = 1 - target
end

M.onInit    = onInit
M.onReset   = onReset
M.updateGFX = updateGFX

return M
