local M = {}

local mathutil = require("../mathutil")

M.type = "auxilliary"
M.relevantDevice = nil
M.defaultOrder = 900
M.debugData = {}

local max = math.max
local min = math.min

local engine = nil
local dynamicBrakingCoef = 0
local tractionMotorPowerGeneration = 0
local resistorResistance = 0
local resistorDamage = 0
local resistorMaxDamage = 0
local resistorBroken = false
local startingTemperature = 25
local resistorMass = 0
local resistorRealResistance = 1
local resistorNodeID = 0
local resistorNode2ID = 0
local dbFanNodeID = 0
local dbFanCoef = 0
local gearIndex = 0
local gear = 0
local reverserMode = 0
local resistorTemperatureDamageThreshold = 380
local resistorFireTemperature = 500
local dbFanSmoother = newTemporalSmoothing(500, 1000)
local resistor = 0
electrics.values.dbFanSpin = 0
electrics.values.dynamicBrake = 0
electrics.values.dynamicBrakingCoef = 0
electrics.values.blowBrakeFan = 0
electrics.values.resistorTemperature = 0
electrics.values.resistorFire = 0

local conversion = {
  kelvinToCelsius = -273.15,
}

local energyCoef = {
  resistor = nil,
}

local constants = {
    -- Dynamic braking simulation
    minDynamicBrakeSpeed = 3.8,
    maxDynamicBrakeSpeed = 15,
	resistorSpecHeat = 300,
    -- Sounds
    dynamicBrakeBaseVolume = 1,
	dynamicBrakeBasePitch = 1,
}

local sounds = {
    dynamicBrake = nil,
}

local dynamicBrakeData = {
  dynamicBrakingCoef = 0,
}
M.debugData.dynamicBrakeData = dynamicBrakeData

local function updateValues(dt)
    gearIndex = electrics.values.gearIndex
    gear = electrics.values.gear
	reverserMode = electrics.values.modeRangeBox
	dynamicBrakeData.dynamicBrakingCoef = M.dynamicBrakingCoef
end

local function updateBrakeFan(dt)
	local dbFanSpeed = dynamicBrakingCoef / 27000
	local dbFanRPM = dbFanSmoother:getUncapped(dbFanSpeed > 0 and 750 or 0, dt)
	electrics.values.dbFanSpin = (electrics.values.dbFanSpin + dbFanSpeed * dbFanRPM * dt) % 360
	
	local volume = dbFanRPM * dbFanSpeed / 750 * dynamicBrakeBaseVolume
	if volume < 0.25 then
		volume = 0
	end
    local pitch = 1--min(dbFanRPM * dbFanSpeed / 750 * dynamicBrakeBasePitch), 1.1
	
	if dbFanNodeID == nil then
		
	else
		obj:setVolumePitch(sounds.dynamicBrake, volume, pitch)
	end
	
	--resistor thermals
	local kResistorToAir = 0.000028
	local energyResistorFanToAir = (((electrics.values.resistorTemperature - tEnv) * dbFanRPM) / 150) * dbFanCoef
	local resistorTempDiff = electrics.values.resistorTemperature - tEnv
	local resistorTempSquared = electrics.values.resistorTemperature * electrics.values.resistorTemperature
	local energyResistorToAir = resistorTempSquared * resistorTempSquared * kResistorToAir
	local energyToResistor = tractionMotorPowerGeneration * 3.5
	local energyFireToResistor = 0
	if electrics.values.resistorFire == 1 then
		energyFireToResistor = 50000
	else
		energyFireToResistor = 0
	end
	electrics.values.resistorTemperature = max(electrics.values.resistorTemperature + (energyToResistor + energyFireToResistor - energyResistorFanToAir - energyResistorToAir * dt) * energyCoef.resistor, tEnv)
	resistorRealResistance = (electrics.values.resistorTemperature / 500 + 0.95) * resistorResistance
	--print(electrics.values.resistorTemperature)
end

local function initSounds()
	if dbFanNodeID == nil then
		sounds.dynamicBrake = nil
	else
    sounds.dynamicBrake =
        obj:createSFXSource(
        dynamicBrakeSound,
        "AudioDefaultLoop3D",
        "dynamicBrake",
        dbFanNodeID
    )
	end
end

local function init(jbeamData)
	dynamicBrakeSound = jbeamData.dynamicBrakeSound or "vehicles/chs4052/wheel_grind.ogg"
	dynamicBrakeBaseVolume = jbeamData.dynamicBrakeBaseVolume or 1
	dynamicBrakeBasePitch = jbeamData.dynamicBrakeBasePitch or 1
	resistorResistance = jbeamData.resistorResistance or 0
	resistorDamage = jbeamData.resistorDamage or 0
	resistorMaxDamage = jbeamData.resistorMaxDamage or 800
	resistorBroken = jbeamData.resistorBroken or false
	resistorMass = jbeamData.resistorMass or 150
	dbFanCoef = jbeamData.dbFanCoef or 0
	resistorTemperatureDamageThreshold = jbeamData.resistorTemperatureDamageThreshold or 380
	resistorFireTemperature = jbeamData.resistorFireTemperature or 500
	
	electrics.values.blowBrakeFan = 0
	dynamicBrakingCoef = 0
	engine = powertrain.getDevice("mainEngine")
	dbFanSmoother:reset()
	dbFanSmoother = newTemporalSmoothing(500, 1000)
	electrics.values.dbFanSpin = 0
	resistorRealResistance = 1
	startingTemperature = 25
	tEnv = obj:getEnvTemperature() + conversion.kelvinToCelsius
	energyCoef.resistor = 1 / (resistorMass * constants.resistorSpecHeat)
	electrics.values.resistorTemperature = startingTemperature
	gearIndex = 0
	gear = 0
	reverserMode = 0
	electrics.values.resistorFire = 0
	
  if jbeamData.resistorNode_nodes and type(jbeamData.resistorNode_nodes) == "table" then
    resistorNodeID = jbeamData.resistorNode_nodes[1]
  end  --YES YES YES FINALLY, it took only 6 hours to figure out how to get the node id
  if jbeamData.resistorNode2_nodes and type(jbeamData.resistorNode2_nodes) == "table" then
    resistorNode2ID = jbeamData.resistorNode2_nodes[1]
  end
  if jbeamData.dbFanNode_nodes and type(jbeamData.dbFanNode_nodes) == "table" then
    dbFanNodeID = jbeamData.dbFanNode_nodes[1]
  end
end

local function updateAmpNeedle(dt)
	if gearIndex == 1 then
		electrics.values.amp_needle = electrics.values.tractionMotorTorque * 0.006
		electrics.values.volt_needle = electrics.values.tractionMotorTorque * 0.005
	elseif gearIndex == 2 then
		electrics.values.amp_needle = electrics.values.dynamicBrakingCoef * -0.0018
		electrics.values.volt_needle = electrics.values.dynamicBrakingCoef * -0.0018
	else
		electrics.values.amp_needle = 0
		electrics.values.volt_needle = 0
	end
	
	
end

local function updateGFX(dt)
    updateValues(dt)
	updateBrakeFan(dt)
	updateAmpNeedle()
	
	/*electrics.values.wheelspeed = math.abs(drivetrain.wheels[10].angularVelocity * 0.525)*/
end

M.igniteNode = fire.igniteNode
M.init = init
M.initSounds = initSounds
M.updateGFX = updateGFX

return M