-- EIGHT-NOTCH LOCOMOTIVE THROTTLE

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local speedospeed = 0
local notch = 0 --notch
local throttle = 0
local throttleAggressivity = 1 --how fast the engine rpm increases when throttle is increased one notch
local throttleDecreaseAggressivity = 1 --how fast the engine rpm decreases when throttle is decreased one notch
local rpmNotch1 = 300 --diesel engine rpm at notch 1
local rpmNotch2 = 300 --diesel engine rpm at notch 2
local rpmNotch3 = 330 --diesel engine rpm at notch 3
local rpmNotch4 = 400 --diesel engine rpm at notch 4
local rpmNotch5 = 480 --diesel engine rpm at notch 5
local rpmNotch6 = 570 --diesel engine rpm at notch 6
local rpmNotch6 = 650 --diesel engine rpm at notch 7
local rpmNotch8 = 750 --diesel engine rpm at notch 8

local oldval = 0
local oldval_r = 0
local roldval = 0
local roldval_r = 0

local function init(jbeamData)
	speedospeed = 0
	notch = 0
	throttleAggressivity = jbeamData.throttleAggressivity or 1
	throttleDecreaseAggressivity = jbeamData.throttleDecreaseAggressivity or 1
	rpmNotch1 = jbeamData.rpmNotch1 or 300
	rpmNotch2 = jbeamData.rpmNotch2 or 300
	rpmNotch3 = jbeamData.rpmNotch3 or 330
	rpmNotch4 = jbeamData.rpmNotch4 or 400
	rpmNotch5 = jbeamData.rpmNotch5 or 480
	rpmNotch6 = jbeamData.rpmNotch6 or 570
	rpmNotch7 = jbeamData.rpmNotch7 or 650
	rpmNotch8 = jbeamData.rpmNotch8 or 750
	notchEnabled = jbeamData.notchEnabled or 1
end

local function frontLights()
	oldval = electrics.values.frontheadlights or 0
	oldval_r = electrics.values.frontheadlights_r or 0
	
	if oldval == 0 and oldval_r == 0 then
		electrics.values.frontheadlights = 1
		electrics.values.frontheadlights_r = 1
	elseif oldval == 0 then
		electrics.values.frontheadlights_r = 0
	else 
		electrics.values.frontheadlights = 0
	end
end

local function rearLights()
	roldval = electrics.values.rearheadlights or 0
	roldval_r = electrics.values.rearheadlights_r or 0
	
	if roldval == 0 and roldval_r == 0 then
		electrics.values.rearheadlights = 1
		electrics.values.rearheadlights_r = 1
	elseif roldval == 0 then
		electrics.values.rearheadlights_r = 0
	else 
		electrics.values.rearheadlights = 0
	end
end

local function onReset()
	notch = 0
end

local function throttleUp()
	if notch == 8 then
		notch = notch
	else
		notch = notch + 1
	end
end

local function throttleDown()
	if notch == 0 then
		notch = notch
	else
		notch = notch - 1
	end
end

local function updateGFX(dt)
	if notchEnabled == 1 then
		if notch == 0 then
			throttle = 0
		elseif notch == 1 then
			if electrics.values.rpm < rpmNotch1 then
				throttle = 0.1 * throttleAggressivity
			else
				throttle = 0.01 / throttleDecreaseAggressivity
			end
		elseif notch == 2 then
			if electrics.values.rpm < rpmNotch2 then
				throttle = 0.11 * throttleAggressivity
			else
				throttle = 0.02 / throttleDecreaseAggressivity
			end
		elseif notch == 3 then
			if electrics.values.rpm < rpmNotch3 then
				throttle = 0.12 * throttleAggressivity
			else
				throttle = 0.03 / throttleDecreaseAggressivity
			end
		elseif notch == 4 then
			if electrics.values.rpm < rpmNotch4 then
				throttle = 0.14 * throttleAggressivity
			else
				throttle = 0.04 / throttleDecreaseAggressivity
			end
		elseif notch == 5 then
			if electrics.values.rpm < rpmNotch5 then
				throttle = 0.15 * throttleAggressivity
			else
				throttle = 0.05 / throttleDecreaseAggressivity
			end	
		elseif notch == 6 then
			if electrics.values.rpm < rpmNotch6 then
				throttle = 0.16 * throttleAggressivity
			else
				throttle = 0.06 / throttleDecreaseAggressivity
			end
		elseif notch == 7 then
			if electrics.values.rpm < rpmNotch7 then
				throttle = 0.17 * throttleAggressivity
			else
				throttle = 0.07 / throttleDecreaseAggressivity
			end
		elseif notch == 8 then
			if electrics.values.rpm < rpmNotch8 then
				throttle = 0.18 * throttleAggressivity
			else
				throttle = 0.07 / throttleDecreaseAggressivity
			end
		end
		electrics.values.notch = notch
		electrics.values.throttle = throttle
	elseif notchEnabled == 0 then

	end
end

M.init = init
M.onReset = onReset
M.updateGFX = updateGFX
M.frontLights = frontLights
M.rearLights = rearLights
M.throttleUp = throttleUp
M.throttleDown = throttleDown

return M