-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local helper = require('scenario/scenariohelper')
local logTag = 'crestRoadAutobello'

local finalWaypointName = 'scenario_wpEnd'
local finalTriggerName = 'finishTrigger'
local playerInstance = 'scenario_player0'
local aiInstance = 'scenario_ai0'
local playerWon = false
local playerSpecialWin = false
local aiWon = false
local tooFar = false
local aiFinished = false
local damageFail = false
local running = false

local distance = 0
local playerDamage = 0
local aiDamage = 0

local messageText = ""
local lastMessage = ""

local function reset()
  running = false
  playerWon = false
  playerSpecialWin = false
  aiWon = false
  tooFar = false
  damageFail = false
  aiFinished = false
  playerDamage = 0
  aiDamage = 0
  distance = 0
  lastMessage = ""
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function success(reason)
  scenario_scenarios.finish({msg = reason})
  reset()
end

local function onRaceResult(outcome)

  scenetree.findObject(aiInstance):queueLuaCommand('ai.stopFollowing()')

  if aiWon or tooFar then
    fail('scenarios.italy.crestRoadAutobello.fail.msg')
  end
  if damageFail then
    fail('scenarios.italy.crestRoadAutobello.damage.msg')
  end
  if playerWon then
    success('scenarios.italy.crestRoadAutobello.win.msg')
  end
  if playerSpecialWin then
    success('scenarios.italy.crestRoadAutobello.win.overtake.msg')
  end
end

local function onCountdownStarted()
  reset()

  -- Start the ai
  local aiData = jsonReadFile('levels/italy_snowy/scenarios/crestRoadAutobello.track.json')
  scenetree.findObject(aiInstance):queueLuaCommand("ai.startFollowing("..serialize(aiData.recording)..")")
end

local function onRaceStart()
  -- log('I', logTag,'onRaceStart called')
  running = true

end

local function onPreRender(dt)

  -- Gets the distance between the 2 cars
  if running == true then
    local playerVehicle = scenetree.findObject(playerInstance)
    local playerVehicleData = map.objects[playerVehicle:getID()]
    playerDamage = playerVehicleData.damage
    local playerVehiclePos = playerVehicle:getPosition()

    local aiVehicle = scenetree.findObject(aiInstance)
    local aiVehicleData = map.objects[aiVehicle:getID()]
    aiDamage = aiVehicleData.damage
    local aiVehiclePos = aiVehicle:getPosition()
    distance = (playerVehiclePos - aiVehiclePos):len()
  end

  -- Fail scenario if player or ai is damaged
  if playerDamage > 10000 or aiDamage > 10000 then
    onRaceResult()
    damageFail = true
  end

  -- Warn player if he's too far behind the ai
  if distance > 200 then
    -- The player loses if the AI is far enough from the player
    tooFar = true
    onRaceResult()
  elseif distance > 50 then
    messageText = "scenarios.italy.crestRoadAutobello.far.msg"
  else
    messageText = ""
  end

  if messageText ~= lastMessage then
    helper.realTimeUiDisplay(messageText)
    lastMessage = messageText
  end
end

local function onRaceWaypointReached(data)
  --log('I', logTag,'onRaceWaypointReached called ')
  --dump(data)

  -- The player wins if he crosses the final waypoint while still being close enough to the AI (distance implied by the scenario failing if AI finishes far enough from player)
  if data.vehicleName == playerInstance and data.waypointName == finalWaypointName then
    if aiFinished then
    playerWon = true
  else --Display special message if player reaches final waypoint before AI
    playerSpecialWin = true
  end
    onRaceResult()
  end
end

local function onBeamNGTrigger(data)
  --log('I', logTag,'onBeamNGTrigger called ')
  --dump(data)

  if data.subjectName == aiInstance and data.triggerName == finalTriggerName and data.event == 'enter' then
    aiFinished = true
    if distance > 50 then -- The player loses if the AI reaches the end of the scenario and is far enough from the player
        aiWon = true
        onRaceResult()
    end
  end
end

M.onCountdownStarted = onCountdownStarted
M.onRaceStart = onRaceStart
M.onPreRender = onPreRender
M.onRaceWaypointReached = onRaceWaypointReached
M.onBeamNGTrigger = onBeamNGTrigger
M.onRaceResult = onRaceResult
return M