-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local running = true
local stop1 = false
local stop2 = false
local result = nil
local tip = false
local tipTime = 500
local scenario
local tipTimer

local playerCarData = nil
local playerSpeed = nil

local helper = require('scenario/scenariohelper')

local function reset()
  running = false
  tip = false
  tipTime = 500
end

local function fail(reason)
  scenario_scenarios.finish({failed = reason})
  reset()
end

local function success(result)
  scenario_scenarios.finish(result)
  reset()
end

local function onRaceStart()
  reset()
  running = true
  scenario = scenario_scenarios.getScenario()
end

local function onRaceTick(raceTickTime)
  if not running then
    return
  end

  playerCarData = map.objects[map.objectNames['scenario_player0']]
  playerSpeed = playerCarData.vel:length()

  if tip == true and scenario.timer > (tipTimer + 1.5) then
    ui_message("scenarios.italy.pizzaDelivery1.tip_horn", 3, 'tip')
    tip = false
  end

  if stop1 == true then
    if playerSpeed <= 0.5 then
      helper.flashUiMessage('scenarios.italy.pizzaDelivery1.customer1', 4)
      stop1 = false
    end
  end

  if stop2 == true then
    if playerSpeed <= 0.5 then
      helper.flashUiMessage('scenarios.italy.pizzaDelivery1.customer2', 4)
      stop2 = false
      tipTimer = scenario.timer
      tip = true
    end
  end
end

local function onRaceWaypointReached( data )

  -- 'Stop' messages and checks for that
  if data.waypointName == 'customer1' then
    ui_message(" ",0.01, 'pizza_delivery') -- Clears the ui message
    helper.flashUiMessage('Stop!', 1.5)
    stop1 = true
  elseif data.waypointName == 'wp4' then
    if stop1 == true then
      fail("scenarios.italy.pizzaDelivery1.fail_stop")
    end
  elseif data.waypointName == 'customer2' then
    ui_message(" ",0.01, 'pizza_delivery') -- Clears the ui message
    helper.flashUiMessage('Stop!', 1.5)
    stop2 = true
  elseif data.waypointName == 'wp12' then
    if stop2 == true then
      fail("scenarios.italy.pizzaDelivery1.fail_stop")
    end
  elseif data.waypointName == 'customer3' then
    ui_message(" ",0.01, 'pizza_delivery') -- Clears the ui message
    scenario = scenario_scenarios.getScenario()
    if scenario.timer >= 110 then
      result = {msg = 'scenarios.italy.pizzaDelivery1.success_slow'}
      success(result)
    elseif scenario.timer < 110 then
      result = {msg = 'scenarios.italy.pizzaDelivery1.success_fast'}
      success(result)
    end
  
  -- 'Think about stopping' messages
  elseif data.waypointName == 'wp2' or data.waypointName == 'wp3' or data.waypointName == 'wp18' then
    ui_message("scenarios.italy.pizzaDelivery1.tip_stop", 10, 'pizza_delivery', nil)
  
  end
  
end

M.onRaceStart = onRaceStart
M.onRaceWaypointReached = onRaceWaypointReached
M.onRaceTick = onRaceTick

return M