local M = {}

local oldLightsValue = nil

local function setAllLightsEnabled(group, lightsValue)
    for i = 0, group.obj:getCount(), 1 do
        local id = group.obj:idAt(i)
        local obj = scenetree.findObjectById(id)
        if obj and obj.obj:isSubClassOf('LightBase') then
            obj.obj:setLightEnabled(lightsValue)
        end
    end
end

local function printTest()
    print('test')
end

local function onUpdate()
    local tod = scenetree.tod
    if not tod then return end

    local lightsValue = false
    if tod.time > 0.21 and tod.time < 0.77 then
        lightsValue = true
    end

    if oldLightsValue == lightsValue then return end
    oldLightsValue = lightsValue

    if scenetree.dynamic_lights then
      setAllLightsEnabled(scenetree.dynamic_lights, lightsValue)
    end
end

M.onUpdate = onUpdate

return M