//-----------------------------------------------------------------------------
// Copyright (c) 2012 GarageGames, LLC
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//-----------------------------------------------------------------------------

// This is the default save location for any TSForestItemData(s) created in the
// Forest Editor Editor (this script is executed from onServerCreated())

datablock TSForestItemData(tree_oak_chopped_a)
{
   internalName = "tree_oak_chopped_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_chopped_a.dae";
   tightnessCoefficient = "1";
   windScale = "0";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(tree_oak_chopped_b)
{
   internalName = "tree_oak_chopped_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_chopped_b.dae";
   tightnessCoefficient = "1";
   windScale = "0";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(tree_oak_bush_a)
{
   internalName = "tree_oak_bush_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_bush_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.3";
   trunkBendScale = "0.05";
   branchAmp = "0";
   detailAmp = "1";
   detailFreq = "0.3";
};

datablock TSForestItemData(tree_oak_bush_c)
{
   internalName = "tree_oak_bush_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_bush_c.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "1";
   detailFreq = "0.3";
};


datablock TSForestItemData(tree_oak_large_a)
{
   internalName = "tree_oak_large_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_large_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "4";
   radius = "1";
};



datablock TSForestItemData(tree_oak_large_c)
{
   internalName = "tree_oak_large_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_large_c.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "4";
   radius = "1";
};

datablock TSForestItemData(tree_oak_bush_b)
{
   internalName = "tree_oak_bush_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_bush_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "4";
   radius = "1";
};


datablock TSForestItemData(tree_oak_sml_a)
{
   internalName = "tree_oak_sml_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_sml_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "4";
   radius = "1";
};


datablock TSForestItemData(tree_oak_forest_a)
{
   internalName = "tree_oak_forest_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_forest_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "4";
   radius = "1";
};

datablock TSForestItemData(tree_oak_large_b)
{
   internalName = "tree_oak_large_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_large_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "8";
   radius = "1";
};

datablock TSForestItemData(tree_oak_forest_group)
{
   internalName = "tree_oak_forest_group";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_forest_group.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "4";
   radius = "1";
};

datablock TSForestItemData(tree_oak_sml_b)
{
   internalName = "tree_oak_sml_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_sml_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "4";
   radius = "1";
};

datablock TSForestItemData(tree_oak_forest_b)
{
   internalName = "tree_oak_forest_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_forest_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "4";
   radius = "1";
};

datablock TSForestItemData(tree_oak_dead_a)
{
   internalName = "tree_oak_dead_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_dead_a.dae";
   radius = "2";
   windScale = "0.4";
};

datablock TSForestItemData(tree_oak_dead_b)
{
   internalName = "tree_oak_dead_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_dead_b.dae";
   windScale = "0.4";
};

datablock TSForestItemData(tree_oak_blocker_a)
{
   internalName = "tree_oak_blocker_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_oak/tree_oak_blocker_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1";
   detailFreq = "0.6";
   rigidity = "10";
   mass = "5";
   dampingCoefficient = "4";
   radius = "1";
};

datablock TSForestItemData(grass_field_large)
{
   internalName = "grass_field_large";
   shapeFile = "levels/test_track/art/shapes/groundcover/grass_field_large.dae";
   radius = "0.4";
   rigidity = "5";
   tightnessCoefficient = "4";
   windScale = "0.6";
   trunkBendScale = "0.1";
   detailAmp = "0.4";
   detailFreq = "0.4";
   collidable = "0";
};

datablock TSForestItemData(grass_field_sml)
{
   internalName = "grass_field_sml";
   shapeFile = "levels/test_track/art/shapes/groundcover/grass_field_sml.dae";
   radius = "0.2";
   tightnessCoefficient = "4";
   windScale = "0.5";
   trunkBendScale = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   collidable = "0";
};

datablock TSForestItemData(grass_field_long)
{
   internalName = "grass_field_long";
   shapeFile = "levels/test_track/art/shapes/groundcover/grass_field_long.dae";
   tightnessCoefficient = "4";
   windScale = "0.6";
   trunkBendScale = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
};

datablock TSForestItemData(grass_field_filler)
{
   internalName = "grass_field_filler";
   shapeFile = "levels/test_track/art/shapes/groundcover/grass_field_filler.dae";
   tightnessCoefficient = "4";
   windScale = "0.6";
   trunkBendScale = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_aspen_chopped)
{
   internalName = "tree_aspen_chopped";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_chopped.dae";
   tightnessCoefficient = "4";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   radius = "0.2";
};

datablock TSForestItemData(tree_aspen_overhang_a)
{
   internalName = "tree_aspen_overhang_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_overhang_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.6";
   trunkBendScale = "0";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(tree_aspen_large_b)
{
   internalName = "tree_aspen_large_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_large_b.dae";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   tightnessCoefficient = "4";
   windScale = "0.6";
};

datablock TSForestItemData(tree_aspen_forest_b)
{
   internalName = "tree_aspen_forest_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_forest_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   trunkBendScale = "0.03";
};

datablock TSForestItemData(tree_aspen_forest_a)
{
   internalName = "tree_aspen_forest_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_forest_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   trunkBendScale = "0.03";
};

datablock TSForestItemData(tree_aspen_forest_group)
{
   internalName = "tree_aspen_forest_group";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_forest_group.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   trunkBendScale = "0.03";
};

datablock TSForestItemData(tree_aspen_small_a)
{
   internalName = "tree_aspen_small_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_small_a.dae";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   tightnessCoefficient = "4";
   windScale = "0.4";
   radius = "0.2";
};

datablock TSForestItemData(tree_aspen_small_b)
{
   internalName = "tree_aspen_small_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_small_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(tree_aspen_small_c)
{
   internalName = "tree_aspen_small_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_small_c.dae";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   tightnessCoefficient = "4";
   windScale = "0.4";
};

datablock TSForestItemData(tree_aspen_small_d)
{
   internalName = "tree_aspen_small_d";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_small_d.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(tree_aspen_bush_c)
{
   internalName = "tree_aspen_bush_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_bush_c.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.3";
};

datablock TSForestItemData(tree_aspen_bush_a)
{
   internalName = "tree_aspen_bush_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_bush_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.3";
   radius = "0.5";
};

datablock TSForestItemData(tree_aspen_bush_b)
{
   internalName = "tree_aspen_bush_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_bush_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.3";
   radius = "0.5";
};

datablock TSForestItemData(tree_aspen_large_a)
{
   internalName = "tree_aspen_large_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_large_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.02";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   mass = "50";
   radius = "0.5";
};

datablock TSForestItemData(tree_aspen_wall)
{
   internalName = "tree_aspen_wall";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_wall.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.02";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   mass = "50";
   radius = "0.5";
};



datablock TSForestItemData(vine_ground_medium)
{
   internalName = "vine_ground_medium";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_ground_medium.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   detailAmp = "0.1";
   detailFreq = "0.5";
   radius = "0.5";
};

datablock TSForestItemData(vine_bush_wide)
{
   internalName = "vine_bush_wide";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_bush_wide.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   radius = "0.8";
};

datablock TSForestItemData(vine_bush_large)
{
   internalName = "vine_bush_large";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_bush_large.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_ground_large)
{
   internalName = "vine_ground_large";
   shapeFile = "levels/test_track/art/shapes/trees/vine/vine_ground_large.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_ground_large)
{
   internalName = "vine_ground_large";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_ground_large.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   radius = "0.5";
   trunkBendScale = "0.1";
};

datablock TSForestItemData(vine_wall_wide_b)
{
   internalName = "vine_wall_wide_b";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_wall_wide_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.3";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_wall_small)
{
   internalName = "vine_wall_small";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_wall_small.dae";
   tightnessCoefficient = "4";
   windScale = "0.3";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   radius = "0.4";
};

datablock TSForestItemData(vine_wall_medium)
{
   internalName = "vine_wall_medium";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_wall_medium.dae";
   tightnessCoefficient = "4";
   windScale = "0.3";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_wall_large)
{
   internalName = "vine_wall_large";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_wall_large.dae";
   tightnessCoefficient = "4";
   windScale = "0.3";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   radius = "0.2";
   trunkBendScale = "0.1";
};

datablock TSForestItemData(vine_ground_small)
{
   internalName = "vine_ground_small";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_ground_small.dae";
   tightnessCoefficient = "4";
   windScale = "0.3";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   radius = "0.5";
};

datablock TSForestItemData(vine_bush_small)
{
   internalName = "vine_bush_small";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_bush_small.dae";
   radius = "0.5";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_bush_wide_b)
{
   internalName = "vine_bush_wide_b";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_bush_wide_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_roof_wide)
{
   internalName = "vine_roof_wide";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_roof_wide.dae";
   tightnessCoefficient = "4";
   windScale = "0.3";
   trunkBendScale = "0";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_roof_small)
{
   internalName = "vine_roof_small";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_roof_small.dae";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0.6";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(vine_roof_end)
{
   internalName = "vine_roof_end";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_roof_end.dae";
   windScale = "0.4";
   trunkBendScale = "0.02";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_2m)
{
   internalName = "vine_side_2m";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_side_2m.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_4m)
{
   internalName = "vine_side_4m";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_side_4m.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_8m)
{
   internalName = "vine_side_8m";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_side_8m.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_side_1m)
{
   internalName = "vine_side_1m";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_side_1m.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(vine_wall_wide_a)
{
   internalName = "vine_wall_wide_a";
   shapeFile = "levels/test_track/art/shapes/trees/vines/vine_wall_wide_a.dae";
   radius = "0.5";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(lush_ferns_01)
{
   internalName = "lush_ferns_01";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_ferns_01_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.1";
   detailAmp = "0.04";
   detailFreq = "1";
   radius = "0.3";
};

datablock TSForestItemData(lush_ferns_02_a)
{
   internalName = "lush_ferns_02_a";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_ferns_02_b.dae";
   radius = "0.2";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.1";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(lush_big_a)
{
   internalName = "lush_big_a";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_big_a.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.5";
   radius = "0.2";
};

datablock TSForestItemData(lush_big_b)
{
   internalName = "lush_big_b";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_big_b.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.1";
   detailFreq = "0.5";
   radius = "0.2";
};

datablock TSForestItemData(lush_general_01_b)
{
   internalName = "lush_general_01_b";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_general_01_b.dae";
   radius = "0.2";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.05";
   detailAmp = "0.1";
   detailFreq = "0.2";
};

datablock TSForestItemData(lush_general_01_c)
{
   internalName = "lush_general_01_c";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_general_01_c.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.05";
   detailAmp = "0.2";
   detailFreq = "0.2";
   radius = "0.2";
};

datablock TSForestItemData(lush_general_01_d)
{
   internalName = "lush_general_01_d";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_general_01_d.dae";
   radius = "0.2";
   tightnessCoefficient = "4";
   windScale = "0.4";
   branchAmp = "0.05";
   detailAmp = "0.2";
   detailFreq = "0.2";
};

datablock TSForestItemData(lush_general_01_e)
{
   internalName = "lush_general_01_e";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_general_01_e.dae";
   tightnessCoefficient = "4";
   windScale = "0.4";
   detailAmp = "0.5";
   detailFreq = "0.5";
   radius = "0.2";
};

datablock TSForestItemData((null))
{
   internalName = "(null)";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_general_01_a.dae";
   windScale = "0.4";
   branchAmp = "0.02";
   detailAmp = "0.1";
   detailFreq = "0.2";
   radius = "0.2";
   tightnessCoefficient = "4";
};

datablock TSForestItemData(lush_ferns_01_a)
{
   internalName = "lush_ferns_01_a";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_ferns_01_a.dae";
   radius = "0.4";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.05";
   detailAmp = "0.3";
   detailFreq = "0.3";
};

datablock TSForestItemData(lush_ferns_01_b)
{
   internalName = "lush_ferns_01_b";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_ferns_01_b.dae";
   radius = "0.2";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.05";
   detailAmp = "0.3";
   detailFreq = "0.3";
};

datablock TSForestItemData(lush_ferns_02_b)
{
   internalName = "lush_ferns_02_b";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_ferns_02_b.dae";
   radius = "0.4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.05";
   detailAmp = "0.3";
   detailFreq = "0.3";
};

datablock TSForestItemData(lush_grass_01_a)
{
   internalName = "lush_grass_01_a";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_grass_01_a.dae";
   radius = "0.2";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.05";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(lush_grass_01_c)
{
   internalName = "lush_grass_01_c";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_grass_01_c.dae";
   radius = "0.2";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.05";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(lush_grass_01_b)
{
   internalName = "lush_grass_01_b";
   shapeFile = "levels/test_track/art/shapes/groundcover/lush_grass_01_b.dae";
   radius = "0.15";
   tightnessCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.1";
   branchAmp = "0.05";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(tree_beech_chopped_a)
{
   internalName = "tree_beech_chopped_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_chopped_a.dae";
   tightnessCoefficient = "1";
   windScale = "0";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(tree_beech_chopped_b)
{
   internalName = "tree_beech_chopped_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_chopped_b.dae";
   tightnessCoefficient = "1";
   windScale = "0";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(tree_beech_large_c)
{
   internalName = "tree_beech_large_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_large_c.dae";
   radius = "0.5";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_overhang_a)
{
   internalName = "tree_beech_overhang_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_overhang_a.dae";
   radius = "0.5";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_small_d)
{
   internalName = "tree_beech_small_d";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_small_d.dae";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_small_c)
{
   internalName = "tree_beech_small_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_small_c.dae";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_small_b)
{
   internalName = "tree_beech_small_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_small_b.dae";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_forest_a)
{
   internalName = "tree_beech_forest_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_forest_a.dae";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_forest_b)
{
   internalName = "tree_beech_forest_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_forest_b.dae";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_forest_group)
{
   internalName = "tree_beech_forest_group";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_forest_group.dae";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_large_b)
{
   internalName = "tree_beech_large_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_large_b.dae";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_bush_c)
{
   internalName = "tree_beech_bush_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_bush_c.dae";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "1.5";
   detailAmp = "0.3";
   detailFreq = "0.4";
   radius = "0.5";
};

datablock TSForestItemData(tree_beech_bush_a)
{
   internalName = "tree_beech_bush_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_bush_a.dae";
   radius = "0.5";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "1.5";
   detailAmp = "0.3";
   detailFreq = "0.3";
};

datablock TSForestItemData(tree_beech_bush_b)
{
   internalName = "tree_beech_bush_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_bush_b.dae";
   radius = "0.5";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.3";
   detailFreq = "0.3";
};

datablock TSForestItemData(oak_beech_wallblocker_long)
{
   internalName = "oak_beech_wallblocker_long";
   shapeFile = "levels/test_track/art/shapes/trees/oak_beech_wallblocker_long.dae";
   radius = "0.6";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.01";
   branchAmp = "0.08";
   detailAmp = "0.5";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_aspen_blocker_a)
{
   internalName = "tree_aspen_blocker_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_blocker_a.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(tree_beech_blocker_a)
{
   internalName = "tree_beech_blocker_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_blocker_a.dae";
   radius = "0.8";
   dampingCoefficient = "4";
   windScale = "0.4";
   trunkBendScale = "0.05";
   branchAmp = "0.5";
   detailAmp = "0.4";
   detailFreq = "0.5";
};

datablock TSForestItemData(tree_beech_dead_a)
{
   internalName = "tree_beech_dead_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_dead_a.dae";
   radius = "0.5";
};

datablock TSForestItemData(tree_beech_dead_b)
{
   internalName = "tree_beech_dead_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_dead_b.dae";
   radius = "0.5";
};

datablock TSForestItemData(tree_aspen_small_low)
{
   internalName = "tree_aspen_small_low";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_small_low.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
   radius = "0.3";
};

datablock TSForestItemData(tree_aspen_small_low_group)
{
   internalName = "tree_aspen_small_low_group";
   shapeFile = "levels/test_track/art/shapes/trees/trees_aspen/tree_aspen_small_low_group.dae";
   radius = "0.5";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.6";
};

datablock TSForestItemData(tree_beech_bush_d)
{
   internalName = "tree_beech_bush_d";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_bush_d.dae";
   radius = "0.7";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.4";
   detailFreq = "0.4";
};

datablock TSForestItemData(tree_beech_bush_e)
{
   internalName = "tree_beech_bush_e";
   shapeFile = "levels/test_track/art/shapes/trees/trees_beech/tree_beech_bush_e.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.2";
   detailAmp = "0.4";
   detailFreq = "0.4";
};

datablock TSForestItemData(rock_01_a_large_b)
{
   internalName = "rock_01_a_large_b";
   shapeFile = "levels/test_track/art/shapes/rocks/rock_01_a_large_b.dae";
   radius = "0.3";
};

datablock TSForestItemData(rock_01_a_large_c)
{
   internalName = "rock_01_a_large_c";
   shapeFile = "levels/test_track/art/shapes/rocks/rock_01_a_large_c.dae";
   radius = "0.3";
};

datablock TSForestItemData(rock_01_a_small_a)
{
   internalName = "rock_01_a_small_a";
   shapeFile = "levels/test_track/art/shapes/rocks/rock_01_a_small_a.dae";
   radius = "0.15";
};

datablock TSForestItemData(rock_01_a_small_b)
{
   internalName = "rock_01_a_small_b";
   shapeFile = "levels/test_track/art/shapes/rocks/rock_01_a_small_b.dae";
   radius = "0.15";
};

datablock TSForestItemData(rock_01_a_small_c)
{
   internalName = "rock_01_a_small_c";
   shapeFile = "levels/test_track/art/shapes/rocks/rock_01_a_small_c.dae";
   radius = "0.15";
};

datablock TSForestItemData(rock_01_a_large_a)
{
   internalName = "rock_01_a_large_a";
   shapeFile = "levels/test_track/art/shapes/rocks/rock_01_a_large_a.dae";
   radius = "0.3";
};

datablock TSForestItemData(tree_palm_a)
{
   internalName = "tree_palm_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_palm/tree_palm_a.dae";
   radius = "0.5";
   windScale = "0.5";
   branchAmp = "0.1";
   detailAmp = "1.5";
   detailFreq = "0.2";
   trunkBendScale = "0.05";
   rigidity = "10";
};

datablock TSForestItemData(tree_palm_b)
{
   internalName = "tree_palm_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_palm/tree_palm_b.dae";
   radius = "0.5";
   windScale = "0.5";
   branchAmp = "0.1";
   detailAmp = "1.5";
   detailFreq = "0.2";
   trunkBendScale = "0.05";
};

datablock TSForestItemData(tree_palm_c)
{
   internalName = "tree_palm_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_palm/tree_palm_c.dae";
   radius = "0.5";
   windScale = "0.5";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1.5";
   detailFreq = "0.2";
};

datablock TSForestItemData(tree_palm_overhang_b)
{
   internalName = "tree_palm_overhang_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_palm/tree_palm_overhang_b.dae";
   windScale = "0.5";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1.5";
   detailFreq = "0.2";
};

datablock TSForestItemData(tree_palm_overhang_a)
{
   internalName = "tree_palm_overhang_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_palm/tree_palm_overhang_a.dae";
   windScale = "0.5";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1.5";
   detailFreq = "0.2";
};

datablock TSForestItemData(tree_palm_e)
{
   internalName = "tree_palm_e";
   shapeFile = "levels/test_track/art/shapes/trees/trees_palm/tree_palm_e.dae";
   radius = "0.5";
   windScale = "0.5";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1.5";
   detailFreq = "0.2";
};

datablock TSForestItemData(tree_palm_f)
{
   internalName = "tree_palm_f";
   shapeFile = "levels/test_track/art/shapes/trees/trees_palm/tree_palm_f.dae";
   windScale = "0.5";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1.5";
   detailFreq = "0.2";
   radius = "0.3";
};

datablock TSForestItemData(tree_palm_d)
{
   internalName = "tree_palm_d";
   shapeFile = "levels/test_track/art/shapes/trees/trees_palm/tree_palm_d.dae";
   radius = "0.5";
   windScale = "0.5";
   trunkBendScale = "0.05";
   branchAmp = "0.1";
   detailAmp = "1.5";
   detailFreq = "0.2";
};

datablock TSForestItemData(ind_rubbish_01_a)
{
   internalName = "ind_rubbish_01_a";
   shapeFile = "levels/test_track/art/shapes/buildings/ind_rubbish_01_a.dae";
   radius = "0.1";
};

datablock TSForestItemData(coastrock_dark_b)
{
   internalName = "coastrock_dark_b";
   shapeFile = "levels/test_track/art/shapes/rocks/coastrock_dark_b.dae";
};

datablock TSForestItemData(coastrock_dark_c)
{
   internalName = "coastrock_dark_c";
   shapeFile = "levels/test_track/art/shapes/rocks/coastrock_dark_c.dae";
};

datablock TSForestItemData(coastrock_dark_d)
{
   internalName = "coastrock_dark_d";
   shapeFile = "levels/test_track/art/shapes/rocks/coastrock_dark_d.dae";
};

datablock TSForestItemData(coastrock_dark_a)
{
   internalName = "coastrock_dark_a";
   shapeFile = "levels/test_track/art/shapes/rocks/coastrock_dark_a.dae";
};

datablock TSForestItemData(DRI_rock_b)
{
   internalName = "DRI_rock_b";
   shapeFile = "levels/test_track/art/shapes/rocks/DRI_rock_b.dae";
};

datablock TSForestItemData(DRI_rock_a)
{
   internalName = "DRI_rock_a";
   shapeFile = "levels/test_track/art/shapes/rocks/DRI_rock_a.dae";
};

datablock TSForestItemData(DRI_rock_c)
{
   internalName = "DRI_rock_c";
   shapeFile = "levels/test_track/art/shapes/rocks/DRI_rock_c.dae";
};

datablock TSForestItemData(DRI_rock_d)
{
   internalName = "DRI_rock_d";
   shapeFile = "levels/test_track/art/shapes/rocks/DRI_rock_d.dae";
};

datablock TSForestItemData(DRI_rock_e)
{
   internalName = "DRI_rock_e";
   shapeFile = "levels/test_track/art/shapes/rocks/DRI_rock_e.dae";
};

datablock TSForestItemData(DRI_rock_g)
{
   internalName = "DRI_rock_g";
   shapeFile = "levels/test_track/art/shapes/rocks/DRI_rock_g.dae";
   radius = "0.5";
};

datablock TSForestItemData(DRI_rock_f)
{
   internalName = "DRI_rock_f";
   shapeFile = "levels/test_track/art/shapes/rocks/DRI_rock_f.dae";
   radius = "0.5";
};

datablock TSForestItemData(tree_douglasfir_chopped)
{
   internalName = "tree_douglasfir_chopped";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_chopped.dae";
   tightnessCoefficient = "1";
   windScale = "0";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(tree_douglasfir_dead)
{
   internalName = "tree_douglasfir_dead";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_dead.dae";
   tightnessCoefficient = "1";
   windScale = "0.3";
   trunkBendScale = "0";
   branchAmp = "0.1";
   detailAmp = "0.3";
   detailFreq = "0.3";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_large_a)
{
   internalName = "tree_douglasfir_large_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_large_a.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_large_b)
{
   internalName = "tree_douglasfir_large_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_large_b.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_large_c)
{
   internalName = "tree_douglasfir_large_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_large_c.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_large_d)
{
   internalName = "tree_douglasfir_large_d";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_large_d.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_small_a)
{
   internalName = "tree_douglasfir_small_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_small_a.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_small_b)
{
   internalName = "tree_douglasfir_small_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_small_b.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_small_c)
{
   internalName = "tree_douglasfir_small_c";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_small_c.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_small_d)
{
   internalName = "tree_douglasfir_small_d";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_small_d.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_bush_a)
{
   internalName = "tree_douglasfir_bush_a";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_bush_a.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_bush_b)
{
   internalName = "tree_douglasfir_bush_b";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_bush_b.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.04";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(tree_douglasfir_group)
{
   internalName = "tree_douglasfir_group";
   shapeFile = "levels/test_track/art/shapes/trees/trees_douglasfir/tree_douglasfir_group.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
};

datablock TSForestItemData(undergrowth_eca_large_a)
{
   internalName = "undergrowth_eca_large_a";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_large_a.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(eca_bld_house_01_a)
{
   internalName = "eca_bld_house_01_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_01_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_02_a)
{
   internalName = "eca_bld_house_02_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_02_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_03_a)
{
   internalName = "eca_bld_house_03_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_03_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_04_a)
{
   internalName = "eca_bld_house_04_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_04_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_05_a)
{
   internalName = "eca_bld_house_05_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_05_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_05_b)
{
   internalName = "eca_bld_house_05_b";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_05_b.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_05_c)
{
   internalName = "eca_bld_house_05_c";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_05_c.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_05_d)
{
   internalName = "eca_bld_house_05_d";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_05_d.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_05_e)
{
   internalName = "eca_bld_house_05_e";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_05_e.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_sml_01)
{
   internalName = "eca_bld_house_sml_01";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_sml_01.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_house_sml_02)
{
   internalName = "eca_bld_house_sml_02";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_house_sml_02.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_filler_wall_01)
{
   internalName = "eca_bld_filler_wall_01";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_filler_wall_01.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_grocerystore)
{
   internalName = "eca_bld_grocerystore";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_grocerystore.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_ornate_01)
{
   internalName = "eca_bld_ornate_01";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_ornate_01.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_shop_town_a)
{
   internalName = "eca_bld_shop_town_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_shop_town_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_shop_town_b)
{
   internalName = "eca_bld_shop_town_b";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_shop_town_b.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_shop_town_bwhite)
{
   internalName = "eca_bld_shop_town_bwhite";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_shop_town_bwhite.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_shop_town_c)
{
   internalName = "eca_bld_shop_town_c";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_shop_town_c.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_shop_town_d)
{
   internalName = "eca_bld_shop_town_d";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_shop_town_d.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_shop_town_e)
{
   internalName = "eca_bld_shop_town_e";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_shop_town_e.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_shop_town_f)
{
   internalName = "eca_bld_shop_town_f";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_shop_town_f.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_station_police_a)
{
   internalName = "eca_bld_station_police_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_station_police_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_store_fish_a)
{
   internalName = "eca_bld_store_fish_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_store_fish_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_warehouse_01_a)
{
   internalName = "eca_bld_warehouse_01_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_warehouse_01_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_bld_warehouse_02_a)
{
   internalName = "eca_bld_warehouse_02_a";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_bld_warehouse_02_a.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};

datablock TSForestItemData(eca_drain_12m)
{
   internalName = "eca_drain_12m";
   shapeFile = "levels/test_track/art/shapes/buildings/eca/eca_drain_12m.dae";
   radius = ".8";
   dampingCoefficient = "0";
   windScale = "0";
   trunkBendScale = "0";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
};



datablock TSForestItemData(undergrowth_eca_med_a)
{
   internalName = "undergrowth_eca_med_a";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_test.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(undergrowth_eca_med_b)
{
   internalName = "undergrowth_eca_med_b";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_test.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(undergrowth_eca_med_c)
{
   internalName = "undergrowth_eca_med_c";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_test.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(undergrowth_eca_med_single)
{
   internalName = "undergrowth_eca_med_single";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_test.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(undergrowth_eca_small_a)
{
   internalName = "undergrowth_eca_small_a";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_test.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(undergrowth_eca_small_b)
{
   internalName = "undergrowth_eca_small_b";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_test.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(undergrowth_eca_tiny_a)
{
   internalName = "undergrowth_eca_tiny_a";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_test.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(undergrowth_eca_tiny_b)
{
   internalName = "undergrowth_eca_tiny_b";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_test.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};

datablock TSForestItemData(undergrowth_eca_test)
{
   internalName = "undergrowth_eca_test";
   shapeFile = "levels/test_track/art/shapes/trees/undergrowth_eca/undergrowth_eca_test.dae";
   tightnessCoefficient = "1";
   windScale = "0.5";
   trunkBendScale = "0.01";
   branchAmp = "0.1";
   detailAmp = "0.5";
   detailFreq = "0.5";
   rigidity = "5";
   radius = "0.3";
};
