local M = {}

local running = true
local helper = require('scenario/scenariohelper')

local function reset()
    running = false
end

local function fail(reason)
    scenario_scenarios.finish({failed = reason})
    reset()
end

local function onRaceStart()
    reset()
    helper.trackVehicle('scenario_player0', 'playerCar')
    running = true
end

local function onRaceTick(raceTickTime)
    if not running then
        return
    end
    local playerCarData = map.objects[map.objectNames['playerCar']]
    if not playerCarData then
        return
    end
    if playerCarData.damage >= 3000 then
        fail("You have damaged the ambulance!")
    end
end

M.onRaceStart = onRaceStart
M.onRaceTick = onRaceTick

return M