local M = {}

local timer = 0.0
local nextUpdateTime = 0.0
local previousSunElevation = 0.0
local previousCloudsCoverage = 0.0
local previousCloudsCoverageCoefficient = 0.0
local areLightsEnabled = false

local function onUpdate(dt)
	timer = timer + dt
	if timer >= nextUpdateTime then
		if scenetree.sunsky then
			local hasSunElevationChanged = previousSunElevation ~= scenetree.sunsky.elevation
			local cloudsCoverageCoefficient
			if scenetree.clouds_1 then
				if hasSunElevationChanged or previousCloudsCoverage ~= scenetree.clouds_1.coverage then
					cloudsCoverageCoefficient = math.max(math.min(math.min(scenetree.clouds_1.coverage / 5.0, 0.25 + (math.abs(scenetree.sunsky.elevation) / 8.0) ^ 2.5), 1.0), 0.0)
					scenetree.clouds_1.exposure = math.max(math.min(0.1 + 1.4 * (scenetree.sunsky.elevation + 2.5) / 2.0 * (1.2 - cloudsCoverageCoefficient) ^ 3.5, 1.5), 0.1)
					scenetree.clouds_1:postApply()
					previousCloudsCoverage = scenetree.clouds_1.coverage
				else
					cloudsCoverageCoefficient = previousCloudsCoverageCoefficient
				end
			else
				cloudsCoverageCoefficient = 0.0
			end
			if hasSunElevationChanged or previousCloudsCoverageCoefficient ~= cloudsCoverageCoefficient then
				scenetree.sunsky.rayleighScattering = math.max(math.min(math.max(1.0 - (scenetree.sunsky.elevation + 8.0) / 16.0, cloudsCoverageCoefficient * 0.25) * 0.006 + 0.004, 0.01), 0.004)
				scenetree.sunsky.shadowSoftness = math.max(math.min(cloudsCoverageCoefficient ^ 1.25 * 3.9 + 0.1, 4.0), 0.25)
				scenetree.sunsky.flareScale = math.max(math.min((1.0 - cloudsCoverageCoefficient) ^ 4.0 * 4.0, 4.0), 0.0)
				scenetree.sunsky.skyBrightness = math.max(math.min((1.0 - cloudsCoverageCoefficient) ^ 0.75 * 45.0 + 15.0, 60.0), 15.0)
				scenetree.sunsky.exposure = math.max(math.min((1.0 - cloudsCoverageCoefficient) ^ 0.75 * 0.5 + 0.5, 1.0), 0.5)
				scenetree.sunsky.brightness = math.max(math.min((1.0 - cloudsCoverageCoefficient) ^ 0.75 * 0.8 + 0.2, 1.0), 0.2)
				scenetree.sunsky:postApply()
				local brightnessCoefficient = math.max(math.min((scenetree.sunsky.elevation + 2.0) / 22.0, 1.0), 0.1) * math.max(math.min((1.0 - cloudsCoverageCoefficient) ^ 0.5 + 0.2, 1.0), 0.2)
				local shouldLightsBeEnabled = brightnessCoefficient < 0.4
				if areLightsEnabled ~= shouldLightsBeEnabled then 
					areLightsEnabled = shouldLightsBeEnabled
					if scenetree.DynamicLights then
						for i = 0, scenetree.DynamicLights.obj:getCount(), 1 do
							local light = scenetree.findObjectById(scenetree.DynamicLights.obj:idAt(i))
							if light and light.obj:isSubClassOf('LightBase') then
								light.obj:setLightEnabled(areLightsEnabled)
							end
						end
					end
				end
				local caveBrightnessCoefficient = brightnessCoefficient * 0.15
				TorqueScript.eval('Cave1Zone1.ambientLightColor = "'..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' 0.75";')
				TorqueScript.eval('Cave1Zone6.ambientLightColor = "'..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' 0.75";')
				TorqueScript.eval('Cave1Zone7.ambientLightColor = "'..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' 0.75";')
				TorqueScript.eval('Cave1Zone8.ambientLightColor = "'..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' 0.75";')
				TorqueScript.eval('Cave1Zone2.ambientLightColor = "'..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' 0.95";')
				TorqueScript.eval('Cave1Zone3.ambientLightColor = "'..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' 0.95";')
				TorqueScript.eval('Cave1Zone4.ambientLightColor = "'..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' 0.95";')
				TorqueScript.eval('Cave1Zone5.ambientLightColor = "'..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' '..caveBrightnessCoefficient..' 0.95";')
				if scenetree.theLevelInfo then
					scenetree.theLevelInfo.canvasClearColor = ColorI(scenetree.sunsky.fogScale.x * brightnessCoefficient * 255, scenetree.sunsky.fogScale.y * brightnessCoefficient * 255, scenetree.sunsky.fogScale.z * brightnessCoefficient * 255, 255)
					scenetree.theLevelInfo:postApply()
				end
				previousSunElevation = scenetree.sunsky.elevation
				previousCloudsCoverageCoefficient = cloudsCoverageCoefficient
			end
		end
		nextUpdateTime = timer + 0.05
	end
end

M.onUpdate = onUpdate

return M