local M = {}
local im = ui_imgui
local wndName = '2k_graphics'
local isRain, isSnow
local cubemapname = "Lo_Trees_Cubemap"
local tod, sunsky, clouds, theLevelInfo
local fogDenOriginal
local userRaysEnabled = TorqueScriptLua.getVar('$LightRayPostFX::Enable')

local lightVal, shadowVal
local lightButton, resButton = 2, 1
local brightSlider = im.FloatPtr(5)
local lightSetting = { [0] = " OFF ", [1] = " LOW", [2] = "HIGH" }
local resSetting = { [0] = 512, [1] = 1024, [2] = 2048 }

if TorqueScriptLua.getVar('$pref::Video::ShaderQualityGroup') ~= "High" then lightButton = 1 resButton = 0 end
if lightButton >= 1 then lightVal = true else lightVal = false shadowVal = false end
if lightButton == 2 then shadowVal = true end


local function setThemeDark()
    im.PushStyleColor2(im.Col_Text, im.ImVec4(1.0, 1.0, 1.0, 1.0))

    im.PushStyleColor2(im.Col_TitleBg, im.ImVec4(0.0, 0.0, 0.0, 0.4))
    im.PushStyleColor2(im.Col_Border, im.ImVec4(0.0, 0.0, 0.0, 0.2))
    im.PushStyleColor2(im.Col_FrameBg, im.ImVec4(0.0, 0.0, 0.0, 0.5))
    im.PushStyleColor2(im.Col_Button, im.ImVec4(0.0, 0.0, 0.0, 0.5))
    im.PushStyleColor2(im.Col_WindowBg, im.ImVec4(0.0, 0.0, 0.0, 0.4))

    im.PushStyleColor2(im.Col_TitleBgActive, im.ImVec4(0.0, 0.0, 0.0, 1.0))
    im.PushStyleColor2(im.Col_FrameBgActive, im.ImVec4(0.0, 0.0, 0.0, 1.0))
    im.PushStyleColor2(im.Col_ButtonActive, im.ImVec4(0.0, 0.0, 0.0, 1.0))

    im.PushStyleColor2(im.Col_ButtonHovered, im.ImVec4(0.0, 0.0, 0.0, 1.0))
    im.PushStyleColor2(im.Col_FrameBgHovered, im.ImVec4(0.0, 0.0, 0.0, 1.0))

    im.PushStyleColor2(im.Col_TitleBgCollapsed, im.ImVec4(0.0, 0.0, 0.0, 0.0))
end
setThemeDark()

local function lightEnabled(group, bool)
    if group then
        for i = 0, group.obj:getCount(), 1 do
            scenetree.findObjectById(group.obj:idAt(i)).isEnabled = bool
        end
    end
end

local function lightShadows(group, bool)
    if group then
        for i = 0, group.obj:getCount(), 1 do
            scenetree.findObjectById(group.obj:idAt(i)).castShadows = bool
        end
    end
end

local function dropSize(group, f, o)
    if group then
        for i = 0, group.obj:getCount(), 1 do
            scenetree.findObjectById(group.obj:idAt(i)).dropSize = ((o * f * 0.5) + (o * 0.5))
        end
    end
end

local function nightColor(f, b)
    sunsky = scenetree.sunsky
    clouds = scenetree.clouds
    local c = (0.85 * f) + 0.15
    if isRain then dropSize(scenetree.Rain, f, 0.7)
    elseif isSnow then dropSize(scenetree.Snow, f, 1.5)
    end

    sunsky.logWeight = (0.09 * f) + 0.9
    core_environment.setNightGradientFile("")
    sunsky.nightColor = Point4F(b, b, b, 1.0)
    clouds.baseColor = Point4F(c, c, c, 1.0)
end

local function nightValues(tod, lightVal, shadowVal, bright)
    local LRPFX = scenetree.findObject("LightRayPostFX")
    local sunsky = scenetree.sunsky
    local time = tod.time
    local frac

    if time > 0.25 and time < 0.75 then -- is Night
        LRPFX.isEnabled = false
        lightEnabled(scenetree.Spotlights, lightVal)
        lightEnabled(scenetree.Pointlights, lightVal)
        lightShadows(scenetree.Spotlights, shadowVal)
        sunsky.castShadows = false
    else
        LRPFX.isEnabled = userRaysEnabled
        lightEnabled(scenetree.Spotlights, false)
        lightEnabled(scenetree.Pointlights, false)
        sunsky.castShadows = not (isRain ~= nil and isRain)
    end

    if time <= 0.20 or time >= 0.80 then frac = 1.0
    elseif time >= 0.3 and time <= 0.7 then frac = 0.0
    elseif time > 0.20 and time < 0.30 then frac = (0.30 - time) / 0.1
    elseif time > 0.70 and time < 0.80 then frac = (0.70 - time) / -0.1
    end
    nightColor(frac, bright)
end

local function getWeather()
    theLevelInfo = scenetree.theLevelInfo
    if isRain == nil and isSnow == nil then 
        isRain = scenetree.Rain 
        isSnow = scenetree.Snow 
    end -- is map Snow or Rain?
    if isRain then
        if tostring(theLevelInfo.globalEnviromentMap) ~= cubemapname then 
            theLevelInfo:setField('globalEnviromentMap', 0, cubemapname) 
            theLevelInfo:postApply() 
        end
    end
    if isSnow then 
    end 
end

local gui_module = require("ge/extensions/editor/api/gui") -- we require the gui module from editor
local gui = { -- otherwise referred to as editor in game files
    setupEditorGuiTheme = nop
}

local function drawBeginWindow()

    local l = lightSetting[lightButton]
    local r = resSetting[resButton]
    scenetree.sunsky.texSize = r

    if gui.beginWindow(wndName, "Graphics Control",im.WindowFlags_AlwaysAutoResize) then
        if im.IsItemHovered() then
            im.BeginTooltip() im.Text("Use ALT+U to toggle UI") im.EndTooltip()
        end
        im.PushItemWidth(170)

        if im.SliderFloat("##Light", brightSlider, 1, 10, "Night Brightness: %.0f0%%") then sunsky:postApply() end im.Separator()

        im.Text("Streetlight Quality:") im.SameLine()
        if im.Button(l .. "##light") then
            lightButton = (lightButton + 1) % 3
            if lightButton >= 1 then lightVal = true else lightVal = false shadowVal = false end
            if lightButton == 2 then shadowVal = true end
        end
        
        im.Text("Shadow Resolution:") im.SameLine()
        if im.Button(r .. "##shadowres") then
            resButton = (resButton + 1) % 3
        end
        
        if im.IsItemHovered() and resButton == 2 then 
            im.BeginTooltip() im.Text("Warning: THIS WILL CAUSE LAG") im.EndTooltip()
            im.PushStyleColor2(im.Col_ButtonHovered, im.ImVec4(1.0, 0.0, 0.0, 0.5))
        else
            im.PushStyleColor2(im.Col_ButtonHovered, im.ImVec4(0.0, 0.0, 0.0, 1.0))
        end
    end
    gui.endWindow()
end

local function onUpdate()
    tod = scenetree.tod
    getWeather()
    drawBeginWindow()
    nightValues(tod, lightVal, shadowVal, brightSlider[0] / 7.5)
end

local function onExtensionLoaded()
    gui_module.initialize(gui) -- initialize the gui module
    gui.registerWindow(wndName, im.ImVec2(300, 800), im.ImVec2(0, 0), true) -- set initial size and position, etc.
    gui.setWindowVisibility(wndName, true) -- set initial visibility
end

M.onExtensionLoaded = onExtensionLoaded
M.onUpdate = onUpdate

return M