angular.module('beamng.apps')
.directive('oldnavigation', [function () {
  return {
    template: `
    <div style="box-sizing: border-box; display: none">
      <!-- map container -->
      <div>
        <svg style="position:absolute"></svg>
        <svg style="position:absolute"></svg>
        <svg style="position:absolute"></svg>
      </div>
      <svg width="20" height="40" style="position: absolute; top:0; left: 50%; margin-top: -20px; margin-left: -10px; transform: scale(1, 1);">
        <polygon points="0,20, 10,40, 20,20, 10,0" style="fill:#ddd;stroke:#ffffff;stroke-width:1.5" />
        <text x="10" y="26" font-family="Verdana" font-size="17" text-anchor="middle" style="font-weight:bold">N</text>
      </svg>
      <svg width="20" height="40" style="position: absolute; top:0; left: 50%; margin-top: -20px; margin-left: -10px; transform: scale(1, 1);">
        <polygon points="0,20, 10,40, 20,20, 10,0" style="fill:#ddd;stroke:#ffffff;stroke-width:1.5" />
        <text x="10" y="26" font-family="Verdana" font-size="17" text-anchor="middle" style="font-weight:bold">S</text>
      </svg>
      <svg width="20" height="40" style="position: absolute; top:0; left: 50%; margin-top: -20px; margin-left: -10px; transform: scale(1, 1);">
        <polygon points="0,20, 10,40, 20,20, 10,0" style="fill:#ddd;stroke:#ffffff;stroke-width:1.5" />
        <text x="10" y="26" font-family="Verdana" font-size="17" text-anchor="middle" style="font-weight:bold">W</text>
      </svg>
      <svg width="20" height="40" style="position: absolute; top:0; left: 50%; margin-top: -20px; margin-left: -10px; transform: scale(1, 1);">
        <polygon points="0,20, 10,40, 20,20, 10,0" style="fill:#ddd;stroke:#ffffff;stroke-width:1.5" />
        <text x="10" y="26" font-family="Verdana" font-size="17" text-anchor="middle" style="font-weight:bold">E</text>
      </svg>
    </div>
    `,
    replace: true,
    restrict: 'EA',
    link: function (scope, element, attrs) {
      var root = element[0];
      var mapcontainer  = root.children[0];
      var svg  = mapcontainer.children[0];
      var vehsvg  = mapcontainer.children[1];
      var auxsvg  = mapcontainer.children[2];

      var threeDMode = 0;
      var isFreeCam = false
      var lastIsFreeCam = false
      var camPosition
      var camPointer
      var borderColorOverwritten = false
      var borderColorBlinkTimer = 0;
      var borderColorTimer = 0;

      var northPointer = root.children[1];
      var southPointer = root.children[2];
      var westPointer = root.children[3];
      var eastPointer = root.children[4];

      var mapReady = 0;
      var size = 200;
      var parts = [];
      var zoomFactor = localStorage.getItem('apps:oldMinimap.zoom') || 3
      var compassState = localStorage.getItem('apps:oldMinimap.compass') || 0

      var speed = 1;
      var streamsList = ['electrics']
      StreamsManager.add(streamsList)

      function updateCompassState(state) {
        northPointer.style.display = state>=1?"inline":"none"
        southPointer.style.display = state==2?"inline":"none"
        westPointer.style.display = state==2?"inline":"none"
        eastPointer.style.display = state==2?"inline":"none"
      }

      root.addEventListener('wheel', function(e) {
        if (e.wheelDelta < 0) {
          (zoomFactor++ < 6)?zoomFactor=zoomFactor++:zoomFactor=6
        } else if (e.wheelDelta > 0) {
          (zoomFactor-- > 2)?zoomFactor=zoomFactor--:zoomFactor=2
        }
        localStorage.setItem('apps:oldMinimap.zoom', zoomFactor)
      })

      root.addEventListener('click', function() {
        bngApi.engineLua(`if freeroam_bigMapMode then freeroam_bigMapMode.enterBigMap() end`)
      })

      root.addEventListener('contextmenu', function() {
        compassState = (compassState+1)%3
        updateCompassState(compassState)
        localStorage.setItem('apps:oldMinimap.compass', compassState)
      })

      root.addEventListener('mouseover', function() {
        element.css({
          'border': '3px solid #FE6601',
        });
        borderColorOverwritten = true;
      })
      root.addEventListener('mouseout', function() {
        element.css({
          'border': '3px solid rgba(20,20,20,0.8)',
        });
        borderColorOverwritten = false;
      })

      scope.$on('app:resized', function (event, data) {
        size = Math.min(data.width, data.height);
        angular.element(root).css({
          height: `${size}px`,
          width: `${size}px`
        });
      });

      var _createCircle = function (x, y, r, c) {
        hu('<circle>', svg).attr({
          cx: x, cy: y, r: 0.5*r, fill: c
        });
      };

      var _createLine = function (p1, p2, color) {
        return hu('<line>', svg).attr({
          x1: p1.x, y1: p1.y, x2: p2.x, y2: p2.y,
          stroke: color,
          strokeWidth: Math.max(p1.radius, p2.radius),
          strokeLinecap: "round",
        });
      };

      scope.$on('streamsUpdate', function (event, streams) {
        if (!streams.electrics) { return }

        speed = streams.electrics.airspeed;
      })

      scope.$on('$destroy', function () {
        bngApi.engineLua('extensions.unload("ui_uiNaviOld")');
        StreamsManager.remove(streamsList)
      });

      // receive live data from the GE map
      var vehicleShapes = {};
      var lastPlayerID = -1;
      scope.$on('NavigationMapUpdateOld', function (event, data) {
        if(mapReady == 0) return;
        //console.log("NavigationMapUpdate", data)
        isFreeCam = data.isFreeCam
        camPosition = data.camPosition

        function updatePlayerShape(key, isPlayer) {
          //console.log('updatePlayerShape', key)
          if(vehicleShapes[key]) vehicleShapes[key].remove();

          if (isPlayer) {
            // remove the player icon, its hardcoded
            var shape = hu('<polygon>', vehsvg)
            shape.attr('points', '0,-10 -8,10, 0,7, 8,10')
            shape.css('fill', '#FF6600');
            shape.css('stroke', '#ffffff');
            shape.css('stroke-width', '1.5px');
          } else {
            var shape = hu('<polygon>', vehsvg)
            shape.attr('points', '0,-10 -8,10, 0,7, 8,10')
            shape.css('fill', '#607d8b');
            shape.css('stroke', '#ffffff');
            shape.css('stroke-width', '1.5px');
          }
          vehicleShapes[key] = shape
        }

        // update shape positions
        for (var key in data.objects) {
          var o = data.objects[key];
          if (vehicleShapes[key]) {
            var iconScale = (!isFreeCam)?((o.id == data.playerID)?Math.min(3, 1 + speed * 0.5):Math.min(2, 1 + speed * 0.25)):1.5;
            vehicleShapes[key].attr("transform",
              "translate(" + o.posX + "," + o.posY + ") scale(" + iconScale +","+iconScale+") rotate(" + o.rot + ")"
            );
          } else if (key != data.playerID) {
            updatePlayerShape(key); // add shape of vehicle if not found
          }
        }

        // player changed? update shapes?
        if(lastPlayerID != data.playerID) {
          if(lastPlayerID != -1) updatePlayerShape(lastPlayerID); // update shape of old vehicle
          updatePlayerShape(data.playerID, true); // update shape of new vehicle
          lastPlayerID = data.playerID;
        }

        // delete missing vehicles
        for(var key in vehicleShapes) {
          if(!data.objects[key]) {
            vehicleShapes[key].remove();
          }
        }

        if (borderColorOverwritten === false && borderColorTimer == 25) {
          var speedOverFactor = data.speedLimit>0?Math.max(0, (speed-data.speedLimit)):0;
          if (speedOverFactor >= 4 && speedOverFactor < 10) {
            element.css({
              'border': '3px solid #B25F00',
            });
          } else if (speedOverFactor >= 10 && speedOverFactor < 15) {
            element.css({
              'border': '3px solid #B20000',
            });
          } else if (speedOverFactor >= 15) {
            borderColorBlinkTimer = Math.min(borderColorBlinkTimer+1, 2)
            if (borderColorBlinkTimer == 2) {
              element.css({
                'border': '3px solid #FF0000',
              });
              borderColorBlinkTimer = 0
            } else if (borderColorBlinkTimer == 1) {
              element.css({
                'border': '3px solid rgba(20,20,20,1)',
              });
            }
          } else {
            element.css({
              'border': '3px solid rgba(20,20,20,1)',
            });
          }
          borderColorTimer = 0
        }
        borderColorTimer = Math.min(borderColorTimer+1,25);

        //if(l != 0) return;console.log(data);l=1;
        if (isFreeCam) {
          threeDMode = 0; // 0 = 2d, 1 = full 3d
          var zoom = 200 * zoomFactor;

          // center on what?
          var focusX = -camPosition[0];
          var focusY = camPosition[1];

          if (camPointer === undefined) {
            camPointer = hu('<circle>', auxsvg).attr({cx:0, cy:0, r:10})
            camPointer.css('fill', '#FF6600');
          }
          camPointer.attr("transform", "translate(" + focusX + "," + focusY + ")");

          // define the view area
          parts = [
            focusX - zoom,
            focusY - zoom,
            zoom * 2,
            zoom * 2,
          ];
        } else {
          var zoom = Math.min(150 + (speed * 3.6) * 1.5, 250) * zoomFactor;
          threeDMode = Math.min(1, Math.max(0, speed * 0.3)); // 0 = 2d, 1 = full 3d

          // define the view area
          var playerObj = data.objects[data.playerID]
          parts = [
            playerObj.posX - zoom,
            playerObj.posY - zoom,
            zoom * 2,
            zoom * 2,
          ];
        }

        if (camPointer && lastIsFreeCam == true && isFreeCam == false) {
          camPointer.attr({cx:0, cy:0, r:0})
        } else if (camPointer && lastIsFreeCam == false && isFreeCam == true) {
          camPointer.attr({cx:0, cy:0, r:10})
        }
        lastIsFreeCam = isFreeCam

        auxsvg.setAttribute('viewBox', parts.join(' '));
        vehsvg.setAttribute('viewBox', parts.join(' '));
        svg.setAttribute('viewBox', parts.join(' '));

        // 3d mode panning
        var rotX = threeDMode * 45;
        element.css({'transform': 'rotateX(' + rotX + 'deg)'});
        // move the view, so the play is at the bottom
        mapcontainer.style.transform = 'rotateX(' + rotX + 'deg) translate(0, ' + Math.min(size * 0.35, Math.floor(threeDMode * zoom * 0.5)) + 'px)';
        element.css({'box-shadow': '0px '+ rotX / 5 +'px rgb(20,20,20)'})

        var camRotation = data.camRotationZ
        auxsvg.style.transform = 'scale(3,3) rotate(' + camRotation + 'deg) '
        vehsvg.style.transform = 'scale(3,3) rotate(' + camRotation + 'deg) '
        svg.style.transform = 'scale(3,3) rotate(' + camRotation + 'deg) '

        var degreeNorth = camRotation
        if (compassState >= 1) {
          var npx =            - Math.cos(degreeNorth * Math.PI / 180) * size * 0.46
          var npy = size * 0.5 - Math.sin(degreeNorth * Math.PI / 180) * size * 0.46 - 3.5; // the magic 4
          northPointer.style.transform = 'translate(' + npx + 'px,' + npy + 'px) rotate(' + (-90 + degreeNorth) + 'deg) ';
        }

        if (compassState == 2) {
          var degreeSouth = degreeNorth + 180;
          npx =            - Math.cos(degreeSouth * Math.PI / 180) * size * 0.46
          npy = size * 0.5 - Math.sin(degreeSouth * Math.PI / 180) * size * 0.46 - 3.5;
          southPointer.style.transform = 'translate(' + npx + 'px,' + npy + 'px) rotate(' + (-90 + degreeSouth) + 'deg) ';

          var degreeWest = degreeNorth - 90;
          npx =            - Math.cos(degreeWest * Math.PI / 180) * size * 0.46
          npy = size * 0.5 - Math.sin(degreeWest * Math.PI / 180) * size * 0.46 - 3.5;
          westPointer.style.transform = 'translate(' + npx + 'px,' + npy + 'px) rotate(' + (-90 + degreeWest) + 'deg) ';

          var degreeEast = degreeNorth + 90;
          npx =            - Math.cos(degreeEast * Math.PI / 180) * size * 0.46
          npy = size * 0.5 - Math.sin(degreeEast * Math.PI / 180) * size * 0.46 - 3.5;
          eastPointer.style.transform = 'translate(' + npx + 'px,' + npy + 'px) rotate(' + (-90 + degreeEast) + 'deg) ';
        }

        mapReady = 2
        root.style.display = ""
      });

      var prevMarkers = null
      var drawnMarkers = {}
      scope.$on('NavigationGroundMarkersUpdate', (evenet, data) => {
        //prevMarkers = null
        //if no previous markers, draw the whole route.
        if(!prevMarkers) {
          console.log("Making complete new path.")

          let markers = data.markers
          if(data) {
            for(var i=2; i<markers.length; i+=2) {
              var i1 = i+1
              var i2 = i+2
              var i3 = i+3
              if (i1 != undefined && i2 != undefined && i3 != undefined) {
                drawnMarkers[i+":"+i1+":"+i2+":"+i3] = _createLine( {
                  x:-markers[i],
                  y: markers[i1],
                  radius: 10
                }, {
                  x:-markers[i2],
                  y: markers[i3],
                  radius: 10
                }, data.color)
              }
            }
          }
        } else {
          let markers = data.markers
          for(var i=2; i<markers.length; i+=2) {
            var i1 = i+1
            var i2 = i+2
            var i3 = i+3
            if (drawnMarkers[i+":"+i1+":"+i2+":"+i3]) {
              drawnMarkers[i+":"+i1+":"+i2+":"+i3].remove()
              drawnMarkers[i+":"+i1+":"+i2+":"+i3] = undefined
            }
            if (markers[i1] != undefined && markers[i2] != undefined && markers[i3] != undefined) {
              drawnMarkers[i+":"+i1+":"+i2+":"+i3] = _createLine( {
                x:-markers[i],
                y: markers[i1],
                radius: 10
              }, {
                x:-markers[i2],
                y: markers[i3],
                radius: 10
              }, data.color)
            }
          }
        }
        if (data.markers.length === undefined) {
          for (var name in drawnMarkers) {
            if (!drawnMarkers[name]) {} else {
              drawnMarkers[name].remove()
            }
          }
        }
        prevMarkers = data.markers
        routeUpdate = true
      })

      /*
      function setupStaticMarkers(data) {
        if(data.key === undefined)
          return
        if(staticMarkersDict[data.key] === undefined) {
          staticMarkersDict[data.key] = {}
        }
        let dict = staticMarkersDict[data.key]

        // remove any existing collectable svgs
        for (var key in dict) {
          dict[key].marker.remove()
        }
        markerGroup = hu('<g>', auxsvg)
        // draw collectable svgs
        for(var i=0; i<data.items.length; i+=4) {
          // let marker = hu('<image>', markerGroup)
          // let icon = '/ui/modules/apps/navigation/missionIcons/'+data.items[i+3]+'.svg'
          // let style = "transform: translate3d("+(-data.items[i+0])+"px,"+(data.items[i+1])+"px, 0px);"
          // marker.attr({
          //   x: -25, y:-25,
          //   width: 50, height: 50,
          //   style: style,
          //   'xlink:href': icon
          // })

          let style = "transform: translate3d("+(-data.items[i+0])+"px,"+(data.items[i+1])+"px,"
          let marker = hu('<circle>', svg)
          marker.attr('cx', -data.items[i+0])
          marker.attr('cy', data.items[i+1])
          marker.attr('r', 8)
          marker.attr('fill', '#2C5CFF')
          marker.attr('style', style)
          marker.css('stroke', '#FFFFFF')
          marker.css('stroke-width', '3px')

          dict[i/4.0] = {
            marker: marker,
            screenX: -data.items[i+0],
            screenY: data.items[i+1],
            visible: false
          }
        }
      }

      scope.$on('NavigationStaticMarkers', (event, data) => {
        if (data) setupStaticMarkers(data)
      })
      */

      // receive the one-time map setup
      scope.$on('NavigationMapOld', function (event, data) {
        element.css({
          'background-color': 'rgba(50, 50, 50, 0.6)',
          'box-shadow': '0px 0px #fff',
          'overflow': 'hidden',
          'border-radius': '50%',
          'border': '3px solid rgba(20,20,20,0.8)',
          'transition': 'border-color 0.4s',
          'cursor': "pointer",
        });

        function getDrivabilityColor(d) {
          if (d <= 0.1) return '#967864'; //'#967864'
          if (d > 0.1 && d < 0.9) return '#969678'; //'#969678'
          return '#DCDCDC'; //#DCDCDC'
        }

        // Draw the map elements
        var minX = -999, maxX = 999;
        var minY = -999, maxY = 999;
        var nodes = data.nodes

        // figure out dimensions of the road network
        for (var key in nodes) {
          var el = nodes[key]
          if (-el.pos[0] < minX) minX = -el.pos[0]
          if (-el.pos[0] > maxX) maxX = -el.pos[0]
          if (el.pos[1] < minY) minY = el.pos[1]
          if (el.pos[1] > maxY) maxY = el.pos[1]
        }

        if (data.minimapImage && data.terrainOffset && data.terrainSize) {
          if (data.terrainTiles && data.terrainTiles[0] && data.terrainTiles[0].size) {
            for (let tile of data.terrainTiles) {
              if (!tile.file || !tile.offset || !tile.size)
                continue;
              if (!tile.file.startsWith("/"))
                tile.file = "/" + tile.file;

              let dest = [
                tile.offset[0],
                -tile.offset[1],
                tile.size[0],
                tile.size[1],
              ];

              hu('<image>', svg).attr({
                'x': dest[0],
                'y': dest[1],
                'width': dest[2],
                'height': dest[3],
                'transform': "scale(-1,-1)",
                'xlink:href': tile.file,
              }).prependTo(svg)
            }
          } else {
            hu('<image>', svg).attr({
              'x': data.terrainOffset[0],
              'y': data.terrainOffset[1],
              'width': data.terrainSize[0],
              'height': data.terrainSize[1],
              'transform': "scale(-1,-1)",
              'xlink:href': "/" + data.minimapImage,
            }).prependTo(svg)
          }
        } else {
          // draw grid
          var dx = 50
          for (var x = minX; x <= maxX + 1; x += dx) {
            _createLine({ x: x, y: minY, radius: 1 }, { x: x, y: maxY, radius: 1 }, '#FFFFFF55')
          }
          var dy = 50
          for (var y = minY; y <= maxY + 1; y += dy) {
            _createLine({ x: minX, y: y, radius: 1 }, { x: maxX, y: y, radius: 1 }, '#FFFFFF55')
          }
        }

        function drawRoads(drivabilityMin, drivabilityMax) {
          for (var key in nodes) {
            var el = nodes[key];
            //1_createCircle(-el.pos[0], el.pos[1], el.radius, '#fa9e28'); // nodes
            if(-el.pos[0] < minX) minX = -el.pos[0];
            if(-el.pos[0] > maxX) maxX = -el.pos[0];
            if(el.pos[1] < minY) minY = el.pos[1];
            if(el.pos[1] > maxY) maxY = el.pos[1];

            if (el.links !== undefined) { // links
              for (var key2 in el.links) {
                var el2 = nodes[key2];
                var drivability = el.links[key2].drivability
                if (drivability >= drivabilityMin && drivability <= drivabilityMax) {
                  _createLine({x: -el.pos[0], y: el.pos[1], radius: el.radius*3}, {x: -el2.pos[0], y: el2.pos[1], radius: el2.radius*3}, getDrivabilityColor(drivability));
                }
              }
            }
          }
        }
        drawRoads(0, 0.1)
        drawRoads(0.1, 0.9)
        drawRoads(0.9, 1)

        updateCompassState(compassState)
        mapReady = 1;
      });

      bngApi.engineLua('extensions.load("ui_uiNaviOld")');
      bngApi.engineLua('extensions.ui_uiNaviOld.requestUIDashboardMap()');
}}}]);