local M = {}

local function setAllLightsEnabled(group, value)
    for i = 0, group.obj:getCount(), 1 do
        local id = group.obj:idAt(i)
        local obj = scenetree.findObjectById(id)
        if obj and obj.obj:isSubClassOf('LightBase') then
            obj.obj:setLightEnabled( value )
        end
    end
end

local lastValue1 = nil
local lastValue2 = nil
local lastValue3 = nil

local function onUpdate()
    local tod = scenetree.tod
    if not tod then return end

	-- first group
    local value1 = false
    if tod.time > 0.21 and tod.time < 0.77 then
        value1 = true
    end

    if lastValue1 ~= value1 then
		if scenetree.Light_Big then
		  setAllLightsEnabled(scenetree.Light_Big, value1 )
		end
	end

	-- second group
    local value2 = false
    if tod.time > 0.21 and tod.time < 0.77 then
        value2 = true
    end

    if lastValue2 ~= value2 then
		if scenetree.Light_Little then
		  setAllLightsEnabled(scenetree.Light_Little, value2 )
		end
	end

	-- third group
    local value3 = false
    if tod.time > 0.21 and tod.time < 0.77 then
        value3 = true
    end

    if lastValue3 ~= value3 then
		if scenetree.Light_Garage then
		  setAllLightsEnabled(scenetree.Light_Garage, value3 )
		end
	end
end

M.onUpdate = onUpdate

return M