ScriptName ShipStats Extends ReferenceAlias
inputEnableLayer ShipDamagedLayer
ActorValue Property Health Auto; 000002d4
ObjectReference CPS Auto
Actor Property PlayerRef Auto Const
Explosion Property Ship_ElectricalExplosionSmall Auto Const
wwiseevent Property Redalert Auto Const ;Security Alarm start 00125a5B
wwiseevent Property Normal Auto Const ;Secuirty alarm stop 00125a5C
wwiseevent Property ShipDamageAlarm Auto Const ; BoardingAlarm 000FD7c6 003f8f3e
Int Property ShipSFXCombat auto
Int Property ShipSFXDamage auto
Int SetforRepair = 0
GlobalVariable Property BattleDamage Auto
GlobalVariable Property AlertSound Auto
Float CurrentShipHealth
Float CurrentShipHull
Float CurrentShipGravdriveHealth
Float CurrentShipGravdrive
Float CurrentShipReactorHealth
Float CurrentShipReactor
Cell ShipInterior
ReferenceAlias Property PlayerShipPilotSeat Auto mandatory
ActorValue Property ShipSystemGravDriveHealth Auto
ActorValue Property ShipSystemReactorHealth Auto

Event OnShipSystemDamaged(ActorValue akSystem, Int aBlocksLost, Bool aElectromagneticDamage, Bool aFullyDamaged)
CPS = Self.GetReference()
CurrentShipHealth = CPS.Getvalue(Health)
CurrentshipHull = CPS.GetBasevalue(Health)
CurrentShipGravdrive = CPS.GetBasevalue(ShipSystemGravDriveHealth)
CurrentShipGravdriveHealth = CPS.Getvalue(ShipSystemGravDriveHealth)
CurrentShipReactor = CPS.GetBasevalue(ShipSystemReactorHealth)
CurrentShipReactorHealth = CPS.Getvalue(ShipSystemReactorHealth)
ShipInterior = PlayerRef.GetParentCell()
	
	If (CurrentShipHealth) < (CurrentshipHull / 2)
	;do 50% damage visual fx
	If BattleDamage.getvalue() == 1
		IF SetforRepair == 0 
		PlayerShipPilotSeat.GetRef().placeatme(Ship_ElectricalExplosionSmall, 1, False, false, true, none, none, True)
		endif
	endif

	If AlertSound.getvalue() == 1 
		IF SetforRepair == 0 
		wwiseevent.StopInstance(ShipSFXDamage)
		ShipSFXDamage = ShipDamageAlarm.Play(PlayerShipPilotSeat.GetRef(), none, none)
		Starttimer(6, 1)
		endif
	endif

	SetforRepair = 1	
	Endif

	If (CurrentShipHealth) < (CurrentshipHull / 4)
	;do 20% damage visual fx
		If BattleDamage.getvalue() == 1
		PlayerShipPilotSeat.GetRef().placeatme(Ship_ElectricalExplosionSmall, 1, False, false, true, none, none, false)
		endif
	Endif

	If (CurrentShipHealth) < (CurrentshipHull / 10) 
	;do 20% damage visual fx
		If BattleDamage.getvalue() == 1
			If (CurrentShipGravdriveHealth < (CurrentShipGravdrive / 10)) || (CurrentShipReactorHealth < (CurrentShipReactor / 10))
			ShipInterior.setGravityscale(0)
			Starttimer(1, 3)
			DisableTravel()
			endif
		PlayerShipPilotSeat.GetRef().placeatme(Ship_ElectricalExplosionSmall, 1, False, false, true, none, none, false)
		endif
	Endif
	
endevent

Event OnShipSystemRepaired(ActorValue akSystem, Int aBlocksGained, Bool aElectromagneticDamage)
CPS = Self.GetReference()
CurrentShipHealth = CPS.Getvalue(Health)
CurrentshipHull = CPS.GetBasevalue(Health)
ShipInterior = PlayerRef.GetParentCell()
CurrentShipGravdrive = CPS.GetBasevalue(ShipSystemGravDriveHealth)
CurrentShipGravdriveHealth = CPS.Getvalue(ShipSystemGravDriveHealth)
CurrentShipReactor = CPS.GetBasevalue(ShipSystemReactorHealth)
CurrentShipReactorHealth = CPS.Getvalue(ShipSystemReactorHealth)
		
	If (CurrentShipHealth) > (CurrentshipHull / 2) 
	;do 50% damage visual fx
		IF SetforRepair == 1
		wwiseevent.StopInstance(ShipSFXDamage)
		SetforRepair = 0
		CancelTimer(1)
		endif
	Endif

	If (CurrentShipGravdriveHealth > (CurrentShipGravdrive / 10)) || (CurrentShipReactorHealth > (CurrentShipReactor / 10))
	ShipInterior.setGravityscale(1)
	EnableTravel()
	endif

endevent

Int Isincombat

Event OnCombatStateChanged(ObjectReference akTarget, Int aeCombatState)
	If AlertSound.getvalue() == 1
		if aeCombatState == 0
		wwiseevent.StopInstance(ShipSFXCombat)
		Isincombat = 0
		ShipSFXCombat = Normal.Play(PlayerShipPilotSeat.GetRef(), none, none)
		CancelTimer(2)
		endif 

		IF aeCombatState == 1
		wwiseevent.StopInstance(ShipSFXCombat)
		Isincombat = 1
		ShipSFXCombat = Redalert.Play(PlayerShipPilotSeat.GetRef(), none, none)
		StartTimer(5.5, 2)
		endif
	endif	
endevent


Event OnTimer(Int aiTimerID)

CPS = Self.GetReference()
CurrentShipHealth = CPS.Getvalue(Health)
CurrentshipHull = CPS.GetBasevalue(Health)
ShipInterior = PlayerRef.GetParentCell()
CurrentShipGravdrive = CPS.GetBasevalue(ShipSystemGravDriveHealth)
CurrentShipGravdriveHealth = CPS.Getvalue(ShipSystemGravDriveHealth)
CurrentShipReactor = CPS.GetBasevalue(ShipSystemReactorHealth)
CurrentShipReactorHealth = CPS.Getvalue(ShipSystemReactorHealth)

	If aiTimerID == 1
		If AlertSound.getvalue() == 1
		Starttimer(6,1)
		ShipSFXDamage = ShipDamageAlarm.Play(PlayerShipPilotSeat.GetRef(), none, none) 
			If (CurrentShipHealth) > (CurrentshipHull / 2) 
			wwiseevent.StopInstance(ShipSFXDamage)
			SetforRepair = 0
			CancelTimer(1)
			endif
		endif
	endif

	If aiTimerID == 2
	wwiseevent.StopInstance(ShipSFXCombat)
	ShipSFXCombat = Normal.Play(PlayerShipPilotSeat.GetRef(), none, none)
	endif

	If aiTimerID == 3
	Starttimer(1,3)
		If (CurrentShipGravdriveHealth > (CurrentShipGravdrive / 10)) || (CurrentShipReactorHealth > (CurrentShipReactor / 10))
		ShipInterior.setGravityscale(1)
		EnableTravel()
		Canceltimer(3)
		endif
	endif
endevent


Function EnableTravel()
	ShipDamagedLayer.EnableFastTravel(True)
	ShipDamagedLayer.reset()
	ShipDamagedLayer.delete()
	ShipDamagedLayer = inputEnableLayer.Create()
	ShipDamagedLayer.EnableFastTravel(True)
Endfunction

Function DisableTravel()
	ShipDamagedLayer.EnableFastTravel(False)
	ShipDamagedLayer.reset()
	ShipDamagedLayer.delete()
	ShipDamagedLayer = inputEnableLayer.Create()
	ShipDamagedLayer.EnableFastTravel(False)
Endfunction
