//-----------------------------------------------------------------------------
// Copyright (c) 2012 GarageGames, LLC
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//-----------------------------------------------------------------------------

// This is the default save location for any ForestBrush(s) created in 
// the Forest Editor.
// This script is executed from ForestEditorPlugin::onWorldEditorStartup().

//--- OBJECT WRITE BEGIN ---
new SimGroup(ForestBrushGroup) {
   canSave = "1";
   canSaveDynamicFields = "1";

   new ForestBrushElement() {
      internalName = "Altitude_PinTree02DEAD";
      canSave = "1";
      canSaveDynamicFields = "1";
      probability = "1";
      rotationRange = "360";
      scaleMin = "0.5";
      scaleMax = "0.7";
      scaleExponent = "1.5";
      sinkMin = "2";
      sinkMax = "4";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrush() {
      internalName = "rocks_01_a_large";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "rock_01_a_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "rocks_01_a_small";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "rock_01_a_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "75";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "75";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "AltitudeSapinBig";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_douglasfir_large_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.4";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.6";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Altitude_PinTree01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Altitude_PinTree01";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.4";
         scaleExponent = "1.5";
         sinkMin = "1";
         sinkMax = "0";
         sinkRadius = "5";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Altitude_PinTree02";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Altitude_PinTree02";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.2";
         scaleExponent = "1.5";
         sinkMin = "1";
         sinkMax = "0";
         sinkRadius = "5";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "AltitudeSapinSmall";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "Altitude_PinTree_small01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Altitude_PinTree_small01";
         probability = "0.5";
         rotationRange = "300";
         scaleMin = "0.7";
         scaleMax = "1.5";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_bush_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1.4";
         scaleMax = "2.5";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_bush_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1.2";
         scaleMax = "2.4";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_small_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.4";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.4";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_small_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_small_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "SapinLow";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "Douglas_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_a_low";
         probability = "2";
         rotationRange = "360";
         scaleMin = "1.2";
         scaleMax = "2";
         scaleExponent = "3";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Douglas_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_b_low";
         probability = "2";
         rotationRange = "360";
         scaleMin = "1.2";
         scaleMax = "2";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "3";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Douglas_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_c_low";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1.2";
         scaleMax = "2";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "4";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Douglas_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_d_low";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1.2";
         scaleMax = "2";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "4";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Epicea01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Altitude_PinTree01Low";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.2";
         scaleExponent = "2";
         sinkMin = "0";
         sinkMax = "3";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Epicea02";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Altitude_PinTree02Low";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1";
         scaleExponent = "0";
         sinkMin = "4";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "Epicea02Dead";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "Altitude_PinTree02DEADLow";
         probability = "0.2";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "3";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "AspenBig";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_aspen_forest_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_forest_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.3";
         scaleExponent = "1.2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_forest_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_forest_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_forest_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_forest_group";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.1";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.6";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "AspenSmall";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_aspen_overhang_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_overhang_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.4";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.5";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_low";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_low";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_low_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_low_group";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_wall";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_wall";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1.2";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "OakBig";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_oak_forest_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_forest_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_forest_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_forest_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_forest_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_forest_group";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1.2";
         scaleMax = "2";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "OakSmall";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_oak_sml_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_sml_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_sml_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_sml_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2";
         scaleExponent = "1.5";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "DeadWood";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "Altitude_PinTree03DEAD";
         canSave = "1";
         canSaveDynamicFields = "1";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "3";
         scaleExponent = "3";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "DeadTrunk";
         canSave = "1";
         canSaveDynamicFields = "1";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_chopped";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_chopped";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_chopped";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_chopped";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "3";
         scaleExponent = "2";
         sinkMin = "0.35";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_dead";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_dead";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_chopped_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_chopped_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_chopped_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_chopped_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_dead_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_dead_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_dead_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_dead_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_forestcover";
         canSave = "1";
         canSaveDynamicFields = "1";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrushElement() {
      internalName = "reflector2";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "reflector2";
      probability = "1";
      rotationRange = "360";
      scaleMin = "1";
      scaleMax = "1";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrush() {
      internalName = "Bush";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "BushBig";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_blocker_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "BushMedium";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_b";
         probability = "3";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "BushMedium2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "AspenSmall01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_a";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "AspenSmall02";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "BushSmall";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_b";
         probability = "4";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "0.8";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
};
//--- OBJECT WRITE END ---
