-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

-- Light culling code created by Dummiesman
-- To performantly toggle lights based on camera position in BeamNG.drive

-- Please check all memory usages in CTRL + SHIFT + F menu!!!!

local M = {}
M.dependencies = {"ui_imgui"}
local im = ui_imgui
local imguiUtils = require('ui/imguiUtils')
local ffi = require("ffi")

local TorqueScriptLua = TorqueScriptLua

-- TWEAKS
local partitionGridSpaceSize = 60.0         --size of chunk for normal lights
local smallpartitionGridSpaceSize = 25.0    --size of chunk for small lights
local shadowpartitionGridSpaceSize = 10.0   --size of chunk for shadows

--independent GUI
local showUI = nil
local fadeScreenRunning = false
local skipImgui = false
local selectedColorRamp = im.IntPtr(0)
local correctionBias = im.FloatPtr(0)

--teleport
local otherLevelPath = "/levels/st_kamuro_judge/info.json"
local playerisintrigger = nil
local promptTitle = "Teleport"

--scenetree
local objects = nil

local tod = nil

-- DATA, DON'T TOUCH (MAIN)
local partitionGridMin
local partitionGridMax
local partitionGridSpacesX
local partitionGridSpacesY
local totalPartitionGridSpaces
local partitionGrid = {}
local luaLoaded = false

-- DATA, DON'T TOUCH 2 (SHADOWS)
local partitionGrid2Min
local partitionGrid2Max
local partitionGrid2SpacesX
local partitionGrid2SpacesY
local totalPartitionGrid2Spaces
local partitionGrid2 = {}

-- DATA, DON'T TOUCH 3 (SMALL)
local partitionGrid3Min
local partitionGrid3Max
local partitionGrid3SpacesX
local partitionGrid3SpacesY
local totalPartitionGrid3Spaces
local partitionGrid3 = {}

local lastValue = nil
local lastValueAdd = nil
local lastCameraCell = -1
local lastCameraCell2 = -1
local lastCameraCell3 = -1
local allLights = {}
local smallLights = {}
local allShadows = {}

local lightmgr
local shadowdisable = 0

local debugEnabled = false

local speedtrpgroup = im.ArrayChar(256)
local speedzonegroup = im.ArrayChar(256)
local cubemapgroup = im.ArrayChar(256)

local instanceData = {}

--weather
local isWet = 0

local emissiveTable = {}

local wetMaterialsTable = {}

local isThunder = false

--progress data
local progressData
local progressFilePath

--cubemmap
local cubemapname

--traffic
local trafficGroupPath = "/vehicleGroups/agentTraffic/agent_traffic_yakuza.vehGroup.json"
local trafficInstalled = false

--D3D11 deprecation
local isVulkan = false
local adapterType = "unknown"

--level data
local levelfolder = nil
local levelname =  nil
local tool_version = "2.3"
local appTitle = " CK Map Controller - ".. tool_version .." - ".. "no-init" .." - ".. beamng_arch
local debugTitle = "Debug Controller - ".. tool_version .." - ".. "no-init" .." - ".. beamng_arch

local isEditorRunning = false

local toolWindowName = 'map_controller'

-- Keep track of the last set of lights we enabled so we don't have to loop over every light and disable it each time we change cells
local lastEnabledLightCount = 0
local lastEnabledLightIndices = {}

local lastEnabledShadowCount = 0
local lastEnabledShadowIndices = {}

local lastEnabledSmallCount = 0
local lastEnabledSmallIndices = {}

local function enableLights(xCell, zCell, value, alwaysOn)
  -- disable previously enabled lights
  for i=1,lastEnabledLightCount,1 do
    local light = allLights[lastEnabledLightIndices[i]]
    if light and scenetree.findObjectById(light:getID()) then light:setLightEnabled(false) else log('E', "enableLights", "Light " .. light:getName() .. " is not existing in mission!") end
  end

  lastEnabledLightCount = 0
  for x=math.max(0, xCell - 1), math.min(partitionGridSpacesX - 1, xCell + 1),1 do
    for z=math.max(0, zCell - 1), math.min(partitionGridSpacesY - 1, zCell + 1),1 do
      for _,lightIndex in ipairs(partitionGrid[1 + (z * partitionGridSpacesX) + x]) do
        -- mark enabled
        lastEnabledLightCount = lastEnabledLightCount + 1
        lastEnabledLightIndices[lastEnabledLightCount] = lightIndex

        -- enable light
        local light = allLights[lightIndex]
        if light and scenetree.findObjectById(light:getID()) then
          if alwaysOn and alwaysOn == true then
            if light:getDynDataFieldbyName('alwaysOn', 0) == "1" then
              light:setLightEnabled(value)
            end
          else
            light:setLightEnabled(value)
          end
        else log('E', "enableLights", "Light " .. light:getName() .. " is not existing in mission!") end
      end
    end
  end
end

local function enableShadows(xCell, zCell)
  -- disable previously enabled lights
  for i=1,lastEnabledShadowCount,1 do
    local shadow = allShadows[lastEnabledShadowIndices[i]]
    if shadow and scenetree.findObjectById(shadow:getID()) then
      shadow.texSize = 32
      shadow.castShadows = false
    else log('E', "enableShadows", "Light " .. shadow:getName() .. " is not existing in mission!") end
  end

  lastEnabledShadowCount = 0
  for x=math.max(0, xCell - 1), math.min(partitionGrid2SpacesX - 1, xCell + 1),1 do
    for z=math.max(0, zCell - 1), math.min(partitionGrid2SpacesY - 1, zCell + 1),1 do
      for _,shadowIndex in ipairs(partitionGrid2[1 + (z * partitionGrid2SpacesX) + x]) do
        -- mark enabled
        lastEnabledShadowCount = lastEnabledShadowCount + 1
        lastEnabledShadowIndices[lastEnabledShadowCount] = shadowIndex

        -- enable light
        local shadow = allShadows[shadowIndex]
        if shadow and scenetree.findObjectById(shadow:getID()) then
          shadow.texSize = 1024
          shadow.castShadows = true
        else log('E', "enableShadows", "Light " .. shadow:getName() .. " is not existing in mission!") end
      end
    end
  end
end

local function enableSmallLights(xCell, zCell, value, alwaysOn)
  -- disable previously enabled lights
  for i=1,lastEnabledSmallCount,1 do
    local light = smallLights[lastEnabledSmallIndices[i]]
    if light and scenetree.findObjectById(light:getID()) then light:setLightEnabled(false) else log('E', "enableSmallLights", "Light " .. light:getName() .. " is not existing in mission!") end
  end

  lastEnabledSmallCount = 0
  for x=math.max(0, xCell - 1), math.min(partitionGrid3SpacesX - 1, xCell + 1),1 do
    for z=math.max(0, zCell - 1), math.min(partitionGrid3SpacesY - 1, zCell + 1),1 do
      for _,lightIndex in ipairs(partitionGrid3[1 + (z * partitionGrid3SpacesX) + x]) do
        -- mark enabled
        lastEnabledSmallCount = lastEnabledSmallCount + 1
        lastEnabledSmallIndices[lastEnabledSmallCount] = lightIndex

        -- enable light
        local light = smallLights[lightIndex]
        if light and scenetree.findObjectById(light:getID()) then
          if alwaysOn and alwaysOn == true then
            if light:getDynDataFieldbyName('alwaysOn', 0) == "1" then
              light:setLightEnabled(value)
            end
          else
            light:setLightEnabled(value)
          end
        else log('E', "enableSmallLights", "Light " .. light:getName() .. " is not existing in mission!") end
      end
    end
  end
end

local function getCellForPosition(p)
  local xCell = math.floor((p.x - partitionGridMin.x) / partitionGridSpaceSize)
  local yCell = math.floor((p.y - partitionGridMin.y) / partitionGridSpaceSize)
  return xCell, yCell
end

local function getCellIndexForPosition(p)
  local xCell, yCell = getCellForPosition(p)
  return (yCell * partitionGridSpacesX) + xCell
end

local function positionInRange(p)
  return p.x >= partitionGridMin.x and p.x <= partitionGridMax.x and p.y >= partitionGridMin.y and p.y <= partitionGridMax.y
end

--grid2
local function getCellForPosition2(p)
  local xCell = math.floor((p.x - partitionGrid2Min.x) / shadowpartitionGridSpaceSize)
  local yCell = math.floor((p.y - partitionGrid2Min.y) / shadowpartitionGridSpaceSize)
  return xCell, yCell
end

local function getCellIndexForPosition2(p)
  local xCell, yCell = getCellForPosition2(p)
  return (yCell * partitionGrid2SpacesX) + xCell
end

local function positionInRange2(p)
  return p.x >= partitionGrid2Min.x and p.x <= partitionGrid2Max.x and p.y >= partitionGrid2Min.y and p.y <= partitionGrid2Max.y
end

--grid3
local function getCellForPosition3(p)
  local xCell = math.floor((p.x - partitionGrid3Min.x) / smallpartitionGridSpaceSize)
  local yCell = math.floor((p.y - partitionGrid3Min.y) / smallpartitionGridSpaceSize)
  return xCell, yCell
end

local function getCellIndexForPosition3(p)
  local xCell, yCell = getCellForPosition3(p)
  return (yCell * partitionGrid3SpacesX) + xCell
end

local function positionInRange3(p)
  return p.x >= partitionGrid3Min.x and p.x <= partitionGrid3Max.x and p.y >= partitionGrid3Min.y and p.y <= partitionGrid3Max.y
end

local function getInstanceData()
  local instanceData = {}
  local materials = {}
  local allObjects = scenetree:getAllObjects()
  if allObjects then
    for k,name in pairs(allObjects) do
      local object = scenetree.findObject(name)
      if object and object.___type == "class<Material>" then
        if object:getField('instanceEmissive', 0) == "1" then
          materials[name] = true
        end
      end
    end
    for k,name in pairs(allObjects) do
      local object = scenetree.findObject(name)
      if object and object:isSubClassOf("TSStatic") then
        if object:getDynDataFieldbyName('is_tunnel', 0) == "1" then
          -- do nothing
        else
          local matNames = object:getMaterialNames()
          for k,v in pairs(matNames) do
            if materials[v] == true then
              local objId = object:getId()
              local instColor = object:getField('instanceColor', 0)
              local instColor1 = object:getField('instanceColor1', 0)
              local instColor2 = object:getField('instanceColor2', 0)
              instanceData[objId] = {instColor, instColor1, instColor2}
            end
          end
        end
      end
    end
    for k,v in pairs(instanceData) do
      local instance = scenetree.findObjectById(k)
      if instance then
        instance:setField('instanceColor', 0, "Black")
        instance:setField('instanceColor1', 0, "Black")
        instance:setField('instanceColor2', 0, "Black")
        instance:updateInstanceRenderData()
      end
    end
  end
  return instanceData
end

--get player vehicle
local function getCurrentVehicle()
  local result = nil
  if gameplay_walk and gameplay_walk.isWalking() then
    return result
  end

  -- get the current vehicle to load it in the garage
  local vehicle = be:getPlayerVehicle(0)
  local playerVehicleData = core_vehicle_manager.getPlayerVehicleData()
  if vehicle and playerVehicleData then
    local config = serialize(playerVehicleData.config) -- when using "vehicle.partConfig" here, the color of the vehicle will be wrong if you use a custom default config
    local model = vehicle.JBeam
    result = { model, {config=config} }
  end
  return result
end

--Hide Elements of map

local function setHiddenRec(object, hidden)
  object.hidden = hidden
  if object:isSubClassOf("SimSet") then
    for i=0, object:size() - 1 do
      setHiddenRec(object:at(i), hidden)
    end
  end
end

local function hideGroup(groupName, hidden)
  if not groupName then
    log('E', "hideGroup", "Group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Group is missing, please contact level author', icon = "goat"})
  else
  local group = scenetree.findObject(groupName)
  if group then setHiddenRec(group, hidden) end
  end
end

--change material data
local function setMaterialProperty(material, property, layer, value)
  if type(material) == "string" then
    material = scenetree.findObject(material)
  end

  if material and material.___type == "class<Material>" then
    if material:getField(property, layer) ~= value then
      material:setField(property, layer, value)
      material:reload()
    end
    return true
  else
    log('E', "setMaterialProperty", "Given object is not a material.")
    return false
  end
end

local currentCube

local function setCubemap(value)
  if value then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      log("I", "setCubemap", "Enabling cubemap " ..value)
      levelinf:setField('globalEnviromentMap', 0, value)
      levelinf:postApply()
    else
      log("W", "setCubemap", "Enabling fallback cubemap " ..value)
      setConsoleVariable("$defaultLevelEnviromentMap", value)
    end
  end
end

local function initializeEmissive(job)
  job.sleep(10)
  for k,v in pairs(emissiveTable) do
    job.yield()
    setMaterialProperty(v[1], 'emissiveFactor', v[3], "0 0 0")
    log('I', "initializeEmissive", "Switching Material "..v[1].." layer "..v[3])
  end
end

local function prepareLights()
  local allObjects = scenetree:getAllObjects()
  for k, v in pairs(allObjects) do
    local obj = scenetree.findObject(v)
    if obj and obj.obj:isSubClassOf('LightBase') then
      if obj:getDynDataFieldbyName('advancedLightingOnly', 0) == "1" then
        if lightmgr == "Advanced Lighting 1.5" then
          if obj:getDynDataFieldbyName('useOptimizedShadows', 0) == "1" then
            table.insert(allShadows, obj.obj)
          end
          if obj:getDynDataFieldbyName('smallLight', 0) == "1" then
            table.insert(smallLights, obj.obj)
          else
            table.insert(allLights, obj.obj)
          end
        else
          obj:setLightEnabled(false)
          obj.castShadows = false
        end
      else
        if obj:getDynDataFieldbyName('useOptimizedShadows', 0) == "1" then
          table.insert(allShadows, obj.obj)
        end
        if obj:getDynDataFieldbyName('smallLight', 0) == "1" then
          table.insert(smallLights, obj.obj)
        else
          table.insert(allLights, obj.obj)
        end
      end
    end
  end

  log('I', 'prepareLights', 'DM light cull')

  -- compute grid
  local minX = 99999.0
  local minY = 99999.0
  local maxX = -99999.0
  local maxY = -99999.0

  for i,v in ipairs(allLights) do
    local pos = v:getPosition()
    minX = math.min(pos.x, minX)
    minY = math.min(pos.y, minY)

    maxX = math.max(pos.x, maxX)
    maxY = math.max(pos.y, maxY)
  end

  partitionGridMin = vec3(minX, minY, 0)
  partitionGridMax = vec3(maxX, maxY, 0)
  partitionGridSpacesX = math.ceil((partitionGridMax.x - partitionGridMin.x) / partitionGridSpaceSize)
  partitionGridSpacesY = math.ceil((partitionGridMax.y - partitionGridMin.y) / partitionGridSpaceSize)
  totalPartitionGridSpaces = (partitionGridSpacesX * partitionGridSpacesY)

  -- compute grid2
  local minX2 = 99999.0
  local minY2 = 99999.0
  local maxX2 = -99999.0
  local maxY2 = -99999.0

  for i,v in ipairs(allShadows) do
    local pos = v:getPosition()
    minX2 = math.min(pos.x, minX2)
    minY2 = math.min(pos.y, minY2)

    maxX2 = math.max(pos.x, maxX2)
    maxY2 = math.max(pos.y, maxY2)
  end

  partitionGrid2Min = vec3(minX2, minY2, 0)
  partitionGrid2Max = vec3(maxX2, maxY2, 0)
  partitionGrid2SpacesX = math.ceil((partitionGrid2Max.x - partitionGrid2Min.x) / shadowpartitionGridSpaceSize)
  partitionGrid2SpacesY = math.ceil((partitionGrid2Max.y - partitionGrid2Min.y) / shadowpartitionGridSpaceSize)
  totalPartitionGrid2Spaces = (partitionGrid2SpacesX * partitionGrid2SpacesY)

  -- compute grid3
  local minX3 = 99999.0
  local minY3 = 99999.0
  local maxX3 = -99999.0
  local maxY3 = -99999.0

  for i,v in ipairs(smallLights) do
    local pos = v:getPosition()
    minX3 = math.min(pos.x, minX3)
    minY3 = math.min(pos.y, minY3)

    maxX3 = math.max(pos.x, maxX3)
    maxY3 = math.max(pos.y, maxY3)
  end


  partitionGrid3Min = vec3(minX3, minY3, 0)
  partitionGrid3Max = vec3(maxX3, maxY3, 0)
  partitionGrid3SpacesX = math.ceil((partitionGrid3Max.x - partitionGrid3Min.x) / smallpartitionGridSpaceSize)
  partitionGrid3SpacesY = math.ceil((partitionGrid3Max.y - partitionGrid3Min.y) / smallpartitionGridSpaceSize)
  totalPartitionGrid3Spaces = (partitionGrid3SpacesX * partitionGrid3SpacesY)

  -- allocate tables
  for i=1,totalPartitionGridSpaces,1 do
    table.insert(partitionGrid, {})
  end

  for i=1,totalPartitionGrid2Spaces,1 do
    table.insert(partitionGrid2, {})
  end

  for i=1,totalPartitionGrid3Spaces,1 do
    table.insert(partitionGrid3, {})
  end

  for i=1,512,1 do
    table.insert(lastEnabledLightIndices, 0)
  end

  for i=1,512,1 do
    table.insert(lastEnabledShadowIndices, 0)
  end

  for i=1,512,1 do
    table.insert(lastEnabledSmallIndices, 0)
  end

  -- place lights in cells
  for i,v in ipairs(allLights) do
    local pos = v:getPosition()
    table.insert(partitionGrid[getCellIndexForPosition(pos) + 1], i)
  end

  for i,v in ipairs(allShadows) do
    local pos = v:getPosition()
    table.insert(partitionGrid2[getCellIndexForPosition2(pos) + 1], i)
  end

  for i,v in ipairs(smallLights) do
    local pos = v:getPosition()
    table.insert(partitionGrid3[getCellIndexForPosition3(pos) + 1], i)
  end

  -- turn off all lights
  for i,v in ipairs(allLights) do
    v:setLightEnabled(false)
    v.castShadows = false
  end

  -- turn off small lights
  for i,v in ipairs(smallLights) do
    v:setLightEnabled(false)
    v.castShadows = false
  end

  -- debug
  local largestCell = -1
  local largestCellIndex = 0
  local totalLightsInCells = 0

  for i,c in ipairs(partitionGrid) do
    if #c > largestCell then
      largestCellIndex = i
      largestCell = #c
    end
    totalLightsInCells = totalLightsInCells + #c
  end

  log('D', 'prepareLights', "Total lights spaces: " .. tostring(totalPartitionGridSpaces))
  log('D', 'prepareLights', "Worst bucket was " .. tostring(largestCellIndex) .. " containing " .. tostring(largestCell) .. ". Total " .. tostring(totalLightsInCells))
  local bigLights = totalLightsInCells

  largestCell = -1
  largestCellIndex = 0
  totalLightsInCells = 0

  for i,c in ipairs(partitionGrid2) do
    if #c > largestCell then
      largestCellIndex = i
      largestCell = #c
    end
    totalLightsInCells = totalLightsInCells + #c
  end
  log('D', 'prepareLights', "Total shadow spaces: " .. tostring(totalPartitionGrid2Spaces))
  log('D', 'prepareLights', "Worst bucket was " .. tostring(largestCellIndex) .. " containing " .. tostring(largestCell) .. ". Total " .. tostring(totalLightsInCells))
  local shadows = totalLightsInCells

  largestCell = -1
  largestCellIndex = 0
  totalLightsInCells = 0

  for i,c in ipairs(partitionGrid3) do
    if #c > largestCell then
      largestCellIndex = i
      largestCell = #c
    end
    totalLightsInCells = totalLightsInCells + #c
  end
  log('D', 'prepareLights', "Total small lights spaces: " .. tostring(totalPartitionGrid3Spaces))
  log('D', 'prepareLights', "Worst bucket was " .. tostring(largestCellIndex) .. " containing " .. tostring(largestCell) .. ". Total " .. tostring(totalLightsInCells))
  -- Display nice info for curious players
  -- This data should depend on user game settings
  log('I', 'prepareLights', "Total amount of active lights: " .. tostring(totalLightsInCells + bigLights).. ". Total amount of lights casting shadows: " ..tostring(shadows))
end

local function prepareTraffic()
  log('I', 'prepareTraffic', "Checking traffic availability")
  if FS:fileExists(trafficGroupPath) and FS:fileExists("/vehicles/agent_traffic_yakuza/info.json") then
    trafficInstalled = true
    log('I', 'prepareTraffic', "Traffic pack is installed :)")
  else
    trafficInstalled = false
    log('I', 'prepareTraffic', "Traffic pack is not installed :(")
  end
end

local function onClientStartMission()
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  log('I', 'onClientStartMission', 'Getting current level path' )
  levelname = getCurrentLevelIdentifier()
  levelfolder = ("/levels/" .. levelname .. "/")
  if TorqueScriptLua then
    lightmgr = tostring(TorqueScriptLua.getVar("$pref::lightManager"))
    log('I', 'onClientStartMission', lightmgr )
    shadowdisable = tonumber(TorqueScriptLua.getVar("$pref::Shadows::disable"))
    local tempEmissive = FS:findFiles(levelfolder, '*emission_data.json', 1, true, false)
    for k,filename in pairs(tempEmissive) do
      emissiveTable = jsonReadFile(filename) or {}
    end
    if tableIsEmpty(emissiveTable) then
      local tempEmissive = FS:findFiles("/temp" ..levelfolder, '*emission_data.json', 1, true, false)
      for k,filename in pairs(tempEmissive) do
        emissiveTable = jsonReadFile(filename) or {}
      end
    end
    if not tableIsEmpty(emissiveTable) then
      extensions.core_jobsystem.create(initializeEmissive, 2)
    end
    local tempWetMats = FS:findFiles(levelfolder, '*wetmat_data.json', 1, true, false)
    for k,filename in pairs(tempWetMats) do
      wetMaterialsTable = jsonReadFile(filename) or {}
    end
    if tableIsEmpty(wetMaterialsTable) then
      local tempWetMats = FS:findFiles("/temp" ..levelfolder, '*wetmat_data.json', 1, true, false)
      for k,filename in pairs(tempWetMats) do
        wetMaterialsTable = jsonReadFile(filename) or {}
      end
    end
    instanceData = getInstanceData()
    cubemapname = "cubemap_st_souyakucenter_judge_reflection"
    setCubemap(cubemapname)
  end
  adapterType = Engine.Render.getAdapterType()
  if adapterType == "Vulkan" then isVulkan = true end
  luaLoaded = true
  prepareLights()
  prepareTraffic()
  log('I', 'onClientStartMission', 'Level is loaded' )
  appTitle = " CK Map Controller - ".. tool_version .." - ".. levelname .." - ".. beamng_arch
  debugTitle = "Debug Controller - ".. tool_version .." - ".. levelname .." - ".. beamng_arch
end

--get scene tree all objects
local function getSimObjects(fileName)
  local ret = {}
  local objs = scenetree.getAllObjects()
  --log('E', '', '# objects existing: ' .. tostring(#scenetree.getAllObjects()))
  for _, objName in ipairs(objs) do
    local o = scenetree.findObject(objName)
    if o and o.getFileName then
      if o:getFileName() == fileName then
        table.insert(ret, o)
      end
    end
  end
  return ret
  --log('E', '', '# objects left: ' .. tostring(#scenetree.getAllObjects()))
end

local function getFontList()
  local fonts = {}
  for i = 0, im.IoFontsGetCount() - 1 do
    table.insert(fonts,
    {
      name = ffi.string(im.IoFontsGetName(i))
    })
  end
  return fonts
end

local function onUiChangedState(newUIState, prevUIState)
  if newUIState:sub(1, 4) == 'menu' then
    skipImgui = false
  else
    skipImgui = true
  end
  if newUIState:sub(1, 4) == 'fade' then
    log("I", "onUiChangedState", "fadeScreenRunning")
    fadeScreenRunning = true
  else
    fadeScreenRunning = false
  end
end

local function getConsoleNumber(varName)
  local result = getConsoleVariable(varName)
  return result == "" and -1 or result
end

local function getFadeScreenData(preview, sub, desc)
  local level_name = "st_souyakucenter_judge"
  local preview = preview or nil
  if level_name == nil then
    if levelname == nil then level_name = "no_init" else level_name = levelname end
  end
  return {image = preview, title = level_name, subtitle = sub, text = desc}
end

--Gameengine decal road workaround
local function fixDecalRoad(group)
  if not group then
    log('E', "fixDecalRoad", "Night reflection group is missing, please contact level author")
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    local decalroad = scenetree.findObjectById(id)
    decalroad.renderPriority = 9
    decalroad.renderPriority = 10
  end
end
end

local function onParticleActivity(group, value)
  if not group then
    log('E', "onParticleActivity", "Group is missing")
  else
    for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local particleEmitter = scenetree.findObjectById(id)
      particleEmitter.active = value
    end
  end
end

local rainAmount = 0
--DynamicWeather
local function setWeather(fogscaleval, colorval, sunval, ambientval, fogamnt, fogHeight, group, rainamnt, vol, useSkybox, skyMat)
  local tod = scenetree.tod
  core_environment.setFogScaleGradientFile(fogscaleval)
  core_environment.setColorizeGradientFile(colorval)
  core_environment.setSunScaleGradientFile(sunval)
  core_environment.setAmbientScaleGradientFile(ambientval)
  core_environment.setFogDensity(fogamnt)
  core_environment.setFogAtmosphereHeight(fogHeight)
  core_environment.setNightFogGradientFile(fogscaleval)
  --core_environment.setPrecipitation(rainamnt)
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    local precipitation = scenetree.findObjectById(id)
    local sfx
    if isThunder == true then
      --onParticleActivity(scenetree.thunder_particle, true)
      sfx = scenetree.findObject("thndr_rain")
      core_environment.setTimeOfDay(tod)
    else
      --onParticleActivity(scenetree.thunder_particle, false)
      core_environment.setTimeOfDay(tod)
      sfx = scenetree.findObjectById(id)
    end
    --[[local skyBox = scenetree.findObject("SkyBox_1")
    if useSkybox == true then
      skyBox.Material = skyMat
      isUsingSkybox = true
      skyBox:postApply()
      skyBox.hidden = false
    else
      skyBox.hidden = true
      isUsingSkybox = false
    end]]--
    precipitation.numDrops = rainamnt
    rainAmount = rainamnt
    sfx.volume = vol
    sfx:postApply()
  end
  guihooks.trigger('Message', {ttl = 10, msg = 'Weather Changed', icon = "goat"})
end

local thndrcnt = 0
local delay = 0
local isPlayedA = false
local isPlayedB = false
local isPlayedC = false
local isPlayedD = false
local realTime = 0
local rndcont = 0

local randomoffset1 = math.random(-3000, 3000)
local randomoffset2 = math.random(-3000, 3000)
local randomoffset3 = math.random(150, 300)

local function onWeatherThunder(dtSim, dtReal)
  local paused = dtSim < 0.00001
  if not paused then
    local playerWPos
    realTime = realTime + dtReal
    thndrcnt = thndrcnt + dtSim
    if realTime >= 5 then
      rndcont = math.random(5, 60)
      if math.random(1, 8) == 4 then
        randomoffset1 = math.random(-500, 500)
        randomoffset2 = math.random(-500, 500)
        randomoffset3 = math.random(1, 200)
      else
        randomoffset1 = math.random(-3000, 3000)
        randomoffset2 = math.random(-3000, 3000)
        randomoffset3 = math.random(1, 200)
      end
      realTime = 0
    end
    if thndrcnt >= rndcont then
      --FIX FUCKIN MATH THERE, THERE IS A BETTER WAY TO DO THIS
      -- done :)
      local veh = be:getPlayerVehicle(0)
      local sounddelay = 0
      local dir = levelfolder.."/art/sound/"
      local sndTable = {dir.."Thunder_a.mp3",dir.."thunder_b.mp3",dir.."thunder_c.mp3",dir.."thunder_d.mp3"}
      if veh then
        playerWPos = vec3(veh:getPosition())
      else
        playerWPos = vec3(core_camera.getPosition())
      end
      local oldplayerPos = playerWPos
      playerWPos = playerWPos + vec3(randomoffset1, randomoffset2, randomoffset3)
      sounddelay = (oldplayerPos - playerWPos):length()
      sounddelay = sounddelay / 331 --sound speed in m/s
      if sounddelay < 0 then sounddelay = -sounddelay end
      local thunderbolt = scenetree.findObject("thunder_obj")
      local vfx = scenetree.findObject("thndr")
      thunderbolt:setPosition(playerWPos)
      vfx.radius = scenetree.theLevelInfo.visibleDistance / 2
      vfx:setPosition(playerWPos)
      if isPlayedA ~= true and randomoffset2 then
        hideGroup("thunder", false)
        isPlayedA = true
        delay = 0
      end
      if delay >= math.random(0.05, 0.3) and isPlayedA == true and isPlayedB ~= true then
        hideGroup("thunder", true)
        delay = 0
        isPlayedB = true
      end
      if delay >= math.random(0.05, 0.1) and isPlayedB == true and isPlayedC ~= true then
        hideGroup("thunder", false)
        delay = 0
        isPlayedC = true
      end
      if delay >= math.random(0.05, 0.3) and isPlayedC == true and isPlayedD ~= true then
        hideGroup("thunder", true)
        delay = 0
        isPlayedD = true
      end
      if delay >= sounddelay and isPlayedC == true then
        Engine.Audio.playOnce('AudioEnvironment', sndTable[math.random(1, 4)])
        thndrcnt = 0
        delay = 0
        isPlayedA = false
        isPlayedB = false
        isPlayedC = false
        isPlayedD = false
      end
    end
  end
end

--DYNAMIC MATERIALS SYSTEM - 2022 Car_Killer
--DAY/NIGHT Section
local function enabledisableEmissionGlow(job, isEmissive)
  log('I', "enabledisableEmissionGlow", "Switching Materials...")
  --waitForUI()
 --[[ local loadingSoundId = nil
  local soundParams = nil
  soundParams = SFXParameterGroup("LoadingSoundParams")
  loadingSoundId = Engine.Audio.createSource('AudioGui', "/levels/st_souyakucenter_judge/art/sound/PleaseListenKiryu.mp3")
  local snd = scenetree.findObjectById(loadingSoundId)]]--

  local loadingText
  local loadingIMG
  if isEmissive == 1 then
    loadingText = "Ono Michio is lurking in the shadows"
    loadingIMG = "/levels/st_souyakucenter_judge/loading_night.jpg"
  else
    loadingText = "The Friday Night has ended"
    loadingIMG = "/levels/st_souyakucenter_judge/loading_day.jpg"
  end
  --ui_fadeScreen.start(1, getFadeScreenData(loadingIMG, "Switching time of day", loadingText))
  guihooks.trigger('app:waiting', true) -- shows the loading icon
  job.sleep(0.5) --pause code so fancy loading is rendering
  --[[if snd then
    snd:play(-1)
    soundParams:addSource(snd.obj)
  end]]--

  if levelname == nil then
    log('E', "enabledisableEmissionGlow", "No init, please restart the game")
    guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
  else
    if tableIsEmpty(emissiveTable) then
      log('W','enabledisableEmissionGlow', 'Emissive list is missing, generating new one' )
      local materialFiles = FS:findFiles(levelfolder, "*materials.json", -1, true, false)
      log('D', '', dumps(materialFiles))
      for _, fn in ipairs(materialFiles) do
        local dir, basefilename, ext = path.splitWithoutExt(fn)

        if string.find(fn, 'materials.cs$') then
          TorqueScript.exec(fn)
          objects = getSimObjects(fn)
        elseif string.find(fn, 'materials.json$') then
          loadJsonMaterialsFile(fn)
          objects = getSimObjects(fn)
        end

        if not tableIsEmpty(objects) then
          log('I', 'enabledisableEmissionGlow', 'parsing all materials file: ' .. tostring(fn))

          for _, obj in ipairs(objects) do
            if obj:getField('emissiveFactor', 0) ~= "0 0 0" and obj:getField('emissiveFactor', 0) ~= "" and obj:getField('instanceEmissive', 0) ~= "1" then
              log('I', 'enabledisableEmissionGlow', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Emission: ' .. tostring(obj:getField('emissiveFactor', 0)).. ' - Layer: 0' )
              table.insert(emissiveTable, { tostring(obj:getName()), tostring(obj:getField('emissiveFactor', 0)), 0 })
            end
            if obj:getField('emissiveFactor', 1) ~= "0 0 0" and obj:getField('emissiveFactor', 1) ~= "" and obj:getField('instanceEmissive', 0) ~= "1" then
              log('I', 'enabledisableEmissionGlow', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Emission: ' .. tostring(obj:getField('emissiveFactor', 1)).. ' - Layer: 1' )
              table.insert(emissiveTable, { tostring(obj:getName()), tostring(obj:getField('emissiveFactor', 1)), 1 })
            end

          end
        end
      end

      local res = jsonWriteFile('/temp' ..levelfolder.. 'main.emission_data.json', emissiveTable, true)
      if not res then
        log('W', "enabledisableEmissionGlow", "unable to save emission data")
      else
        log('I', "enabledisableEmissionGlow", "Saved emission data in /temp" .. levelfolder .. "main.emission_data.json")
      end

    else
      if isEmissive == 1 then
        for k,v in pairs(instanceData) do
          local instance = scenetree.findObjectById(k)
          if instance then
            instance:setField('instanceColor', 0, v[1])
            instance:setField('instanceColor1', 0, v[2])
            instance:setField('instanceColor2', 0, v[3])
            instance:updateInstanceRenderData()
          end
        end
        for k,v in pairs(emissiveTable) do
          local obj = scenetree.findObject(v[1])
          if obj and obj:getField('emissiveFactor', v[3]) ~= v[2] then
            setMaterialProperty(v[1], 'emissiveFactor', v[3], v[2])
            log('I', "enabledisableEmissionGlow", "Switching Material "..v[1].." layer "..v[3])
          end
          job.yield()
        end
      else
        for k,v in pairs(instanceData) do
          local instance = scenetree.findObjectById(k)
          if instance then
            instance:setField('instanceColor', 0, "Black")
            instance:setField('instanceColor1', 0, "Black")
            instance:setField('instanceColor2', 0, "Black")
            instance:updateInstanceRenderData()
          end
        end
        for k,v in pairs(emissiveTable) do
          local obj = scenetree.findObject(v[1])
          if obj and obj:getField('emissiveFactor', v[3]) ~= "0 0 0" then
            setMaterialProperty(v[1], 'emissiveFactor', v[3], "0 0 0")
            log('I', "enabledisableEmissionGlow", "Switching Material "..v[1].." layer "..v[3])
          end
          job.yield()
        end
      end
      log('I', "enabledisableEmissionGlow", "Switching Done!")
    end
end
--[[if loadingSoundId then
  Engine.Audio.deleteSource(loadingSoundId)
  loadingSoundId = nil
end]]--
job.sleep(0.1)
--ui_fadeScreen.stop(1)
guihooks.trigger('app:waiting', false)
end

--WET/DRY Section
local function setDryWetMaterials(roughnessVal, groundVal)
  log('I', "setDryWetMaterials", "Switching Materials...")
  if levelname == nil then
    log('E', "setDryWetMaterials", "No init, please restart the game")
    guihooks.trigger('Message', {ttl = 10, msg = 'No init, please restart the game', icon = "goat"})
  else
    if tableIsEmpty(wetMaterialsTable) then
      log('W','setDryWetMaterials', 'Emissive list is missing, generating new one' )
      local materialFiles = FS:findFiles(levelfolder, "*materials.json", -1, true, false)
      log('D', '', dumps(materialFiles))
      for _, fn in ipairs(materialFiles) do
        local dir, basefilename, ext = path.splitWithoutExt(fn)

        if string.find(fn, 'materials.cs$') then
          TorqueScript.exec(fn)
          objects = getSimObjects(fn)
        elseif string.find(fn, 'materials.json$') then
          loadJsonMaterialsFile(fn)
          objects = getSimObjects(fn)
        end

        if not tableIsEmpty(objects) then
          log('I', 'setDryWetMaterials', 'parsing all materials file: ' .. tostring(fn))

          for _, obj in ipairs(objects) do
            if obj and obj.___type == "class<Material>" then
              if string.startswith(obj:getField('name', 0), "r_rd_") then
                log('I', 'setDryWetMaterials', ' * ' .. tostring(obj:getClassName()) .. ' - ' .. tostring(obj:getName()) .. ' - Layer: 0' )
                table.insert(wetMaterialsTable, { tostring(obj:getName()), tostring(obj:getField('roughnessFactor', 0)), tostring(obj:getField('groundType', 0))})
              end
            end
          end
        end
      end

      local res = jsonWriteFile('/temp' ..levelfolder.. 'main.wetmat_data.json', wetMaterialsTable, true)
      if not res then
        log('W', "setDryWetMaterials", "unable to save emission data")
      else
        log('I', "setDryWetMaterials", "Saved emission data in /temp" .. levelfolder .. "main.wetmat_data.json")
      end
    else
      if groundVal == 'ASPHALT_WET' then
        for k,v in pairs(wetMaterialsTable) do
          local obj = scenetree.findObject(v[1])
          if obj and obj:getField('roughnessFactor', 0) ~= roughnessVal and obj:getField('groundType', 0) ~= groundVal then
            setMaterialProperty(v[1], 'roughnessFactor', 0, roughnessVal)
            setMaterialProperty(v[1], 'groundType', 0, groundVal)
            log('I', "setDryWetMaterials", "Switching Material "..v[1])
          end
        end
      else
        for k,v in pairs(wetMaterialsTable) do
          if v[3] == "" or v[3] == "0" then v[3] = "ASPHALT" end
          local obj = scenetree.findObject(v[1])
          if obj then
            local groundType = obj:getField('groundType', 0)
            if groundType == "" or groundType == "0" then groundType = "ASPHALT" end
            if obj:getField('roughnessFactor', 0) ~= v[2] and obj:getField('groundType', 0) ~= v[3] then
              setMaterialProperty(v[1], 'roughnessFactor', 0, v[2])
              setMaterialProperty(v[1], 'groundType', 0, v[3])
              log('I', "setDryWetMaterials", "Switching Material "..v[1])
            end
          end
        end
      end
    end
    be:reloadCollision()
    log('I', "setDryWetMaterials", "Switching Done!")
  end
end

--never joke about pissfilters near me
local function onSelectedColorRamp(colorRamp)
  if colorRamp == 0 then TorqueScriptLua.setVar("PostEffectCombinePassObject.colorCorrectionRampPath", "") end
  if colorRamp == 1 then TorqueScriptLua.setVar("PostEffectCombinePassObject.colorCorrectionRampPath", "/levels/st_souyakucenter_judge/art/colorramp/kiwami2d.png") end
  if colorRamp == 2 then TorqueScriptLua.setVar("PostEffectCombinePassObject.colorCorrectionRampPath", "/levels/st_souyakucenter_judge/art/colorramp/kiwami2.png") end
  if colorRamp == 3 then TorqueScriptLua.setVar("PostEffectCombinePassObject.colorCorrectionRampPath", "/levels/st_souyakucenter_judge/art/colorramp/y6.png")  end
  if colorRamp == 4 then TorqueScriptLua.setVar("PostEffectCombinePassObject.colorCorrectionRampPath", "/levels/st_souyakucenter_judge/art/colorramp/y6n.png")  end
end

local function spawnYkTraffic()
  if trafficInstalled == true then
    local trafficGroup = jsonReadFile(trafficGroupPath)
    local amountFromSettings = settings.getValue('trafficAmount')
    if amountFromSettings == 0 then -- use CPU-based value
      amountFromSettings = getMaxVehicleAmount(32)
    end
    local amount = extensions.gameplay_traffic.getIdealSpawnAmount(amountFromSettings)

    log('I', "spawnYkTraffic", "Spawning "..tostring(amount).." vehicles")
    extensions.core_multiSpawn.spawnGroup(trafficGroup.data, amount, {name = 'kamuroTrafficCurrent', shuffle = true, gap = 20, instant = true, configPopPower = 10})
    extensions.gameplay_traffic.scatterTraffic(extensions.gameplay_traffic.getTrafficList(), 0, 2000)
    if settings.getValue('trafficParkedVehicles') then
      local parkedAmount = settings.getValue("trafficParkedAmount")
      extensions.core_multiSpawn.spawnGroup(trafficGroup.data, parkedAmount, {name = 'autoParking', shuffle = true, gap = 20, instant = true, configPopPower = 10})
      extensions.gameplay_parking.scatterParkedCars(extensions.gameplay_parking.getParkedCarsList(), 0, 2000)
    end
    extensions.gameplay_traffic.activate()
  else
    log('E', "spawnYkTraffic", "Traffic pack is not installed!")
  end
end

local function onBeamNGTrigger(data)
  -- dump(data)
  if data.triggerName == "kamuro_teleport" and data.event == "enter" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 1
    end
  end
  if data.event == "exit" then
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 0
    end
  end
end


local pos = im.ImVec2(0, 0)
local function teleportUI()
  if playerisintrigger == 1 or playerisintrigger == 2 or playerisintrigger == 3 or playerisintrigger == 4 then
    local addonmap = nil
    if playerisintrigger == 1 then
      addonmap = FS:fileExists(otherLevelPath)
    end
    local win = im.GetMainViewport()

    local image2 = imguiUtils.texObj('/levels/st_souyakucenter_judge/map_switch.png')
    local image2size = im.ImVec2(640, 480)
    -- set position
    pos.x = win.Pos.x + win.Size.x / 2
    pos.y = win.Pos.y + win.Size.y / 2
    im.SetNextWindowPos(pos, im.ImGuiCond_Always, im.ImVec2(0.5, 0.5))
    im.SetNextWindowBgAlpha(0.7)

    im.Begin(promptTitle, nil, im.WindowFlags_AlwaysAutoResize+im.WindowFlags_NoResize+im.WindowFlags_NoMove+im.WindowFlags_NoCollapse+im.WindowFlags_NoDocking+im.WindowFlags_NoTitleBar)
    im.PushFont3("cairo_bold")
    if addonmap == true then
      im.SetWindowFontScale(2.0)
      im.Text("\n       Do you want to switch to another map?        \n ")
      if playerisintrigger == 1 then
        if im.Button("Tokyo, Kamurocho", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
          freeroam_freeroam.startFreeroam(otherLevelPath, nil, nil, getCurrentVehicle())
        end
      end
      if im.Button("Stay Here", im.ImVec2(im.GetContentRegionAvailWidth(), 0)) then
        playerisintrigger = 0
      end
    else
      im.SetWindowFontScale(1.65)
      if playerisintrigger == 1 then
        im.Text("This feature requires the Tokyo, Kamurocho, Japan (2018) mod. This can be downloaded from the repository link below, come back once it has been installed")
      end
      im.Text("")
      im.Image(image2.texId, image2size, im.ImVec2(0, 0), im.ImVec2(1, 1), col)
      im.Text("")
      im.SetWindowFontScale(1.2)
      if im.Button("Download (beamng.com)", im.ImVec2(120, 0)) then
        playerisintrigger = 0
        openWebBrowser("https://www.beamng.com/threads/83067/")
      end
      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text("Open BeamNG Repository in your web browser")
        im.EndTooltip()
      end
    end
    im.PopFont()
    im.SetWindowFontScale(1.0)
    im.End()
  end
end

local function renderDebugImgui()
  im.Begin(debugTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  if editor and editor.isEditorActive and editor.isEditorActive() then
    im.PushItemWidth(im.GetContentRegionAvailWidth())
    im.Text("Speedtraps scenetree group")
    if im.InputText("##speedtrpgroup", speedtrpgroup) then
    end
    im.Text("Speedzones scenetree group")
    if im.InputText("##speedzonegroup", speedzonegroup) then
    end
    im.Text("Cubemaps scenetree group")
    if im.InputText("##cubemapgroup", cubemapgroup) then
    end
    im.PopItemWidth()
    if im.Button("Generate waypoints data") then
      local speedtrpgroup = ffi.string(speedtrpgroup)
      local trapgroup = scenetree[speedtrpgroup]

      local speedzonegroup = ffi.string(speedzonegroup)
      local zonegroup = scenetree[speedzonegroup]

      local cubemapgroup = ffi.string(cubemapgroup)
      local cubegroup = scenetree[cubemapgroup]

      local trapwaypoints = {}
      local zonewaypoints = {}
      local cubemapwaypoints = {}

      if trapgroup and speedtrpgroup then
        for i = 0, trapgroup.obj:getCount(), 1 do
          local id = trapgroup.obj:idAt(i)
          local wpobj = scenetree.findObjectById(id)
          local wp = wpobj:getName()
          if wpobj:isSubClassOf("BeamNGTrigger") then
            table.insert(trapwaypoints, wp)
          end
        end
      end

      if zonegroup and speedzonegroup then
        for i = 0, zonegroup.obj:getCount(), 1 do
          local id = zonegroup.obj:idAt(i)
          local wpobj = scenetree.findObjectById(id)
          local wp = wpobj:getName()
          if wpobj:isSubClassOf("BeamNGTrigger") then
            table.insert(zonewaypoints, wp)
          end
        end
      end

      if cubegroup and cubemapgroup then
        for i = 0, cubegroup.obj:getCount(), 1 do
          local id = cubegroup.obj:idAt(i)
          local wpobj = scenetree.findObjectById(id)
          local wp = wpobj:getName()
          if wpobj:isSubClassOf("BeamNGTrigger") then
            table.insert(cubemapwaypoints, wp)
          end
        end
      end

        local jsonData = {}
        jsonData.levelname = levelname
        jsonData.directory = levelfolder
        jsonData.speedtraps = {}
        jsonData.speedzones = {}
        jsonData.cubemaps = {}
        jsonData.version = tool_version
        for k,v in pairs(trapwaypoints) do
          jsonData.speedtraps[v] = {}
          jsonData.speedtraps[v].triggerName = v
          jsonData.speedtraps[v].name = "Replace with name"
          jsonData.speedtraps[v].speedLimit = 60
        end
        for k,v in pairs(zonewaypoints) do
          jsonData.speedzones[v] = {}
          jsonData.speedzones[v].triggerName = v
          jsonData.speedzones[v].name = "Replace with name"
          jsonData.speedzones[v].speedLimit = 60
        end
        for k,v in pairs(cubemapwaypoints) do
          jsonData.cubemaps[v] = {}
          jsonData.cubemaps[v].triggerName = v
          jsonData.cubemaps[v].cubemapname = "cubemap_"..levelname.."_reflection"
        end
        dump(jsonData)
        extensions.editor_fileDialog.saveFile(
          function(data)
            local dir, filename, ext = path.splitWithoutExt(data.filepath, true)
            local saveData = jsonData
            saveData.name = filename
            jsonWriteFile(data.filepath, saveData, true)
            log("I","saveData","Saved Waypoint Data to " .. data.filepath)
          end,
          {{"Waypoint Data",".waypoint_data.json"}}, false, 'levels/'..levelname)
        end
    else
      if im.Button("Enable all features") then
        editor.toggleActive()
      end
    end
    if im.Button("Enable Emissive") then
      extensions.core_jobsystem.create(enabledisableEmissionGlow, 2, 1)
    end
    if im.Button("Add roughness to all ne kanbans") then
      local allObjects = scenetree:getAllObjects()
      if allObjects then
        for k,name in pairs(allObjects) do
          local object = scenetree.findObject(name)
          if object and object.___type == "class<Material>" then
            if object:getField('emissiveMap', 0) == "/levels/st_souyakucenter_judge/art/st_souyakucenter_judge/textures/r_ne_kan_all_a1_na_d_d.color.png" then
              object:setField('roughnessMap', 0, '/levels/st_souyakucenter_judge/art/st_souyakucenter_judge/textures/r_pl_kan_all_m2_na_m_r.data.png')
              if object:getField("activeLayers", 0) > 1 then
                object:setField('roughnessMap', 1, '/levels/st_souyakucenter_judge/art/st_souyakucenter_judge/textures/r_pl_kan_all_m2_na_m_r.data.png')
              end
              object:flush()
              scenetree.matLuaEd_PersistMan:setDirty(object, '')
              scenetree.matLuaEd_PersistMan:saveDirty()
              object:reload()
            end
          end
        end
      end
    end
    if im.Button("Add tunnel triggers") then
      local count = 0
      local tunnelZone = scenetree.Zones
      local missionGroup = scenetree.MissionGroup
      if tunnelZone then
        for i = 0, tunnelZone.obj:getCount(), 1 do
          local id = tunnelZone.obj:idAt(i)
          local obj = scenetree.findObjectById(id)
          if obj and obj:getClassName() == "Zone" then
            count = count + 1
            local position = obj:getPosition()
            local rotation = obj:getRotation()
            local scale = obj:getScale()
            local createTrigger
            createTrigger = createObject('BeamNGTrigger')
            createTrigger:setPosRot(position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w)
            createTrigger:setScale(scale)
            createTrigger:registerObject("TunnelTrigger_"..count)
            missionGroup:addObject(createTrigger)
          end
        end
      end
    end
    if im.Button("Light generator") then
      local count = 0
      local AllObjects = scenetree.getAllObjects()
      local missionGroup = scenetree.MissionGroup
      --[[if AllObjects and missionGroup then
        for k,name in pairs(AllObjects) do
          local object = scenetree.findObject(name)
          if object:isSubClassOf("TSStatic") then
            if string.endswith(object:getModelFile(), '8A_66_60_BA.dae') or string.endswith(object:getModelFile(), '71_5E_5C_AF.dae') or string.endswith(object:getModelFile(), 'DD_91_E0_0C.dae') then
              local position = object:getWorldBoxCenter()
              local createLight
              print(position)
              count = count + 1
              createLight = createObject('PointLight')
              createLight:setPosition(position)
              createLight:registerObject("StreetLightH_"..count)
              missionGroup:addObject(createLight)
            end
          end
        end
      end]]--
    end
    if im.Button("Light optimizer") then
      local lights = {}
      local count = 0
      local AllObjects = scenetree.getAllObjects()
      if AllObjects then
        for k,name in pairs(AllObjects) do
          local object = scenetree.findObject(name)
          if object:isSubClassOf("LightBase") then
            local position = object:getPosition()
            if position then
              local posX = tonumber(string.format("%.1f", position.x))
              local posY =  tonumber(string.format("%.1f", position.y))
              local newPos = tostring(vec3(posX, posY, 0))
              if lights[newPos] == true then
                print(object:getName())
                object:deleteObject()
              end
              lights[newPos] = true
            end
          end
        end
      end
    end
    if im.Button("Get lights amount") then
      local count = 0
      local AllObjects = scenetree.getAllObjects()
      if AllObjects then
        for k,name in pairs(AllObjects) do
          local object = scenetree.findObject(name)
          if object:isSubClassOf("LightBase") then
            count = count +1
          end
        end
        print('There is '..count..' lights in the level')
      end
    end
    if im.Button("Slap Delay Generator") then
      local positions = {}
      local count = 0
      local AllObjects = scenetree.getAllObjects()
      local missionGroup = scenetree.MissionGroup
      if AllObjects and missionGroup then
        for k,name in pairs(AllObjects) do
          local object = scenetree.findObject(name)
          if object:isSubClassOf("SpotLight") then
            local position = object:getPosition()
            if not tableIsEmpty(positions) then
              for k,v in pairs(positions) do if (v - position):length() < 40  then goto skipObject end end
            end
            local createDelay
            count = count + 1
            createDelay = createObject('SFXEmitter')
            createDelay:setPosition(position)
            createDelay:setField('track',0, 'event:>Special>Slap Delays>Delay_10')
            createDelay:registerObject("SlapDelay10_"..count)
            missionGroup:addObject(createDelay)
            table.insert(positions, position)
          end
          ::skipObject::
        end
      end
      print("Done. Generated: "..count.." objects")
    end
  im.End()
end

local function renderImgui()
  --imgui app
  im.Begin(appTitle, showUI, im.WindowFlags_AlwaysAutoResize)
  if isVulkan == false then
    im.TextColored(im.ImVec4(0.76, 0.27, 0.27, 1), "Game is running in "..tostring(adapterType).." mode,\nexpect low performance and issues.\nPlease run the game in Vulkan API mode\nto ensure best experience.")
  end
  if TorqueScriptLua then
    if levelname == nil then
      im.Text("No init, please restart the game")
      im.Text("Some features are not available")
      im.Text("")
      if im.Button("Fix level lua without restarting") then
        extensions.mainLevel.onClientStartMission()
      end
      im.Text("")
    else
      im.Text("Change weather")
      --fog, color, sun, ambient, fog density, group, rain, volume of rain
      --Road roughness and ground type
      if im.Button("Set Clear (Default)") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/default/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_ambient.png", 0.001, 1200, scenetree.Level_objects, 0, 0, false, nil)
        if isWet == 1 then
          setDryWetMaterials(1, "ASPHALT")
          --hideGroup("ck_rainroad", true)
          --fixDecalRoad(scenetree.ck_rainroad)
          isWet = 0
          elseif isWet == 0 then
        end
        hideGroup("thunder", true)
      end

      im.SameLine()
      if im.Button("Set Wet (Clear)") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/default/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_ambient.png", 0.001, 1200, scenetree.Level_objects, 0, 0, false, nil)
        if isWet == 0 then
          setDryWetMaterials(0.4, "ASPHALT_WET")
          --hideGroup("ck_rainroad", false)
          --fixDecalRoad(scenetree.ck_rainroad)
          isWet = 1
          elseif isWet == 1 then
        end
        hideGroup("thunder", true)
      end

      if im.Button("Set Overcast") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.003, 1200, scenetree.Level_objects, 0, 0, false, nil)
        if isWet == 1 then
          setDryWetMaterials(1, "ASPHALT")
          --hideGroup("ck_rainroad", true)
          --fixDecalRoad(scenetree.ck_rainroad)
          isWet = 0
          elseif isWet == 0 then
        end
        hideGroup("thunder", true)
      end

      im.SameLine()
      if im.Button("Set Foggy") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/foggy/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/foggy/gradient_ambient.png", 0.010, 0, scenetree.Level_objects, 0, 0, false, nil)
        if isWet == 1 then
          setDryWetMaterials(1, "ASPHALT")
          --hideGroup("ck_rainroad", true)
          --fixDecalRoad(scenetree.ck_rainroad)
          isWet = 0
          elseif isWet == 0 then
        end
        hideGroup("thunder", true)
      end

      if im.Button("Set Rain") then
        isThunder = false
        setWeather(levelfolder .. "/art/skies/sky_gradients/overcast/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/overcast/gradient_ambient.png", 0.005, 0, scenetree.Level_objects, 2048, 0.6, false, nil)
        if isWet == 0 then
          setDryWetMaterials(0.4, "ASPHALT_WET")
          --hideGroup("ck_rainroad", false)
          --fixDecalRoad(scenetree.ck_rainroad)
          isWet = 1
          elseif isWet == 1 then
        end
        hideGroup("thunder", true)
      end

      im.SameLine()
      if im.Button("Set Thunder") then
        isThunder = true
        setWeather(levelfolder .. "/art/skies/sky_gradients/thunder/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/thunder/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/thunder/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/thunder/gradient_ambient.png", 0.015, 0, scenetree.Level_objects, 2048*1.5, 1, true, "cloudy-original")
        if isWet == 0 then
          setDryWetMaterials(0.4, "ASPHALT_WET")
          --hideGroup("ck_rainroad", false)
          --fixDecalRoad(scenetree.ck_rainroad)
          isWet = 1
          elseif isWet == 1 then
        end
      end
      im.Separator()
      --if you hate pissfilters blame DankMemeBunny
      im.Text("Change color correction")
      if im.Combo2("##Selected Color Ramp", selectedColorRamp, "Default\0Yakuza Kiwami 2 (Day)\0Yakuza Kiwami 2 (Night)\0Yakuza 6 (Day)\0Yakuza 6 (Night)\0\0") then
        onSelectedColorRamp(selectedColorRamp[0])
      end
      if selectedColorRamp[0] ~= 0 then
        im.Text("Color correction intensity")
        correctionBias[0] = tonumber(TorqueScriptLua.getVar("PostEffectCombinePassObject.colorCorrectionStrength")) or 1
        im.PushItemWidth(im.GetContentRegionAvailWidth())
        if im.SliderFloat("##correction_int", correctionBias, 0, 1, "%.2f") then
          TorqueScriptLua.setVar("PostEffectCombinePassObject.colorCorrectionStrength", correctionBias[0])
        end
      end
      im.Separator()
    end
    if trafficInstalled == true then
      im.Text("Yakuza Traffic")
      if im.Button("Spawn Traffic") then spawnYkTraffic() end
      im.SameLine()
      if im.Button("Remove Traffic") then
        extensions.gameplay_parking.deleteVehicles()
        extensions.gameplay_traffic.deleteVehicles()
      end
      im.Separator()
    end
    if im.TreeNode1("Advanced settings") then
      im.Separator()
      local dbgEnabled = im.BoolPtr(debugEnabled)
      if im.Checkbox("Enable Debug", dbgEnabled) then
        debugEnabled = dbgEnabled[0]
      end
      im.TreePop()
    end
  end
  im.End()
end

local cubevalue = false

local function onUpdate(dtReal, dtSim)
  if luaLoaded == false then
    extensions.mainLevel.onClientStartMission()
  end

  tod = scenetree.tod

  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end

  local dont_showUI
  if freeroam_bigMapMode then
    dont_showUI = freeroam_bigMapMode.bigMapActive() == true or photoModeOpen or fadeScreenRunning ~= false
  end

  if not dont_showUI and skipImgui == false then
    --imgui app
    renderImgui()
    if debugEnabled == true then
      renderDebugImgui()
    end
  end
  teleportUI()
  delay = delay + dtSim

  if not tod then return end

  local value = (tod.time > 0.21 and tod.time < 0.79)
  local cameraCell = getCellIndexForPosition(core_camera.getPosition())
  local cameraCell2 = getCellIndexForPosition2(core_camera.getPosition())
  local cameraCell3 = getCellIndexForPosition3(core_camera.getPosition())

  if (cameraCell ~= lastCameraCell or lastValue ~= value) and positionInRange(core_camera.getPosition())  then
    local xCell, zCell = getCellForPosition(core_camera.getPosition())
    enableLights(xCell, zCell, value)
  end
  if (cameraCell3 ~= lastCameraCell3 or lastValue ~= value) and positionInRange3(core_camera.getPosition())  then
    local xCell, zCell = getCellForPosition3(core_camera.getPosition())
    enableSmallLights(xCell, zCell, value)
  end

  local valueAdd = false
  if value == false then valueAdd = true end
  if valueAdd == true then
    if (cameraCell ~= lastCameraCell or lastValueAdd ~= valueAdd) and positionInRange(core_camera.getPosition()) then
      local xCell, zCell = getCellForPosition(core_camera.getPosition())
      enableLights(xCell, zCell, valueAdd, true)
    end
    if (cameraCell3 ~= lastCameraCell3 or lastValueAdd ~= valueAdd) and positionInRange3(core_camera.getPosition()) then
      local xCell, zCell = getCellForPosition3(core_camera.getPosition())
      enableSmallLights(xCell, zCell, valueAdd, true)
    end
  end

  lastCameraCell = cameraCell
  lastCameraCell3 = cameraCell3
  lastValue = value
  lastValueAdd = valueAdd

  if shadowdisable == 0 then
    local position = core_camera.getPosition()
    if be:getPlayerVehicle(0) then
      position = be:getPlayerVehicle(0):getPosition()
    end
    if (cameraCell2 ~= lastCameraCell2) and positionInRange2(position) then
      local xCell, zCell = getCellForPosition2(position)
      enableShadows(xCell, zCell)
    end
  end

  lastCameraCell2 = cameraCell2

  if isEditorRunning == false then
    if tod.time > 0.21 and tod.time < 0.79 then
      if cubevalue == false and not dont_showUI then
        extensions.core_jobsystem.create(enabledisableEmissionGlow, 2, 1)
        cubemapname = "cubemap_st_souyakucenter_judgeNight_reflection"
        setCubemap(cubemapname)
        --hideGroup("godrays", false)
        print("night")
        cubevalue = true
      end
      value = true
    else
      if cubevalue == true and not dont_showUI then
        extensions.core_jobsystem.create(enabledisableEmissionGlow, 2, 0)
        cubemapname = "cubemap_st_souyakucenter_judge_reflection"
        setCubemap(cubemapname)
        --hideGroup("godrays", true)
        print("day")
        cubevalue = false
      end
    end
    if isThunder == true then onWeatherThunder(dtSim, dtReal) end
  end
end

local function onEditorActivated()
  log('I', "onEditorActivated", "Restoring default map state to avoid saving broken data")
  isEditorRunning = true
  if not tableIsEmpty(emissiveTable) then
    for k,v in pairs(emissiveTable) do
      setMaterialProperty(v[1], 'emissiveFactor', v[3], v[2])
      log('I', "onEditorActivated", "Switching Material "..v[1].." layer "..v[3])
    end
  end
  if not tableIsEmpty(instanceData) then
    for k,v in pairs(instanceData) do
      local instance = scenetree.findObjectById(k)
      if instance then
        instance:setField('instanceColor', 0, v[1])
        instance:setField('instanceColor1', 0, v[2])
        instance:setField('instanceColor2', 0, v[3])
        instance:updateInstanceRenderData()
      end
    end
  end
  cubemapname = "cubemap_st_souyakucenter_judge_reflection"
  setCubemap(cubemapname)
  setWeather(levelfolder .. "/art/skies/sky_gradients/default/gradient_fog.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_colorize.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_sunscale.png", levelfolder .. "/art/skies/sky_gradients/default/gradient_ambient.png", 0.001, 1200, scenetree.Level_objects, 0, 0, false, nil)
  --onParticleActivity(scenetree.thunder_particle, false)
  if isWet == 1 then
    setDryWetMaterials(1, "ASPHALT")
  end
  hideGroup("thunder", true)
  core_environment.setTimeOfDay(tod)
end

local function onEditorDeactivated()
  log('I', "onEditorDeactivated", "Restoring dynamic map state")
  isEditorRunning = false
  if tod.time > 0.21 and tod.time < 0.79 then
    extensions.core_jobsystem.create(enabledisableEmissionGlow, 2, 1)
    cubemapname = "cubemap_st_souyakucenter_judgeNight_reflection"
    setCubemap(cubemapname)
    --hideGroup("godrays", false)
    print("night")
    cubevalue = true
  else
    extensions.core_jobsystem.create(enabledisableEmissionGlow, 2, 0)
    cubemapname = "cubemap_st_souyakucenter_judge_reflection"
    setCubemap(cubemapname)
    --hideGroup("godrays", true)
    print("day")
    cubevalue = false
  end
  if isWet == 1 then
    setDryWetMaterials(0.4, "ASPHALT_WET")
  end
  if isWet == 0 then
    setDryWetMaterials(1, "ASPHALT")
  end
  core_environment.setTimeOfDay(tod)
end

local function onEditorInitialized()
  editor.addWindowMenuItem("Map Controller", onWindowMenuItem, {groupMenuName = 'Car_Killer Addons'})
  editor.registerWindow(toolWindowName, im.ImVec2(500, 200))

end

M.onClientStartMission = onClientStartMission
M.onUiChangedState = onUiChangedState
M.onBeamNGTrigger = onBeamNGTrigger
M.onUpdate = onUpdate
M.onEditorActivated = onEditorActivated
M.onEditorDeactivated = onEditorDeactivated
M.onEditorInitialized = onEditorInitialized

return M