local M = {}

local checkForId = 0
local customVehOrder = {}
local blackListedVehicles = {}

local function onUpdate(dt)
    local success, err = pcall(function()
        if not gameplay_walk or not gameplay_walk.getBlacklist then return end

        if not gameplay_walk.getBlacklist()[checkForId] then
            for _,v in pairs(scenetree.findClassObjects("BeamNGVehicle") or {}) do
                local obj = scenetree.findObject and scenetree.findObject(v)
                if obj and obj.getId then
                    checkForId = obj:getId()
                    if v:match("nonvehicle") then
                        if gameplay_walk.addVehicleToBlacklist then
                            gameplay_walk.addVehicleToBlacklist(checkForId)
                        end
                        table.insert(blackListedVehicles, checkForId)
                    else
                        table.insert(customVehOrder, checkForId)
                    end
                end
            end

            if extensions and extensions.core_input_vehicleSwitching and extensions.core_input_vehicleSwitching.setVehicleOrder then
                extensions.core_input_vehicleSwitching.setVehicleOrder(customVehOrder)
            end
        end
    end)

    if not success then
        log("E", "VehicleSwitcher", "Fout in onUpdate: " .. tostring(err))
    end
end

local function onVehicleSwitched()
    local success, err = pcall(function()
        customVehOrder = {}

        for _,v in pairs(scenetree.findClassObjects("BeamNGVehicle") or {}) do
            local obj = scenetree.findObject and scenetree.findObject(v)
            if obj and obj.getId then
                checkForId = obj:getId()
                if not v:match("nonvehicle") then
                    table.insert(customVehOrder, checkForId)
                end
            end
        end

        if extensions and extensions.core_input_vehicleSwitching and extensions.core_input_vehicleSwitching.setVehicleOrder then
            extensions.core_input_vehicleSwitching.setVehicleOrder(customVehOrder)
        end
    end)

    if not success then
        log("E", "VehicleSwitcher", "Fout in onVehicleSwitched: " .. tostring(err))
    end
end

M.onUpdate = onUpdate
M.onVehicleSwitched = onVehicleSwitched

return M
