local M = {}

local platformDown = false
local electricsValue = "doorOpen"
local resetTimer = 0
local resetDelay = 30 -- tijdsvertraging in seconden

local function updateGFX(dt)
    -- Controleer of platformDown actief is en de reset-timer loopt
    if platformDown then
        resetTimer = resetTimer + dt
        -- Zet platformDown terug naar false na de ingestelde vertraging
        if resetTimer >= resetDelay then
            platformDown = false
            resetTimer = 0
        end
    end
    electrics.values[electricsValue] = platformDown and 0.95 or 0
end

local function onDoorTrigger()
    platformDown = not platformDown
    -- Reset de timer elke keer dat de deurtrigger wordt geactiveerd
    if platformDown then
        resetTimer = 0
    end
end

local function init(jbeamData)
    electricsValue = jbeamData.electricsValue or "doorOpen"
end

local function reset()
    platformDown = false
    resetTimer = 0
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX
M.onDoorTrigger = onDoorTrigger

return M
