local M = {}

local im = ui_imgui

M.showUI = im.BoolPtr(true)

local envObjectIdCache = {}

local function getObject(className)
  if envObjectIdCache[className] then
    if envObjectIdCache[className] == 0 then return nil end
    return scenetree.findObjectById(envObjectIdCache[className])
  end
  envObjectIdCache[className] = 0
  local objNames = scenetree.findClassObjects(className)
  if objNames and not tableIsEmpty(objNames) then
    local obj = scenetree.findObject(objNames[1])
    if obj then
      envObjectIdCache[className] = obj:getID()
      return obj
    end
  end
  return nil
end

TorqueScriptLua.getVar('$LightRayPostFX::Enable')

-- TOD Lights Function
local function setAllLightsEnabled(group, value)
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    local obj = scenetree.findObjectById(id)
    if obj and obj.obj:isSubClassOf('LightBase') then
      obj.obj:setLightEnabled(value)
    end
  end
end

local shadowvalue = nil

-- TOD Shadows Function
local function setAllLightsShadowsEnabledDisabled(group, shadowvalue)
  if not group then
  else
    for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local light_obj = scenetree.findObjectById(id)
      light_obj.castShadows = shadowvalue
    end
  end
end

local function streetLamps()
  local tod = scenetree.tod
  if not tod then return end

  local value = false
  local shadowvalue = true
  if tod.time > 0.25 and tod.time < 0.75 then
    value = true
    shadowvalue = false
    scenetree.findObject("LightRayPostFX"):disable()
  end

  if shadowvalue == true then
    scenetree.findObject("LightRayPostFX"):enable()
  end

  if lastValue == value then return end
  lastValue = value

  if scenetree.Spotlights then
    setAllLightsEnabled(scenetree.Spotlights, value)
    setAllLightsEnabled(scenetree.Pointlights, value)
    setAllLightsShadowsEnabledDisabled(scenetree.sky_and_sun, shadowvalue)
  end
end

local function forceApply()
  core_environment.setTimeOfDay(core_environment.getTimeOfDay())
end

local function overrideNightcolor(value)
  local scatterSkyObj = getObject("ScatterSky")
  if scatterSkyObj then
    scatterSkyObj.nightColor = Point4F(value, value, value, 1.0)
  end
end

local function overrideCloudcolor(value)
  local cloudLayerObj = getObject("CloudLayer")
  if cloudLayerObj then
    cloudLayerObj.baseColor = Point4F(value, value, value, 1.0)
  end
end


local function setThemeLight()
  local Dark = im.ImVec4(0.2, 0.2, 0.2, 1.0)
  local Mid = im.ImVec4(0.5, 0.5, 0.5, 1.0)
  local Light = im.ImVec4(0.8, 0.8, 0.8, 1.0)

  im.PushStyleColor2(im.Col_Text, im.ImVec4(1.0, 1.0, 1.0, 1.0))
  im.PushStyleColor2(im.Col_WindowBg, im.ImVec4(0.2, 0.2, 0.2, 0.8))
  im.PushStyleColor2(im.Col_Border, Dark)
  im.PushStyleColor2(im.Col_FrameBg, Mid)
  im.PushStyleColor2(im.Col_FrameBgHovered, Light)
  im.PushStyleColor2(im.Col_FrameBgActive, Mid)
  im.PushStyleColor2(im.Col_TitleBg, Dark)
  im.PushStyleColor2(im.Col_TitleBgActive, Mid)
  im.PushStyleColor2(im.Col_TitleBgCollapsed, Dark)
  im.PushStyleColor2(im.Col_Button, Mid)
  im.PushStyleColor2(im.Col_ButtonHovered, Light)
  im.PushStyleColor2(im.Col_ButtonActive, Mid)
end

local function setThemeDark()
  local Dark = im.ImVec4(0.0, 0.0, 0.0, 1.0)
  local Mid = im.ImVec4(0.1, 0.1, 0.1, 1.0)
  local Light = im.ImVec4(0.2, 0.2, 0.2, 1.0)

  im.PushStyleColor2(im.Col_Text, im.ImVec4(1.0, 1.0, 1.0, 1.0))
  im.PushStyleColor2(im.Col_WindowBg, im.ImVec4(0.1, 0.1, 0.1, 0.7))
  im.PushStyleColor2(im.Col_Border, Dark)
  im.PushStyleColor2(im.Col_FrameBg, Mid)
  im.PushStyleColor2(im.Col_FrameBgHovered, Light)
  im.PushStyleColor2(im.Col_FrameBgActive, Mid)
  im.PushStyleColor2(im.Col_TitleBg, Dark)
  im.PushStyleColor2(im.Col_TitleBgActive, Mid)
  im.PushStyleColor2(im.Col_TitleBgCollapsed, Dark)
  im.PushStyleColor2(im.Col_Button, Mid)
  im.PushStyleColor2(im.Col_ButtonHovered, Light)
  im.PushStyleColor2(im.Col_ButtonActive, Mid)
end

local original_gradient = nil

local isArcade = nil

local function drawUI()
  im.Begin("Night Control Panel", M.showUI, im.ImGuiWindowFlags_AlwaysAutoResize)
  im.Text("Set Visibility")
  if im.Button("Realistic") then
    isArcade = false
    overrideCloudcolor(1.0)
    core_environment.setNightGradientFile(original_gradient)
    forceApply()
  end
  im.SameLine()
  if im.Button("Arcade") then
    isArcade = true
    core_environment.setNightGradientFile("")
    overrideNightcolor(1.0)
    forceApply()
  end
  im.Text("Streetlight Shadows")
  if im.Button("On") then
    setAllLightsShadowsEnabledDisabled(scenetree.Spotlights, true)
  end
  im.SameLine()
  if im.Button("Off") then
    setAllLightsShadowsEnabledDisabled(scenetree.Spotlights, false)
  end
  im.Text("UI Color")
  if im.Button("Dark") then
    isLight = false
  end
  im.SameLine()
  if im.Button("Light") then
    isLight = true
  end
  if isArcade == true then
    if scenetree.tod.time > 0.25 and scenetree.tod.time < 0.75 then
      overrideCloudcolor(0.1)
    else 
      overrideCloudcolor(1.0)
    end
  end
  im.End()
end

local once = false

local function onUpdate()
  if not once then
    original_gradient = core_environment.getNightGradientFile()
    once = true
  end
  drawUI()
  if isLight == true then
    setThemeLight()
  else
    setThemeDark()
  end
  -- Dynamic Street Lamps
  streetLamps()
end

M.onUpdate = onUpdate

return M
