-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local gaugesScreenName = nil
local htmlPath = nil

local updateTimer = 0
local updateFPS = 30
local invFPS = 1 / updateFPS

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS then
    local data = {}
		if electrics.values["radio"] == nil or electrics.values["radio"] == "Radio Off" then
			data.radioscreen = "No Music Selected"
		else
			data.radioscreen = electrics.values["radio"]
		end

		if electrics.values["radioAuthor"] == nil or electrics.values["radio"] == "Radio Off" then
			data.radioscreenauthor = "by Unknown"
		else
			data.radioscreenauthor = "by " .. electrics.values["radioAuthor"]
		end
    --dump(data)
    htmlTexture.call(gaugesScreenName, "update", data)
    updateTimer = 0
  end
end

local function init(jbeamData)
	gaugesScreenName = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 512
	local height = jbeamData.textureHeight or 256

    htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
end

M.init = init
M.updateGFX = updateGFX

return M
