local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local gaugesScreenName = nil
local htmlPath = nil

local updateTimer = 0
local updateFPS = 30
local invFPS = 1 / updateFPS
local numberBoard = nil

local function reset()
	numberBoard = nil
	local data = {}

	if numberBoard == nil then
		data.numberBoard = math.random (1, 99)
		numberBoard = data.numberBoard
	end
    htmlTexture.call(gaugesScreenName, "init", data)
end

local function init(jbeamData)
	gaugesScreenName = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 512
	local height = jbeamData.textureHeight or 256

	local data = {}

	if numberBoard == nil then
		data.numberBoard = math.random (1, 99)
		numberBoard = data.numberBoard
	end

    htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
    htmlTexture.call(gaugesScreenName, "init", data)
end

M.init = init
M.reset = reset

return M
