local M = {}
local device = nil
local timer = 0
local timer2 = 0
local timer3 = 0
local hasBeenActive = 0
local hasBeenActive2 = 0
local hasBeenActive3 = 0
local keySaveValue = 0
local indicatorActive = false
local timer_ind = 0
local indicator_l = false
local indicator_r = false
local indicator_lr = false
local doorStateCache = 0
local efficiencyShifterSmoother = newExponentialSmoothing(10)

--This File contains the Vertex's gauge cluster starting sequence, the key twisting logic and the DRL logic, logic for moving the automatic shifter as well as a bit of stuff for the "door open" gauge light
local function onInit()
    device = powertrain.getDevice("mainEngine")
    electrics.values["startermotor"] = 0
    electrics.values["startermotor2"] = 0
    electrics.values["startermotor3"] = 0
    electrics.values["doorsOpen"] = 0
	hasBeenActive = 0
	hasBeenActive2 = 0
	hasBeenActive3 = 0
	electrics.values["key"] = 0
	keySaveValue = 0
	indicatorActive = false
	timer_ind = 0
	indicator_l = false
	indicator_r = false
	indicator_lr = false
end

local function onReset()
	electrics.values["startermotor"] = 0
    electrics.values["startermotor2"] = 0
    electrics.values["startermotor3"] = 0
    electrics.values["doorsOpen"] = 0
	electrics.values["doorFLOpenInput"] = 0 
	electrics.values["doorFROpenInput"] = 0 
	electrics.values["doorRROpenInput"] = 0
	electrics.values["doorRLOpenInput"] = 0 
	electrics.values["doorTrOpenInput"] = 0 
	electrics.values["doorHoOpenInput"] = 0 
	electrics.values["domelight"] = 0
	hasBeenActive = 0
	hasBeenActive2 = 0
	hasBeenActive3 = 0
	electrics.values["key"] = 0
	keySaveValue = 0
	indicatorActive = false
	timer_ind = 0
	indicator_l = false
	indicator_r = false
	indicator_lr = false
	doorStateCache = 0
end

local function updateGFX(dt) 
	if electrics.values["engineRunning"] == 0 then
		indicatorActive = false
		if electrics.values["signal_L"] == 1 and electrics.values["signal_R"] == 1 then
			electrics.values["drl_L"] = 1
			electrics.values["drl_R"] = 1
		elseif electrics.values["signal_L"] == 1 then
			electrics.values["drl_L"] = 1
			electrics.values["drl_R"] = 0
		elseif electrics.values["signal_R"] == 1 then
			electrics.values["drl_L"] = 0
			electrics.values["drl_R"] = 1
		else
			electrics.values["drl_L"] = 0
			electrics.values["drl_R"] = 0
		end
	elseif electrics.values["engineRunning"] == 1 and electrics.values["signal_R"] ~= 0 or electrics.values["signal_L"] ~= 0 then
		indicatorActive = true
		timer_ind = 0
		if electrics.values["signal_L"] == 1 and electrics.values["signal_R"] == 1 then
			indicator_lr = true
			indicator_r = false
			indicator_l = false
			electrics.values["drl_L"] = 1
			electrics.values["drl_R"] = 1
		elseif electrics.values["signal_L"] == 1 then
			indicator_l = true
			indicator_r = false
			indicator_lr = false
			electrics.values["drl_L"] = 1
			electrics.values["drl_R"] = 1
		elseif electrics.values["signal_R"] == 1 then
			indicator_r = true
			indicator_l = false
			indicator_lr = false
			electrics.values["drl_L"] = 1
			electrics.values["drl_R"] = 1
		end
	elseif electrics.values["engineRunning"] == 1 and electrics.values["signal_R"] == 0 and electrics.values["signal_L"] == 0 and indicatorActive == true then
		timer_ind = timer_ind + dt
		if indicator_lr == true then
			electrics.values["drl_L"] = 0
			electrics.values["drl_R"] = 0
		elseif indicator_l == true then
			electrics.values["drl_L"] = 0
			electrics.values["drl_R"] = 1
		elseif indicator_r == true then
			electrics.values["drl_L"] = 1
			electrics.values["drl_R"] = 0
		end
		if timer_ind >= 0.7 then
			indicatorActive = false
		end
	else
		electrics.values["drl_L"] = 1
		electrics.values["drl_R"] = 1
		indicator_r = false
		indicator_l = false
		indicator_lr = false
		indicatorActive = false
	end

  if device == nil then return end -- prevent lua error when engine removed
  if device.starterEngagedCoef == nil then return end
  if device.starterEngagedCoef ~= 0 and not device.isDisabled then 
	hasBeenActive = 1
	hasBeenActive2 = 1
	hasBeenActive3 = 1

    electrics.values["startermotor"] = 1
    electrics.values["startermotor2"] = 1
    electrics.values["startermotor3"] = 1

	--else
    --electrics.values["startermotor"] = 0
  end
  if hasBeenActive == 1 then
	timer = timer + dt		
	if timer >= 1.5 then
		electrics.values["startermotor"] = 0
		hasBeenActive = 0
		timer = 0
	end
  end
  if hasBeenActive2 == 1 then
	timer2 = timer2 + dt	
	if timer2 >= 2.5 then
		electrics.values["startermotor2"] = 0
		hasBeenActive2 = 0
		timer2 = 0
	end
  end
  if hasBeenActive3 == 1 then	
	timer3 = timer3 + dt	
	if timer3 >= 4.5 then
		electrics.values["startermotor3"] = 0
		hasBeenActive3 = 0
		timer3 = 0
	end
  end
  
 --car key twisting functions
 keySaveValue = electrics.values["key"]
 
  if device.starterEngagedCoef ~= 0 and not device.isDisabled then
	if keySaveValue >= 1  then 
		electrics.values["key"] = 1
	elseif 1 < keySaveValue then
		electrics.values["key"] = electrics.values["key"] - 0.1
	elseif 1 > keySaveValue then
		electrics.values["key"] = electrics.values["key"] + 0.1
	end
  elseif electrics.values["engineRunning"] == 1 or electrics.values["lowbeam"] == 1 or electrics.values["highbeam"] == 1 or electrics.values["radio"] ~= "Radio Off" or electrics.values["domelight"] == 1 or electrics.values["ambient"] == 1 then
	if keySaveValue == 0.7 then 
		electrics.values["key"] = 0.7
	elseif keySaveValue > 0.75 then
		electrics.values["key"] = electrics.values["key"] - 0.1
	elseif keySaveValue < 0.7 then
		electrics.values["key"] = electrics.values["key"] + 0.1
	end

  else
		electrics.values["key"] = 0
  end
  
  --Door open gauge light
  if electrics.values["doorFLOpenInput"] == 1 or electrics.values["doorFROpenInput"] == 1 or electrics.values["doorRROpenInput"] == 1 or electrics.values["doorRLOpenInput"] == 1 or electrics.values["doorTrOpenInput"] == 1 or electrics.values["doorHoOpenInput"] == 1 then
    electrics.values["doorsOpen"] = 1
	if electrics.values["doorFLOpenInput"] == 1 or electrics.values["doorFROpenInput"] == 1 or electrics.values["doorRROpenInput"] == 1 or electrics.values["doorRLOpenInput"] == 1 then
		if doorStateCache ~= electrics.values["doorsOpen"] then
			doorStateCache = electrics.values["doorsOpen"]
			electrics.values["domelight"] = 1
		end
	end
  else
    electrics.values["doorsOpen"] = 0
	if doorStateCache ~= electrics.values["doorsOpen"] then
		doorStateCache = electrics.values["doorsOpen"]
		electrics.values["domelight"] = 0
	end
  end  
  --Automatic shifter
    if electrics.values['gear'] == "P" then
		electrics.values["automaticShifterPos"] = 0
		electrics.values["automaticShifterPos"] = efficiencyShifterSmoother:get(electrics.values["automaticShifterPos"])
    elseif electrics.values['gear'] == "R" then
		electrics.values["automaticShifterPos"] = 0.25
		electrics.values["automaticShifterPos"] = efficiencyShifterSmoother:get(electrics.values["automaticShifterPos"])

    elseif electrics.values['gear'] == "N" then
		electrics.values["automaticShifterPos"] = 0.45
		electrics.values["automaticShifterPos"] = efficiencyShifterSmoother:get(electrics.values["automaticShifterPos"])

	else
		electrics.values["automaticShifterPos"] = 0.65
		electrics.values["automaticShifterPos"] = efficiencyShifterSmoother:get(electrics.values["automaticShifterPos"])

	end
  
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M