-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"

local rpmToAV = 0.104719755
local gearbox = nil
local engine = nil
local minTemp = nil
local warmTemp = nil
local killWithThrottle = nil
local killInGear = nil
local moveInSteps = nil
local steps = nil
local highIdleAVMod = nil
local killed = false
local origIdle = nil
local inGearFactor = nil
local timeOverride = 0
local timeSinceStarted = 0
local desiredLoad = 0
local appliedLoad = 0
local originalFriction = 0

local function updateGFX(dt)
	local setIdle = 0
	local factor = (warmTemp-electrics.values.oiltemp)/(warmTemp-minTemp) --scale from 0 to 1 of engine temperature
	if not moveInSteps then
		setIdle = highIdleAVMod*factor
	else
		local step = 0
		while (step / steps < factor) do
			step = step + 1
		end
		setIdle = highIdleAVMod * (step / steps)
	end
	if electrics.values.oiltemp <= minTemp then
		setIdle = highIdleAVMod
	end
	if electrics.values.throttle > 0 and killWithThrottle then
		killed = true
	end
	if electrics.values.gearIndex ~= 0 and killInGear then
		killed = true
	end
	if not electrics.values.ignition then
		killed = false
		timeSinceStarted = 0
	end
	if (timeSinceStarted > timeOverride and timeOverride ~= 0) or (electrics.values.oiltemp >= warmTemp) then
		killed = true
	end
	if killed then
		setIdle = 0
		appliedLoad = 0
		engine.friction = originalFriction
	end
	timeSinceStarted = timeSinceStarted + dt
	if not killed then
		if electrics.values.gearIndex == 0 then
			if engine.instantEngineLoad < desiredLoad then
				appliedLoad = appliedLoad + 0.5
			elseif engine.instantEngineLoad > desiredLoad and appliedLoad > 0 then
				appliedLoad = appliedLoad - 0.5
			end
			engine.friction = appliedLoad
		else
		  engine.friction = originalFriction
		  setIdle = setIdle * inGearFactor
		end
	end
	engine.idleAV = origIdle + setIdle
end
local function reset(jbeamData)
	killed = false
	timeSinceStarted = 0
	appliedLoad = 0
end

local function init(jbeamData)
	if jbeamData.engineName then
		engine = powertrain.getDevice(jbeamData.engineName)
	else
		engine = powertrain.getDevice("mainEngine")
	end
	engine.idleStartCoef = 1 --override to 1
	if jbeamData.gearboxName then
		gearbox = powertrain.getDevice(jbeamData.gearboxName)
	else
		gearbox = powertrain.getDevice("gearbox")
	end
	
	minTemp = jbeamData.fullColdTemp or 3
	warmTemp = jbeamData.warmTemp or 40
	killWithThrottle = jbeamData.killWithThrottle or false
	killInGear = jbeamData.killInGear or false
	moveInSteps = jbeamData.moveInSteps or false
	steps = jbeamData.steps or 1
	if jbeamData.highIdleRPM then
		highIdleAVMod = (jbeamData.highIdleRPM * rpmToAV) - engine.idleAV
	else
		highIdleAVMod = ((engine.maxAV+(4*engine.idleAV))/5) - engine.idleAV
	end
	origIdle = engine.idleAV
	inGearFactor = jbeamData.inGearFactor or 0.33
	timeOverride = jbeamData.raisedIdleTimeout or 0
	desiredLoad = jbeamData.desiredLoad or 0
	originalFriction = engine.friction
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX

return M
