-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local hillDescentData = {}
local hillDescentEnabled = false
local hillDescentModeEnabled = true
local hillDescentSpeed = 0
local hillDescentActive = false

local function zeitADASUpdate(dt)
    if not hillDescentEnabled or not hillDescentModeEnabled or tonumber(electrics.values.brakeOverride or 0) > hillDescentData.maxBrakeAmount then return end
    local _, pitch = obj:getRollPitchYaw()
    if not hillDescentActive then
        if pitch <= -hillDescentData.pitchThreshold then
            hillDescentActive = true
            hillDescentSpeed = electrics.values.wheelspeed
        else
            return
        end
    end

    if electrics.values.brake_input == 0 and electrics.values.throttle_input == 0 then
        local speedDifference = electrics.values.wheelspeed - hillDescentSpeed
        local brakeAmount = math.min(speedDifference*hillDescentData.timeToHitSpeed/10, hillDescentData.maxBrakeAmount)
        electrics.values.brakeOverride = brakeAmount > 0 and brakeAmount or electrics.values.brakeOverride
        electrics.values.brakelights = electrics.values.brakeOverride ~= 0 and 0 or electrics.values.brakelights
    else
        electrics.values.brakeOverride = nil
        hillDescentSpeed = electrics.values.wheelspeed
    end

    if pitch >= -hillDescentData.pitchThreshold then
        hillDescentActive = false
        electrics.values.brakeOverride = nil
    end
end

local function init(jbeamData)
    hillDescentEnabled = next(jbeamData) ~= nil
    hillDescentData = jbeamData
end

local function setGlobalActive(bool)
    hillDescentEnabled = bool
    if not hillDescentEnabled then
        electrics.values.brakeOverride = nil
    end
end

local function setParameters(params)
    hillDescentModeEnabled = params.isEnabled
    if not hillDescentModeEnabled then
        electrics.values.brakeOverride = nil
    end
end

M.setParameters = setParameters
M.setGlobalActive = setGlobalActive
M.zeitADASUpdate = zeitADASUpdate
M.init = init

return M