-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local controllers = {}

local camPos
local vehPos
local camDistToCar
local isInCar
M.isInCar = false

M.otherVehSensors = {
    sensors = {},
    directions = {},
    velocities = {},
    objects = {},
    idSlotMatch = {}
}

local curSlot = 1

local function checkCamInside()
    camPos = obj:getCameraPosition()

    if camPos and vehPos then
        camDistToCar = camPos:distance(vehPos)
        isInCar = camDistToCar <= 0.6
    end

    M.isInCar = isInCar
    vehPos = obj:getPosition() + obj:getNodePosition((beamstate.nodeNameMap and beamstate.nodeNameMap["driver"]) or 0)
end

local function updateSensors(dt)
    local curVeh = M.otherVehSensors.objects[M.otherVehSensors.idSlotMatch[curSlot-1]]
    if curVeh then
        local id = curVeh:getId()
        local sensors = M.otherVehSensors.sensors
        if not sensors[id] then
            sensors[id] = {
                gx_smooth2 = newTemporalSmoothingNonLinear(7),
                gy_smooth2 = newTemporalSmoothingNonLinear(7),
                gz_smooth2 = newTemporalSmoothingNonLinear(7),
                sensors = {}
            }
        end

        local _sensors = sensors[id].sensors
        _sensors.gx2 = sensors[id].gx_smooth2:get(obj:getSensorX(), dt)
        _sensors.gy2 = sensors[id].gy_smooth2:get(obj:getSensorY(), dt)
        _sensors.gz2 = sensors[id].gz_smooth2:get(obj:getSensorZnonInertial(), dt)

        M.otherVehSensors.directions[id] = curVeh:getDirectionVector()
        M.otherVehSensors.velocities[id] = curVeh:getVelocity()
    end

    curSlot = curSlot - 1
    if curSlot == 0 then
        M.otherVehSensors.idSlotMatch = {}
        M.otherVehSensors.objects = {}

        for i=1, BeamEngine:getSlotCount() do
            local slot = BeamEngine:getSlot(i-1)
            M.otherVehSensors.idSlotMatch[i] = slot:getId()
            M.otherVehSensors.objects[slot:getId()] = slot
        end

        curSlot = #M.otherVehSensors.idSlotMatch
    end
end

local function updateGFX(dt)
    if not playerInfo.anyPlayerSeated or electrics.values.ignitionLevel == 0 then return end

    checkCamInside()
    local mailboxData = lpack.decode(obj:getLastMailbox("zeitADASVehOBBs"))
    if not mailboxData or not next(mailboxData) then return end

    updateSensors(dt)

    for k=1, #controllers do
        controllers[k].zeitADASUpdate(dt, mailboxData)
    end
end

local function initSecondStage(jbeamData)
    obj:queueGameEngineLua([[
        extensions.load("zeit_q7mbGetVehOBBs");
        zeit_q7mbGetVehOBBs.registerVehicle(]]..objectId..[[)
    ]])

    for _,controllerData in ipairs(tableFromHeaderTable(jbeamData.components)) do
        controllers[#controllers+1] = controller.getController(controllerData.name)
    end
end

M.updateGFX = updateGFX
M.reset = nop
M.init = nop
M.initSecondStage = initSecondStage

return M