-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local maxVal = 1
local steeringAtMaxVal = 450

local electricsNames = {l={},r={}}
local lastLights = 0

local lowbeamsActive = false
local highbeamsActive = false

local state = "track steering"
local nextState = "track steering"
local stateChangeConfidence = 0

local lightData = {
    r ={
        value = 0,
        smoother = newTemporalSmoothing(5),
        targetValue = 0,
        offTimer = 0
    },
    l = {
        value = 0,
        smoother = newTemporalSmoothing(5),
        targetValue = 0,
        offTimer = 0
    }
}

local function adjustHighbeams(dt, mailboxData)
    local ownVeh = mailboxData[objectId] or {}
    if not next(ownVeh) then return end
    mailboxData[objectId] = nil

    local vehFrontPos = ownVeh.center - ownVeh.y
    local vehRot = quat(obj:getRotation())

    -- hardcoded to 3
    local hits = {
        {vec3(0.245,0,0):rotated(vehRot),  maxVal*0, math.huge},
        {vec3(0,0,0),                      maxVal*1, math.huge},
        {vec3(-0.245,0,0):rotated(vehRot), maxVal*2, math.huge},
    }

    for othervehid,otherveh in pairs(mailboxData) do
        if not otherveh.lightsActive then goto nextVeh end
        local dir = obj:getForwardVector()

        local debugDrawer = obj.debugDrawProxy
        debugDrawer:drawSphere(0.05, vehFrontPos, color(255,0,0,255))

        local distToCar = ownVeh.center:distance(otherveh.center)
        local dirToCar = (otherveh.center-ownVeh.center):normalized()

        local othervehX = distToCar < 40 and otherveh.x or otherveh.x6
        local othervehY = distToCar < 40 and otherveh.y or otherveh.y6

        for k,v in ipairs(hits) do
            debugDrawer:drawLine(vehFrontPos, vehFrontPos+dir+v[1], color(255,0,0,255))
            debugDrawer:drawLine(vehFrontPos, vehFrontPos+dir+v[1]+vec3(0.075,0,0):rotated(vehRot), color(255,0,0,255))
            debugDrawer:drawLine(vehFrontPos, vehFrontPos+dir+v[1]+vec3(-0.075,0,0):rotated(vehRot), color(255,0,0,255))

            local hit = intersectsRay_OBB(vehFrontPos, dir+v[1], otherveh.center, othervehX, othervehY, otherveh.z15)
            local hit2 = intersectsRay_OBB(vehFrontPos, dir+v[1]+vec3(0.075,0,0):rotated(vehRot), otherveh.center, othervehX, othervehY, otherveh.z15)
            local hit3 = intersectsRay_OBB(vehFrontPos, dir+v[1]+vec3(-0.075,0,0):rotated(vehRot), otherveh.center, othervehX, othervehY, otherveh.z15)

            if hit ~= math.huge and hit > 0 and hit < 250 then
                hits[k][3] = math.min(hits[k][3], hit)
            end
            if hit2 ~= math.huge and hit2 > 0 and hit2 < 250 then
                hits[k][3] = math.min(hits[k][3], hit2)
            end
            if hit3 ~= math.huge and hit3 > 0 and hit3 < 250 then
                hits[k][3] = math.min(hits[k][3], hit3)
            end

            if obj:castRayStatic(vehFrontPos, dirToCar, 600)*1.2 < hits[k][3] then
                hits[k][3] = math.huge
            end
        end
        ::nextVeh::
    end

    if (hits[1][3] == math.huge and hits[2][3] ~= math.huge and hits[3][3] == math.huge) then
        nextState = "to sides"
        state = "to sides"
        if state == "to sides" then
            print("to sides")
            lightData.l.targetValue = hits[3][2]
            lightData.r.targetValue = hits[3][2]
        end
    elseif hits[1][3] ~= math.huge and hits[2][3] == math.huge and hits[3][3] == math.huge then
        nextState = "to right"
        if state == "to right" then
            print("to right")
            lightData.l.targetValue = hits[1][2]
            lightData.r.targetValue = hits[3][2]
        end
    elseif hits[1][3] == math.huge and hits[2][3] == math.huge and hits[3][3] ~= math.huge then
        nextState = "to left"
        if state == "to left" then
            print("to left")
            lightData.l.targetValue = hits[3][2]
            lightData.r.targetValue = hits[1][2]
        end
    elseif hits[1][3] == math.huge and hits[2][3] ~= math.huge and hits[3][3] ~= math.huge then
        nextState = "right off"
        state = "right off"
        if state == "right off" then
            print("right off")
            lightData.l.targetValue = hits[3][2]
            lightData.r.offTimer = 2
        end
    elseif hits[1][3] ~= math.huge and hits[2][3] ~= math.huge and hits[3][3] == math.huge then
        nextState = "left off"
        state = "left off"
        if state == "left off" then
            print("left off")
            lightData.r.targetValue = hits[3][2]
            lightData.l.offTimer = 2
        end
    elseif hits[1][3] ~= math.huge and hits[2][3] ~= math.huge and hits[3][3] ~= math.huge then
        nextState = "all off"
        if state == "all off" then
            print("all off")
            lightData.r.offTimer = 2
            lightData.l.offTimer = 2
        end
    else
        nextState = "track steering"
        if state == "track steering" then
            print("track steering")
            local steering = -electrics.values.steering

            local steeringFac = steering/steeringAtMaxVal * maxVal
            lightData.r.targetValue = math.max(steeringFac+maxVal, 0)

            steeringFac = (-steering)/steeringAtMaxVal * maxVal
            lightData.l.targetValue = math.max(steeringFac+maxVal, 0)
        end
    end

    if state ~= nextState then
        stateChangeConfidence = stateChangeConfidence + 1
        if stateChangeConfidence == 10 then
            state = nextState
            stateChangeConfidence = 0
        end
    end

    lightData.l.value = lightData.l.smoother:get(lightData.l.targetValue, dt)
    lightData.r.value = lightData.r.smoother:get(lightData.r.targetValue, dt)
    lightData.l.offTimer = math.max(lightData.l.offTimer-dt, 0)
    lightData.r.offTimer = math.max(lightData.r.offTimer-dt, 0)

    if electricsNames.l.highbeam then
        electrics.values[electricsNames.l.highbeam] = lightData.l.offTimer > 0 and 0 or lightData.l.value+0.001
    end
    if electricsNames.r.highbeam then
        electrics.values[electricsNames.r.highbeam] = lightData.r.offTimer > 0 and 0 or lightData.r.value+0.001
    end
end

local function adjustLowbeams()
    local steering = -electrics.values.steering

    if electricsNames.r.lowbeam then
        local steeringFac = steering/steeringAtMaxVal * maxVal
        electrics.values[electricsNames.r.lowbeam] = math.max(steeringFac+maxVal, 0)+0.001
    end
    if electricsNames.l.lowbeam then
        local steeringFac = (-steering)/steeringAtMaxVal * maxVal
        electrics.values[electricsNames.l.lowbeam] = math.max(steeringFac+maxVal, 0)+0.001
    end
end

local function toggleLowBeams()
    local active = lastLights >= 1
    if active == false then
        if electricsNames.r.lowbeam then
            electrics.values[electricsNames.r.lowbeam] = 0
        end
        if electricsNames.l.lowbeam then
            electrics.values[electricsNames.l.lowbeam] = 0
        end
    end
    return active
end

local function toggleHighBeams()
    local active = lastLights == 2
    if active == false then
        if electricsNames.r.highbeam then
            electrics.values[electricsNames.r.highbeam] = 0
        end
        if electricsNames.l.highbeam then
            electrics.values[electricsNames.l.highbeam] = 0
        end
    end
    return active
end

local function zeitADASUpdate(dt, mailboxData)
    if lastLights ~= electrics.values.lights_state then
        lastLights = electrics.values.lights_state

        lowbeamsActive = toggleLowBeams()
        highbeamsActive = toggleHighBeams()

        return
    end

    if lowbeamsActive then
        adjustLowbeams()
    end
    if highbeamsActive then
        adjustHighbeams(dt, mailboxData)
    end
end

local function init(jbeamData)
    electricsNames = jbeamData.electricsNames or electricsNames
    maxVal = jbeamData.maxVal or 1
    steeringAtMaxVal = jbeamData.steeringAtMaxVal or 400
end

M.init = init
M.zeitADASUpdate = zeitADASUpdate

return M